/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.InternalPersistentJavaLanguageLevelReaderService;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.tree.java.JavaFileElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class JavaFileElementType
extends ILightStubFileElementType<PsiJavaFileStub> {
    public static final int STUB_VERSION = 59;
    private static volatile int TEST_STUB_VERSION_MODIFIER = 0;

    public JavaFileElementType() {
        super("java.FILE", JavaLanguage.INSTANCE);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new JavaLightStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 59 + (ApplicationManager.getApplication().isUnitTestMode() ? TEST_STUB_VERSION_MODIFIER : 0);
    }

    @Override
    public boolean shouldBuildStubFor(VirtualFile file2) {
        return JavaFileElementType.isInSourceContent(file2);
    }

    public static boolean isInSourceContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaFileElementType.$$$reportNull$$$0(0);
        }
        return ApplicationManager.getApplication().getService(InternalPersistentJavaLanguageLevelReaderService.class).getPersistedLanguageLevel(file2) != null;
    }

    @Override
    public ASTNode createNode(CharSequence text) {
        return new JavaFileElement(text);
    }

    @Override
    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiBuilder builder2 = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder2);
        return builder2.getLightTree();
    }

    @Override
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        if (chameleon == null) {
            JavaFileElementType.$$$reportNull$$$0(1);
        }
        PsiBuilder builder2 = JavaParserUtil.createBuilder(chameleon);
        long startTime = System.nanoTime();
        this.doParse(builder2);
        ASTNode result2 = builder2.getTreeBuilt().getFirstChildNode();
        ParsingDiagnostics.registerParse(builder2, this.getLanguage(), System.nanoTime() - startTime);
        return result2;
    }

    private void doParse(PsiBuilder builder2) {
        PsiBuilder.Marker root = builder2.mark();
        JavaParser.INSTANCE.getFileParser().parse(builder2);
        root.done(this);
    }

    @Override
    @NotNull
    public String getExternalId() {
        return "java.FILE";
    }

    @Override
    public void serialize(@NotNull PsiJavaFileStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            JavaFileElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            JavaFileElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeBoolean(stub2.isCompiled());
        LanguageLevel level = stub2.getLanguageLevel();
        dataStream.writeByte(level != null ? level.ordinal() : -1);
        dataStream.writeName(stub2.getPackageName());
    }

    @Override
    @NotNull
    public PsiJavaFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaFileElementType.$$$reportNull$$$0(4);
        }
        boolean compiled = dataStream.readBoolean();
        byte level = dataStream.readByte();
        String packageName2 = dataStream.readNameString();
        return new PsiJavaFileStubImpl(null, packageName2, level >= 0 ? LanguageLevel.values()[level] : null, compiled);
    }

    @Override
    public void indexStub(@NotNull PsiJavaFileStub stub2, @NotNull IndexSink sink) {
        if (stub2 == null) {
            JavaFileElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            JavaFileElementType.$$$reportNull$$$0(6);
        }
    }

    @ApiStatus.Internal
    public static void setTestStubVersionModifier(int modifier) {
        TEST_STUB_VERSION_MODIFIER = modifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/JavaFileElementType";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSourceContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseContents";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

