/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaVersion
implements Comparable<JavaVersion> {
    public final int feature;
    public final int minor;
    public final int update;
    public final int build;
    public final boolean ea;
    private static JavaVersion current;
    private static final int MAX_ACCEPTED_VERSION = 25;

    private JavaVersion(int feature, int minor, int update, int build2, boolean ea) {
        this.feature = feature;
        this.minor = minor;
        this.update = update;
        this.build = build2;
        this.ea = ea;
    }

    @Override
    public int compareTo(@NotNull JavaVersion o) {
        int diff;
        if (o == null) {
            JavaVersion.$$$reportNull$$$0(0);
        }
        if ((diff = this.feature - o.feature) != 0) {
            return diff;
        }
        diff = this.minor - o.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.update - o.update;
        if (diff != 0) {
            return diff;
        }
        diff = this.build - o.build;
        if (diff != 0) {
            return diff;
        }
        return (this.ea ? 0 : 1) - (o.ea ? 0 : 1);
    }

    public boolean isAtLeast(int feature) {
        return this.feature >= feature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaVersion)) {
            return false;
        }
        JavaVersion other = (JavaVersion)o;
        return this.feature == other.feature && this.minor == other.minor && this.update == other.update && this.build == other.build && this.ea == other.ea;
    }

    public int hashCode() {
        int hash = this.feature;
        hash = 31 * hash + this.minor;
        hash = 31 * hash + this.update;
        hash = 31 * hash + this.build;
        hash = 31 * hash + (this.ea ? 1231 : 1237);
        return hash;
    }

    @NotNull
    public String toFeatureString() {
        String string2 = this.formatVersionTo(true, true);
        if (string2 == null) {
            JavaVersion.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String toFeatureMinorUpdateString() {
        String string2 = this.formatVersionTo(false, true);
        if (string2 == null) {
            JavaVersion.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public String toString() {
        return this.formatVersionTo(false, false);
    }

    private String formatVersionTo(boolean upToFeature, boolean upToUpdate) {
        StringBuilder sb = new StringBuilder();
        if (this.feature > 8) {
            sb.append(this.feature);
            if (!upToFeature) {
                if (this.minor > 0 || this.update > 0) {
                    sb.append('.').append(this.minor);
                }
                if (this.update > 0) {
                    sb.append('.').append(this.update);
                }
                if (!upToUpdate) {
                    if (this.ea) {
                        sb.append("-ea");
                    }
                    if (this.build > 0) {
                        sb.append('+').append(this.build);
                    }
                }
            }
        } else {
            sb.append("1.").append(this.feature);
            if (!upToFeature) {
                if (this.minor > 0 || this.update > 0 || this.ea || this.build > 0) {
                    sb.append('.').append(this.minor);
                }
                if (this.update > 0) {
                    sb.append('_').append(this.update);
                }
                if (!upToUpdate) {
                    if (this.ea) {
                        sb.append("-ea");
                    }
                    if (this.build > 0) {
                        sb.append("-b").append(this.build);
                    }
                }
            }
        }
        return sb.toString();
    }

    @NotNull
    public static JavaVersion compose(int feature, int minor, int update, int build2, boolean ea) throws IllegalArgumentException {
        if (feature < 0) {
            throw new IllegalArgumentException();
        }
        if (minor < 0) {
            throw new IllegalArgumentException();
        }
        if (update < 0) {
            throw new IllegalArgumentException();
        }
        if (build2 < 0) {
            throw new IllegalArgumentException();
        }
        return new JavaVersion(feature, minor, update, build2, ea);
    }

    @NotNull
    public static JavaVersion compose(int feature) {
        return JavaVersion.compose(feature, 0, 0, 0, false);
    }

    @NotNull
    public static JavaVersion current() {
        if (current == null) {
            JavaVersion fallback = JavaVersion.parse(System.getProperty("java.version"));
            JavaVersion rt = JavaVersion.rtVersion();
            if (rt == null) {
                try {
                    rt = JavaVersion.parse(System.getProperty("java.runtime.version"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            current = rt != null && rt.feature == fallback.feature && rt.minor == fallback.minor ? rt : fallback;
        }
        JavaVersion javaVersion = current;
        if (javaVersion == null) {
            JavaVersion.$$$reportNull$$$0(3);
        }
        return javaVersion;
    }

    @Nullable
    private static JavaVersion rtVersion() {
        try {
            Object version = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            int major = (Integer)version.getClass().getMethod("major", new Class[0]).invoke(version, new Object[0]);
            int minor = (Integer)version.getClass().getMethod("minor", new Class[0]).invoke(version, new Object[0]);
            int security = (Integer)version.getClass().getMethod("security", new Class[0]).invoke(version, new Object[0]);
            Object buildOpt = version.getClass().getMethod("build", new Class[0]).invoke(version, new Object[0]);
            int build2 = (Integer)buildOpt.getClass().getMethod("orElse", Object.class).invoke(buildOpt, 0);
            Object preOpt = version.getClass().getMethod("pre", new Class[0]).invoke(version, new Object[0]);
            boolean ea = (Boolean)preOpt.getClass().getMethod("isPresent", new Class[0]).invoke(preOpt, new Object[0]);
            return new JavaVersion(major, minor, security, build2, ea);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @NotNull
    public static JavaVersion parse(@NotNull String versionString) throws IllegalArgumentException {
        if (versionString == null) {
            JavaVersion.$$$reportNull$$$0(4);
        }
        String str = versionString.trim();
        HashMap<String, String> trimmingMap = new HashMap<String, String>();
        trimmingMap.put("Runtime Environment", "(build ");
        trimmingMap.put("OpenJ9", "version ");
        for (String keyToDetect : trimmingMap.keySet()) {
            int p;
            if (!str.contains(keyToDetect) || (p = str.indexOf((String)trimmingMap.get(keyToDetect))) <= 0) continue;
            str = str.substring(p);
        }
        ArrayList<String> numbers = new ArrayList<String>();
        ArrayList separators = new ArrayList();
        int length = str.length();
        int p = 0;
        boolean number = false;
        while (p < length) {
            int start = p;
            while (p < length && Character.isDigit(str.charAt(p)) == number) {
                ++p;
            }
            String part = str.substring(start, p);
            (number ? numbers : separators).add(part);
            number = !number;
        }
        if (!numbers.isEmpty() && !separators.isEmpty()) {
            try {
                int feature = Integer.parseInt((String)numbers.get(0));
                int minor = 0;
                int update = 0;
                int build2 = 0;
                boolean ea = false;
                if (feature >= 5 && feature < 25) {
                    for (p = 1; p < separators.size() && ".".equals(separators.get(p)); ++p) {
                    }
                    if (p > 1 && numbers.size() > 2) {
                        minor = Integer.parseInt((String)numbers.get(1));
                        update = Integer.parseInt((String)numbers.get(2));
                    }
                    if (p < separators.size()) {
                        String s2 = (String)separators.get(p);
                        if (s2 != null && !s2.isEmpty() && s2.charAt(0) == '-') {
                            boolean bl = ea = JavaVersion.startsWithWord(s2, "-ea") || JavaVersion.startsWithWord(s2, "-internal");
                            if (p < numbers.size() && s2.charAt(s2.length() - 1) == '+') {
                                build2 = Integer.parseInt((String)numbers.get(p));
                            }
                            ++p;
                        }
                        if (build2 == 0 && p < separators.size() && p < numbers.size() && "+".equals(separators.get(p))) {
                            build2 = Integer.parseInt((String)numbers.get(p));
                        }
                    }
                    return new JavaVersion(feature, minor, update, build2, ea);
                }
                if (feature == 1 && numbers.size() > 1 && separators.size() > 1 && ".".equals(separators.get(1)) && (feature = Integer.parseInt((String)numbers.get(1))) <= 25) {
                    if (numbers.size() > 2 && separators.size() > 2 && ".".equals(separators.get(2))) {
                        minor = Integer.parseInt((String)numbers.get(2));
                        if (numbers.size() > 3 && separators.size() > 3 && "_".equals(separators.get(3))) {
                            update = Integer.parseInt((String)numbers.get(3));
                            if (separators.size() > 4) {
                                String s3 = (String)separators.get(4);
                                if (s3 != null && !s3.isEmpty() && s3.charAt(0) == '-') {
                                    ea = JavaVersion.startsWithWord(s3, "-ea") || JavaVersion.startsWithWord(s3, "-internal");
                                }
                                for (p = 4; p < separators.size() && !((String)separators.get(p)).endsWith("-b"); ++p) {
                                }
                                if (p < numbers.size()) {
                                    build2 = Integer.parseInt((String)numbers.get(p));
                                }
                            }
                        }
                    }
                    return new JavaVersion(feature, minor, update, build2, ea);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(versionString);
    }

    private static boolean startsWithWord(String s2, String word) {
        return s2.startsWith(word) && (s2.length() == word.length() || !Character.isLetterOrDigit(s2.charAt(word.length())));
    }

    @Nullable
    public static JavaVersion tryParse(String versionString) {
        if (versionString != null) {
            try {
                return JavaVersion.parse(versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/JavaVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/JavaVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toFeatureString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toFeatureMinorUpdateString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

