/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.PlatformSupertypeUpdater;
import org.jetbrains.kotlin.fir.resolve.transformers.PlatformSupertypeUpdaterKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirApplySupertypesTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformDeclarationContent", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "applyResolvedSupertypesToClass", "", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "transformAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirSupertypesResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSupertypesResolution.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirApplySupertypesTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,889:1\n229#2,4:890\n1755#3,3:894\n1557#3:897\n1628#3,3:898\n*S KotlinDebug\n*F\n+ 1 FirSupertypesResolution.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirApplySupertypesTransformer\n*L\n153#1:890,4\n165#1:894,3\n167#1:897\n167#1:898,3\n*E\n"})
final class FirApplySupertypesTransformer
extends FirDefaultTransformer<Object> {
    @NotNull
    private final SupertypeComputationSession supertypeComputationSession;
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;

    public FirApplySupertypesTransformer(@NotNull SupertypeComputationSession supertypeComputationSession, @NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)supertypeComputationSession, (String)"supertypeComputationSession");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.supertypeComputationSession = supertypeComputationSession;
        this.session = session;
        this.scopeSession = scopeSession;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        return element2;
    }

    private final FirDeclaration transformDeclarationContent(FirDeclaration declaration2, Object data) {
        FirElement firElement = declaration2.transformChildren(this, data);
        Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirDeclaration");
        return (FirDeclaration)firElement;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            FirDeclaration firDeclaration = this.transformDeclarationContent(file2, null);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
            firFile = (FirFile)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firFile;
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        this.applyResolvedSupertypesToClass(regularClass);
        FirDeclaration firDeclaration = this.transformDeclarationContent(regularClass, null);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        return (FirRegularClass)firDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyResolvedSupertypesToClass(FirClass firClass) {
        block6: {
            boolean bl;
            block5: {
                Iterable $this$any$iv = firClass.getSuperTypeRefs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl2 = false;
                        if (!(!(it instanceof FirResolvedTypeRef) || it instanceof FirImplicitBuiltinTypeRef)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                void $this$mapTo$iv$iv;
                Object element$iv;
                Iterable $this$map$iv = this.supertypeComputationSession.getResolvedSupertypeRefs(firClass);
                boolean $i$f$map = false;
                element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.supertypeComputationSession.expandTypealiasInPlace((FirTypeRef)it, this.session));
                }
                List supertypeRefs = (List)destination$iv$iv;
                firClass.replaceSuperTypeRefs(supertypeRefs);
            }
            PlatformSupertypeUpdater platformSupertypeUpdater = PlatformSupertypeUpdaterKt.getPlatformSupertypeUpdater(this.session);
            if (platformSupertypeUpdater == null) break block6;
            platformSupertypeUpdater.updateSupertypesIfNeeded(firClass, this.scopeSession);
        }
    }

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        this.applyResolvedSupertypesToClass(anonymousObject);
        FirElement firElement = anonymousObject.transformChildren(this, data);
        Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirAnonymousObject");
        return (FirAnonymousObject)firElement;
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
            return typeAlias;
        }
        FirTypeRef resolvedTypeRef = this.supertypeComputationSession.getResolvedExpandedTypeRef(typeAlias);
        FirTypeRef resolvedExpandedTypeRef = this.supertypeComputationSession.expandTypealiasInPlace(resolvedTypeRef, this.session);
        typeAlias.replaceExpandedTypeRef(resolvedExpandedTypeRef);
        return typeAlias;
    }
}

