/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LoweredStatementOrigins;
import org.jetbrains.kotlin.backend.common.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArguments;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArgumentsBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.indy.MetafactoryArgumentsResult;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBlock;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBuilder;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrTypeParameterBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;

@PhaseDescription(name="FunctionReference")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0001\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0002HIB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u000f\u001a\u00020\f*\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\fH\u0002J \u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J \u0010+\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020!H\u0002J$\u0010.\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020&2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u001900H\u0002J,\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u001b2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u001900H\u0002J,\u0010:\u001a\u00020;2\u0006\u00102\u001a\u00020*2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020=H\u0002J\u0014\u0010?\u001a\u00020@*\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u001a\u0010D\u001a\u00020E*\u00020A2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020C0GH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00106\u001a\u0010\u0012\f\u0012\n 9*\u0004\u0018\u0001080807X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "crossinlineLambdas", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lkotlin/collections/HashSet;", "isIgnored", "", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "isSuspendFunctionReference", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "shouldGenerateIndySamConversions", "shouldGenerateIndyLambdas", "shouldGenerateLightweightLambdas", "isJavaSamConversionWithEqualsHashCode", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "processBlock", "forceSerializability", "wrapLambdaReferenceWithIndySamConversion", "reference", "lambdaMetafactoryArguments", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArguments;", "visitFunctionReference", "getDeclarationParentForDelegatingLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "createProxyLocalFunctionForIndySamConversion", "canGenerateIndySamConversionOnFunctionalExpression", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "wrapSamDelegatingLambdaWithIndySamConversion", "lambdaBlock", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/SamDelegatingLambdaBlock;", "wrapSamConversionArgumentWithIndySamConversion", "produceSamConversion", "Lkotlin/Function1;", "wrapFunctionReferenceInsideBlockWithIndySamConversion", "samType", "block", "jvmIndyLambdaMetafactoryIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "specialNullabilityAnnotationsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.jvm.PlatformType", "wrapWithIndySamConversion", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "startOffset", "", "endOffset", "irRawFunctionRef", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrRawFunctionReferenceImpl;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "irFun", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irVarargOfRawFunctionRefs", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrVarargImpl;", "irFuns", "", "FunctionReferenceBuilder", "Companion", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering\n+ 2 IrInlineReferenceLocator.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocatorKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,957:1\n233#2,11:958\n1863#3,2:969\n1863#3,2:971\n1557#3:978\n1628#3,3:979\n237#4,4:973\n343#4,4:982\n1#5:977\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering\n*L\n60#1:958,11\n93#1:969,2\n158#1:971,2\n432#1:978\n432#1:979,3\n248#1:973,4\n283#1:982,4\n*E\n"})
public final class FunctionReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashSet<IrSimpleFunction> crossinlineLambdas;
    private final boolean shouldGenerateIndySamConversions;
    private final boolean shouldGenerateIndyLambdas;
    private final boolean shouldGenerateLightweightLambdas;
    private final boolean isJavaSamConversionWithEqualsHashCode;
    @NotNull
    private final IrSimpleFunctionSymbol jvmIndyLambdaMetafactoryIntrinsic;
    @NotNull
    private final Set<FqName> specialNullabilityAnnotationsFqNames;

    public FunctionReferenceLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.crossinlineLambdas = new HashSet();
        this.shouldGenerateIndySamConversions = this.context.getConfig().getSamConversionsScheme() == JvmClosureGenerationScheme.INDY;
        this.shouldGenerateIndyLambdas = this.context.getConfig().getLambdasScheme() == JvmClosureGenerationScheme.INDY;
        this.shouldGenerateLightweightLambdas = this.shouldGenerateIndyLambdas && this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.LightweightLambdas);
        this.isJavaSamConversionWithEqualsHashCode = this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
        this.jvmIndyLambdaMetafactoryIntrinsic = this.context.getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic();
        Object[] objectArray = new FqName[]{JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION};
        this.specialNullabilityAnnotationsFqNames = SetsKt.setOf((Object[])objectArray);
    }

    private final boolean isIgnored(IrFunctionReference $this$isIgnored) {
        return !IrTypeUtilsKt.isFunctionOrKFunction($this$isIgnored.getType()) && !this.isSuspendFunctionReference($this$isIgnored) || Intrinsics.areEqual((Object)$this$isIgnored.getOrigin(), (Object)LoweredStatementOrigins.INSTANCE.getINLINE_LAMBDA());
    }

    private final boolean isSuspendFunctionReference(IrFunctionReference $this$isSuspendFunctionReference) {
        return IrUtilsKt.isSuspend($this$isSuspendFunctionReference) && ($this$isSuspendFunctionReference.getOrigin() == null || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE()) || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.Companion.getSUSPEND_CONVERSION()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrFile irFile) {
        void $this$findInlineLambdas$iv;
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrFile irFile2 = irFile;
        JvmBackendContext context$iv = this.context;
        boolean $i$f$findInlineLambdas = false;
        $this$findInlineLambdas$iv.accept(new IrInlineReferenceLocator(context$iv, this){
            final /* synthetic */ FunctionReferenceLowering this$0;
            {
                this.this$0 = functionReferenceLowering;
                super($context);
            }

            /*
             * WARNING - void declaration
             */
            public void visitInlineLambda(IrFunctionReference argument, IrFunction callee, IrValueParameter parameter2, IrDeclaration scope) {
                void parameter3;
                Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
                Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                IrValueParameter irValueParameter = parameter2;
                IrFunctionReference argument2 = argument;
                boolean bl = false;
                if (parameter3.isCrossinline()) {
                    HashSet hashSet = FunctionReferenceLowering.access$getCrossinlineLambdas$p(this.this$0);
                    IrFunction irFunction = ((IrFunctionSymbol)argument2.getSymbol()).getOwner();
                    Intrinsics.checkNotNull((Object)irFunction, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
                    hashSet.add((IrSimpleFunction)irFunction);
                }
            }
        }, null);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
        this.crossinlineLambdas.clear();
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.processBlock(expression2, false);
    }

    private final IrExpression processBlock(IrBlock expression2, boolean forceSerializability) {
        MetafactoryArgumentsResult lambdaMetafactoryArguments;
        if (!IrUtilsKt.isLambda(expression2.getOrigin())) {
            return super.visitBlock(expression2);
        }
        Object object = CollectionsKt.last(expression2.getStatements());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
        IrFunctionReference reference2 = (IrFunctionReference)object;
        if (this.isIgnored(reference2)) {
            return super.visitBlock(expression2);
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast(expression2.getStatements(), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            it.transform(this, null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(reference2, this);
        if (this.shouldGenerateIndyLambdas && (lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(reference2, reference2.getType(), true, forceSerializability)) instanceof LambdaMetafactoryArguments) {
            return this.wrapLambdaReferenceWithIndySamConversion(expression2, reference2, (LambdaMetafactoryArguments)lambdaMetafactoryArguments);
        }
        return new FunctionReferenceBuilder(this, reference2, null, 2, null).build();
    }

    private final IrBlock wrapLambdaReferenceWithIndySamConversion(IrBlock expression2, IrFunctionReference reference2, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = FunctionReferenceLowering.wrapWithIndySamConversion$default(this, reference2.getType(), lambdaMetafactoryArguments, 0, 0, 12, null);
        expression2.getStatements().set(expression2.getStatements().size() - 1, indySamConversion);
        expression2.setType(indySamConversion.getType());
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        return this.isIgnored(expression2) ? (IrExpression)expression2 : new FunctionReferenceBuilder(this, expression2, null, 2, null).build();
    }

    private final IrDeclarationParent getDeclarationParentForDelegatingLambda() {
        for (ScopeWithIr s2 : CollectionsKt.asReversedMutable(this.getAllScopes())) {
            IrSymbolOwner scopeOwner = s2.getScope().getScopeOwnerSymbol().getOwner();
            if (!(scopeOwner instanceof IrDeclarationParent)) continue;
            return (IrDeclarationParent)((Object)scopeOwner);
        }
        throw new AssertionError((Object)("No IrDeclarationParent found in scopes:\n" + CollectionsKt.joinToString$default((Iterable)this.getAllScopes(), (CharSequence)"\n", null, null, (int)0, null, FunctionReferenceLowering::getDeclarationParentForDelegatingLambda$lambda$2, (int)30, null)));
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getOperator() != IrTypeOperator.SAM_CONVERSION) {
            return super.visitTypeOperator(expression2);
        }
        IrType samSuperType = expression2.getTypeOperand();
        IrExpression invokable = expression2.getArgument();
        if (invokable instanceof IrFunctionReference) {
            irFunctionReference = (IrFunctionReference)invokable;
        } else if (invokable instanceof IrBlock && IrUtilsKt.isLambda(((IrBlock)invokable).getOrigin()) && CollectionsKt.last(((IrBlock)invokable).getStatements()) instanceof IrFunctionReference) {
            Iterable $this$forEach$iv = CollectionsKt.dropLast(((IrBlock)invokable).getStatements(), (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl = false;
                it.transform(this, null);
            }
            Object object = CollectionsKt.last(((IrBlock)invokable).getStatements());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            irFunctionReference = (IrFunctionReference)object;
        } else {
            if (this.shouldGenerateIndySamConversions && this.canGenerateIndySamConversionOnFunctionalExpression(samSuperType, invokable)) {
                SamDelegatingLambdaBuilder samDelegatingLambdaBuilder = new SamDelegatingLambdaBuilder(this.context);
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                SamDelegatingLambdaBlock lambdaBlock = samDelegatingLambdaBuilder.build(invokable, samSuperType, scopeWithIr.getScope().getScopeOwnerSymbol(), this.getDeclarationParentForDelegatingLambda());
                MetafactoryArgumentsResult lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(lambdaBlock.getRef(), samSuperType, false, false);
                if (!(lambdaMetafactoryArguments instanceof LambdaMetafactoryArguments)) {
                    return super.visitTypeOperator(expression2);
                }
                if (invokable instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)invokable).getOperator() == IrTypeOperator.IMPLICIT_CAST && ((IrTypeOperatorCall)invokable).getArgument() instanceof IrBlock) {
                    IrTypeOperatorCall irTypeOperatorCall = (IrTypeOperatorCall)invokable;
                    IrExpression irExpression = ((IrTypeOperatorCall)invokable).getArgument();
                    Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlock");
                    irTypeOperatorCall.setArgument(this.processBlock((IrBlock)irExpression, ((LambdaMetafactoryArguments)lambdaMetafactoryArguments).getShouldBeSerializable()));
                } else {
                    this.transformChildrenVoid(invokable);
                }
                return this.wrapSamDelegatingLambdaWithIndySamConversion(samSuperType, lambdaBlock, (LambdaMetafactoryArguments)lambdaMetafactoryArguments);
            }
            return super.visitTypeOperator(expression2);
        }
        IrFunctionReference reference2 = irFunctionReference;
        this.transformChildrenVoid(reference2);
        if (this.shouldGenerateIndySamConversions) {
            MetafactoryArgumentsResult lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(reference2, samSuperType, false, false);
            if (lambdaMetafactoryArguments instanceof LambdaMetafactoryArguments) {
                return this.wrapSamConversionArgumentWithIndySamConversion(expression2, (Function1<? super IrType, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceLowering.visitTypeOperator$lambda$4(this, lambdaMetafactoryArguments, expression2, arg_0)));
            }
            if (lambdaMetafactoryArguments instanceof MetafactoryArgumentsResult.Failure.FunctionHazard) {
                IrBlock proxyLocalFunBlock = this.createProxyLocalFunctionForIndySamConversion(reference2);
                IrStatement irStatement = proxyLocalFunBlock.getStatements().get(proxyLocalFunBlock.getStatements().size() - 1);
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference proxyLocalFunRef = (IrFunctionReference)irStatement;
                MetafactoryArgumentsResult proxyLambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(proxyLocalFunRef, samSuperType, false, false);
                if (proxyLambdaMetafactoryArguments instanceof LambdaMetafactoryArguments) {
                    return this.wrapSamConversionArgumentWithIndySamConversion(expression2, (Function1<? super IrType, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceLowering.visitTypeOperator$lambda$5(proxyLocalFunBlock, this, proxyLambdaMetafactoryArguments, arg_0)));
                }
            }
        }
        IrType erasedSamSuperType = JvmIrUtilsKt.rawType(JvmIrTypeUtilsKt.getErasedUpperBound(samSuperType), this.context);
        return new FunctionReferenceBuilder(this, reference2, erasedSamSuperType).build();
    }

    private final IrBlock createProxyLocalFunctionForIndySamConversion(IrFunctionReference reference2) {
        IrBlockBody irBlockBody;
        IrFunctionAccessExpression irFunctionAccessExpression;
        int startOffset = reference2.getStartOffset();
        int endOffset = reference2.getEndOffset();
        IrFunction targetFun = ((IrFunctionSymbol)reference2.getSymbol()).getOwner();
        ArrayList<IrVariable> temporaryVals = new ArrayList<IrVariable>();
        IrFunction irFunction = targetFun;
        if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner(IrCallImpl.Companion, startOffset, endOffset, ((IrSimpleFunction)targetFun).getSymbol());
        } else if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, startOffset, endOffset, targetFun.getReturnType(), ((IrConstructor)targetFun).getSymbol(), null, 16, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunctionAccessExpression targetCall = irFunctionAccessExpression;
        Object $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246 = $this$buildFun_u24lambda_u2420$iv;
        boolean $i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22 = false;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246.setName(Name.identifier(targetFun.getName().asString() + "__proxy"));
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246.setReturnType(JvmIrTypeUtilsKt.eraseTypeParameters(targetFun.getReturnType()));
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246.setVisibility(DescriptorVisibilities.LOCAL);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246.setModality(Modality.FINAL);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246.setSuspend(false);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246.setInline(false);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u246.setOrigin(targetFun.isInline() || VarargLoweringKt.isArrayOf(targetFun) ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getPROXY_FUN_FOR_METAFACTORY() : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_PROXY_FUN_FOR_METAFACTORY());
        Object proxyFun = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl2 = false;
        IrDeclarationParent irDeclarationParent = this.getCurrentDeclarationParent();
        if (irDeclarationParent == null) {
            throw new AssertionError((Object)("No declaration parent when processing " + reference2));
        }
        ((IrDeclarationBase)proxyFun).setParent(irDeclarationParent);
        Ref.IntRef temporaryValIndex = new Ref.IntRef();
        Ref.IntRef proxyParameterIndex = new Ref.IntRef();
        targetCall.setDispatchReceiver(FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$10$getTargetCallArgument(startOffset, endOffset, temporaryValIndex, (IrSimpleFunction)proxyFun, temporaryVals, proxyParameterIndex, reference2.getDispatchReceiver(), targetFun.getDispatchReceiverParameter()));
        targetCall.setExtensionReceiver(FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$10$getTargetCallArgument(startOffset, endOffset, temporaryValIndex, (IrSimpleFunction)proxyFun, temporaryVals, proxyParameterIndex, reference2.getExtensionReceiver(), targetFun.getExtensionReceiverParameter()));
        Iterator $i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22 = ((Iterable)targetFun.getValueParameters()).iterator();
        int n = 0;
        while ($i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22.hasNext()) {
            int valueParameterIndex = n++;
            IrValueParameter valueParameter2 = (IrValueParameter)$i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22.next();
            targetCall.putValueArgument(valueParameterIndex, FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$10$getTargetCallArgument(startOffset, endOffset, temporaryValIndex, (IrSimpleFunction)proxyFun, temporaryVals, proxyParameterIndex, reference2.getValueArgument(valueParameterIndex), valueParameter2));
        }
        n = ((Collection)targetFun.getTypeParameters()).size();
        for (int typeParameterIndex = 0; typeParameterIndex < n; ++typeParameterIndex) {
            targetCall.putTypeArgument(typeParameterIndex, reference2.getTypeArgument(typeParameterIndex));
        }
        IrBlockBody it = irBlockBody = this.context.getIrFactory().createBlockBody(startOffset, endOffset);
        boolean bl3 = false;
        ((IrFunction)proxyFun).setBody(it);
        IrBlockBody proxyFunBody = irBlockBody;
        boolean bl4 = IrTypePredicatesKt.isUnit(targetFun.getReturnType()) ? proxyFunBody.getStatements().add(targetCall) : proxyFunBody.getStatements().add(new IrReturnImpl(startOffset, endOffset, this.context.getIrBuiltIns().getNothingType(), ((IrSimpleFunction)proxyFun).getSymbol(), targetCall));
        Object proxyFun2 = $this$buildFun$iv;
        IrFunctionReferenceImpl proxyFunRef = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrFunctionReferenceImpl$default(startOffset, endOffset, reference2.getType(), ((IrSimpleFunction)proxyFun2).getSymbol(), 0, null, null, 96, null);
        return org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrBlockImpl(startOffset, endOffset, reference2.getType(), null, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)temporaryVals, (Object)proxyFun2), (Object)proxyFunRef));
    }

    private final boolean canGenerateIndySamConversionOnFunctionalExpression(IrType samSuperType, IrExpression expression2) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(samSuperType);
        if (irClassSymbol == null) {
            throw new AssertionError((Object)("Class type expected: " + RenderIrElementKt.render$default(samSuperType, null, 1, null)));
        }
        IrClassSymbol samClass = irClassSymbol;
        if (!IrUtilsKt.isFromJava((IrDeclaration)samClass.getOwner()) || this.isJavaSamConversionWithEqualsHashCode) {
            return false;
        }
        return !(expression2 instanceof IrBlock) || !Intrinsics.areEqual((Object)((IrBlock)expression2).getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE());
    }

    private final IrExpression wrapSamDelegatingLambdaWithIndySamConversion(IrType samSuperType, SamDelegatingLambdaBlock lambdaBlock, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = FunctionReferenceLowering.wrapWithIndySamConversion$default(this, samSuperType, lambdaMetafactoryArguments, 0, 0, 12, null);
        lambdaBlock.replaceRefWith(indySamConversion);
        return lambdaBlock.getBlock();
    }

    private final IrExpression wrapSamConversionArgumentWithIndySamConversion(IrTypeOperatorCall expression2, Function1<? super IrType, ? extends IrExpression> produceSamConversion) {
        IrExpression irExpression;
        IrType samType = expression2.getTypeOperand();
        IrExpression argument = expression2.getArgument();
        if (argument instanceof IrFunctionReference) {
            irExpression = (IrExpression)produceSamConversion.invoke((Object)samType);
        } else if (argument instanceof IrBlock) {
            irExpression = this.wrapFunctionReferenceInsideBlockWithIndySamConversion(samType, (IrBlock)argument, produceSamConversion);
        } else {
            throw new AssertionError((Object)("Block or function reference expected: " + RenderIrElementKt.render$default(expression2, null, 1, null)));
        }
        return irExpression;
    }

    private final IrExpression wrapFunctionReferenceInsideBlockWithIndySamConversion(IrType samType, IrBlock block, Function1<? super IrType, ? extends IrExpression> produceSamConversion) {
        IrExpression indySamConversion = (IrExpression)produceSamConversion.invoke((Object)samType);
        block.getStatements().set(block.getStatements().size() - 1, indySamConversion);
        block.setType(indySamConversion.getType());
        return block;
    }

    private final IrCall wrapWithIndySamConversion(IrType samType, LambdaMetafactoryArguments lambdaMetafactoryArguments, int startOffset, int endOffset) {
        IrCall irCall;
        IrType notNullSamType = IrTypesKt.removeAnnotations(IrTypesKt.makeNotNull(samType), (Function1<? super IrConstructorCall, Boolean>)((Function1)arg_0 -> FunctionReferenceLowering.wrapWithIndySamConversion$lambda$11(this, arg_0)));
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        JvmIrBuilder $this$wrapWithIndySamConversion_u24lambda_u2413 = JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr, startOffset, endOffset);
        boolean bl = false;
        IrCall $this$wrapWithIndySamConversion_u24lambda_u2413_u24lambda_u2412 = irCall = ExpressionHelpersKt.irCall$default($this$wrapWithIndySamConversion_u24lambda_u2413, this.jvmIndyLambdaMetafactoryIntrinsic, notNullSamType, 0, 0, null, 28, null);
        boolean bl2 = false;
        $this$wrapWithIndySamConversion_u24lambda_u2413_u24lambda_u2412.putTypeArgument(0, notNullSamType);
        $this$wrapWithIndySamConversion_u24lambda_u2413_u24lambda_u2412.putValueArgument(0, this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u2413, lambdaMetafactoryArguments.getSamMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u2413_u24lambda_u2412.putValueArgument(1, lambdaMetafactoryArguments.getImplMethodReference());
        $this$wrapWithIndySamConversion_u24lambda_u2413_u24lambda_u2412.putValueArgument(2, this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u2413, lambdaMetafactoryArguments.getFakeInstanceMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u2413_u24lambda_u2412.putValueArgument(3, this.irVarargOfRawFunctionRefs($this$wrapWithIndySamConversion_u24lambda_u2413, lambdaMetafactoryArguments.getExtraOverriddenMethods()));
        $this$wrapWithIndySamConversion_u24lambda_u2413_u24lambda_u2412.putValueArgument(4, ExpressionHelpersKt.irBoolean($this$wrapWithIndySamConversion_u24lambda_u2413, lambdaMetafactoryArguments.getShouldBeSerializable()));
        return irCall;
    }

    static /* synthetic */ IrCall wrapWithIndySamConversion$default(FunctionReferenceLowering functionReferenceLowering, IrType irType, LambdaMetafactoryArguments lambdaMetafactoryArguments, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        return functionReferenceLowering.wrapWithIndySamConversion(irType, lambdaMetafactoryArguments, n, n2);
    }

    private final IrRawFunctionReferenceImpl irRawFunctionRef(IrBuilderWithScope $this$irRawFunctionRef, IrFunction irFun) {
        return ExpressionHelpersKt.irRawFunctionReference($this$irRawFunctionRef, $this$irRawFunctionRef.getContext().getIrBuiltIns().getAnyType(), irFun.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrVarargImpl irVarargOfRawFunctionRefs(IrBuilderWithScope $this$irVarargOfRawFunctionRefs, List<? extends IrFunction> irFuns) {
        Collection<IrRawFunctionReferenceImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = irFuns;
        IrType irType = $this$irVarargOfRawFunctionRefs.getContext().getIrBuiltIns().getAnyType();
        IrBuilderWithScope irBuilderWithScope = $this$irVarargOfRawFunctionRefs;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrFunction irFunction = (IrFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.irRawFunctionRef($this$irVarargOfRawFunctionRefs, (IrFunction)it));
        }
        collection = (List)destination$iv$iv;
        return ExpressionHelpersKt.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection);
    }

    private static final CharSequence getDeclarationParentForDelegatingLambda$lambda$2(ScopeWithIr it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  " + RenderIrElementKt.render$default(it.getScope().getScopeOwnerSymbol().getOwner(), null, 1, null);
    }

    private static final IrExpression visitTypeOperator$lambda$4(FunctionReferenceLowering this$0, MetafactoryArgumentsResult $lambdaMetafactoryArguments, IrTypeOperatorCall $expression, IrType samType) {
        Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
        return this$0.wrapWithIndySamConversion(samType, (LambdaMetafactoryArguments)$lambdaMetafactoryArguments, $expression.getStartOffset(), $expression.getEndOffset());
    }

    private static final IrExpression visitTypeOperator$lambda$5(IrBlock $proxyLocalFunBlock, FunctionReferenceLowering this$0, MetafactoryArgumentsResult $proxyLambdaMetafactoryArguments, IrType samType) {
        Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
        $proxyLocalFunBlock.getStatements().set($proxyLocalFunBlock.getStatements().size() - 1, FunctionReferenceLowering.wrapWithIndySamConversion$default(this$0, samType, (LambdaMetafactoryArguments)$proxyLambdaMetafactoryArguments, 0, 0, 12, null));
        $proxyLocalFunBlock.setType(samType);
        return $proxyLocalFunBlock;
    }

    private static final IrGetValue createProxyLocalFunctionForIndySamConversion$lambda$10$addAndGetTemporaryVal(int startOffset, int endOffset, Ref.IntRef temporaryValIndex, IrSimpleFunction $proxyFun, ArrayList<IrVariable> temporaryVals, IrExpression initializer) {
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        IrVariableSymbol irVariableSymbol = new IrVariableSymbolImpl(null, 1, null);
        int n = temporaryValIndex.element;
        temporaryValIndex.element = n + 1;
        Name name2 = Name.identifier("tmp_proxy_" + n);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        IrVariableImpl tmpVal = BuildersKt.IrVariableImpl(startOffset, endOffset, irDeclarationOrigin, irVariableSymbol, name2, initializer.getType(), false, false, false);
        tmpVal.setInitializer(initializer);
        tmpVal.setParent($proxyFun.getParent());
        temporaryVals.add(tmpVal);
        return org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default(startOffset, endOffset, tmpVal.getSymbol(), null, 8, null);
    }

    private static final IrGetValue createProxyLocalFunctionForIndySamConversion$lambda$10$addAndGetProxyValueParameter(IrSimpleFunction $proxyFun, int startOffset, int endOffset, Ref.IntRef proxyParameterIndex, IrValueParameter originalParameter) {
        IrValueParameter irValueParameter;
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean bl = false;
        IrValueParameterBuilder $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2410_u24addAndGetProxyValueParameter_u24lambda_u247 = $this$buildValueParameter_u24lambda_u2430$iv;
        boolean bl2 = false;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2410_u24addAndGetProxyValueParameter_u24lambda_u247.updateFrom(originalParameter);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2410_u24addAndGetProxyValueParameter_u24lambda_u247.setName(Name.identifier("" + 'p' + proxyParameterIndex.element + '$' + originalParameter.getName().asString()));
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2410_u24addAndGetProxyValueParameter_u24lambda_u247.setType(JvmIrTypeUtilsKt.eraseTypeParameters(originalParameter.getType()));
        int n = proxyParameterIndex.element;
        proxyParameterIndex.element = n + 1;
        IrValueParameter $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2410_u24addAndGetProxyValueParameter_u24lambda_u248 = irValueParameter = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)$proxyFun).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)$proxyFun)));
        boolean bl3 = false;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u2410_u24addAndGetProxyValueParameter_u24lambda_u248.setParent($proxyFun);
        IrValueParameter proxyParameter = irValueParameter;
        $proxyFun.setValueParameters(CollectionsKt.plus((Collection)$proxyFun.getValueParameters(), (Object)proxyParameter));
        return org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default(startOffset, endOffset, proxyParameter.getSymbol(), null, 8, null);
    }

    private static final IrExpression createProxyLocalFunctionForIndySamConversion$lambda$10$getTargetCallArgument(int startOffset, int endOffset, Ref.IntRef temporaryValIndex, IrSimpleFunction $proxyFun, ArrayList<IrVariable> temporaryVals, Ref.IntRef proxyParameterIndex, IrExpression boundValue, IrValueParameter originalParameter) {
        return boundValue != null ? (IrExpression)FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$10$addAndGetTemporaryVal(startOffset, endOffset, temporaryValIndex, $proxyFun, temporaryVals, boundValue) : (originalParameter != null ? (IrExpression)FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$10$addAndGetProxyValueParameter($proxyFun, startOffset, endOffset, proxyParameterIndex, originalParameter) : null);
    }

    private static final boolean wrapWithIndySamConversion$lambda$11(FunctionReferenceLowering this$0, IrConstructorCall it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.specialNullabilityAnnotationsFqNames.contains(IrTypesKt.getClassFqName(it.getType()));
    }

    public static final /* synthetic */ HashSet access$getCrossinlineLambdas$p(FunctionReferenceLowering $this) {
        return $this.crossinlineLambdas;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0019\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion;", "", "<init>", "()V", "calculateOwnerKClass", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "irContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "calculateOwnerKClass$backend_jvm_lower", "getReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getReceiverField$backend_jvm_lower", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,957:1\n74#2,4:958\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion\n*L\n948#1:958,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrExpression calculateOwnerKClass$backend_jvm_lower(@NotNull JvmIrBuilder $this$calculateOwnerKClass, @NotNull IrDeclarationParent irContainer) {
            Intrinsics.checkNotNullParameter((Object)$this$calculateOwnerKClass, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            return JvmIrUtilsKt.kClassReference($this$calculateOwnerKClass, JvmIrUtilsKt.getCallableReferenceOwnerKClassType(irContainer, $this$calculateOwnerKClass.getBackendContext()));
        }

        @NotNull
        public final IrField getReceiverField$backend_jvm_lower(@NotNull IrClass $this$getReceiverField, @NotNull JvmBackendContext context2) {
            IrField irField;
            Intrinsics.checkNotNullParameter((Object)$this$getReceiverField, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            IrFactory $this$buildField$iv = context2.getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$getReceiverField_u24lambda_u240 = $this$buildField_u24lambda_u244$iv;
            boolean bl2 = false;
            $this$getReceiverField_u24lambda_u240.setName(Name.identifier("receiver"));
            $this$getReceiverField_u24lambda_u240.setType(context2.getIrBuiltIns().getAnyNType());
            $this$getReceiverField_u24lambda_u240.setVisibility(DescriptorVisibilities.PROTECTED);
            IrField $this$getReceiverField_u24lambda_u241 = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
            boolean bl3 = false;
            $this$getReceiverField_u24lambda_u241.setParent($this$getReceiverField);
            return irField;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\u00172\u0006\u00100\u001a\u00020(H\u0002J\u0006\u00101\u001a\u00020\u0015J\u0016\u00102\u001a\u000203*\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0002J\b\u00107\u001a\u000208H\u0002J-\u00109\u001a\u000203*\u0002042\u0006\u0010:\u001a\u00020\"2\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u00150<\u00a2\u0006\u0002\b>H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0011H\u0002J\b\u0010B\u001a\u00020@H\u0002J\b\u0010C\u001a\u00020\rH\u0002J\u0012\u0010D\u001a\u00020 2\b\u0010E\u001a\u0004\u0018\u00010FH\u0002J\f\u0010G\u001a\u000203*\u00020 H\u0002J\f\u0010H\u001a\u000203*\u00020 H\u0002J\u0016\u0010I\u001a\u000203*\u00020 2\b\u0010J\u001a\u0004\u0018\u00010FH\u0002J\u0018\u0010K\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\"2\u0006\u0010M\u001a\u00020 H\u0002J\u0014\u0010R\u001a\u00020\u0015*\u0002042\u0006\u0010S\u001a\u00020TH\u0002J\u0014\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020V0\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00050\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010N\u001a\u00020O*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "isLambda", "", "isLightweightLambda", "isHeavyweightLambda", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "boundReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "parameterTypes", "", "argumentTypes", "referenceReturnType", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "functionSuperClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "superMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "adapteeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "adaptedReferenceOriginalTarget", "isFunInterfaceConstructorReference", "constructedFunInterfaceSymbol", "isAdaptedReference", "samInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isKotlinFunInterface", "needToGenerateSamEqualsHashCodeMethods", "superType", "functionReferenceClass", "createFakeFormalTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "sourceTypeParameters", "irClass", "build", "generateSamEqualsHashCodeMethods", "", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "boundReceiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "generateConstructorCallArguments", "call", "generateBoundReceiver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilder;", "Lkotlin/ExtensionFunctionType;", "getFunctionReferenceFlags", "", "callableReferenceTarget", "getAdaptedCallableReferenceFlags", "hasVarargMappedToElement", "createInvokeMethod", "receiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createLambdaInvokeMethod", "createFunInterfaceConstructorInvokeMethod", "createFunctionReferenceInvokeMethod", "receiver", "inlineAdapterCallIfPossible", "expression", "invokeMethod", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/name/Name;", "generateSignature", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "createFakeBoundReceiverForJvmStaticInObject", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,957:1\n1557#2:958\n1628#2,3:959\n1557#2:966\n1628#2,2:967\n1630#2:973\n1279#2,2:974\n1293#2,4:976\n1557#2:980\n1628#2,3:981\n1187#2,2:1045\n1261#2,4:1047\n50#3,4:962\n385#3,4:969\n289#3:1000\n283#3,13:1001\n249#3:1033\n243#3:1034\n237#3,10:1035\n349#3,6:1051\n343#3,4:1057\n383#4,13:984\n416#4,5:1026\n98#5,2:997\n1#6:999\n350#7,12:1014\n350#7,12:1061\n72#8,2:1031\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder\n*L\n451#1:958\n451#1:959,3\n561#1:966\n561#1:967,2\n561#1:973\n567#1:974,2\n567#1:976,4\n570#1:980\n570#1:981,3\n750#1:1045,2\n750#1:1047,4\n525#1:962,4\n562#1:969,4\n618#1:1000\n618#1:1001,13\n723#1:1033\n723#1:1034\n723#1:1035,10\n769#1:1051,6\n928#1:1057,4\n577#1:984,13\n654#1:1026,5\n577#1:997,2\n647#1:1014,12\n607#1:1061,12\n654#1:1031,2\n*E\n"})
    private final class FunctionReferenceBuilder {
        @NotNull
        private final IrFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        private final boolean isLambda;
        private final boolean isLightweightLambda;
        private final boolean isHeavyweightLambda;
        @NotNull
        private final IrFunction callee;
        @Nullable
        private final Pair<IrValueParameter, IrExpression> boundReceiver;
        @NotNull
        private final List<IrType> parameterTypes;
        @NotNull
        private final List<IrType> argumentTypes;
        @NotNull
        private final IrType referenceReturnType;
        @NotNull
        private final Map<IrTypeParameterSymbol, IrType> typeArgumentsMap;
        @NotNull
        private final IrClassSymbol functionSuperClass;
        @NotNull
        private final IrSimpleFunction superMethod;
        @Nullable
        private final IrFunctionAccessExpression adapteeCall;
        @Nullable
        private final IrFunction adaptedReferenceOriginalTarget;
        private final boolean isFunInterfaceConstructorReference;
        @Nullable
        private final IrClassSymbol constructedFunInterfaceSymbol;
        private final boolean isAdaptedReference;
        @Nullable
        private final IrClass samInterface;
        private final boolean isKotlinFunInterface;
        private final boolean needToGenerateSamEqualsHashCodeMethods;
        @NotNull
        private final IrType superType;
        @NotNull
        private final IrClass functionReferenceClass;
        final /* synthetic */ FunctionReferenceLowering this$0;

        /*
         * WARNING - void declaration
         */
        public FunctionReferenceBuilder(@NotNull FunctionReferenceLowering this$0, @Nullable IrFunctionReference irFunctionReference, IrType samSuperType) {
            void $this$functionReferenceClass_u24lambda_u243;
            void $this$functionReferenceClass_u24lambda_u242;
            IrClassSymbol irClassSymbol;
            Object object;
            IrFunctionAccessExpression irFunctionAccessExpression;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.this$0 = this$0;
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.isLambda = IrUtilsKt.isLambda(this.irFunctionReference.getOrigin());
            this.isLightweightLambda = this.isLambda && this.this$0.shouldGenerateLightweightLambdas && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner(), JvmAnnotationUtilKt.JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME);
            this.isHeavyweightLambda = this.isLambda && !this.isLightweightLambda;
            this.callee = ((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner();
            this.boundReceiver = JvmStaticAnnotationLoweringKt.isJvmStaticInObject(this.callee) ? this.createFakeBoundReceiverForJvmStaticInObject() : (Pair)CollectionsKt.singleOrNull(IrUtilsKt.getArgumentsWithIr(this.irFunctionReference));
            IrType irType = this.irFunctionReference.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            Object object2 = ((IrSimpleType)irType).getArguments();
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            FunctionReferenceBuilder functionReferenceBuilder = this;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrType irType2;
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var14_21 = it;
                if (var14_21 instanceof IrTypeProjection) {
                    irType2 = ((IrTypeProjection)it).getType();
                } else if (var14_21 instanceof IrStarProjection) {
                    irType2 = functionReferenceLowering.context.getIrBuiltIns().getAnyNType();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(irType2);
            }
            functionReferenceBuilder.parameterTypes = (List)destination$iv$iv;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            this.referenceReturnType = (IrType)CollectionsKt.last(this.parameterTypes);
            this.typeArgumentsMap = IrUtilsKt.getTypeSubstitutionMap(this.irFunctionReference);
            Object object3 = this.samSuperType;
            if (object3 == null || (object3 = IrTypesKt.getClassOrNull((IrType)object3)) == null) {
                object3 = IrUtilsKt.isSuspend(this.irFunctionReference) ? this.this$0.context.getIrBuiltIns().suspendFunctionN(this.argumentTypes.size()).getSymbol() : this.this$0.context.getIrBuiltIns().functionN(this.argumentTypes.size()).getSymbol();
            }
            this.functionSuperClass = object3;
            IrSimpleFunction irSimpleFunction = JvmIrUtilsKt.getSingleAbstractMethod((IrClass)this.functionSuperClass.getOwner());
            if (irSimpleFunction == null) {
                throw new AssertionError((Object)("Not a SAM class: " + RenderIrElementKt.render$default(this.functionSuperClass.getOwner(), null, 1, null)));
            }
            this.superMethod = irSimpleFunction;
            if (Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE())) {
                IrStatement call2;
                IrStatement irStatement;
                IrBody irBody = this.callee.getBody();
                Intrinsics.checkNotNull((Object)irBody);
                IrStatement statement = (IrStatement)CollectionsKt.single(IrUtilsKt.getStatements(irBody));
                if (statement instanceof IrTypeOperatorCall) {
                    boolean bl = $i$f$map = ((IrTypeOperatorCall)statement).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                    if (_Assertions.ENABLED && !$i$f$map) {
                        functionReferenceBuilder = this;
                        boolean $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = false;
                        FunctionReferenceBuilder functionReferenceBuilder2 = functionReferenceBuilder;
                        String $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = "Unexpected type operator in ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render$default(this.callee, null, 1, null);
                        throw new AssertionError((Object)$i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22);
                    }
                    irStatement = ((IrTypeOperatorCall)statement).getArgument();
                } else {
                    irStatement = call2 = statement instanceof IrReturn ? (IrStatement)((IrReturn)statement).getValue() : statement;
                }
                if (!(call2 instanceof IrFunctionAccessExpression)) {
                    throw new UnsupportedOperationException("Unknown structure of ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render$default(this.callee, null, 1, null));
                }
                irFunctionAccessExpression = (IrFunctionAccessExpression)call2;
            } else {
                irFunctionAccessExpression = null;
            }
            this.adaptedReferenceOriginalTarget = (object = (this.adapteeCall = irFunctionAccessExpression)) != null && (object = (IrFunctionSymbol)((IrMemberAccessExpression)object).getSymbol()) != null ? object.getOwner() : null;
            this.isFunInterfaceConstructorReference = Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_FUN_INTERFACE_CONSTRUCTOR());
            if (this.isFunInterfaceConstructorReference) {
                irClassSymbol = IrTypesKt.getClassOrNull(this.callee.getReturnType());
                if (irClassSymbol == null) {
                    throw new AssertionError((Object)("Fun interface type expected: " + RenderIrElementKt.render$default(this.callee.getReturnType(), null, 1, null)));
                }
            } else {
                irClassSymbol = null;
            }
            this.constructedFunInterfaceSymbol = irClassSymbol;
            this.isAdaptedReference = this.isFunInterfaceConstructorReference || this.adaptedReferenceOriginalTarget != null;
            IrType irType3 = this.samSuperType;
            this.samInterface = irType3 != null ? IrTypesKt.getClass(irType3) : null;
            this.isKotlinFunInterface = this.samInterface != null && !IrUtilsKt.isFromJava(this.samInterface);
            this.needToGenerateSamEqualsHashCodeMethods = !(!this.isKotlinFunInterface && !this.this$0.isJavaSamConversionWithEqualsHashCode || !this.isAdaptedReference && this.isLambda);
            IrType irType4 = this.samSuperType;
            if (irType4 == null) {
                irType4 = IrTypesKt.getDefaultType(this.isLightweightLambda ? this.this$0.context.getIr().getSymbols().getAny() : (this.isHeavyweightLambda ? this.this$0.context.getIr().getSymbols().getLambdaClass() : (this.isFunInterfaceConstructorReference ? this.this$0.context.getIr().getSymbols().getFunInterfaceConstructorReferenceClass() : (this.isAdaptedReference ? this.this$0.context.getIr().getSymbols().getAdaptedFunctionReference() : this.this$0.context.getIr().getSymbols().getFunctionReferenceImpl()))));
            }
            this.superType = irType4;
            IrFactory $this$buildClass$iv = this.this$0.context.getIrFactory();
            boolean $i$f$buildClass = false;
            Object $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean bl = false;
            destination$iv$iv = $this$buildClass_u24lambda_u241$iv;
            functionReferenceBuilder = this;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$functionReferenceClass_u24lambda_u242, this.irFunctionReference);
            $this$functionReferenceClass_u24lambda_u242.setVisibility(DescriptorVisibilities.LOCAL);
            $this$functionReferenceClass_u24lambda_u242.setOrigin(this.isLambda ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL() : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL());
            $this$functionReferenceClass_u24lambda_u242.setName(SpecialNames.NO_NAME_PROVIDED);
            object2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
            FunctionReferenceLowering functionReferenceLowering2 = this.this$0;
            $this$buildClass_u24lambda_u241$iv = object2;
            boolean bl3 = false;
            IrDeclarationParent irDeclarationParent = functionReferenceLowering2.getCurrentDeclarationParent();
            if (irDeclarationParent == null) {
                throw new IllegalStateException(("No current declaration parent at " + DumpIrTreeKt.dump$default(this.irFunctionReference, null, 1, null)).toString());
            }
            $this$functionReferenceClass_u24lambda_u243.setParent(irDeclarationParent);
            Object[] objectArray = new IrType[]{this.superType, this.samSuperType == null ? IrTypesKt.typeWith((IrClassifierSymbol)this.functionSuperClass, this.parameterTypes) : null, this.needToGenerateSamEqualsHashCodeMethods ? IrTypesKt.getDefaultType(functionReferenceLowering2.context.getIr().getSymbols().getFunctionAdapter()) : null};
            $this$functionReferenceClass_u24lambda_u243.setSuperTypes(CollectionsKt.listOfNotNull((Object[])objectArray));
            if (this.samInterface != null && Intrinsics.areEqual((Object)$this$functionReferenceClass_u24lambda_u243.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL())) {
                $this$functionReferenceClass_u24lambda_u243.setTypeParameters(this.createFakeFormalTypeParameters(this.samInterface.getTypeParameters(), (IrClass)$this$functionReferenceClass_u24lambda_u243));
            }
            IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$functionReferenceClass_u24lambda_u243);
            IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$functionReferenceClass_u24lambda_u243, this.irFunctionReference);
            if (this.isHeavyweightLambda) {
                $this$functionReferenceClass_u24lambda_u243.setMetadata(((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner().getMetadata());
            }
            functionReferenceBuilder.functionReferenceClass = object2;
        }

        public /* synthetic */ FunctionReferenceBuilder(FunctionReferenceLowering functionReferenceLowering, IrFunctionReference irFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(functionReferenceLowering, irFunctionReference, irType);
        }

        @NotNull
        public final IrFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrTypeParameter> createFakeFormalTypeParameters(List<? extends IrTypeParameter> sourceTypeParameters, IrClass irClass) {
            Object object;
            void $this$mapTo$iv$iv;
            if (sourceTypeParameters.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = sourceTypeParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                boolean $i$f$buildTypeParameter = false;
                IrTypeParameterBuilder $this$buildTypeParameter_u24lambda_u2436$iv = new IrTypeParameterBuilder();
                boolean bl2 = false;
                IrTypeParameterBuilder $this$createFakeFormalTypeParameters_u24lambda_u245_u24lambda_u244 = $this$buildTypeParameter_u24lambda_u2436$iv;
                boolean bl3 = false;
                $this$createFakeFormalTypeParameters_u24lambda_u245_u24lambda_u244.updateFrom((IrTypeParameter)it);
                $this$createFakeFormalTypeParameters_u24lambda_u245_u24lambda_u244.setName(it.getName());
                object.add(DeclarationBuildersKt.buildTypeParameter(((IrTypeParametersContainer)irClass).getFactory(), $this$buildTypeParameter_u24lambda_u2436$iv, irClass));
            }
            List fakeTypeParameters = (List)destination$iv$iv;
            Iterable $this$associateWith$iv = sourceTypeParameters;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                IrTypeParameter bl = (IrTypeParameter)element$iv$iv;
                Object e = element$iv$iv;
                Map map = result$iv;
                boolean bl4 = false;
                IrTypeParameter irTypeParameter = (IrTypeParameter)fakeTypeParameters.get(it.getIndex());
                map.put(e, irTypeParameter);
            }
            Map map = result$iv;
            IrTypeParameterRemapper typeRemapper = new IrTypeParameterRemapper(map);
            for (IrTypeParameter fakeTypeParameter : fakeTypeParameters) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object item$iv$iv;
                IrTypeParameter sourceTypeParameter = sourceTypeParameters.get(fakeTypeParameter.getIndex());
                $this$associateWithTo$iv$iv = sourceTypeParameter.getSuperTypes();
                object = fakeTypeParameter;
                boolean $i$f$map2 = false;
                item$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    IrType bl2 = (IrType)item$iv$iv2;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(typeRemapper.remapType((IrType)it));
                }
                ((IrTypeParameter)object).setSuperTypes((List)destination$iv$iv2);
            }
            return fakeTypeParameters;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            void $this$build_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
            IrConstructorCall irConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            JvmBackendContext jvmBackendContext = this.this$0.context;
            ScopeWithIr scopeWithIr = this.this$0.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            JvmIrBuilder $this$build_u24lambda_u2410 = JvmIrBuilderKt.createJvmIrBuilder(jvmBackendContext, scopeWithIr);
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$build_u24lambda_u2410;
            int n = this.irFunctionReference.getStartOffset();
            int endOffset$iv = this.irFunctionReference.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$build_u24lambda_u2410_u24lambda_u249 = this_$iv$iv;
            boolean bl2 = false;
            IrConstructor constructor = this.createConstructor();
            IrVariable boundReceiverVar = this.samSuperType != null && this.boundReceiver != null ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$build_u24lambda_u2410_u24lambda_u249, (IrExpression)this.boundReceiver.getSecond(), null, null, false, null, 30, null) : null;
            this.createInvokeMethod(boundReceiverVar);
            if (this.needToGenerateSamEqualsHashCodeMethods) {
                this.generateSamEqualsHashCodeMethods($this$build_u24lambda_u2410, boundReceiverVar);
            }
            if (this.isKotlinFunInterface) {
                IrUtilsKt.addFakeOverrides$default(this.functionReferenceClass, $this$build_u24lambda_u2410.getBackendContext().getTypeSystem(), null, null, 6, null);
            }
            $this$build_u24lambda_u2410_u24lambda_u249.unaryPlus(this.functionReferenceClass);
            IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$build_u24lambda_u2410_u24lambda_u249, constructor.getSymbol());
            void var17_17 = $this$build_u24lambda_u2410_u24lambda_u249;
            boolean bl3 = false;
            if ($this$build_u24lambda_u2410_u24lambda_u249_u24lambda_u248.getValueArgumentsCount() > 0) {
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                Intrinsics.checkNotNull(pair);
                $this$build_u24lambda_u2410_u24lambda_u249_u24lambda_u248.putValueArgument(0, (IrExpression)pair.getSecond());
            }
            var17_17.unaryPlus(irConstructorCall);
            return this_$iv$iv.doBuild();
        }

        private final void generateSamEqualsHashCodeMethods(JvmIrBuilder $this$generateSamEqualsHashCodeMethods, IrVariable boundReceiverVar) {
            if (this.samSuperType == null) {
                boolean bl = false;
                String string2 = "equals/hashCode can only be generated for fun interface wrappers: " + RenderIrElementKt.render$default(this.callee, null, 1, null);
                throw new IllegalStateException(string2.toString());
            }
            new SamEqualsHashCodeMethodsGenerator($this$generateSamEqualsHashCodeMethods.getBackendContext(), this.functionReferenceClass, this.samSuperType, (Function2<? super IrBuilderWithScope, ? super IrExpression, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> FunctionReferenceBuilder.generateSamEqualsHashCodeMethods$lambda$15(this, $this$generateSamEqualsHashCodeMethods, boundReceiverVar, arg_0, arg_1))).generate();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            void $this$createConstructor_u24lambda_u2422_u24lambda_u2421;
            Object it;
            IrConstructor irConstructor;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
            boolean bl2 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u2416 = $this$addConstructor_u24lambda_u2425$iv;
            boolean bl3 = false;
            $this$createConstructor_u24lambda_u2416.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_MEMBER_IN_CALLABLE_REFERENCE());
            $this$createConstructor_u24lambda_u2416.setReturnType(IrUtilsKt.getDefaultType(this.functionReferenceClass));
            $this$createConstructor_u24lambda_u2416.setPrimary(true);
            $this$addConstructor_u24lambda_u2425$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2424$iv$iv);
            boolean bl4 = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            ((IrDeclarationBase)constructor$iv).setParent($this$addConstructor$iv);
            Object object = $this$buildConstructor$iv$iv;
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            Object $this$createConstructor_u24lambda_u2422 = object;
            boolean bl5 = false;
            if (this.samSuperType == null && this.boundReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$createConstructor_u24lambda_u2422, "receiver", functionReferenceLowering.context.getIrBuiltIns().getAnyNType(), null, 4, null);
            }
            if (this.isFunInterfaceConstructorReference) {
                irConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)functionReferenceLowering.context.getIr().getSymbols().getFunInterfaceConstructorReferenceClass().getOwner()));
            } else if (this.samSuperType != null) {
                irConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)functionReferenceLowering.context.getIrBuiltIns().getAnyClass().getOwner()));
            } else {
                int expectedArity = this.isLightweightLambda && !this.isAdaptedReference ? 0 : (this.isHeavyweightLambda && !this.isAdaptedReference ? 1 : 1 + (this.boundReceiver != null ? 1 : 0) + 4);
                IrClass irClass = IrTypesKt.getClass(this.superType);
                Intrinsics.checkNotNull((Object)irClass);
                Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors(irClass);
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (IrConstructor)element$iv;
                    boolean bl6 = false;
                    if (!(((IrFunction)it).getValueParameters().size() == expectedArity)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irConstructor = single$iv;
            }
            IrConstructor constructor = irConstructor;
            JvmIrBuilder $this$single$iv = JvmIrBuilderKt.createJvmIrBuilder$default(functionReferenceLowering.context, ((IrConstructor)$this$createConstructor_u24lambda_u2422).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$createConstructor_u24lambda_u2422;
            boolean bl7 = false;
            IrBuilderWithScope single$iv = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2422_u24lambda_u2421;
            int found$iv = $this$createConstructor_u24lambda_u2422_u24lambda_u2421.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2422_u24lambda_u2421.getEndOffset();
            boolean $i$f$irBlockBody = false;
            it = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420 = this_$iv$iv;
            boolean bl8 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420, constructor);
            void var20_34 = $this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420;
            boolean bl9 = false;
            if (this.samSuperType == null) {
                void call2;
                this.generateConstructorCallArguments((JvmIrBuilder)$this$createConstructor_u24lambda_u2422_u24lambda_u2421, (IrFunctionAccessExpression)call2, (Function1<? super IrBuilder, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceBuilder.createConstructor$lambda$22$lambda$21$lambda$20$lambda$19$lambda$18((IrBlockBodyBuilder)$this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420, (IrConstructor)$this$createConstructor_u24lambda_u2422, arg_0)));
            }
            var20_34.unaryPlus(irDelegatingConstructorCall);
            $this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.unaryPlus(org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.getStartOffset(), $this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.getEndOffset(), this.functionReferenceClass.getSymbol(), $this$createConstructor_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.getContext().getIrBuiltIns().getUnitType()));
            ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
            return object;
        }

        private final void generateConstructorCallArguments(JvmIrBuilder $this$generateConstructorCallArguments, IrFunctionAccessExpression call2, Function1<? super IrBuilder, ? extends IrExpression> generateBoundReceiver) {
            if (this.isFunInterfaceConstructorReference) {
                IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                IrClassSymbol irClassSymbol = this.constructedFunInterfaceSymbol;
                Intrinsics.checkNotNull((Object)irClassSymbol);
                IrClassReference funInterfaceKClassRef = JvmIrUtilsKt.kClassReference(irBuilderWithScope, IrUtilsKt.getDefaultType((IrClass)irClassSymbol.getOwner()));
                IrCall funInterfaceJavaClassRef = JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, funInterfaceKClassRef);
                call2.putValueArgument(0, funInterfaceJavaClassRef);
            } else {
                int index2 = 0;
                if (!this.isLightweightLambda) {
                    call2.putValueArgument(index2++, ExpressionHelpersKt.irInt$default($this$generateConstructorCallArguments, this.argumentTypes.size() + (IrUtilsKt.isSuspend(this.irFunctionReference) ? 1 : 0), null, 2, null));
                }
                if (this.boundReceiver != null) {
                    call2.putValueArgument(index2++, (IrExpression)generateBoundReceiver.invoke((Object)$this$generateConstructorCallArguments));
                }
                if (!this.isLambda) {
                    IrFunction irFunction = this.adaptedReferenceOriginalTarget;
                    if (irFunction == null) {
                        irFunction = this.callee;
                    }
                    IrFunction callableReferenceTarget = irFunction;
                    IrExpression owner = Companion.calculateOwnerKClass$backend_jvm_lower($this$generateConstructorCallArguments, callableReferenceTarget.getParent());
                    call2.putValueArgument(index2++, JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, owner));
                    int n = index2++;
                    IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                    String string2 = this.getOriginalName(callableReferenceTarget).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    call2.putValueArgument(n, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
                    call2.putValueArgument(index2++, this.generateSignature($this$generateConstructorCallArguments, callableReferenceTarget.getSymbol()));
                    call2.putValueArgument(index2, ExpressionHelpersKt.irInt$default($this$generateConstructorCallArguments, this.getFunctionReferenceFlags(callableReferenceTarget), null, 2, null));
                }
            }
        }

        private final int getFunctionReferenceFlags(IrFunction callableReferenceTarget) {
            int isTopLevelBit = JvmIrUtilsKt.getCallableReferenceTopLevelFlag(callableReferenceTarget);
            int adaptedCallableReferenceFlags = this.getAdaptedCallableReferenceFlags();
            return isTopLevelBit + (adaptedCallableReferenceFlags << 1);
        }

        private final int getAdaptedCallableReferenceFlags() {
            if (this.adaptedReferenceOriginalTarget == null) {
                return 0;
            }
            int isVarargMappedToElementBit = this.hasVarargMappedToElement() ? 1 : 0;
            int isSuspendConvertedBit = !AdditionalIrUtilsKt.isSuspend(this.adaptedReferenceOriginalTarget) && AdditionalIrUtilsKt.isSuspend(this.callee) ? 1 : 0;
            int isCoercedToUnitBit = !IrTypePredicatesKt.isUnit(this.adaptedReferenceOriginalTarget.getReturnType()) && IrTypePredicatesKt.isUnit(this.callee.getReturnType()) ? 1 : 0;
            return isVarargMappedToElementBit + (isSuspendConvertedBit << 1) + (isCoercedToUnitBit << 2);
        }

        private final boolean hasVarargMappedToElement() {
            if (this.adapteeCall == null) {
                return false;
            }
            int n = this.adapteeCall.getValueArgumentsCount();
            for (int i = 0; i < n; ++i) {
                IrExpression arg;
                if (this.adapteeCall.getValueArgument(i) == null || !(arg instanceof IrVararg)) continue;
                for (IrVarargElement varargElement : ((IrVararg)arg).getElements()) {
                    if (!(varargElement instanceof IrGetValue)) continue;
                    return true;
                }
            }
            return false;
        }

        private final IrSimpleFunction createInvokeMethod(IrValueDeclaration receiverVar) {
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2;
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u2423 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$createInvokeMethod_u24lambda_u2423, this.isLambda ? (IrElement)this.callee : (IrElement)this.irFunctionReference);
            $this$createInvokeMethod_u24lambda_u2423.setName(this.superMethod.getName());
            $this$createInvokeMethod_u24lambda_u2423.setReturnType(this.referenceReturnType);
            $this$createInvokeMethod_u24lambda_u2423.setSuspend(AdditionalIrUtilsKt.isSuspend(this.callee));
            IrSimpleFunction function$iv$iv = irSimpleFunction2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2420$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            IrSimpleFunction $this$createInvokeMethod_u24lambda_u2424 = irSimpleFunction = irSimpleFunction2;
            boolean bl4 = false;
            $this$createInvokeMethod_u24lambda_u2424.setMetadata(this.functionReferenceClass.getMetadata());
            $this$createInvokeMethod_u24lambda_u2424.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$createInvokeMethod_u24lambda_u2424.getOverriddenSymbols(), (Object)this.superMethod.getSymbol()));
            $this$createInvokeMethod_u24lambda_u2424.setDispatchReceiverParameter(DeclarationBuildersKt.buildReceiverParameter$default($this$createInvokeMethod_u24lambda_u2424, IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER(), IrTypesKt.getDefaultType(this.functionReferenceClass.getSymbol()), 0, 0, 24, null));
            if (this.isLambda) {
                this.createLambdaInvokeMethod($this$createInvokeMethod_u24lambda_u2424);
            } else if (this.isFunInterfaceConstructorReference) {
                this.createFunInterfaceConstructorInvokeMethod($this$createInvokeMethod_u24lambda_u2424);
            } else {
                this.createFunctionReferenceInvokeMethod($this$createInvokeMethod_u24lambda_u2424, receiverVar);
            }
            return irSimpleFunction;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(CollectionsKt.plus((Collection)$this$createLambdaInvokeMethod.getAnnotations(), (Iterable)this.callee.getAnnotations()));
            Iterable $this$associate$iv = IrUtilsKt.getExplicitParameters(this.callee);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IrValueParameter param = (IrValueParameter)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)param, (Object)IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, 0, 0, null, null, null, null, null, false, false, false, 4094, null));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setValueParameters(CollectionsKt.plus((Collection)$this$createLambdaInvokeMethod.getValueParameters(), (Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.callee, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        private final void createFunInterfaceConstructorInvokeMethod(IrSimpleFunction $this$createFunInterfaceConstructorInvokeMethod) {
            IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(this.callee.getValueParameters());
            if (irValueParameter == null) {
                throw new AssertionError((Object)("Single value parameter expected: " + RenderIrElementKt.render$default(this.callee, null, 1, null)));
            }
            IrValueParameter adapterValueParameter = irValueParameter;
            IrValueParameter invokeValueParameter = IrUtilsKt.copyTo$default(adapterValueParameter, $this$createFunInterfaceConstructorInvokeMethod, null, 0, 0, null, null, null, null, null, false, false, false, 4094, null);
            Map valueParameterMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)adapterValueParameter, (Object)invokeValueParameter));
            $this$createFunInterfaceConstructorInvokeMethod.setValueParameters(CollectionsKt.listOf((Object)invokeValueParameter));
            $this$createFunInterfaceConstructorInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.callee, $this$createFunInterfaceConstructorInvokeMethod, valueParameterMap));
            this.callee.setBody(null);
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod, IrValueDeclaration receiver) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2429;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrValueParameter irValueParameter;
            Iterator iterator2 = ((Iterable)this.argumentTypes).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                IrType argumentType = (IrType)iterator2.next();
                IrFunction $this$addValueParameter$iv = $this$createFunctionReferenceInvokeMethod;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv = new IrValueParameterBuilder();
                boolean bl = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2426 = $this$addValueParameter_u24lambda_u2432$iv;
                boolean bl2 = false;
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2426.setName(Name.identifier("" + 'p' + index2));
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2426.setType(argumentType);
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2432$iv, $this$addValueParameter$iv);
                boolean bl3 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
            }
            JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(this.this$0.context, $this$createFunctionReferenceInvokeMethod.getSymbol(), $this$createFunctionReferenceInvokeMethod.getStartOffset(), $this$createFunctionReferenceInvokeMethod.getEndOffset());
            IrSimpleFunction irSimpleFunction = $this$createFunctionReferenceInvokeMethod;
            boolean bl = false;
            int unboundIndex = 0;
            IrFunctionAccessExpression $this$createFunctionReferenceInvokeMethod_u24lambda_u2429_u24lambda_u2428 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2429, this.callee.getSymbol(), this.referenceReturnType);
            boolean bl4 = false;
            for (IrTypeParameter typeParameter : IrUtilsKt.getAllTypeParameters(((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner())) {
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2429_u24lambda_u2428.putTypeArgument(typeParameter.getIndex(), this.typeArgumentsMap.get(typeParameter.getSymbol()));
            }
            for (IrValueParameter parameter2 : IrUtilsKt.getExplicitParameters(this.callee)) {
                IrExpression irExpression;
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                if (Intrinsics.areEqual((Object)(pair != null ? (IrValueParameter)pair.getFirst() : null), (Object)parameter2)) {
                    if (this.samSuperType == null) {
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2429;
                        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2429;
                        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2429;
                        IrValueParameter irValueParameter2 = $this$createFunctionReferenceInvokeMethod.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter2);
                        irExpression = ExpressionHelpersKt.irImplicitCast(irBuilderWithScope, ExpressionHelpersKt.irGetField$default(irBuilderWithScope2, ExpressionHelpersKt.irGet(irBuilderWithScope3, irValueParameter2), Companion.getReceiverField$backend_jvm_lower(this.functionReferenceClass, $this$createFunctionReferenceInvokeMethod_u24lambda_u2429.getBackendContext()), null, 4, null), ((IrExpression)this.boundReceiver.getSecond()).getType());
                    } else {
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2429;
                        IrValueDeclaration irValueDeclaration = receiver;
                        Intrinsics.checkNotNull((Object)irValueDeclaration);
                        irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope, irValueDeclaration);
                    }
                } else if (unboundIndex >= this.argumentTypes.size()) {
                    irExpression = null;
                } else {
                    int n2 = unboundIndex;
                    unboundIndex = n2 + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2429, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n2));
                }
                if ((irValueParameter = irExpression) == null) continue;
                IrValueParameter it = irValueParameter;
                boolean bl5 = false;
                IrExpressionsKt.putArgument($this$createFunctionReferenceInvokeMethod_u24lambda_u2429_u24lambda_u2428, this.callee, parameter2, (IrExpression)((Object)it));
            }
            IrFunctionAccessExpression call2 = irFunctionAccessExpression;
            irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2429, this.inlineAdapterCallIfPossible(call2, $this$createFunctionReferenceInvokeMethod)));
        }

        private final IrExpression inlineAdapterCallIfPossible(IrFunctionAccessExpression expression2, IrSimpleFunction invokeMethod) {
            IrValueDeclaration irValueDeclaration;
            Map map;
            IrValueParameter it;
            IrExpression irExpression;
            IrBlockBody adapterBody;
            IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
            if (irCall == null) {
                return expression2;
            }
            IrCall irCall2 = irCall;
            IrSimpleFunction callee = (IrSimpleFunction)irCall2.getSymbol().getOwner();
            if (!Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE())) {
                return expression2;
            }
            if (callee.isSuspend()) {
                return expression2;
            }
            IrBody irBody = callee.getBody();
            IrBlockBody irBlockBody = adapterBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
            if (adapterBody == null || adapterBody.getStatements().size() != 1) {
                throw new AssertionError((Object)("Unexpected adapter body: " + DumpIrTreeKt.dump$default(callee, null, 1, null)));
            }
            IrStatement resultStatement = adapterBody.getStatements().get(0);
            if (resultStatement instanceof IrReturn) {
                irExpression = ((IrReturn)resultStatement).getValue();
            } else if (resultStatement instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)resultStatement).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT) {
                irExpression = (IrExpression)resultStatement;
            } else if (resultStatement instanceof IrCall) {
                irExpression = (IrExpression)resultStatement;
            } else if (resultStatement instanceof IrConstructorCall) {
                irExpression = (IrExpression)resultStatement;
            } else {
                throw new AssertionError((Object)("Unexpected adapter body: " + DumpIrTreeKt.dump$default(callee, null, 1, null)));
            }
            IrExpression resultExpression = irExpression;
            int startOffset = irCall2.getStartOffset();
            int endOffset = irCall2.getEndOffset();
            LinkedHashMap callArguments = new LinkedHashMap();
            IrBlockImpl inlinedAdapterBlock = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrBlockImpl(startOffset, endOffset, irCall2.getType(), null);
            Ref.IntRef tmpVarIndex = new Ref.IntRef();
            IrValueParameter irValueParameter = callee.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                it = irValueParameter;
                boolean bl = false;
                map = callArguments;
                IrExpression irExpression2 = irCall2.getDispatchReceiver();
                if (irExpression2 == null) {
                    throw new AssertionError((Object)("No dispatch receiver in adapter call: " + DumpIrTreeKt.dump$default(irCall2, null, 1, null)));
                }
                irValueDeclaration = FunctionReferenceBuilder.inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(startOffset, endOffset, tmpVarIndex, invokeMethod, inlinedAdapterBlock, irExpression2);
                map.put(it, irValueDeclaration);
            }
            IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
            if (irValueParameter2 != null) {
                it = irValueParameter2;
                boolean bl = false;
                map = callArguments;
                IrExpression irExpression3 = irCall2.getExtensionReceiver();
                if (irExpression3 == null) {
                    throw new AssertionError((Object)("No extension receiver in adapter call: " + DumpIrTreeKt.dump$default(irCall2, null, 1, null)));
                }
                irValueDeclaration = FunctionReferenceBuilder.inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(startOffset, endOffset, tmpVarIndex, invokeMethod, inlinedAdapterBlock, irExpression3);
                map.put(it, irValueDeclaration);
            }
            for (IrValueParameter valueParameter2 : callee.getValueParameters()) {
                Map map2 = callArguments;
                IrExpression irExpression4 = irCall2.getValueArgument(valueParameter2.getIndex());
                if (irExpression4 == null) {
                    throw new AssertionError((Object)("No value argument #" + valueParameter2.getIndex() + " in adapter call: " + DumpIrTreeKt.dump$default(irCall2, null, 1, null)));
                }
                IrValueDeclaration irValueDeclaration2 = FunctionReferenceBuilder.inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(startOffset, endOffset, tmpVarIndex, invokeMethod, inlinedAdapterBlock, irExpression4);
                map2.put(valueParameter2, irValueDeclaration2);
            }
            IrElement inlinedAdapterResult = resultExpression.transform((IrElementTransformer)new VariableRemapper(callArguments), (Object)null);
            inlinedAdapterBlock.getStatements().add((IrStatement)inlinedAdapterResult);
            callee.setBody(null);
            return (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)inlinedAdapterBlock, invokeMethod);
        }

        private final Name getOriginalName(IrFunction $this$originalName) {
            Object object = $this$originalName.getMetadata();
            if (object == null || (object = object.getName()) == null) {
                object = $this$originalName.getName();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression generateSignature(JvmIrBuilder $this$generateSignature, IrFunctionSymbol target) {
            void $this$generateSignature_u24lambda_u2433_u24lambda_u2432;
            IrFunctionReferenceImpl irFunctionReferenceImpl;
            IrCall irCall;
            IrCall $this$generateSignature_u24lambda_u2433 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateSignature, $this$generateSignature.getBackendContext().getIr().getSymbols().getSignatureStringIntrinsic());
            boolean bl = false;
            IrFunctionReferenceImpl irFunctionReferenceImpl2 = irFunctionReferenceImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrFunctionReferenceImpl(-1, -1, this.irFunctionReference.getType(), target, this.irFunctionReference.getTypeArgumentsCount(), this.irFunctionReference.getReflectionTarget(), null);
            int n = 0;
            IrCall irCall2 = $this$generateSignature_u24lambda_u2433;
            boolean bl2 = false;
            IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$generateSignature_u24lambda_u2433_u24lambda_u2432, this.irFunctionReference, 0, 2, null);
            Unit unit = Unit.INSTANCE;
            irCall2.putValueArgument(n, irFunctionReferenceImpl);
            return irCall;
        }

        private final Pair<IrValueParameter, IrGetObjectValueImpl> createFakeBoundReceiverForJvmStaticInObject() {
            IrClass objectClass = IrUtilsKt.getParentAsClass(this.callee);
            IrDeclaration declaration$iv = this.callee;
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
            boolean bl = false;
            IrValueParameterBuilder $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2434 = $this$buildValueParameter_u24lambda_u2430$iv;
            boolean bl2 = false;
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2434.setName(Name.identifier("$this"));
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2434.setType(IrTypesKt.typeWith(objectClass, new IrType[0]));
            return TuplesKt.to((Object)DeclarationBuildersKt.buildValueParameter(declaration$iv.getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)declaration$iv)), (Object)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetObjectValueImpl(-1, -1, IrTypesKt.typeWith(objectClass, new IrType[0]), objectClass.getSymbol()));
        }

        private static final IrExpression generateSamEqualsHashCodeMethods$lambda$15$lambda$14$lambda$13(IrBuilderWithScope $this_SamEqualsHashCodeMethodsGenerator, IrVariable $boundReceiverVar, IrBuilder $this$generateConstructorCallArguments) {
            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
            IrVariable irVariable = $boundReceiverVar;
            Intrinsics.checkNotNull((Object)irVariable);
            return ExpressionHelpersKt.irGet($this_SamEqualsHashCodeMethodsGenerator, irVariable);
        }

        private static final IrExpression generateSamEqualsHashCodeMethods$lambda$15(FunctionReferenceBuilder this$0, JvmIrBuilder $this_generateSamEqualsHashCodeMethods, IrVariable $boundReceiverVar, IrBuilderWithScope $this$SamEqualsHashCodeMethodsGenerator, IrExpression it) {
            IrConstructorCall irConstructorCall;
            Intrinsics.checkNotNullParameter((Object)$this$SamEqualsHashCodeMethodsGenerator, (String)"$this$SamEqualsHashCodeMethodsGenerator");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            IrClassSymbol internalClass = this$0.isAdaptedReference ? $this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getAdaptedFunctionReference() : $this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getFunctionReferenceImpl();
            Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors((IrClass)internalClass.getOwner());
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it2 = (IrConstructor)element$iv;
                boolean bl = false;
                if (!(it2.getValueParameters().size() == 1 + (this$0.boundReceiver != null ? 1 : 0) + 4)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrConstructor constructor = single$iv;
            IrConstructorCall $this$generateSamEqualsHashCodeMethods_u24lambda_u2415_u24lambda_u2414 = irConstructorCall = ExpressionHelpersKt.irCallConstructor($this$SamEqualsHashCodeMethodsGenerator, constructor.getSymbol(), CollectionsKt.emptyList());
            boolean bl = false;
            this$0.generateConstructorCallArguments($this_generateSamEqualsHashCodeMethods, $this$generateSamEqualsHashCodeMethods_u24lambda_u2415_u24lambda_u2414, (Function1<? super IrBuilder, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceBuilder.generateSamEqualsHashCodeMethods$lambda$15$lambda$14$lambda$13($this$SamEqualsHashCodeMethodsGenerator, $boundReceiverVar, arg_0)));
            return irConstructorCall;
        }

        private static final IrExpression createConstructor$lambda$22$lambda$21$lambda$20$lambda$19$lambda$18(IrBlockBodyBuilder $this_irBlockBody, IrConstructor $this_apply, IrBuilder $this$generateConstructorCallArguments) {
            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
            return ExpressionHelpersKt.irGet($this_irBlockBody, (IrValueDeclaration)CollectionsKt.first($this_apply.getValueParameters()));
        }

        private static final IrValueDeclaration inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(int startOffset, int endOffset, Ref.IntRef tmpVarIndex, IrSimpleFunction $invokeMethod, IrBlockImpl inlinedAdapterBlock, IrExpression expression2) {
            if (expression2 instanceof IrGetValue) {
                return ((IrGetValue)expression2).getSymbol().getOwner();
            }
            if (!(expression2 instanceof IrTypeOperatorCall) || !(((IrTypeOperatorCall)expression2).getArgument() instanceof IrGetField)) {
                throw new AssertionError((Object)("Unexpected adapter argument:\n" + DumpIrTreeKt.dump$default(expression2, null, 1, null)));
            }
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
            IrVariableSymbol irVariableSymbol = new IrVariableSymbolImpl(null, 1, null);
            int n = tmpVarIndex.element;
            tmpVarIndex.element = n + 1;
            Name name2 = Name.identifier("tmp_" + n);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            IrVariableImpl temporaryVar = BuildersKt.IrVariableImpl(startOffset, endOffset, irDeclarationOrigin, irVariableSymbol, name2, expression2.getType(), false, false, false);
            temporaryVar.setParent($invokeMethod);
            temporaryVar.setInitializer(expression2);
            inlinedAdapterBlock.getStatements().add(temporaryVar);
            return temporaryVar;
        }
    }
}

