/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiSwitchBlockImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiSwitchExpressionImpl
extends PsiSwitchBlockImpl
implements PsiSwitchExpression {
    public PsiSwitchExpressionImpl() {
        super(JavaElementType.SWITCH_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        if (PsiUtil.isLanguageLevel8OrHigher(this) && PsiPolyExpressionUtil.isPolyExpression(this) && !MethodCandidateInfo.isOverloadCheck(PsiUtil.skipParenthesizedExprUp(this.getParent()))) {
            return InferenceSession.getTargetType(this);
        }
        List<PsiExpression> resultExpressions = PsiUtil.getSwitchResultExpressions(this);
        HashSet<PsiType> resultTypes = new HashSet<PsiType>();
        for (PsiExpression expression2 : resultExpressions) {
            PsiType resultExpressionType = expression2.getType();
            if (resultExpressionType == null) {
                return null;
            }
            resultTypes.add(resultExpressionType);
        }
        if (resultTypes.isEmpty()) {
            return null;
        }
        if (resultTypes.size() == 1) {
            return (PsiType)ContainerUtil.getFirstItem(resultTypes);
        }
        if (resultTypes.stream().allMatch(type2 -> PsiTypes.booleanType().isAssignableFrom((PsiType)type2))) {
            return PsiTypes.booleanType();
        }
        int[] ranks = resultTypes.stream().mapToInt(type2 -> TypeConversionUtil.getTypeRank(type2)).toArray();
        int maxRank = ArrayUtil.max(ranks);
        if (TypeConversionUtil.isNumericType(maxRank)) {
            if (maxRank == 7) {
                return PsiTypes.doubleType();
            }
            if (maxRank == 6) {
                return PsiTypes.floatType();
            }
            if (maxRank == 5) {
                return PsiTypes.longType();
            }
            if (PsiSwitchExpressionImpl.isNumericPromotion(resultExpressions, ranks, PsiTypes.charType())) {
                return PsiTypes.charType();
            }
            if (PsiSwitchExpressionImpl.isNumericPromotion(resultExpressions, ranks, PsiTypes.shortType())) {
                return PsiTypes.shortType();
            }
            if (PsiSwitchExpressionImpl.isNumericPromotion(resultExpressions, ranks, PsiTypes.byteType())) {
                return PsiTypes.byteType();
            }
            return PsiTypes.intType();
        }
        PsiType leastUpperBound = PsiTypes.nullType();
        for (PsiType type3 : resultTypes) {
            if (TypeConversionUtil.isPrimitiveAndNotNull(type3)) {
                type3 = ((PsiPrimitiveType)type3).getBoxedType(this);
            }
            leastUpperBound = GenericsUtil.getLeastUpperBound(type3, leastUpperBound, this.getManager());
        }
        return leastUpperBound != null ? PsiUtil.captureToplevelWildcards(leastUpperBound, this) : null;
    }

    private static boolean isNumericPromotion(List<PsiExpression> resultExpressions, int[] ranks, PsiPrimitiveType type2) {
        return ArrayUtil.find(ranks, TypeConversionUtil.getTypeRank(type2)) > -1 && resultExpressions.stream().allMatch(expression2 -> TypeConversionUtil.areTypesAssignmentCompatible(type2, expression2));
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiSwitchExpressionImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSwitchExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            PsiSwitchExpressionImpl.$$$reportNull$$$0(1);
        }
        if (newElement == null) {
            PsiSwitchExpressionImpl.$$$reportNull$$$0(2);
        }
        super.replaceChildInternal(child, JavaSourceUtil.addParenthToReplacedChild(child, newElement, this.getManager()));
    }

    @Override
    public String toString() {
        PsiExpression expression2 = this.getExpression();
        return "PsiSwitchExpression: " + (expression2 != null ? expression2.getText() : "(incomplete)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiSwitchExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceChildInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

