/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationTargetUtil {
    private static final Logger LOG = Logger.getInstance(AnnotationTargetUtil.class);
    public static final Set<PsiAnnotation.TargetType> DEFAULT_TARGETS = Collections.unmodifiableSet(EnumSet.of(PsiAnnotation.TargetType.PACKAGE, new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.MODULE, PsiAnnotation.TargetType.RECORD_COMPONENT}));
    private static final PsiAnnotation.TargetType[] PACKAGE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
    private static final PsiAnnotation.TargetType[] TYPE_USE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] ANNOTATION_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] CONSTRUCTOR_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] METHOD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] FIELD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] RECORD_COMPONENT_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.RECORD_COMPONENT, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] LOCAL_VARIABLE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] MODULE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.MODULE};

    public static PsiAnnotation.TargetType @NotNull [] getTargetsForLocation(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(0);
            }
            return PsiAnnotation.TargetType.EMPTY_ARRAY;
        }
        if (owner instanceof PsiType || owner instanceof PsiTypeElement) {
            if (TYPE_USE_TARGETS == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(1);
            }
            return TYPE_USE_TARGETS;
        }
        if (owner instanceof PsiTypeParameter) {
            if (TYPE_PARAMETER_TARGETS == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(2);
            }
            return TYPE_PARAMETER_TARGETS;
        }
        if (owner instanceof PsiModifierList) {
            PsiElement element2 = ((PsiModifierList)owner).getParent();
            if (element2 instanceof PsiPackageStatement) {
                if (PACKAGE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(3);
                }
                return PACKAGE_TARGETS;
            }
            if (element2 instanceof PsiClass) {
                if (((PsiClass)element2).getModifierList() != owner) {
                    if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(4);
                    }
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                if (((PsiClass)element2).isAnnotationType()) {
                    if (ANNOTATION_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(5);
                    }
                    return ANNOTATION_TARGETS;
                }
                if (TYPE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(6);
                }
                return TYPE_TARGETS;
            }
            if (element2 instanceof PsiRecordComponent) {
                if (RECORD_COMPONENT_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(7);
                }
                return RECORD_COMPONENT_TARGETS;
            }
            if (element2 instanceof PsiMethod) {
                if (((PsiMethod)element2).isConstructor()) {
                    if (CONSTRUCTOR_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(8);
                    }
                    return CONSTRUCTOR_TARGETS;
                }
                if (METHOD_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(9);
                }
                return METHOD_TARGETS;
            }
            if (element2 instanceof PsiField) {
                if (FIELD_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(10);
                }
                return FIELD_TARGETS;
            }
            if (element2 instanceof PsiParameter) {
                PsiElement scope = element2.getParent();
                if (scope instanceof PsiForeachStatement || element2 instanceof PsiPatternVariable) {
                    if (LOCAL_VARIABLE_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(11);
                    }
                    return LOCAL_VARIABLE_TARGETS;
                }
                if (scope instanceof PsiParameterList && scope.getParent() instanceof PsiLambdaExpression && ((PsiParameter)element2).getTypeElement() == null) {
                    if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(12);
                    }
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                if (PARAMETER_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(13);
                }
                return PARAMETER_TARGETS;
            }
            if (element2 instanceof PsiLocalVariable) {
                if (LOCAL_VARIABLE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(14);
                }
                return LOCAL_VARIABLE_TARGETS;
            }
            if (element2 instanceof PsiReceiverParameter) {
                if (TYPE_USE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(15);
                }
                return TYPE_USE_TARGETS;
            }
            if (element2 instanceof PsiJavaModule) {
                if (MODULE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(16);
                }
                return MODULE_TARGETS;
            }
        }
        if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(17);
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> extractRequiredAnnotationTargets(@Nullable PsiAnnotationMemberValue value2) {
        if (value2 instanceof PsiReference) {
            PsiAnnotation.TargetType targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)value2));
            if (targetType != null) {
                return Collections.singleton(targetType);
            }
        } else if (value2 instanceof PsiArrayInitializerMemberValue) {
            EnumSet<PsiAnnotation.TargetType> targets = EnumSet.noneOf(PsiAnnotation.TargetType.class);
            for (PsiAnnotationMemberValue initializer : ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                PsiAnnotation.TargetType targetType;
                if (!(initializer instanceof PsiReference) || (targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)initializer))) == null) continue;
                targets.add(targetType);
            }
            return targets;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation.TargetType translateTargetRef(@NotNull PsiReference reference2) {
        PsiElement field;
        String name2;
        if (reference2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(18);
        }
        if (reference2 instanceof PsiJavaCodeReferenceElement && (name2 = ((PsiJavaCodeReferenceElement)reference2).getReferenceName()) != null) {
            try {
                return PsiAnnotation.TargetType.valueOf(name2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((field = reference2.resolve()) instanceof PsiEnumConstant) {
            String name3 = ((PsiEnumConstant)field).getName();
            try {
                return PsiAnnotation.TargetType.valueOf(name3);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unknown target: " + name3);
            }
        }
        return null;
    }

    public static boolean isTypeAnnotation(@NotNull PsiAnnotation element2) {
        if (element2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(19);
        }
        return AnnotationTargetUtil.findAnnotationTarget(element2, PsiAnnotation.TargetType.TYPE_USE) == PsiAnnotation.TargetType.TYPE_USE;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiAnnotation annotation, PsiAnnotation.TargetType ... types2) {
        PsiClass annotationType2;
        if (annotation == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(20);
        }
        if (types2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(21);
        }
        if (types2.length != 0 && (annotationType2 = annotation.resolveAnnotationType()) != null) {
            return AnnotationTargetUtil.findAnnotationTarget(annotationType2, types2);
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiClass annotationType2, PsiAnnotation.TargetType ... types2) {
        Set<PsiAnnotation.TargetType> targets;
        if (annotationType2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(22);
        }
        if (types2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(23);
        }
        if (types2.length != 0 && (targets = AnnotationTargetUtil.getAnnotationTargets(annotationType2)) != null) {
            for (PsiAnnotation.TargetType type2 : types2) {
                if (type2 == PsiAnnotation.TargetType.UNKNOWN || !targets.contains((Object)type2)) continue;
                return type2;
            }
            return null;
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> getAnnotationTargets(@NotNull PsiClass annotationType2) {
        if (annotationType2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(24);
        }
        if (!annotationType2.isAnnotationType()) {
            return null;
        }
        PsiModifierList modifierList2 = annotationType2.getModifierList();
        if (modifierList2 == null) {
            return null;
        }
        return (Set)CachedValuesManager.getCachedValue(modifierList2, () -> CachedValueProvider.Result.create(AnnotationTargetUtil.calcAnnotationTargets(modifierList2), PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private static Set<PsiAnnotation.TargetType> calcAnnotationTargets(PsiModifierList modifierList2) {
        PsiAnnotation target = modifierList2.findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return DEFAULT_TARGETS;
        }
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute(target, null);
        if (attribute == null) {
            return null;
        }
        return AnnotationTargetUtil.extractRequiredAnnotationTargets(attribute.getDetachedValue());
    }

    @Contract(pure=true)
    @Nullable
    public static PsiAnnotationOwner getTarget(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotation) {
        PsiModifierList list;
        if (modifierListOwner == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(25);
        }
        if (annotation == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(26);
        }
        if ((list = modifierListOwner.getModifierList()) == null) {
            return null;
        }
        PsiClass annotationClass = JavaPsiFacade.getInstance(modifierListOwner.getProject()).findClass(annotation, modifierListOwner.getResolveScope());
        return AnnotationTargetUtil.getTarget(modifierListOwner, annotationClass != null && AnnotationTargetUtil.findAnnotationTarget(annotationClass, PsiAnnotation.TargetType.TYPE_USE) != null);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiAnnotationOwner getTarget(@NotNull PsiModifierListOwner modifierListOwner, boolean existsTypeUseTarget) {
        PsiModifierList list;
        if (modifierListOwner == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(27);
        }
        if ((list = modifierListOwner.getModifierList()) == null) {
            return null;
        }
        if (existsTypeUseTarget && !(modifierListOwner instanceof PsiCompiledElement)) {
            PsiElement parent2 = list.getParent();
            PsiTypeElement type2 = null;
            if (parent2 instanceof PsiMethod) {
                type2 = ((PsiMethod)parent2).getReturnTypeElement();
            } else if (parent2 instanceof PsiVariable) {
                type2 = ((PsiVariable)parent2).getTypeElement();
            }
            if (type2 != null && type2.acceptsAnnotations()) {
                return type2;
            }
        }
        return list;
    }

    public static void collectStrictlyTypeUseAnnotations(PsiModifierList modifierList2, List<? super PsiAnnotation> annotations2) {
        if (modifierList2 == null) {
            return;
        }
        for (PsiAnnotation annotation : modifierList2.getAnnotations()) {
            if (!AnnotationTargetUtil.isStrictlyTypeUseAnnotation(modifierList2, annotation)) continue;
            annotations2.add(annotation);
        }
    }

    public static PsiType keepStrictlyTypeUseAnnotations(@Nullable PsiModifierList modifierList2, @NotNull PsiType type2) {
        PsiAnnotation[] originalAnnotations2;
        if (type2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(28);
        }
        if (modifierList2 == null) {
            return type2;
        }
        ArrayList<PsiAnnotation> annotations2 = new ArrayList<PsiAnnotation>();
        for (PsiAnnotation annotation : originalAnnotations2 = type2.getAnnotations()) {
            if (!AnnotationTargetUtil.isStrictlyTypeUseAnnotation(modifierList2, annotation)) continue;
            annotations2.add(annotation);
        }
        if (originalAnnotations2.length == annotations2.size()) {
            return type2;
        }
        return annotations2.isEmpty() ? type2.annotate(TypeAnnotationProvider.EMPTY) : type2.annotate(TypeAnnotationProvider.Static.create(annotations2.toArray(PsiAnnotation.EMPTY_ARRAY)));
    }

    public static boolean isStrictlyTypeUseAnnotation(PsiModifierList modifierList2, PsiAnnotation annotation) {
        Set<PsiAnnotation.TargetType> targets;
        PsiElement parent2 = annotation.getParent();
        if (parent2 instanceof PsiJavaCodeReferenceElement || parent2 instanceof PsiTypeElement) {
            return true;
        }
        PsiClass annotationClass = annotation.resolveAnnotationType();
        return annotationClass != null && (targets = AnnotationTargetUtil.getAnnotationTargets(annotationClass)) != null && targets.contains((Object)PsiAnnotation.TargetType.TYPE_USE) && (targets.size() == 1 || NullableNotNullManager.isNullabilityAnnotation(annotation) || !ContainerUtil.exists(AnnotationTargetUtil.getTargetsForLocation(modifierList2), target -> target != PsiAnnotation.TargetType.TYPE_USE && targets.contains(target)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationTargetUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationType";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsForLocation";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationTargetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "translateTargetRef";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTypeAnnotation";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationTarget";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTargets";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "keepStrictlyTypeUseAnnotations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

