/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirOperationNameConventions;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAssignmentOperatorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirAssignmentOperatorCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirAssignmentOperatorCallChecker INSTANCE = new FirAssignmentOperatorCallChecker();

    private FirAssignmentOperatorCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol resolvedCalleeSymbol = firNamedFunctionSymbol;
        Name resolvedCalleeName = resolvedCalleeSymbol.getName();
        if (expression2.getOrigin() != FirFunctionCallOrigin.Operator || !FirOperationNameConventions.INSTANCE.getASSIGNMENT_NAMES().containsKey(resolvedCalleeName)) {
            return;
        }
        if (!ConeBuiltinTypeUtilsKt.isUnit(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getResolvedType(expression2), context2.getSession(), null, 2, null))) {
            AbstractKtSourceElement abstractKtSourceElement = expression2.getSource();
            KtDiagnosticFactory2<FirNamedFunctionSymbol, String> ktDiagnosticFactory2 = FirErrors.INSTANCE.getASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT();
            FirOperation firOperation = FirOperationNameConventions.INSTANCE.getASSIGNMENT_NAMES().get(resolvedCalleeName);
            Intrinsics.checkNotNull((Object)((Object)firOperation));
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)resolvedCalleeSymbol, (Object)firOperation.getOperator(), (DiagnosticContext)context2, null, 32, null);
        }
    }
}

