/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticList;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.LLFirDiagnosticVisitor;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eJ\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!J(\u0010\"\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u001f0\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0#2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0#J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "structureElements", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "invalidateElement", "", "element", "getStructureElementFor", "addStructureElementForTo", "result", "", "getContainerKtElement", "getStructureKtElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isPartOfSuperClassCall", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getAllDiagnosticsForFile", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "diagnosticCheckerFilter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "collectDiagnosticsFromStructureElements", "", "getAllStructureElements", "createDeclarationStructure", "declaration", "createDanglingModifierListStructure", "container", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "createStructureElement", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFileStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 5 LLFirDiagnosticVisitor.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/LLFirDiagnosticVisitor$Companion\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 FileStructureElementDiagnostics.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics\n+ 9 FileStructureElementDiagnosticList.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticList\n+ 10 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,244:1\n72#2,2:245\n1#3:247\n37#4,2:248\n135#5,6:250\n141#5,2:257\n8#6:256\n1863#7:259\n1863#7,2:263\n1864#7:269\n1863#7,2:270\n37#8,2:260\n40#8,4:265\n16#9:262\n81#10,7:272\n76#10,2:279\n57#10:281\n78#10:282\n*S KotlinDebug\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n*L\n88#1:245,2\n88#1:247\n92#1:248,2\n93#1:250,6\n93#1:257,2\n93#1:256\n156#1:259\n157#1:263,2\n156#1:269\n200#1:270,2\n157#1:260,2\n157#1:265,4\n157#1:262\n239#1:272,7\n239#1:279,2\n239#1:281\n239#1:282\n*E\n"})
public final class FileStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final FirFile firFile;
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final FirProvider firProvider;
    @NotNull
    private final ConcurrentHashMap<KtElement, FileStructureElement> structureElements;

    private FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents) {
        this.ktFile = ktFile;
        this.firFile = firFile;
        this.moduleComponents = moduleComponents;
        this.firProvider = FirProviderKt.getFirProvider(this.firFile.getModuleData().getSession());
        this.structureElements = new ConcurrentHashMap();
    }

    public final void invalidateElement(@NotNull KtElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        KtElement container = this.getContainerKtElement(element2);
        this.structureElements.remove(container);
    }

    @NotNull
    public final FileStructureElement getStructureElementFor(@NotNull KtElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        KtElement container = this.getContainerKtElement(element2);
        ConcurrentMap $this$getOrPut$iv = this.structureElements;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(container);
        if (object == null) {
            boolean bl = false;
            FileStructureElement default$iv = this.createStructureElement(container);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(container, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (FileStructureElement)object;
    }

    private final void addStructureElementForTo(KtElement element2, Collection<FileStructureElement> result2) {
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirDiagnosticVisitor.Companion this_$iv = LLFirDiagnosticVisitor.Companion;
        boolean $i$f$suppressAndLogExceptions = false;
        try {
            boolean bl = false;
            result2.add(this.getStructureElementFor(element2));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e$iv);
            LLFirDiagnosticVisitor.Companion $this$thisLogger$iv$iv = this_$iv;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(LLFirDiagnosticVisitor.Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("The diagnostic collector has been interrupted by an exception. The result may be incomplete", e$iv);
            Object var6_8 = null;
        }
    }

    private final KtElement getContainerKtElement(KtElement element2) {
        KtDeclaration declaration2 = this.getStructureKtElement(element2);
        KtElement container = null;
        if (declaration2 != null) {
            container = declaration2;
        } else {
            KtElement ktElement;
            KtModifierList modifierList2 = PsiTreeUtil.getParentOfType((PsiElement)element2, KtModifierList.class, false);
            if (modifierList2 != null && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(modifierList2, false, 1, null) instanceof PsiErrorElement) {
                ktElement = modifierList2;
            } else {
                KtFile ktFile = element2.getContainingKtFile();
                Intrinsics.checkNotNull((Object)ktFile);
                ktElement = ktFile;
            }
            container = ktElement;
        }
        return container;
    }

    private final KtDeclaration getStructureKtElement(KtElement element2) {
        KtPrimaryConstructor resultedContainer;
        KtDeclaration container = FirElementBuilderKt.getNonLocalContainingOrThisDeclaration(element2, (Function1<? super KtDeclaration, Boolean>)((Function1)FileStructure::getStructureKtElement$lambda$2));
        KtPrimaryConstructor ktPrimaryConstructor = resultedContainer = container instanceof KtClassOrObject && this.isPartOfSuperClassCall((KtClassOrObject)container, element2) ? ((KtClassOrObject)container).getPrimaryConstructor() : null;
        return ktPrimaryConstructor != null ? (KtDeclaration)ktPrimaryConstructor : container;
    }

    private final boolean isPartOfSuperClassCall(KtClassOrObject $this$isPartOfSuperClassCall, KtElement element2) {
        for (KtSuperTypeListEntry entry : $this$isPartOfSuperClassCall.getSuperTypeListEntries()) {
            boolean typeReferenceIsAncestor;
            if (!(entry instanceof KtSuperTypeCallEntry)) continue;
            KtTypeReference ktTypeReference = ((KtSuperTypeCallEntry)entry).getCalleeExpression().getTypeReference();
            boolean bl = ktTypeReference != null ? PsiUtilsKt.isAncestor(ktTypeReference, element2, false) : (typeReferenceIsAncestor = false);
            if (typeReferenceIsAncestor) {
                return false;
            }
            if (!PsiUtilsKt.isAncestor(entry, element2, false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getAllDiagnosticsForFile(@NotNull DiagnosticCheckerFilter diagnosticCheckerFilter) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticCheckerFilter), (String)"diagnosticCheckerFilter");
        Collection<FileStructureElement> structureElements = this.getAllStructureElements();
        List $this$getAllDiagnosticsForFile_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.collectDiagnosticsFromStructureElements($this$getAllDiagnosticsForFile_u24lambda_u243, structureElements, diagnosticCheckerFilter);
        return CollectionsKt.build((List)list);
    }

    private final void collectDiagnosticsFromStructureElements(Collection<KtPsiDiagnostic> $this$collectDiagnosticsFromStructureElements, Collection<? extends FileStructureElement> structureElements, DiagnosticCheckerFilter diagnosticCheckerFilter) {
        Iterable $this$forEach$iv = structureElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List diagnostics;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv$iv$iv;
            boolean $i$f$forEach3;
            FileStructureElementDiagnosticList this_$iv$iv;
            FileStructureElement structureElement = (FileStructureElement)element$iv;
            boolean bl2 = false;
            FileStructureElementDiagnostics this_$iv = structureElement.getDiagnostics();
            boolean $i$f$forEach4 = false;
            if (diagnosticCheckerFilter.getRunCommonCheckers()) {
                this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByCommonCheckers(this_$iv);
                $i$f$forEach3 = false;
                $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
                $i$f$forEach2 = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    diagnostics = (List)element$iv$iv$iv;
                    bl = false;
                    $this$collectDiagnosticsFromStructureElements.addAll(diagnostics);
                }
            }
            if (!diagnosticCheckerFilter.getRunExtendedCheckers()) continue;
            this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByExtendedCheckers(this_$iv);
            $i$f$forEach3 = false;
            $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
            $i$f$forEach2 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                diagnostics = (List)element$iv$iv$iv;
                bl = false;
                $this$collectDiagnosticsFromStructureElements.addAll(diagnostics);
            }
        }
    }

    @NotNull
    public final Collection<FileStructureElement> getAllStructureElements() {
        Set structureElements = new LinkedHashSet();
        this.addStructureElementForTo(this.ktFile, structureElements);
        this.ktFile.accept(new KtVisitorVoid(this, structureElements){
            final /* synthetic */ FileStructure this$0;
            final /* synthetic */ Set<FileStructureElement> $structureElements;
            {
                this.this$0 = $receiver;
                this.$structureElements = $structureElements;
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }

            public void visitDeclaration(KtDeclaration dcl) {
                boolean canHaveInnerStructure;
                Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                FileStructure.access$addStructureElementForTo(this.this$0, dcl, this.$structureElements);
                boolean bl = canHaveInnerStructure = dcl instanceof KtClassOrObject || dcl instanceof KtScript || dcl instanceof KtDestructuringDeclaration;
                if (canHaveInnerStructure) {
                    dcl.acceptChildren(this);
                }
            }

            public void visitModifierList(KtModifierList list) {
                Intrinsics.checkNotNullParameter((Object)list, (String)"list");
                if (Intrinsics.areEqual((Object)list.getParent(), (Object)FileStructure.access$getKtFile$p(this.this$0))) {
                    FileStructure.access$addStructureElementForTo(this.this$0, list, this.$structureElements);
                }
            }
        });
        return CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)structureElements));
    }

    private final FileStructureElement createDeclarationStructure(KtDeclaration declaration2) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceNonLocalFirDeclaration(declaration2, this.firFile, this.firProvider);
        FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE);
        if (firDeclaration instanceof FirPrimaryConstructor) {
            Iterable $this$forEach$iv = ((FirPrimaryConstructor)firDeclaration).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameter parameter2 = (FirValueParameter)element$iv;
                boolean bl = false;
                FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(parameter2);
                if (firProperty != null) {
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(firProperty, FirResolvePhase.BODY_RESOLVE);
                }
            }
        }
        return FileElementFactory.INSTANCE.createFileStructureElement(firDeclaration, this.firFile, this.moduleComponents);
    }

    private final FileStructureElement createDanglingModifierListStructure(KtModifierList container) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceByTraversingWholeTree(container, this.moduleComponents.getFirFileBuilder(), this.firFile);
        FirDanglingModifierList firDanglingModifierList = firDeclaration instanceof FirDanglingModifierList ? (FirDanglingModifierList)firDeclaration : null;
        if (firDanglingModifierList == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No dangling modifier found", null, null, null, container, null, 46, null);
            throw new KotlinNothingValueException();
        }
        FirDanglingModifierList firDanglingModifierList2 = firDanglingModifierList;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(firDanglingModifierList2, FirResolvePhase.BODY_RESOLVE);
        return new DeclarationStructureElement(this.firFile, firDanglingModifierList2, this.moduleComponents);
    }

    /*
     * WARNING - void declaration
     */
    private final FileStructureElement createStructureElement(KtElement container) {
        FileStructureElement fileStructureElement;
        if (container instanceof KtCodeFragment) {
            FirCodeFragment firCodeFragment = DeclarationUtilsKt.getCodeFragment(this.firFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firCodeFragment, FirResolvePhase.BODY_RESOLVE);
            fileStructureElement = new DeclarationStructureElement(this.firFile, firCodeFragment, this.moduleComponents);
        } else if (container instanceof KtFile) {
            FirFile firFile = this.moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(this.ktFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firFile, FirResolvePhase.BODY_RESOLVE);
            fileStructureElement = new RootStructureElement(firFile, this.moduleComponents);
        } else if (container instanceof KtDeclaration) {
            fileStructureElement = this.createDeclarationStructure((KtDeclaration)container);
        } else if (container instanceof KtModifierList && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(container, false, 1, null) instanceof PsiErrorElement) {
            fileStructureElement = this.createDanglingModifierListStructure((KtModifierList)container);
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Invalid container " + Reflection.getOrCreateKotlinClass(container.getClass());
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$createStructureElement_u24lambda_u247 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$createStructureElement_u24lambda_u247, "container", container);
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        return fileStructureElement;
    }

    private static final boolean getStructureKtElement$lambda$2(KtDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirElementBuilderKt.isAutonomousDeclaration(it);
    }

    public /* synthetic */ FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents, DefaultConstructorMarker $constructor_marker) {
        this(ktFile, firFile, moduleComponents);
    }

    public static final /* synthetic */ void access$addStructureElementForTo(FileStructure $this, KtElement element2, Collection result2) {
        $this.addStructureElementForTo(element2, result2);
    }

    public static final /* synthetic */ KtFile access$getKtFile$p(FileStructure $this) {
        return $this.ktFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure$Companion;", "", "<init>", "()V", "build", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileStructure build(@NotNull KtFile ktFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
            FirFile firFile = moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(ktFile);
            return new FileStructure(ktFile, firFile, moduleComponents, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

