/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.platform.JsPlatformKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001TB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0012\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0006\u0010;\u001a\u00020\u0000J5\u0010<\u001a\u0004\u0018\u00010+2\u0006\u0010=\u001a\u00020+2\b\b\u0002\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020?2\b\b\u0002\u0010A\u001a\u00020?H\u0000\u00a2\u0006\u0002\bBJ;\u0010C\u001a\u00020+2\u0006\u0010=\u001a\u00020+2\b\b\u0002\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020?2\b\b\u0002\u0010A\u001a\u00020?2\u0006\u0010D\u001a\u00020+H\u0000\u00a2\u0006\u0002\bEJ\u001f\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020JH\u0000\u00a2\u0006\u0002\bKJ\u001d\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020G2\u0006\u0010O\u001a\u00020MH\u0000\u00a2\u0006\u0002\bPJ\u0016\u0010Q\u001a\u0004\u0018\u00010-*\u00020-2\u0006\u0010R\u001a\u00020SH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R&\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R*\u0010%\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\u0004\u0012\u00020\u00170\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001f\"\u0004\b(\u0010!R\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010,\u001a\u00020-8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R\u001b\u00102\u001a\u00020-8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00101\u001a\u0004\b3\u0010/R\u001b\u00105\u001a\u00020-8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00101\u001a\u0004\b6\u0010/R\u001b\u00108\u001a\u00020-8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u00101\u001a\u0004\b9\u0010/\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "configuration", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;)V", "environment", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getConfiguration", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "irExceptions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrExceptions$ir_interpreter", "()Ljava/util/List;", "mapOfEnums", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "getMapOfEnums$ir_interpreter", "()Ljava/util/Map;", "setMapOfEnums$ir_interpreter", "(Ljava/util/Map;)V", "mapOfObjects", "getMapOfObjects$ir_interpreter", "setMapOfObjects$ir_interpreter", "javaClassToIrClass", "Ljava/lang/Class;", "getJavaClassToIrClass$ir_interpreter", "setJavaClassToIrClass$ir_interpreter", "functionCache", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment$CacheFunctionSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "kTypeParameterClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getKTypeParameterClass$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "kTypeParameterClass$delegate", "Lkotlin/Lazy;", "kParameterClass", "getKParameterClass$ir_interpreter", "kParameterClass$delegate", "kTypeProjectionClass", "getKTypeProjectionClass$ir_interpreter", "kTypeProjectionClass$delegate", "kTypeClass", "getKTypeClass$ir_interpreter", "kTypeClass$delegate", "copyWithNewCallStack", "getCachedFunction", "symbol", "hasDispatchReceiver", "", "hasExtensionReceiver", "fromDelegatingCall", "getCachedFunction$ir_interpreter", "setCachedFunction", "newFunction", "setCachedFunction$ir_interpreter", "convertToState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "value", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "convertToState$ir_interpreter", "stateToIrExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "state", "original", "stateToIrExpression$ir_interpreter", "getIrClassOfReflectionFromList", "name", "", "CacheFunctionSignature", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreterEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterEnvironment.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,145:1\n1368#2:146\n1454#2,5:147\n808#2,11:152\n774#2:163\n865#2,2:164\n1#3:166\n385#4,11:167\n*S KotlinDebug\n*F\n+ 1 IrInterpreterEnvironment.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment\n*L\n68#1:146\n68#1:147,5\n69#1:152,11\n70#1:163\n70#1:164,2\n140#1:167,11\n*E\n"})
public final class IrInterpreterEnvironment {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final IrInterpreterConfiguration configuration;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final List<IrClass> irExceptions;
    @NotNull
    private Map<IrSymbol, Complex> mapOfEnums;
    @NotNull
    private Map<IrSymbol, Complex> mapOfObjects;
    @NotNull
    private Map<Class<?>, IrClass> javaClassToIrClass;
    @NotNull
    private Map<CacheFunctionSignature, IrFunctionSymbol> functionCache;
    @NotNull
    private final Lazy kTypeParameterClass$delegate;
    @NotNull
    private final Lazy kParameterClass$delegate;
    @NotNull
    private final Lazy kTypeProjectionClass$delegate;
    @NotNull
    private final Lazy kTypeClass$delegate;

    public IrInterpreterEnvironment(@NotNull IrBuiltIns irBuiltIns, @NotNull IrInterpreterConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.irBuiltIns = irBuiltIns;
        this.configuration = configuration2;
        this.callStack = new CallStack();
        this.irExceptions = new ArrayList();
        this.mapOfEnums = new LinkedHashMap();
        this.mapOfObjects = new LinkedHashMap();
        this.javaClassToIrClass = new LinkedHashMap();
        this.functionCache = new LinkedHashMap();
        this.kTypeParameterClass$delegate = LazyKt.lazy(() -> IrInterpreterEnvironment.kTypeParameterClass_delegate$lambda$0(this));
        this.kParameterClass$delegate = LazyKt.lazy(() -> IrInterpreterEnvironment.kParameterClass_delegate$lambda$1(this));
        this.kTypeProjectionClass$delegate = LazyKt.lazy(() -> IrInterpreterEnvironment.kTypeProjectionClass_delegate$lambda$2(this));
        this.kTypeClass$delegate = LazyKt.lazy(() -> IrInterpreterEnvironment.kTypeClass_delegate$lambda$3(this));
        this.mapOfObjects.put(this.irBuiltIns.getUnitClass(), new Common((IrClass)this.irBuiltIns.getUnitClass().getOwner()));
    }

    public /* synthetic */ IrInterpreterEnvironment(IrBuiltIns irBuiltIns, IrInterpreterConfiguration irInterpreterConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            irInterpreterConfiguration = new IrInterpreterConfiguration(null, 0, 0, false, false, false, 63, null);
        }
        this(irBuiltIns, irInterpreterConfiguration);
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final IrInterpreterConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final CallStack getCallStack$ir_interpreter() {
        return this.callStack;
    }

    @NotNull
    public final List<IrClass> getIrExceptions$ir_interpreter() {
        return this.irExceptions;
    }

    @NotNull
    public final Map<IrSymbol, Complex> getMapOfEnums$ir_interpreter() {
        return this.mapOfEnums;
    }

    public final void setMapOfEnums$ir_interpreter(@NotNull Map<IrSymbol, Complex> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.mapOfEnums = map;
    }

    @NotNull
    public final Map<IrSymbol, Complex> getMapOfObjects$ir_interpreter() {
        return this.mapOfObjects;
    }

    public final void setMapOfObjects$ir_interpreter(@NotNull Map<IrSymbol, Complex> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.mapOfObjects = map;
    }

    @NotNull
    public final Map<Class<?>, IrClass> getJavaClassToIrClass$ir_interpreter() {
        return this.javaClassToIrClass;
    }

    public final void setJavaClassToIrClass$ir_interpreter(@NotNull Map<Class<?>, IrClass> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.javaClassToIrClass = map;
    }

    @NotNull
    public final IrClassSymbol getKTypeParameterClass$ir_interpreter() {
        Lazy lazy = this.kTypeParameterClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    @NotNull
    public final IrClassSymbol getKParameterClass$ir_interpreter() {
        Lazy lazy = this.kParameterClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    @NotNull
    public final IrClassSymbol getKTypeProjectionClass$ir_interpreter() {
        Lazy lazy = this.kTypeProjectionClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    @NotNull
    public final IrClassSymbol getKTypeClass$ir_interpreter() {
        Lazy lazy = this.kTypeClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    private IrInterpreterEnvironment(IrInterpreterEnvironment environment) {
        this(environment.irBuiltIns, environment.configuration);
        this.irExceptions.addAll((Collection<IrClass>)environment.irExceptions);
        this.mapOfEnums = environment.mapOfEnums;
        this.mapOfObjects = environment.mapOfObjects;
    }

    /*
     * WARNING - void declaration
     */
    public IrInterpreterEnvironment(@NotNull IrModuleFragment irModule) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        IrElementBase it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        this(irModule.getIrBuiltins(), null, 2, null);
        Iterable iterable = irModule.getFiles();
        List<IrClass> list = this.irExceptions;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDeclarations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrClass)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.isSubclassOf((IrClass)it, (IrClass)this.irBuiltIns.getThrowableClass().getOwner())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
    }

    @NotNull
    public final IrInterpreterEnvironment copyWithNewCallStack() {
        return new IrInterpreterEnvironment(this);
    }

    @Nullable
    public final IrFunctionSymbol getCachedFunction$ir_interpreter(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.functionCache.get(new CacheFunctionSignature(symbol2, hasDispatchReceiver, hasExtensionReceiver, fromDelegatingCall));
    }

    public static /* synthetic */ IrFunctionSymbol getCachedFunction$ir_interpreter$default(IrInterpreterEnvironment irInterpreterEnvironment, IrFunctionSymbol irFunctionSymbol, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return irInterpreterEnvironment.getCachedFunction$ir_interpreter(irFunctionSymbol, bl, bl2, bl3);
    }

    @NotNull
    public final IrFunctionSymbol setCachedFunction$ir_interpreter(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall, @NotNull IrFunctionSymbol newFunction) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)newFunction, (String)"newFunction");
        this.functionCache.put(new CacheFunctionSignature(symbol2, hasDispatchReceiver, hasExtensionReceiver, fromDelegatingCall), newFunction);
        return newFunction;
    }

    public static /* synthetic */ IrFunctionSymbol setCachedFunction$ir_interpreter$default(IrInterpreterEnvironment irInterpreterEnvironment, IrFunctionSymbol irFunctionSymbol, boolean bl, boolean bl2, boolean bl3, IrFunctionSymbol irFunctionSymbol2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return irInterpreterEnvironment.setCachedFunction$ir_interpreter(irFunctionSymbol, bl, bl2, bl3, irFunctionSymbol2);
    }

    @NotNull
    public final State convertToState$ir_interpreter(@Nullable Object value2, @NotNull IrType irType) {
        State state;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Object object = value2;
        if (object instanceof Proxy) {
            state = ((Proxy)value2).getState();
        } else if (object instanceof State) {
            state = (State)value2;
        } else if (object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof String || object instanceof Float || object instanceof Double || object instanceof Object[] || object instanceof byte[] || object instanceof char[] || object instanceof short[] || object instanceof int[] || object instanceof long[] || object instanceof float[] || object instanceof double[] || object instanceof boolean[]) {
            state = new Primitive<Object>(value2, irType);
        } else if (object == null) {
            state = Primitive.Companion.nullStateOfType(irType);
        } else {
            Wrapper wrapper;
            Object object2 = IrTypesKt.getClassOrNull(irType);
            if (object2 != null && (object2 = (IrClass)object2.getOwner()) != null) {
                Object it = object2;
                boolean bl = false;
                wrapper = new Wrapper(value2, (IrClass)it, this);
            } else {
                IrClass irClass = this.javaClassToIrClass.get(value2.getClass());
                Intrinsics.checkNotNull((Object)irClass);
                wrapper = new Wrapper(value2, irClass, this);
            }
            state = wrapper;
        }
        return state;
    }

    @NotNull
    public final IrExpression stateToIrExpression$ir_interpreter(@NotNull State state, @NotNull IrExpression original) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        int start = original.getStartOffset();
        int end = original.getEndOffset();
        IrType type2 = IrTypesKt.makeNotNull(original.getType());
        State state2 = state;
        if (state2 instanceof Primitive) {
            irExpression = JsPlatformKt.isJs(this.configuration.getPlatform()) && ((Primitive)state).getValue() instanceof Float ? (IrExpression)IrConstImpl.Companion.float(start, end, type2, ((Number)((Primitive)state).getValue()).floatValue()) : (JsPlatformKt.isJs(this.configuration.getPlatform()) && ((Primitive)state).getValue() instanceof Double ? (IrExpression)IrConstImpl.Companion.double(start, end, type2, ((Number)((Primitive)state).getValue()).doubleValue()) : (((Primitive)state).getValue() == null || IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null) || IrTypePredicatesKt.isString(type2) ? (IrExpression)IrUtilsKt.toIrConst(((Primitive)state).getValue(), type2, start, end) : original));
        } else if (state2 instanceof ExceptionState) {
            String message = this.configuration.getPrintOnlyExceptionMessage() ? ((ExceptionState)state).getShortDescription() : '\n' + ((ExceptionState)state).getFullDescription();
            irExpression = BuildersKt.IrErrorExpressionImpl(original.getStartOffset(), original.getEndOffset(), original.getType(), message);
        } else if (state2 instanceof Complex) {
            IrSimpleType stateType = IrUtilsKt.getDefaultType(state.getIrClass());
            if (IrTypePredicatesKt.isUnsignedType$default(stateType, false, 1, null)) {
                Object object = CollectionsKt.single((Iterable)state.getFields().values());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
                irExpression = IrUtilsKt.toIrConst(((Primitive)object).getValue(), type2, start, end);
            } else {
                irExpression = original;
            }
        } else {
            irExpression = original;
        }
        return irExpression;
    }

    private final IrClassSymbol getIrClassOfReflectionFromList(IrClassSymbol $this$getIrClassOfReflectionFromList, String name2) {
        IrProperty property;
        IrDeclarationBase irDeclarationBase;
        Object v0;
        block2: {
            Sequence<IrProperty> $this$singleOrNull$iv = IrUtilsKt.getProperties((IrDeclarationContainer)((Object)$this$getIrClassOfReflectionFromList.getOwner()));
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name2)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrType irType = (irDeclarationBase = (property = (IrProperty)v0)) != null && (irDeclarationBase = ((IrProperty)irDeclarationBase).getGetter()) != null ? ((IrFunction)irDeclarationBase).getReturnType() : null;
        IrSimpleType list = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        Object object = list;
        return object != null && (object = ((IrSimpleType)object).getArguments()) != null && (object = (IrTypeArgument)CollectionsKt.single((List)object)) != null && (object = IrTypesKt.getTypeOrNull((IrTypeArgument)object)) != null ? IrTypesKt.getClassOrNull((IrType)object) : null;
    }

    private static final IrClassSymbol kTypeParameterClass_delegate$lambda$0(IrInterpreterEnvironment this$0) {
        IrClassSymbol irClassSymbol = this$0.getIrClassOfReflectionFromList(this$0.irBuiltIns.getKClassClass(), "typeParameters");
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return irClassSymbol;
    }

    private static final IrClassSymbol kParameterClass_delegate$lambda$1(IrInterpreterEnvironment this$0) {
        IrClassSymbol irClassSymbol = this$0.getIrClassOfReflectionFromList(this$0.irBuiltIns.getKFunctionClass(), "parameters");
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return irClassSymbol;
    }

    private static final IrClassSymbol kTypeProjectionClass_delegate$lambda$2(IrInterpreterEnvironment this$0) {
        IrClassSymbol irClassSymbol = this$0.getIrClassOfReflectionFromList(this$0.getKTypeClass$ir_interpreter(), "arguments");
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return irClassSymbol;
    }

    private static final IrClassSymbol kTypeClass_delegate$lambda$3(IrInterpreterEnvironment this$0) {
        return this$0.irBuiltIns.getKTypeClass();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment$CacheFunctionSignature;", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "hasDispatchReceiver", "", "hasExtensionReceiver", "fromDelegatingCall", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;ZZZ)V", "getSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getHasDispatchReceiver", "()Z", "getHasExtensionReceiver", "getFromDelegatingCall", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.interpreter"})
    private static final class CacheFunctionSignature {
        @NotNull
        private final IrFunctionSymbol symbol;
        private final boolean hasDispatchReceiver;
        private final boolean hasExtensionReceiver;
        private final boolean fromDelegatingCall;

        public CacheFunctionSignature(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall) {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            this.symbol = symbol2;
            this.hasDispatchReceiver = hasDispatchReceiver;
            this.hasExtensionReceiver = hasExtensionReceiver;
            this.fromDelegatingCall = fromDelegatingCall;
        }

        @NotNull
        public final IrFunctionSymbol getSymbol() {
            return this.symbol;
        }

        public final boolean getHasDispatchReceiver() {
            return this.hasDispatchReceiver;
        }

        public final boolean getHasExtensionReceiver() {
            return this.hasExtensionReceiver;
        }

        public final boolean getFromDelegatingCall() {
            return this.fromDelegatingCall;
        }

        @NotNull
        public final IrFunctionSymbol component1() {
            return this.symbol;
        }

        public final boolean component2() {
            return this.hasDispatchReceiver;
        }

        public final boolean component3() {
            return this.hasExtensionReceiver;
        }

        public final boolean component4() {
            return this.fromDelegatingCall;
        }

        @NotNull
        public final CacheFunctionSignature copy(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall) {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            return new CacheFunctionSignature(symbol2, hasDispatchReceiver, hasExtensionReceiver, fromDelegatingCall);
        }

        public static /* synthetic */ CacheFunctionSignature copy$default(CacheFunctionSignature cacheFunctionSignature, IrFunctionSymbol irFunctionSymbol, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                irFunctionSymbol = cacheFunctionSignature.symbol;
            }
            if ((n & 2) != 0) {
                bl = cacheFunctionSignature.hasDispatchReceiver;
            }
            if ((n & 4) != 0) {
                bl2 = cacheFunctionSignature.hasExtensionReceiver;
            }
            if ((n & 8) != 0) {
                bl3 = cacheFunctionSignature.fromDelegatingCall;
            }
            return cacheFunctionSignature.copy(irFunctionSymbol, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "CacheFunctionSignature(symbol=" + this.symbol + ", hasDispatchReceiver=" + this.hasDispatchReceiver + ", hasExtensionReceiver=" + this.hasExtensionReceiver + ", fromDelegatingCall=" + this.fromDelegatingCall + ')';
        }

        public int hashCode() {
            int result2 = this.symbol.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasDispatchReceiver);
            result2 = result2 * 31 + Boolean.hashCode(this.hasExtensionReceiver);
            result2 = result2 * 31 + Boolean.hashCode(this.fromDelegatingCall);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheFunctionSignature)) {
                return false;
            }
            CacheFunctionSignature cacheFunctionSignature = (CacheFunctionSignature)other;
            if (!Intrinsics.areEqual((Object)this.symbol, (Object)cacheFunctionSignature.symbol)) {
                return false;
            }
            if (this.hasDispatchReceiver != cacheFunctionSignature.hasDispatchReceiver) {
                return false;
            }
            if (this.hasExtensionReceiver != cacheFunctionSignature.hasExtensionReceiver) {
                return false;
            }
            return this.fromDelegatingCall == cacheFunctionSignature.fromDelegatingCall;
        }
    }
}

