/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ErrorReportingContext;
import org.jetbrains.kotlin.backend.common.IrValidationContext;
import org.jetbrains.kotlin.backend.common.IrValidatorKt;
import org.jetbrains.kotlin.backend.common.phaser.ActionState;
import org.jetbrains.kotlin.backend.common.phaser.BackendContextHolder;
import org.jetbrains.kotlin.backend.common.phaser.BeforeOrAfter;
import org.jetbrains.kotlin.backend.common.phaser.DumperVerifierKt;
import org.jetbrains.kotlin.backend.common.phaser.KotlinBackendIrHolder;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.IrVerificationMode;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a)\u0010\f\u001a\u0004\u0018\u00010\u0002\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u000b\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0010\u001aF\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r`\u0014\"\b\b\u0000\u0010\r*\u00020\u0015\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\u0016\u001a\u00020\u0006\u001a>\u0010\u0017\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r`\u0014\"\u0004\b\u0000\u0010\u000e\"\b\b\u0001\u0010\r*\u00020\u0015\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"?\u0010\u0018\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a`\u00140\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"elementName", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getElementName", "(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/lang/String;", "isDumpNeeded", "", "Lorg/jetbrains/kotlin/backend/common/phaser/ActionState;", "isValidationNeeded", "dumpIrElement", "actionState", "data", "findKotlinBackendIr", "Context", "Data", "context", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/ir/IrElement;", "getIrValidator", "Lkotlin/Function3;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/Action;", "Lorg/jetbrains/kotlin/backend/common/ErrorReportingContext;", "checkTypes", "getIrDumper", "DEFAULT_IR_ACTIONS", "", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getDEFAULT_IR_ACTIONS", "()Ljava/util/Set;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nDumperVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumperVerifier.kt\norg/jetbrains/kotlin/backend/common/phaser/DumperVerifierKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class DumperVerifierKt {
    @NotNull
    private static final Set<Function3<ActionState, IrElement, CommonBackendContext, Unit>> DEFAULT_IR_ACTIONS;

    private static final String getElementName(IrElement $this$elementName) {
        String string2;
        IrElement irElement = $this$elementName;
        if (irElement instanceof IrModuleFragment) {
            String string3 = ((IrModuleFragment)$this$elementName).getName().asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        } else {
            string2 = irElement instanceof IrFile ? IrDeclarationsKt.getName((IrFile)$this$elementName) : $this$elementName.toString();
        }
        return string2;
    }

    private static final boolean isDumpNeeded(ActionState $this$isDumpNeeded) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isDumpNeeded.getBeforeOrAfter().ordinal()]) {
            case 1: {
                bl = $this$isDumpNeeded.getConfig().shouldDumpStateBefore($this$isDumpNeeded.getPhase());
                break;
            }
            case 2: {
                bl = $this$isDumpNeeded.getConfig().shouldDumpStateAfter($this$isDumpNeeded.getPhase());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean isValidationNeeded(ActionState $this$isValidationNeeded) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isValidationNeeded.getBeforeOrAfter().ordinal()]) {
            case 1: {
                bl = $this$isValidationNeeded.getConfig().shouldValidateStateBefore($this$isValidationNeeded.getPhase());
                break;
            }
            case 2: {
                bl = $this$isValidationNeeded.getConfig().shouldValidateStateAfter($this$isValidationNeeded.getPhase());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final String dumpIrElement(ActionState actionState, IrElement data) {
        String beforeOrAfterStr = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(actionState.getBeforeOrAfter().name());
        Ref.ObjectRef dumpText = new Ref.ObjectRef();
        dumpText.element = "";
        String elementName = null;
        String dumpStrategy = System.getProperty("org.jetbrains.kotlin.compiler.ir.dump.strategy");
        Function1 dump2 = Intrinsics.areEqual((Object)dumpStrategy, (Object)"KotlinLike") ? (Function1)dumpIrElement.dump.1.INSTANCE : (Function1)dumpIrElement.dump.2.INSTANCE;
        String dumpOnlyFqName = actionState.getConfig().getDumpOnlyFqName();
        if (dumpOnlyFqName != null) {
            elementName = dumpOnlyFqName;
            IrVisitorsKt.acceptVoid(data, new IrElementVisitorVoid(dumpOnlyFqName, (Ref.ObjectRef<String>)dumpText, (Function1<? super IrElement, String>)dump2){
                final /* synthetic */ String $dumpOnlyFqName;
                final /* synthetic */ Ref.ObjectRef<String> $dumpText;
                final /* synthetic */ Function1<IrElement, String> $dump;
                {
                    this.$dumpOnlyFqName = $dumpOnlyFqName;
                    this.$dumpText = $dumpText;
                    this.$dump = $dump;
                }

                public void visitElement(IrElement element2) {
                    Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element2, this);
                }

                public void visitDeclaration(IrDeclarationBase declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    if (declaration2 instanceof IrDeclarationWithName && Intrinsics.areEqual((Object)new FqName(this.$dumpOnlyFqName), (Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((Object)declaration2)))) {
                        this.$dumpText.element = (String)this.$dumpText.element + (String)this.$dump.invoke((Object)declaration2);
                    } else {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                    }
                }

                public void visitElement(IrElement element2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data);
                }

                public void visitDeclaration(IrDeclarationBase declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
                }

                public void visitValueParameter(IrValueParameter declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
                }

                public void visitValueParameter(IrValueParameter declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                }

                public void visitClass(IrClass declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
                }

                public void visitClass(IrClass declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                }

                public void visitTypeParameter(IrTypeParameter declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
                }

                public void visitTypeParameter(IrTypeParameter declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                }

                public void visitFunction(IrFunction declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
                }

                public void visitFunction(IrFunction declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                }

                public void visitConstructor(IrConstructor declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
                }

                public void visitConstructor(IrConstructor declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                }

                public void visitEnumEntry(IrEnumEntry declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
                }

                public void visitEnumEntry(IrEnumEntry declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                }

                public void visitField(IrField declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
                }

                public void visitField(IrField declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                }

                public void visitModuleFragment(IrModuleFragment declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
                }

                public void visitModuleFragment(IrModuleFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                }

                public void visitProperty(IrProperty declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
                }

                public void visitProperty(IrProperty declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                }

                public void visitScript(IrScript declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
                }

                public void visitScript(IrScript declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
                }

                public void visitTypeAlias(IrTypeAlias declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
                }

                public void visitTypeAlias(IrTypeAlias declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                }

                public void visitVariable(IrVariable declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
                }

                public void visitVariable(IrVariable declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                }

                public void visitPackageFragment(IrPackageFragment declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
                }

                public void visitPackageFragment(IrPackageFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                }

                public void visitFile(IrFile declaration2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
                }

                public void visitFile(IrFile declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                }

                public void visitExpression(IrExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitExpression(IrExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                }

                public void visitBody(IrBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBody(IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitExpressionBody(IrExpressionBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExpressionBody(IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitBlockBody(IrBlockBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBlockBody(IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitConstructorCall(IrConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                }

                public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitContainerExpression(IrContainerExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitBlock(IrBlock expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlock(IrBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitComposite(IrComposite expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                }

                public void visitComposite(IrComposite expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
                }

                public void visitReturnableBlock(IrReturnableBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
                }

                public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitSyntheticBody(IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitBreakContinue(IrBreakContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitBreakContinue(IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreak(IrBreak jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreak(IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitContinue(IrContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitContinue(IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitCall(IrCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                }

                public void visitCall(IrCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                }

                public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitFunctionReference(IrFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitPropertyReference(IrPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitClassReference(IrClassReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitClassReference(IrClassReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                public void visitConst(IrConst<?> expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConst(IrConst<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public void visitConstantValue(IrConstantValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
                }

                public void visitConstantValue(IrConstantValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
                }

                public void visitConstantObject(IrConstantObject expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
                }

                public void visitConstantObject(IrConstantObject expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
                }

                public void visitConstantArray(IrConstantArray expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
                }

                public void visitConstantArray(IrConstantArray expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitErrorExpression(IrErrorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitGetField(IrGetField expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetField(IrGetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitSetField(IrSetField expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSetField(IrSetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                }

                public void visitGetClass(IrGetClass expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetClass(IrGetClass expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitLoop(IrLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
                }

                public void visitLoop(IrLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
                }

                public void visitWhileLoop(IrWhileLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
                }

                public void visitWhileLoop(IrWhileLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
                }

                public void visitReturn(IrReturn expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitReturn(IrReturn expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitStringConcatenation(IrStringConcatenation expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                }

                public void visitThrow(IrThrow expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitThrow(IrThrow expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitTry(IrTry aTry, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTry(IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitCatch(IrCatch aCatch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitCatch(IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                }

                public void visitValueAccess(IrValueAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
                }

                public void visitGetValue(IrGetValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitGetValue(IrGetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitSetValue(IrSetValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
                }

                public void visitSetValue(IrSetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                }

                public void visitVararg(IrVararg expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitVararg(IrVararg expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitSpreadElement(IrSpreadElement spread, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitSpreadElement(IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitWhen(IrWhen expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhen(IrWhen expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitBranch(IrBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBranch(IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitElseBranch(IrElseBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitElseBranch(IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }
            });
        } else {
            elementName = DumperVerifierKt.getElementName(data);
            dumpText.element = dump2.invoke((Object)data);
        }
        String title = "// --- IR for " + elementName + ' ' + beforeOrAfterStr + ' ' + actionState.getPhase().getDescription() + '\n';
        return title + (String)dumpText.element;
    }

    @Nullable
    public static final <Context, Data> IrElement findKotlinBackendIr(Context context2, Data data) {
        return data instanceof IrElement ? (IrElement)data : (data instanceof KotlinBackendIrHolder ? ((KotlinBackendIrHolder)data).getKotlinIr() : (context2 instanceof KotlinBackendIrHolder ? ((KotlinBackendIrHolder)context2).getKotlinIr() : null));
    }

    @NotNull
    public static final <Context extends ErrorReportingContext, Data> Function3<ActionState, Data, Context, Unit> getIrValidator(boolean checkTypes) {
        return (arg_0, arg_1, arg_2) -> DumperVerifierKt.getIrValidator$lambda$1(checkTypes, arg_0, arg_1, arg_2);
    }

    @NotNull
    public static final <Data, Context extends ErrorReportingContext> Function3<ActionState, Data, Context, Unit> getIrDumper() {
        return DumperVerifierKt::getIrDumper$lambda$3;
    }

    @NotNull
    public static final Set<Function3<ActionState, IrElement, CommonBackendContext, Unit>> getDEFAULT_IR_ACTIONS() {
        return DEFAULT_IR_ACTIONS;
    }

    private static final Unit getIrValidator$lambda$1$lambda$0(IrElement $element, ErrorReportingContext $context, ActionState $state, boolean $checkTypes, IrValidationContext $this$validateIr) {
        Intrinsics.checkNotNullParameter((Object)$this$validateIr, (String)"$this$validateIr");
        IrValidationContext.performBasicIrValidation$default($this$validateIr, $element, ((BackendContextHolder)((Object)$context)).getHeldBackendContext().getIrBuiltIns(), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly($state.getBeforeOrAfter().name()) + ' ' + $state.getPhase(), false, $checkTypes, false, false, false, false, null, 1000, null);
        return Unit.INSTANCE;
    }

    private static final <Data, Context extends ErrorReportingContext> Unit getIrValidator$lambda$1(boolean $checkTypes, ActionState state, Data data, Context context2) {
        if (!DumperVerifierKt.isValidationNeeded(state)) {
            return Unit.INSTANCE;
        }
        MessageCollector messageCollector = context2.getMessageCollector();
        if (!(context2 instanceof BackendContextHolder)) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "Cannot verify IR " + (Object)((Object)state.getBeforeOrAfter()) + ' ' + state.getPhase() + ": insufficient context.", null, 4, null);
            return Unit.INSTANCE;
        }
        IrElement element2 = DumperVerifierKt.findKotlinBackendIr(context2, data);
        if (element2 == null) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "Cannot verify IR " + (Object)((Object)state.getBeforeOrAfter()) + ' ' + state.getPhase() + ": IR not found.", null, 4, null);
            return Unit.INSTANCE;
        }
        IrValidatorKt.validateIr(messageCollector, IrVerificationMode.ERROR, (Function1<? super IrValidationContext, Unit>)((Function1)arg_0 -> DumperVerifierKt.getIrValidator$lambda$1$lambda$0(element2, context2, state, $checkTypes, arg_0)));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final <Data, Context extends ErrorReportingContext> Unit getIrDumper$lambda$3(ActionState state, Data data, Context context2) {
        block7: {
            String string2;
            File directoryFile;
            Object object;
            StringBuilder stringBuilder;
            String dumpDirectory;
            String dumpContent;
            block9: {
                block8: {
                    void it;
                    block6: {
                        if (!DumperVerifierKt.isDumpNeeded(state)) {
                            return Unit.INSTANCE;
                        }
                        IrElement element2 = DumperVerifierKt.findKotlinBackendIr(context2, data);
                        if (element2 == null) {
                            MessageCollector.report$default(context2.getMessageCollector(), CompilerMessageSeverity.WARNING, "Cannot dump IR " + (Object)((Object)state.getBeforeOrAfter()) + ' ' + state.getPhase() + ": IR not found.", null, 4, null);
                            return Unit.INSTANCE;
                        }
                        dumpContent = DumperVerifierKt.dumpIrElement(state, element2);
                        dumpDirectory = state.getConfig().getDumpToDirectory();
                        if (dumpDirectory != null) break block6;
                        System.out.println((Object)"\n\n----------------------------------------------");
                        System.out.println((Object)dumpContent);
                        System.out.println();
                        break block7;
                    }
                    stringBuilder = new StringBuilder().append(dumpDirectory);
                    object = data instanceof IrModuleFragment ? (IrModuleFragment)data : null;
                    if (object == null) break block8;
                    IrModuleFragment irModuleFragment = object;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    StringBuilder stringBuilder3 = new StringBuilder().append('/');
                    String string3 = it.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                    String string4 = stringBuilder3.append(StringsKt.removeSurrounding((String)string3, (CharSequence)"<", (CharSequence)">")).toString();
                    stringBuilder = stringBuilder2;
                    object = string4;
                    if (string4 != null) break block9;
                }
                object = "";
            }
            if (!(directoryFile = new File(string2 = stringBuilder.append((String)object).toString())).isDirectory() && !directoryFile.mkdirs()) {
                throw new IllegalStateException(("Can't create directory for IR dumps at " + dumpDirectory).toString());
            }
            String string5 = "%02d";
            Object[] objectArray = new Object[]{state.getPhaseCount()};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            String phaseIdFormatted = string6;
            String dumpStrategy = System.getProperty("org.jetbrains.kotlin.compiler.ir.dump.strategy");
            String extPrefix = Intrinsics.areEqual((Object)dumpStrategy, (Object)"KotlinLike") ? "kt." : "";
            String fileName2 = phaseIdFormatted + '_' + (Object)((Object)state.getBeforeOrAfter()) + '.' + state.getPhase().getName() + '.' + extPrefix + "ir";
            FilesKt.writeText$default((File)new File(directoryFile, fileName2), (String)dumpContent, null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Function3[]{DumperVerifierKt.getIrDumper(), DumperVerifierKt.getIrValidator(false)};
        DEFAULT_IR_ACTIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeforeOrAfter.values().length];
            try {
                nArray[BeforeOrAfter.BEFORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeforeOrAfter.AFTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

