/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance(DefaultJDOMExternalizer.class);
    private static final ClassValue<Map<String, Field>> fieldCache = new DefaultJDOMExternalizerMapClassValue();

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(1);
        }
        DefaultJDOMExternalizer.write(data, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") JDOMFilter filter) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(2);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(3);
        }
        if (filter instanceof Predicate) {
            DefaultJDOMExternalizer.write(data, parentNode, (Predicate)((Object)filter));
        } else {
            DefaultJDOMExternalizer.write(data, parentNode, filter == null ? null : field -> filter.isAccept((Field)field));
        }
    }

    public static void write(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") Predicate<? super Field> filter) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(5);
        }
        for (Field field : fieldCache.get(data.getClass()).values()) {
            Element element2;
            String value2;
            block25: {
                if (filter != null && !filter.test(field)) continue;
                Class<?> type2 = field.getType();
                value2 = null;
                try {
                    if (type2.isPrimitive()) {
                        if (type2.equals(Byte.TYPE)) {
                            value2 = Byte.toString(field.getByte(data));
                        } else if (type2.equals(Short.TYPE)) {
                            value2 = Short.toString(field.getShort(data));
                        } else if (type2.equals(Integer.TYPE)) {
                            value2 = Integer.toString(field.getInt(data));
                        } else if (type2.equals(Long.TYPE)) {
                            value2 = Long.toString(field.getLong(data));
                        } else if (type2.equals(Float.TYPE)) {
                            value2 = Float.toString(field.getFloat(data));
                        } else if (type2.equals(Double.TYPE)) {
                            value2 = Double.toString(field.getDouble(data));
                        } else if (type2.equals(Character.TYPE)) {
                            value2 = String.valueOf(field.getChar(data));
                        } else {
                            if (!type2.equals(Boolean.TYPE)) continue;
                            value2 = Boolean.toString(field.getBoolean(data));
                        }
                        break block25;
                    }
                    if (type2.equals(String.class)) {
                        value2 = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data));
                        break block25;
                    }
                    if (type2.isEnum()) {
                        value2 = field.get(data).toString();
                        break block25;
                    }
                    if (type2.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value2 = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block25;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                        element2 = new Element("option");
                        parentNode.addContent(element2);
                        element2.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element2.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type2);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element2 = new Element("option");
            parentNode.addContent(element2);
            element2.setAttribute("name", field.getName());
            if (value2 == null) continue;
            element2.setAttribute("value", value2);
        }
    }

    @Nullable
    static String filterXMLCharacters(@Nullable String value2) {
        if (value2 == null) {
            return null;
        }
        StringBuilder builder2 = null;
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (Verifier.isXMLCharacter(c)) {
                if (builder2 == null) continue;
                builder2.append(c);
                continue;
            }
            if (builder2 != null) continue;
            builder2 = new StringBuilder(value2.length() + 5);
            builder2.append(value2, 0, i);
        }
        if (builder2 != null) {
            value2 = builder2.toString();
        }
        return value2;
    }

    public static void readExternal(@NotNull Object data, Element parentNode) throws InvalidDataException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(6);
        }
        if (parentNode == null) {
            return;
        }
        Map<String, Field> fields = fieldCache.get(data.getClass());
        block12: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Object value2;
                Field field = fields.get(fieldName);
                if (field == null) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    value2 = field.get(data);
                    if (!(value2 instanceof JDOMExternalizable)) continue;
                    List<Element> children2 = e.getChildren("value");
                    Iterator<Element> iterator2 = children2.iterator();
                    while (iterator2.hasNext()) {
                        Element child;
                        Element valueTag = child = iterator2.next();
                        ((JDOMExternalizable)value2).readExternal(valueTag);
                    }
                    continue;
                }
                value2 = e.getAttributeValue("value");
                Class<?> type2 = field.getType();
                if (type2.isPrimitive()) {
                    if (value2 == null) continue;
                    if (type2.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value2);
                        field.setInt(data, i);
                        continue;
                    }
                    if (type2.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Character.TYPE)) {
                        if (((String)value2).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, ((String)value2).charAt(0));
                        continue;
                    }
                    if (type2.equals(Boolean.TYPE)) {
                        if (((String)value2).equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (((String)value2).equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type2.isEnum()) {
                    for (Object enumValue : type2.getEnumConstants()) {
                        if (!enumValue.toString().equals(value2)) continue;
                        field.set(data, enumValue);
                        continue block12;
                    }
                    continue;
                }
                if (type2.equals(String.class)) {
                    field.set(data, value2);
                    continue;
                }
                if (type2.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value2);
                    field.set(data, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                    List<Element> children3 = e.getChildren("value");
                    if (children3.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element2 : children3) {
                        object = (JDOMExternalizable)type2.newInstance();
                        object.readExternal(element2);
                    }
                    field.set(data, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type2);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException ex) {
                throw new InvalidDataException(ex);
            }
        }
    }

    public static int toInt(@NotNull String value2) throws InvalidDataException {
        int i;
        if (value2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(7);
        }
        try {
            i = Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            throw new InvalidDataException(value2, e);
        }
        return i;
    }

    public static Color toColor(@Nullable String value2) {
        Color color;
        if (value2 == null) {
            return null;
        }
        try {
            int rgb = Integer.parseInt(value2, 16);
            color = new Color(rgb);
        }
        catch (NumberFormatException e) {
            LOG.debug("Wrong color value: " + value2, e);
            throw new InvalidDataException("Wrong color value: " + value2, e);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/DefaultJDOMExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "toInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }

    private static final class DefaultJDOMExternalizerMapClassValue
    extends ClassValue<Map<String, Field>> {
        private DefaultJDOMExternalizerMapClassValue() {
        }

        @Override
        protected Map<String, Field> computeValue(Class<?> type2) {
            LinkedHashMap<String, Field> result2 = new LinkedHashMap<String, Field>();
            for (Field field : type2.getFields()) {
                int modifiers2;
                String name2 = field.getName();
                if (name2.indexOf(36) >= 0 || result2.containsKey(name2) || !Modifier.isPublic(modifiers2 = field.getModifiers()) || Modifier.isStatic(modifiers2) || Modifier.isTransient(modifiers2) || field.isAnnotationPresent(Transient.class)) continue;
                field.setAccessible(true);
                if (field.getDeclaringClass().isAnnotationPresent(Transient.class)) continue;
                result2.put(name2, field);
            }
            return result2;
        }
    }
}

