/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.util.AstUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0000H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsCompositeBlock;", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "<init>", "()V", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "statements", "", "(Ljava/util/List;)V", "isTransparent", "", "deepCopy", "js.ast"})
public final class JsCompositeBlock
extends JsBlock {
    public JsCompositeBlock() {
    }

    public JsCompositeBlock(@NotNull JsStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        super(statement);
    }

    public JsCompositeBlock(@NotNull List<? extends JsStatement> statements) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        super(statements);
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    @NotNull
    public JsCompositeBlock deepCopy() {
        JsCompositeBlock globalBlockCopy = new JsCompositeBlock();
        List<JsStatement> list = AstUtil.deepCopy(this.getStatements());
        Intrinsics.checkNotNullExpressionValue(list, (String)"deepCopy(...)");
        List<JsStatement> statementscopy = list;
        globalBlockCopy.getStatements().addAll((Collection<JsStatement>)statementscopy);
        HasMetadata hasMetadata = globalBlockCopy.withMetadataFrom(this);
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"withMetadataFrom(...)");
        return (JsCompositeBlock)hasMetadata;
    }
}

