/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.AbsentDescriptorHandler;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.LockBasedLazyResolveStorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0019H\u0007J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u001d\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b1R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;", "", "globalContext", "Lorg/jetbrains/kotlin/context/GlobalContext;", "delegationTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "absentDescriptorHandler", "Lorg/jetbrains/kotlin/resolve/lazy/AbsentDescriptorHandler;", "<init>", "(Lorg/jetbrains/kotlin/context/GlobalContext;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;Lorg/jetbrains/kotlin/resolve/lazy/AbsentDescriptorHandler;)V", "trace", "scopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;", "getScopeProvider", "()Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;", "setScopeProvider", "(Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;)V", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "setDeclarationScopeProvider", "", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl;", "getClassDescriptorIfAny", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getClassDescriptor", "getScriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "findClassDescriptorIfAny", "classObjectOrScript", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "findClassDescriptor", "resolveToDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "track", "", "getMemberScopeDeclaredIn", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getMemberScopeDeclaredIn$frontend", "frontend"})
public class LazyDeclarationResolver {
    @NotNull
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    @NotNull
    private final AbsentDescriptorHandler absentDescriptorHandler;
    @NotNull
    private final BindingTrace trace;
    protected DeclarationScopeProvider scopeProvider;

    public LazyDeclarationResolver(@NotNull GlobalContext globalContext, @NotNull BindingTrace delegationTrace, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull AbsentDescriptorHandler absentDescriptorHandler) {
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)delegationTrace, (String)"delegationTrace");
        Intrinsics.checkNotNullParameter((Object)topLevelDescriptorProvider, (String)"topLevelDescriptorProvider");
        Intrinsics.checkNotNullParameter((Object)absentDescriptorHandler, (String)"absentDescriptorHandler");
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        this.absentDescriptorHandler = absentDescriptorHandler;
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
    }

    @NotNull
    protected final DeclarationScopeProvider getScopeProvider() {
        DeclarationScopeProvider declarationScopeProvider = this.scopeProvider;
        if (declarationScopeProvider != null) {
            return declarationScopeProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scopeProvider");
        return null;
    }

    protected final void setScopeProvider(@NotNull DeclarationScopeProvider declarationScopeProvider) {
        Intrinsics.checkNotNullParameter((Object)declarationScopeProvider, (String)"<set-?>");
        this.scopeProvider = declarationScopeProvider;
    }

    private final BindingContext getBindingContext() {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        return bindingContext;
    }

    @Inject
    public final void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl scopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)scopeProvider2, (String)"scopeProvider");
        this.setScopeProvider(scopeProvider2);
    }

    @Nullable
    public ClassDescriptor getClassDescriptorIfAny(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return this.findClassDescriptorIfAny(classOrObject, location2);
    }

    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return this.findClassDescriptor(classOrObject, location2);
    }

    @NotNull
    public final ClassDescriptorWithResolutionScopes getScriptDescriptor(@NotNull KtScript script, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        ClassDescriptor classDescriptor = this.findClassDescriptor(script, location2);
        Intrinsics.checkNotNull((Object)classDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
        return (ClassDescriptorWithResolutionScopes)classDescriptor;
    }

    private final ClassDescriptor findClassDescriptorIfAny(KtNamedDeclaration classObjectOrScript, LookupLocation location2) {
        MemberScope scope = this.getMemberScopeDeclaredIn$frontend(classObjectOrScript, location2);
        Name name2 = classObjectOrScript.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
        scope.getContributedClassifier(name2, location2);
        DeclarationDescriptor descriptor = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classObjectOrScript);
        return descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null;
    }

    private final ClassDescriptor findClassDescriptor(KtNamedDeclaration classObjectOrScript, LookupLocation location2) {
        ClassDescriptor classDescriptor = this.findClassDescriptorIfAny(classObjectOrScript, location2);
        if (classDescriptor == null) {
            DeclarationDescriptor declarationDescriptor = this.absentDescriptorHandler.diagnoseDescriptorNotFound(classObjectOrScript);
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            classDescriptor = (ClassDescriptor)declarationDescriptor;
        }
        return classDescriptor;
    }

    @NotNull
    public final DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        DeclarationDescriptor declarationDescriptor = this.resolveToDescriptor(declaration2, true);
        if (declarationDescriptor == null) {
            declarationDescriptor = this.absentDescriptorHandler.diagnoseDescriptorNotFound(declaration2);
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor resolveToDescriptor(KtDeclaration declaration2, boolean track) {
        return (DeclarationDescriptor)declaration2.accept(new KtVisitor(track, this){
            final /* synthetic */ boolean $track;
            final /* synthetic */ LazyDeclarationResolver this$0;
            {
                this.$track = $track;
                this.this$0 = $receiver;
            }

            private final LookupLocation lookupLocationFor(KtDeclaration declaration2, boolean isTopLevel) {
                return isTopLevel && this.$track ? (LookupLocation)new KotlinLookupLocation(declaration2) : (LookupLocation)NoLookupLocation.WHEN_RESOLVE_DECLARATION;
            }

            public DeclarationDescriptor visitClass(KtClass klass, Void data) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                return this.this$0.getClassDescriptorIfAny(klass, this.lookupLocationFor(klass, klass.isTopLevel()));
            }

            public DeclarationDescriptor visitObjectDeclaration(KtObjectDeclaration declaration2, Void data) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                return this.this$0.getClassDescriptorIfAny(declaration2, this.lookupLocationFor(declaration2, declaration2.isTopLevel()));
            }

            public DeclarationDescriptor visitTypeParameter(KtTypeParameter parameter2, Void data) {
                Object v4;
                Name name2;
                DeclarationDescriptor ownerDescriptor;
                block8: {
                    List<TypeParameterDescriptor> list;
                    Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
                    KtTypeParameterListOwner ktTypeParameterListOwner = PsiTreeUtil.getParentOfType((PsiElement)parameter2, KtTypeParameterListOwner.class);
                    if (ktTypeParameterListOwner == null) {
                        throw new IllegalStateException(("Owner not found for type parameter: " + parameter2.getText()).toString());
                    }
                    KtTypeParameterListOwner ownerElement = ktTypeParameterListOwner;
                    DeclarationDescriptor declarationDescriptor = LazyDeclarationResolver.access$resolveToDescriptor(this.this$0, ownerElement, false);
                    if (declarationDescriptor == null) {
                        return null;
                    }
                    ownerDescriptor = declarationDescriptor;
                    List<TypeParameterDescriptor> typeParameters2 = null;
                    DeclarationDescriptor declarationDescriptor2 = ownerDescriptor;
                    if (declarationDescriptor2 instanceof CallableDescriptor) {
                        list = ((CallableDescriptor)ownerDescriptor).getTypeParameters();
                    } else if (declarationDescriptor2 instanceof ClassifierDescriptorWithTypeParameters) {
                        list = ((ClassifierDescriptorWithTypeParameters)ownerDescriptor).getTypeConstructor().getParameters();
                    } else {
                        throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                    }
                    typeParameters2 = list;
                    Name name3 = parameter2.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getNameAsSafeName(...)");
                    name2 = name3;
                    Iterable $this$firstOrNull$iv = typeParameters2;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                        v4 = element$iv;
                        break block8;
                    }
                    v4 = null;
                }
                TypeParameterDescriptor typeParameterDescriptor = v4;
                if (typeParameterDescriptor == null) {
                    throw new IllegalStateException("Type parameter " + name2 + " not found for " + ownerDescriptor);
                }
                return typeParameterDescriptor;
            }

            public DeclarationDescriptor visitNamedFunction(KtNamedFunction function2, Void data) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                LookupLocation location2 = this.lookupLocationFor(function2, function2.isTopLevel());
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(function2, location2);
                Name name2 = function2.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                scopeForDeclaration.getContributedFunctions(name2, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            }

            public DeclarationDescriptor visitParameter(KtParameter parameter2, Void data) {
                PsiElement grandFather;
                Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
                PsiElement psiElement = grandFather = parameter2.getParent().getParent();
                if (psiElement instanceof KtPrimaryConstructor) {
                    DeclarationDescriptor declarationDescriptor;
                    KtClassOrObject ktClassOrObject = ((KtPrimaryConstructor)grandFather).getContainingClassOrObject();
                    ClassDescriptor classDescriptor = this.this$0.getClassDescriptorIfAny(ktClassOrObject, this.lookupLocationFor(ktClassOrObject, false));
                    if (classDescriptor == null) {
                        declarationDescriptor = null;
                    } else if (parameter2.hasValOrVar()) {
                        MemberScope memberScope2 = classDescriptor.getDefaultType().getMemberScope();
                        Name name2 = parameter2.getNameAsSafeName();
                        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                        memberScope2.getContributedVariables(name2, this.lookupLocationFor(parameter2, false));
                        declarationDescriptor = (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter2);
                    } else {
                        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                        if (classConstructorDescriptor == null) {
                            throw new IllegalStateException("There are constructor parameters found, so a constructor should also exist".toString());
                        }
                        ClassConstructorDescriptor constructor = classConstructorDescriptor;
                        constructor.getValueParameters();
                        declarationDescriptor = (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.VALUE_PARAMETER, parameter2);
                    }
                    return declarationDescriptor;
                }
                if (psiElement instanceof KtNamedFunction) {
                    FunctionDescriptor function2;
                    DeclarationDescriptor declarationDescriptor = this.visitNamedFunction((KtNamedFunction)grandFather, data);
                    FunctionDescriptor functionDescriptor = function2 = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                    if (functionDescriptor != null) {
                        functionDescriptor.getValueParameters();
                    }
                    return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.VALUE_PARAMETER, parameter2);
                }
                if (psiElement instanceof KtSecondaryConstructor) {
                    ConstructorDescriptor constructorDescriptor;
                    DeclarationDescriptor declarationDescriptor = this.visitSecondaryConstructor((KtSecondaryConstructor)grandFather, data);
                    ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = declarationDescriptor instanceof ConstructorDescriptor ? (ConstructorDescriptor)declarationDescriptor : null;
                    if (constructorDescriptor2 != null) {
                        constructorDescriptor2.getValueParameters();
                    }
                    return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.VALUE_PARAMETER, parameter2);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter2, data);
            }

            public DeclarationDescriptor visitSecondaryConstructor(KtSecondaryConstructor constructor, Void data) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                    PsiElement psiElement = constructor.getParent().getParent();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                    ClassDescriptor classDescriptor = this.this$0.getClassDescriptorIfAny((KtClassOrObject)psiElement, this.lookupLocationFor(constructor, false));
                    if (classDescriptor == null) break block0;
                    classDescriptor.getConstructors();
                }
                return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.CONSTRUCTOR, constructor);
            }

            public DeclarationDescriptor visitPrimaryConstructor(KtPrimaryConstructor constructor, Void data) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                    ClassDescriptor classDescriptor = this.this$0.getClassDescriptorIfAny(constructor.getContainingClassOrObject(), this.lookupLocationFor(constructor, false));
                    if (classDescriptor == null) break block0;
                    classDescriptor.getConstructors();
                }
                return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.CONSTRUCTOR, constructor);
            }

            public DeclarationDescriptor visitProperty(KtProperty property, Void data) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                LookupLocation location2 = this.lookupLocationFor(property, property.isTopLevel());
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(property, location2);
                Name name2 = property.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                scopeForDeclaration.getContributedVariables(name2, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, property);
            }

            public DeclarationDescriptor visitDestructuringDeclarationEntry(KtDestructuringDeclarationEntry destructuringDeclarationEntry, Void data) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclarationEntry, (String)"destructuringDeclarationEntry");
                LookupLocation location2 = this.lookupLocationFor(destructuringDeclarationEntry, false);
                PsiElement psiElement = destructuringDeclarationEntry.getParent();
                KtDestructuringDeclaration ktDestructuringDeclaration = psiElement instanceof KtDestructuringDeclaration ? (KtDestructuringDeclaration)psiElement : null;
                if (ktDestructuringDeclaration == null) {
                    return null;
                }
                KtDestructuringDeclaration destructuringDeclaration = ktDestructuringDeclaration;
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(destructuringDeclaration, location2);
                Name name2 = destructuringDeclarationEntry.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                scopeForDeclaration.getContributedVariables(name2, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, destructuringDeclarationEntry);
            }

            public DeclarationDescriptor visitTypeAlias(KtTypeAlias typeAlias, Void data) {
                Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                LookupLocation location2 = this.lookupLocationFor(typeAlias, typeAlias.isTopLevel());
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(typeAlias, location2);
                Name name2 = typeAlias.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                scopeForDeclaration.getContributedClassifier(name2, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, typeAlias);
            }

            public DeclarationDescriptor visitScript(KtScript script, Void data) {
                Intrinsics.checkNotNullParameter((Object)script, (String)"script");
                return this.this$0.getScriptDescriptor(script, this.lookupLocationFor(script, true));
            }

            public DeclarationDescriptor visitKtElement(KtElement element2, Void data) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                throw new IllegalArgumentException("Unsupported declaration type: " + element2 + ' ' + PsiUtilsKt.getElementTextWithContext(element2));
            }
        }, null);
    }

    @NotNull
    public final MemberScope getMemberScopeDeclaredIn$frontend(@NotNull KtDeclaration declaration2, @NotNull LookupLocation location2) {
        MemberScope memberScope2;
        boolean isTopLevel;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        KtDeclaration parentDeclaration2 = KtStubbedPsiUtil.getContainingDeclaration(declaration2);
        boolean bl = isTopLevel = parentDeclaration2 == null;
        if (isTopLevel) {
            PsiFile psiFile = declaration2.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile ktFile = (KtFile)psiFile;
            FqName fqName = ktFile.getPackageFqName();
            this.topLevelDescriptorProvider.assertValid();
            LazyPackageDescriptor packageDescriptor = this.topLevelDescriptorProvider.getPackageFragmentOrDiagnoseFailure(fqName, ktFile);
            MemberScope memberScope3 = packageDescriptor.getMemberScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope3, (String)"getMemberScope(...)");
            return memberScope3;
        }
        KtDeclaration ktDeclaration = parentDeclaration2;
        if (ktDeclaration instanceof KtClassOrObject) {
            MemberScope memberScope4 = this.getClassDescriptor((KtClassOrObject)parentDeclaration2, location2).getUnsubstitutedMemberScope();
            memberScope2 = memberScope4;
            Intrinsics.checkNotNullExpressionValue((Object)memberScope4, (String)"getUnsubstitutedMemberScope(...)");
        } else if (ktDeclaration instanceof KtScript) {
            MemberScope memberScope5 = this.getScriptDescriptor((KtScript)parentDeclaration2, location2).getUnsubstitutedMemberScope();
            memberScope2 = memberScope5;
            Intrinsics.checkNotNullExpressionValue((Object)memberScope5, (String)"getUnsubstitutedMemberScope(...)");
        } else {
            throw new IllegalStateException("Don't call this method for local declarations: " + declaration2 + '\n' + PsiUtilsKt.getElementTextWithContext(declaration2));
        }
        return memberScope2;
    }

    public static final /* synthetic */ DeclarationDescriptor access$resolveToDescriptor(LazyDeclarationResolver $this, KtDeclaration declaration2, boolean track) {
        return $this.resolveToDescriptor(declaration2, track);
    }

    public static final /* synthetic */ BindingContext access$getBindingContext(LazyDeclarationResolver $this) {
        return $this.getBindingContext();
    }
}

