/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.AnalyzerExtensions;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.inline.ReasonableInlineRule;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020%2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension;", "Lorg/jetbrains/kotlin/resolve/AnalyzerExtensions$AnalyzerExtension;", "reasonableInlineRules", "", "Lorg/jetbrains/kotlin/resolve/inline/ReasonableInlineRule;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Ljava/lang/Iterable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "process", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "functionOrProperty", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "notSupportedInInlineCheck", "checkDefaults", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "checkDefaultValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "ktParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "checkModalityAndOverrides", "callableDescriptor", "checkHasInlinableAndNullability", "checkInlinableParameter", "", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nInlineAnalyzerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineAnalyzerExtension.kt\norg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1863#2,2:206\n1755#2,3:208\n*S KotlinDebug\n*F\n+ 1 InlineAnalyzerExtension.kt\norg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension\n*L\n173#1:206,2\n182#1:208,3\n*E\n"})
public final class InlineAnalyzerExtension
implements AnalyzerExtensions.AnalyzerExtension {
    @NotNull
    private final Iterable<ReasonableInlineRule> reasonableInlineRules;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public InlineAnalyzerExtension(@NotNull Iterable<? extends ReasonableInlineRule> reasonableInlineRules, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(reasonableInlineRules, (String)"reasonableInlineRules");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.reasonableInlineRules = reasonableInlineRules;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    public void process(@NotNull CallableMemberDescriptor descriptor, @NotNull KtCallableDeclaration functionOrProperty, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)functionOrProperty, (String)"functionOrProperty");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.checkModalityAndOverrides(descriptor, functionOrProperty, trace);
        this.notSupportedInInlineCheck(functionOrProperty, trace);
        if (descriptor instanceof FunctionDescriptor) {
            boolean bl = functionOrProperty instanceof KtNamedFunction;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-InlineAnalyzerExtension$process$42 = false;
                String $i$a$-assert-InlineAnalyzerExtension$process$42 = "Function descriptor " + descriptor + " should have corresponded KtNamedFunction, but has " + functionOrProperty;
                throw new AssertionError((Object)$i$a$-assert-InlineAnalyzerExtension$process$42);
            }
            this.checkDefaults((FunctionDescriptor)descriptor, (KtNamedFunction)functionOrProperty, trace);
            this.checkHasInlinableAndNullability((FunctionDescriptor)descriptor, (KtFunction)functionOrProperty, trace);
        } else {
            boolean bl = descriptor instanceof PropertyDescriptor;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-InlineAnalyzerExtension$process$52 = false;
                String $i$a$-assert-InlineAnalyzerExtension$process$52 = "PropertyDescriptor expected, but was " + descriptor;
                throw new AssertionError((Object)$i$a$-assert-InlineAnalyzerExtension$process$52);
            }
            bl = functionOrProperty instanceof KtProperty;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Property descriptor " + descriptor + " should have corresponded KtProperty, but has " + functionOrProperty;
                throw new AssertionError((Object)string2);
            }
            boolean hasBackingField2 = Intrinsics.areEqual(trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)descriptor), (Object)true);
            if (hasBackingField2 || ((KtProperty)functionOrProperty).getDelegateExpression() != null) {
                trace.report(Errors.INLINE_PROPERTY_WITH_BACKING_FIELD.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
        }
    }

    private final void notSupportedInInlineCheck(KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        KtVisitorVoid visitor2 = new KtVisitorVoid(trace){
            final /* synthetic */ BindingTrace $trace;
            {
                this.$trace = $trace;
            }

            public void visitKtElement(KtElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                super.visitKtElement(element2);
                element2.acceptChildren(this);
            }

            public void visitClass(KtClass klass) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)klass), "Local classes"));
            }

            public void visitNamedFunction(KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (function2.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function2);
                } else {
                    this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)function2), "Local functions"));
                }
            }
        };
        functionOrProperty.acceptChildren(visitor2);
    }

    private final void checkDefaults(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        List<KtParameter> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        List<KtParameter> ktParameters = list;
        for (ValueParameterDescriptor parameter2 : functionDescriptor.getValueParameters()) {
            Intrinsics.checkNotNull((Object)parameter2);
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter2)) continue;
            KtParameter ktParameter = ktParameters.get(parameter2.getIndex());
            boolean inheritsDefaultValue = !parameter2.declaresDefaultValue() && DescriptorUtilsKt.declaresOrInheritsDefaultValue(parameter2);
            ParameterDescriptor parameterDescriptor = parameter2;
            Intrinsics.checkNotNull((Object)ktParameter);
            if (this.checkInlinableParameter(parameterDescriptor, ktParameter, functionDescriptor, null) || inheritsDefaultValue) {
                if (inheritsDefaultValue || !this.languageVersionSettings.supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters)) {
                    trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)ktParameter), "Functional parameters with inherited default values"));
                } else {
                    this.checkDefaultValue(trace, parameter2, ktParameter);
                }
            }
            if (!functionDescriptor.isSuspend() || !InlineUtil.isInlineParameterExceptNullability(parameter2) || !CoroutineUtilKt.getHasSuspendFunctionType(parameter2)) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)ktParameter), "Suspend functional parameters with default values"));
        }
    }

    private final void checkDefaultValue(BindingTrace trace, ValueParameterDescriptor parameterDescriptor, KtParameter ktParameter) {
        block1: {
            KtExpression ktExpression = ktParameter.getDefaultValue();
            if (ktExpression == null) break block1;
            KtExpression defaultValue = ktExpression;
            boolean bl = false;
            if (!InlineUtil.isInlinableParameterExpression(KtPsiUtil.deparenthesize(defaultValue))) {
                trace.report(Errors.INVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE.on((KtElement)((PsiElement)defaultValue), defaultValue, parameterDescriptor));
            }
        }
    }

    private final void checkModalityAndOverrides(CallableMemberDescriptor callableDescriptor, KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        boolean overridesAnything;
        if (callableDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        if (DescriptorVisibilities.isPrivate(callableDescriptor.getVisibility())) {
            return;
        }
        Collection<? extends CallableMemberDescriptor> collection = callableDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        boolean bl = overridesAnything = !collection.isEmpty();
        if (overridesAnything) {
            List<KtTypeParameter> list = functionOrProperty.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
            List<KtTypeParameter> ktTypeParameters = list;
            for (TypeParameterDescriptor typeParameter : callableDescriptor.getTypeParameters()) {
                if (!typeParameter.isReified()) continue;
                KtTypeParameter ktTypeParameter = ktTypeParameters.get(typeParameter.getIndex());
                PsiElement psiElement = ktTypeParameter.getModifierList();
                if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.REIFIED_KEYWORD)) == null) {
                    psiElement = ktTypeParameter;
                }
                PsiElement reportOn = psiElement;
                trace.report(Errors.REIFIED_TYPE_PARAMETER_IN_OVERRIDE.on(reportOn));
            }
        }
        if (KtDescriptorUtilKt.isEffectivelyFinal(callableDescriptor, true)) {
            if (overridesAnything) {
                trace.report(Errors.OVERRIDE_BY_INLINE.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
            if (!KtDescriptorUtilKt.isEffectivelyFinal(callableDescriptor, false)) {
                trace.report(Errors.DECLARATION_CANT_BE_INLINED_WARNING.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on((KtDeclaration)((PsiElement)functionOrProperty)));
    }

    private final void checkHasInlinableAndNullability(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        boolean bl;
        block9: {
            boolean hasInlineArgs = false;
            List<KtParameter> list = function2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
            Iterable iterable = list;
            List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                Pair pair = (Pair)t;
                boolean bl2 = false;
                KtParameter parameter2 = (KtParameter)pair.component1();
                ValueParameterDescriptor descriptor = (ValueParameterDescriptor)pair.component2();
                Intrinsics.checkNotNull((Object)descriptor);
                ParameterDescriptor parameterDescriptor = descriptor;
                Intrinsics.checkNotNull((Object)parameter2);
                hasInlineArgs |= this.checkInlinableParameter(parameterDescriptor, parameter2, functionDescriptor, trace);
            }
            if (hasInlineArgs) {
                return;
            }
            if (InlineOnlyKt.isInlineWithReified(functionDescriptor) || InlineOnlyKt.isInlineOnly(functionDescriptor) || functionDescriptor.isExpect() || functionDescriptor.isSuspend()) {
                return;
            }
            Iterable<ReasonableInlineRule> $this$any$iv = this.reasonableInlineRules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object object : $this$any$iv) {
                    ReasonableInlineRule it = (ReasonableInlineRule)object;
                    boolean bl3 = false;
                    CallableMemberDescriptor callableMemberDescriptor = functionDescriptor;
                    KtCallableDeclaration ktCallableDeclaration = function2;
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    if (!it.isInlineReasonable(callableMemberDescriptor, ktCallableDeclaration, bindingContext)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        KotlinType kotlinType = functionDescriptor.getReturnType();
        boolean bl2 = kotlinType != null ? InlineClassesUtilsKt.needsMfvcFlattening(kotlinType) : false;
        if (bl2) {
            return;
        }
        PsiElement psiElement = function2.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
            psiElement = function2;
        }
        PsiElement reportOn = psiElement;
        trace.report(Errors.NOTHING_TO_INLINE.on(reportOn));
    }

    private final boolean checkInlinableParameter(ParameterDescriptor parameter2, KtElement expression2, CallableDescriptor functionDescriptor, BindingTrace trace) {
        if (InlineUtil.isInlineParameterExceptNullability(parameter2)) {
            if (parameter2.getType().isMarkedNullable()) {
                BindingTrace bindingTrace = trace;
                if (bindingTrace != null) {
                    bindingTrace.report(Errors.NULLABLE_INLINE_PARAMETER.on((KtElement)((PsiElement)expression2), expression2, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

