/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionResultOverridesOtherToPreserveCompatibility;
import org.jetbrains.kotlin.fir.resolve.transformers.ExpectedArgumentType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0001\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001ae\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0012j\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u0011`\u000f\"\u0004\b\u0000\u0010\u0010\"\b\b\u0001\u0010\u0011*\u00020\u0013**\u0012\u0006\b\u0001\u0012\u0002H\u0010\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00110\u0012j\u0014\u0012\u0006\b\u0001\u0012\u0002H\u0010\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u0011`\u000fH\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"getExpectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ExpectedArgumentType;", "argument", "Lorg/jetbrains/kotlin/fir/FirElement;", "toExpectedType", "doesResolutionResultOverrideOtherToPreserveCompatibility", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "addNonFatalDiagnostic", "", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "filterValuesNotNull", "Lkotlin/collections/LinkedHashMap;", "K", "V", "Ljava/util/LinkedHashMap;", "", "(Ljava/util/LinkedHashMap;)Ljava/util/LinkedHashMap;", "resolve"})
public final class FirCallCompletionResultsWriterTransformerKt {
    private static final ConeKotlinType getExpectedType(ExpectedArgumentType $this$getExpectedType, FirElement argument) {
        ConeKotlinType coneKotlinType;
        ExpectedArgumentType expectedArgumentType = $this$getExpectedType;
        if (expectedArgumentType instanceof ExpectedArgumentType.ArgumentsMap) {
            coneKotlinType = ((ExpectedArgumentType.ArgumentsMap)$this$getExpectedType).getMap().get(argument);
        } else if (expectedArgumentType instanceof ExpectedArgumentType.ExpectedType) {
            coneKotlinType = ((ExpectedArgumentType.ExpectedType)$this$getExpectedType).getType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ExpectedArgumentType toExpectedType(@NotNull ConeKotlinType $this$toExpectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$toExpectedType, (String)"<this>");
        return new ExpectedArgumentType.ExpectedType($this$toExpectedType);
    }

    public static final boolean doesResolutionResultOverrideOtherToPreserveCompatibility(@NotNull Candidate $this$doesResolutionResultOverrideOtherToPreserveCompatibility) {
        Intrinsics.checkNotNullParameter((Object)$this$doesResolutionResultOverrideOtherToPreserveCompatibility, (String)"<this>");
        return $this$doesResolutionResultOverrideOtherToPreserveCompatibility.getDiagnostics().contains(ResolutionResultOverridesOtherToPreserveCompatibility.INSTANCE);
    }

    public static final void addNonFatalDiagnostic(@NotNull FirQualifiedAccessExpression $this$addNonFatalDiagnostic, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$addNonFatalDiagnostic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        $this$addNonFatalDiagnostic.replaceNonFatalDiagnostics(CollectionsKt.plus((Collection)$this$addNonFatalDiagnostic.getNonFatalDiagnostics(), (Iterable)CollectionsKt.listOf((Object)diagnostic)));
    }

    private static final <K, V> LinkedHashMap<K, V> filterValuesNotNull(LinkedHashMap<? extends K, ? extends V> $this$filterValuesNotNull) {
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry entry : ((Map)$this$filterValuesNotNull).entrySet()) {
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            if (value2 == null) continue;
            ((Map)result2).put(key, value2);
        }
        return result2;
    }

    public static final /* synthetic */ LinkedHashMap access$filterValuesNotNull(LinkedHashMap $receiver) {
        return FirCallCompletionResultsWriterTransformerKt.filterValuesNotNull($receiver);
    }

    public static final /* synthetic */ ConeKotlinType access$getExpectedType(ExpectedArgumentType $receiver, FirElement argument) {
        return FirCallCompletionResultsWriterTransformerKt.getExpectedType($receiver, argument);
    }
}

