/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizer;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizerResult;
import org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizer;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.TypeQualifier;
import org.jetbrains.kotlin.analysis.api.fir.references.KDocReferenceResolver;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtNonErrorClassType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizer;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "firResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;)V", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "getFirSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "analyseImports", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizerResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectReferencedEntities", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer$ReferencedEntitiesResult;", "ReferencedEntitiesResult", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,579:1\n1#2:580\n381#3,7:581\n*S KotlinDebug\n*F\n+ 1 KtFirImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer\n*L\n87#1:581,7\n*E\n"})
public final class KtFirImportOptimizer
extends KtImportOptimizer {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;
    @NotNull
    private final LLFirResolveSession firResolveSession;

    public KtFirImportOptimizer(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token, @NotNull LLFirResolveSession firResolveSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)firResolveSession, (String)"firResolveSession");
        this.analysisSession = analysisSession;
        this.token = token;
        this.firResolveSession = firResolveSession;
    }

    @Override
    @NotNull
    public KtLifetimeToken getToken() {
        return this.token;
    }

    private final FirSession getFirSession() {
        return this.firResolveSession.getUseSiteFirSession();
    }

    @Override
    @NotNull
    public KtImportOptimizerResult analyseImports(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List<KtImportDirective> existingImports = file2.getImportDirectives();
        if (existingImports.isEmpty()) {
            return new KtImportOptimizerResult(null, null, 3, null);
        }
        ReferencedEntitiesResult referencedEntitiesResult = this.collectReferencedEntities(file2);
        Map<FqName, Set<Name>> usedDeclarations = referencedEntitiesResult.component1();
        Set<Name> unresolvedNames = referencedEntitiesResult.component2();
        return new KtImportOptimizerResult(usedDeclarations, unresolvedNames);
    }

    private final ReferencedEntitiesResult collectReferencedEntities(KtFile file2) {
        FirFile firFile;
        FirFile $this$collectReferencedEntities_u24lambda_u240 = firFile = LowLevelFirApiFacadeKt.getOrBuildFirFile(file2, this.firResolveSession);
        boolean bl = false;
        FirLazyDeclarationResolverKt.lazyResolveToPhaseRecursively($this$collectReferencedEntities_u24lambda_u240, FirResolvePhase.BODY_RESOLVE);
        FirFile firFile2 = firFile;
        Map usedImports = new LinkedHashMap();
        Set unresolvedNames = new LinkedHashSet();
        firFile2.accept(new FirVisitorVoid(unresolvedNames, usedImports, this){
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            final /* synthetic */ KtFirImportOptimizer this$0;
            {
                this.$unresolvedNames = $unresolvedNames;
                this.$usedImports = $usedImports;
                this.this$0 = $receiver;
            }

            public void visitElement(FirElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }

            public void visitFunctionCall(FirFunctionCall functionCall) {
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                this.processFunctionCall(functionCall);
                super.visitFunctionCall(functionCall);
            }

            public void visitImplicitInvokeCall(FirImplicitInvokeCall implicitInvokeCall) {
                Intrinsics.checkNotNullParameter((Object)implicitInvokeCall, (String)"implicitInvokeCall");
                this.processImplicitFunctionCall(implicitInvokeCall);
                super.visitImplicitInvokeCall(implicitInvokeCall);
            }

            public void visitComponentCall(FirComponentCall componentCall) {
                Intrinsics.checkNotNullParameter((Object)componentCall, (String)"componentCall");
                this.processFunctionCall(componentCall);
                super.visitComponentCall(componentCall);
            }

            public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                this.processPropertyAccessExpression(propertyAccessExpression);
                super.visitPropertyAccessExpression(propertyAccessExpression);
            }

            public void visitResolvedTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
                this.processTypeRef(resolvedTypeRef);
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitTypeRef(resolvedTypeRef);
            }

            public void visitErrorTypeRef(FirErrorTypeRef errorTypeRef) {
                Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
                this.processTypeRef(errorTypeRef);
                this.processErrorTypeRef(errorTypeRef);
                FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitErrorTypeRef(errorTypeRef);
            }

            public void visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
                this.processCallableReferenceAccess(callableReferenceAccess);
                super.visitCallableReferenceAccess(callableReferenceAccess);
            }

            public void visitResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
                this.processResolvedQualifier(resolvedQualifier);
                super.visitResolvedQualifier(resolvedQualifier);
            }

            public void visitErrorResolvedQualifier(FirErrorResolvedQualifier errorResolvedQualifier) {
                Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
                this.processResolvedQualifier(errorResolvedQualifier);
                super.visitErrorResolvedQualifier(errorResolvedQualifier);
            }

            private final void processErrorNameReference(FirResolvable resolvable) {
                FirReference firReference = resolvable.getCalleeReference();
                FirErrorNamedReference firErrorNamedReference = firReference instanceof FirErrorNamedReference ? (FirErrorNamedReference)firReference : null;
                if (firErrorNamedReference == null) {
                    return;
                }
                FirErrorNamedReference nameReference = firErrorNamedReference;
                Name name2 = KtFirImportOptimizerKt.access$getUnresolvedName(nameReference);
                if (name2 == null) {
                    return;
                }
                Name name3 = name2;
                ((Collection)this.$unresolvedNames).add(name3);
            }

            private final void processErrorTypeRef(FirErrorTypeRef typeRef) {
                ConeDiagnostic coneDiagnostic = typeRef.getDiagnostic();
                ConeUnresolvedError coneUnresolvedError = coneDiagnostic instanceof ConeUnresolvedError ? (ConeUnresolvedError)coneDiagnostic : null;
                if (coneUnresolvedError == null) {
                    return;
                }
                ConeUnresolvedError diagnostic = coneUnresolvedError;
                Name name2 = KtFirImportOptimizerKt.access$getUnresolvedName(diagnostic);
                if (name2 == null) {
                    return;
                }
                Name name3 = name2;
                ((Collection)this.$unresolvedNames).add(name3);
            }

            private final void processFunctionCall(FirFunctionCall functionCall) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(functionCall)) {
                    return;
                }
                this.processErrorNameReference(functionCall);
                Name name2 = KtFirImportOptimizerKt.access$getFunctionReferenceName(functionCall);
                if (name2 == null) {
                    return;
                }
                Name referencesByName = name2;
                this.saveCallable(functionCall, referencesByName);
            }

            private final void processImplicitFunctionCall(FirImplicitInvokeCall implicitInvokeCall) {
                this.processErrorNameReference(implicitInvokeCall);
                this.saveCallable(implicitInvokeCall, OperatorNameConventions.INVOKE);
            }

            private final void processPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(propertyAccessExpression)) {
                    return;
                }
                this.processErrorNameReference(propertyAccessExpression);
                Name name2 = KtFirImportOptimizerKt.access$getPropertyReferenceName(propertyAccessExpression);
                if (name2 == null) {
                    return;
                }
                Name referencedByName = name2;
                this.saveCallable(propertyAccessExpression, referencedByName);
            }

            private final void processTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedTypeRef);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(callableReferenceAccess)) {
                    return;
                }
                this.processErrorNameReference(callableReferenceAccess);
                Name name2 = KtFirImportOptimizerKt.access$getCallableReferenceName(callableReferenceAccess);
                if (name2 == null) {
                    return;
                }
                Name referencedByName = name2;
                this.saveCallable(callableReferenceAccess, referencedByName);
            }

            private final void processResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedQualifier);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processTypeQualifier(TypeQualifier qualifier2) {
                TypeQualifier mostOuterTypeQualifier = (TypeQualifier)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)qualifier2, collectReferencedEntities.1::processTypeQualifier$lambda$0));
                if (mostOuterTypeQualifier.isQualified()) {
                    return;
                }
                this.saveType(mostOuterTypeQualifier);
            }

            private final void saveType(TypeQualifier qualifier2) {
                FqName importableName = qualifier2.getReferencedClassId().asSingleFqName();
                Name referencedByName = qualifier2.getReferencedByName();
                KtFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem(this.$usedImports, importableName, referencedByName);
            }

            private final void saveCallable(FirQualifiedAccessExpression qualifiedCall, Name referencedByName) {
                FqName fqName = this.importableNameForReferencedSymbol(qualifiedCall);
                if (fqName == null) {
                    return;
                }
                FqName importableName = fqName;
                KtFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem(this.$usedImports, importableName, referencedByName);
            }

            private final FqName importableNameForReferencedSymbol(FirQualifiedAccessExpression qualifiedCall) {
                FqName fqName = this.importableNameForImplicitlyDispatchedCallable(qualifiedCall);
                if (fqName == null) {
                    FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol(qualifiedCall);
                    fqName = firCallableSymbol != null ? org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt.computeImportableName(firCallableSymbol, KtFirImportOptimizer.access$getFirSession(this.this$0)) : null;
                }
                return fqName;
            }

            private final FqName importableNameForImplicitlyDispatchedCallable(FirQualifiedAccessExpression $this$importableNameForImplicitlyDispatchedCallable) {
                FirExpression dispatchReceiver = $this$importableNameForImplicitlyDispatchedCallable.getDispatchReceiver();
                if (!(dispatchReceiver instanceof FirResolvedQualifier) || !FirUtilsKt.isImplicitDispatchReceiver((FirResolvedQualifier)dispatchReceiver)) {
                    return null;
                }
                ClassId classId = ((FirResolvedQualifier)dispatchReceiver).getClassId();
                if (classId == null) {
                    return null;
                }
                ClassId dispatcherClass = classId;
                Object object = KtFirImportOptimizerKt.access$getReferencedCallableSymbol($this$importableNameForImplicitlyDispatchedCallable);
                if (object == null || (object = ((FirCallableSymbol)object).getName()) == null) {
                    return null;
                }
                Object referencedSymbolName = object;
                return new CallableId(dispatcherClass, (Name)referencedSymbolName).asSingleFqName();
            }

            private static final TypeQualifier processTypeQualifier$lambda$0(TypeQualifier it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getOuterTypeQualifier();
            }
        });
        file2.accept(new KtTreeVisitorVoid(this, unresolvedNames, usedImports){
            final /* synthetic */ KtFirImportOptimizer this$0;
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            {
                this.this$0 = $receiver;
                this.$unresolvedNames = $unresolvedNames;
                this.$usedImports = $usedImports;
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                super.visitElement(element2);
                if (element2 instanceof KDocLink) {
                    this.visitKDocLink((KDocLink)element2);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void visitKDocLink(KDocLink docLink) {
                void $this$forEach$iv;
                List list;
                PsiElement $this$getChildOfType$iv = docLink;
                boolean $i$f$getChildOfType22 = false;
                KDocName kDocName = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KDocName.class);
                if (kDocName == null) {
                    return;
                }
                KDocName docName = kDocName;
                FqName qualifiedNameAsFqName = docName.getQualifiedNameAsFqName();
                Object $i$f$getChildOfType22 = KtFirImportOptimizer.access$getAnalysisSession$p(this.this$0);
                Object object = this.$unresolvedNames;
                KtFirAnalysisSession $this$visitKDocLink_u24lambda_u241 = $i$f$getChildOfType22;
                boolean bl = false;
                Collection<KtSymbol> resolvedSymbols = KDocReferenceResolver.INSTANCE.resolveKdocFqName$analysis_api_fir($this$visitKDocLink_u24lambda_u241.getAnalysisSession(), qualifiedNameAsFqName, qualifiedNameAsFqName, docLink);
                if (resolvedSymbols.isEmpty()) {
                    ((Collection)object).add(qualifiedNameAsFqName.shortName());
                    list = CollectionsKt.emptyList();
                } else {
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv = resolvedSymbols;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        KtSymbol it = (KtSymbol)element$iv$iv;
                        boolean bl2 = false;
                        Iterable list$iv$iv = this.toImportableFqNames(it, qualifiedNameAsFqName);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
                List importableNames = list;
                $i$f$getChildOfType22 = importableNames;
                object = this.$usedImports;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    FqName importableName = (FqName)element$iv;
                    boolean bl3 = false;
                    Name name2 = importableName.shortName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
                    KtFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem((Map)object, importableName, name2);
                }
            }

            private final List<FqName> toImportableFqNames(KtSymbol symbol, FqName qualifiedNameAsFqName) {
                List list;
                List $this$toImportableFqNames_u24lambda_u243 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                KtSymbol ktSymbol = symbol;
                if (ktSymbol instanceof KtCallableSymbol) {
                    FqName classFqName;
                    CallableId callableId = ((KtCallableSymbol)symbol).getCallableIdIfNonLocal();
                    if (callableId == null) {
                        return CollectionsKt.emptyList();
                    }
                    CallableId callableId2 = callableId;
                    FqName fqName = callableId2.asSingleFqName();
                    ClassId classId = callableId2.getClassId();
                    FqName fqName2 = classFqName = classId != null ? classId.asSingleFqName() : null;
                    if (classFqName != null) {
                        if (!Intrinsics.areEqual((Object)classFqName, (Object)qualifiedNameAsFqName)) {
                            ((Collection)$this$toImportableFqNames_u24lambda_u243).add(classFqName);
                        }
                    } else if (!Intrinsics.areEqual((Object)fqName, (Object)qualifiedNameAsFqName)) {
                        FqName receiverFqName;
                        ((Collection)$this$toImportableFqNames_u24lambda_u243).add(fqName);
                        KtReceiverParameterSymbol ktReceiverParameterSymbol = ((KtCallableSymbol)symbol).getReceiverParameter();
                        KtType ktType2 = ktReceiverParameterSymbol != null ? ktReceiverParameterSymbol.getType() : null;
                        KtNonErrorClassType receiverClassType = ktType2 instanceof KtNonErrorClassType ? (KtNonErrorClassType)ktType2 : null;
                        Object object = receiverClassType;
                        FqName fqName3 = object != null && (object = ((KtNonErrorClassType)object).getClassId()) != null ? ((ClassId)object).asSingleFqName() : (receiverFqName = null);
                        if (receiverFqName != null && qualifiedNameAsFqName.pathSegments().size() > 1) {
                            ((Collection)$this$toImportableFqNames_u24lambda_u243).add(receiverFqName);
                        }
                    }
                } else if (ktSymbol instanceof KtClassLikeSymbol) {
                    FqName fqName;
                    ClassId classId = ((KtClassLikeSymbol)symbol).getClassIdIfNonLocal();
                    FqName fqName4 = fqName = classId != null ? classId.asSingleFqName() : null;
                    if (fqName != null && !Intrinsics.areEqual((Object)fqName, (Object)qualifiedNameAsFqName)) {
                        ((Collection)$this$toImportableFqNames_u24lambda_u243).add(fqName);
                    }
                }
                return CollectionsKt.build((List)list);
            }
        });
        return new ReferencedEntitiesResult(usedImports, unresolvedNames);
    }

    private static final void collectReferencedEntities$saveReferencedItem(Map<FqName, Set<Name>> usedImports, FqName importableName, Name referencedByName) {
        Set set;
        Map<FqName, Set<Name>> $this$getOrPut$iv = usedImports;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(importableName);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(importableName, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        ((Collection)set).add(referencedByName);
    }

    public static final /* synthetic */ void access$collectReferencedEntities$saveReferencedItem(Map usedImports, FqName importableName, Name referencedByName) {
        KtFirImportOptimizer.collectReferencedEntities$saveReferencedItem(usedImports, importableName, referencedByName);
    }

    public static final /* synthetic */ FirSession access$getFirSession(KtFirImportOptimizer $this) {
        return $this.getFirSession();
    }

    public static final /* synthetic */ KtFirAnalysisSession access$getAnalysisSession$p(KtFirImportOptimizer $this) {
        return $this.analysisSession;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J5\u0010\u0010\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer$ReferencedEntitiesResult;", "", "usedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "unresolvedNames", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "getUsedImports", "()Ljava/util/Map;", "getUnresolvedNames", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-api-fir"})
    private static final class ReferencedEntitiesResult {
        @NotNull
        private final Map<FqName, Set<Name>> usedImports;
        @NotNull
        private final Set<Name> unresolvedNames;

        public ReferencedEntitiesResult(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, (String)"usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            this.usedImports = usedImports;
            this.unresolvedNames = unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getUsedImports() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> getUnresolvedNames() {
            return this.unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> component1() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> component2() {
            return this.unresolvedNames;
        }

        @NotNull
        public final ReferencedEntitiesResult copy(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, (String)"usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            return new ReferencedEntitiesResult(usedImports, unresolvedNames);
        }

        public static /* synthetic */ ReferencedEntitiesResult copy$default(ReferencedEntitiesResult referencedEntitiesResult, Map map, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                map = referencedEntitiesResult.usedImports;
            }
            if ((n & 2) != 0) {
                set = referencedEntitiesResult.unresolvedNames;
            }
            return referencedEntitiesResult.copy(map, set);
        }

        @NotNull
        public String toString() {
            return "ReferencedEntitiesResult(usedImports=" + this.usedImports + ", unresolvedNames=" + this.unresolvedNames + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.usedImports).hashCode();
            result2 = result2 * 31 + ((Object)this.unresolvedNames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReferencedEntitiesResult)) {
                return false;
            }
            ReferencedEntitiesResult referencedEntitiesResult = (ReferencedEntitiesResult)other;
            if (!Intrinsics.areEqual(this.usedImports, referencedEntitiesResult.usedImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.unresolvedNames, referencedEntitiesResult.unresolvedNames);
        }
    }
}

