/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceResolver
implements ResolveCache.PolyVariantContextResolver<PsiMethodReferenceExpressionImpl> {
    public JavaResolveResult @NotNull [] resolve(final @NotNull PsiMethodReferenceExpressionImpl reference2, @NotNull PsiFile containingFile2, boolean incompleteCode) {
        if (reference2 == null) {
            MethodReferenceResolver.$$$reportNull$$$0(0);
        }
        if (containingFile2 == null) {
            MethodReferenceResolver.$$$reportNull$$$0(1);
        }
        final PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference2);
        final PsiClass containingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor substitutor2 = qualifierResolveResult.getSubstitutor();
        if (containingClass != null) {
            PsiElement element2 = reference2.getReferenceNameElement();
            boolean isConstructor = reference2.isConstructor();
            if (element2 instanceof PsiIdentifier || isConstructor) {
                if (isConstructor && !MethodReferenceResolver.canBeConstructed(containingClass)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        MethodReferenceResolver.$$$reportNull$$$0(2);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                final PsiType functionalInterfaceType = reference2.getFunctionalInterfaceType();
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                final PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                PsiSubstitutor functionalInterfaceSubstitutor = interfaceMethod != null ? LambdaUtil.getSubstitutor(interfaceMethod, resolveResult) : null;
                final MethodSignature signature = interfaceMethod != null ? interfaceMethod.getSignature(functionalInterfaceSubstitutor) : null;
                final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                if (isConstructor && containingClass.getConstructors().length == 0) {
                    JavaResolveResult[] javaResolveResultArray;
                    if (interfaceMethodReturnType != null) {
                        PsiClassType returnType2 = MethodReferenceResolver.composeReturnType(containingClass, substitutor2);
                        InferenceSession session = new InferenceSession(containingClass.getTypeParameters(), substitutor2, reference2.getManager(), null);
                        if (!session.isProperType(session.substituteWithInferenceVariables(returnType2)) || !session.isProperType(interfaceMethodReturnType)) {
                            session.registerReturnTypeConstraints(returnType2, interfaceMethodReturnType, reference2);
                            substitutor2 = session.infer();
                        }
                    }
                    ClassCandidateInfo candidateInfo = null;
                    boolean isArray = PsiUtil.isArrayClass(containingClass);
                    if (signature == null || !isArray && (containingClass.getContainingClass() == null || !MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference2)) && signature.getParameterTypes().length == 0 || isArray && MethodReferenceResolver.arrayCreationSignature(signature)) {
                        candidateInfo = new ClassCandidateInfo(containingClass, substitutor2);
                    }
                    if (candidateInfo == null) {
                        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                    } else {
                        JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                        javaResolveResultArray = javaResolveResultArray2;
                        javaResolveResultArray2[0] = candidateInfo;
                    }
                    if (javaResolveResultArray == null) {
                        MethodReferenceResolver.$$$reportNull$$$0(3);
                    }
                    return javaResolveResultArray;
                }
                PsiConflictResolver conflictResolver = this.createResolver(reference2, qualifierResolveResult, interfaceMethod, signature);
                MethodCandidatesProcessor processor = new MethodCandidatesProcessor(reference2, containingFile2, new PsiConflictResolver[]{conflictResolver}, new SmartList()){

                    @Override
                    protected boolean acceptVarargs() {
                        return true;
                    }

                    @Override
                    @NotNull
                    protected MethodCandidateInfo createCandidateInfo(final @NotNull PsiMethod method, final @NotNull PsiSubstitutor substitutor2, boolean staticProblem, boolean accessible, final boolean varargs) {
                        if (method == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (substitutor2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        PsiExpressionList argumentList = this.getArgumentList();
                        PsiType[] typeParameters2 = reference2.getTypeParameters();
                        return new MethodCandidateInfo(method, substitutor2, !accessible, staticProblem, argumentList, this.myCurrentFileContext, argumentList != null ? argumentList.getExpressionTypes() : null, method.hasTypeParameters() && typeParameters2.length > 0 ? typeParameters2 : null, this.getLanguageLevel()){

                            @Override
                            public boolean isVarargs() {
                                return varargs;
                            }

                            @Override
                            @NotNull
                            public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
                                if (policy == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                PsiSubstitutor psiSubstitutor = includeReturnConstraint ? this.inferTypeArguments(true) : Objects.requireNonNull(MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(reference2, false, () -> this.inferTypeArguments(false)));
                                if (psiSubstitutor == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return psiSubstitutor;
                            }

                            private PsiSubstitutor inferTypeArguments(boolean includeReturnConstraint) {
                                if (interfaceMethod == null) {
                                    return substitutor2;
                                }
                                InferenceSession session = new InferenceSession(method.getTypeParameters(), substitutor2, reference2.getManager(), reference2);
                                session.initThrowsConstraints(method);
                                PsiSubstitutor psiSubstitutor = session.collectApplicabilityConstraints(reference2, this, functionalInterfaceType);
                                if (psiSubstitutor != null) {
                                    return psiSubstitutor;
                                }
                                if (!session.repeatInferencePhases()) {
                                    List<String> errorMessages = session.getIncompatibleErrorMessages();
                                    if (errorMessages != null) {
                                        this.setApplicabilityError(StringUtil.join(errorMessages, "\n"));
                                    }
                                    return substitutor2;
                                }
                                if (includeReturnConstraint && !PsiType.VOID.equals(interfaceMethodReturnType) && interfaceMethodReturnType != null) {
                                    PsiClassType returnType2;
                                    PsiType psiType = returnType2 = method.isConstructor() ? MethodReferenceResolver.composeReturnType(containingClass, substitutor2) : PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, method, containingClass, reference2).substitute(method.getReturnType());
                                    if (returnType2 != null) {
                                        session.registerReturnTypeConstraints(returnType2, interfaceMethodReturnType, reference2);
                                    }
                                }
                                return session.infer(method.getParameterList().getParameters(), null, null, null);
                            }

                            @Override
                            public boolean isApplicable() {
                                boolean hasReceiver;
                                if (signature == null) {
                                    return false;
                                }
                                if (this.getInferenceErrorMessageAssumeAlreadyComputed() != null) {
                                    return false;
                                }
                                PsiType[] argTypes = signature.getParameterTypes();
                                return MethodReferenceConflictResolver.isApplicableByFirstSearch(this, argTypes, hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, qualifierResolveResult, reference2), reference2, interfaceMethod.isVarArgs(), interfaceMethod) != null;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string2;
                                switch (n) {
                                    default: {
                                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 1: {
                                        string2 = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 1: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "policy";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "inferTypeArguments";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "inferTypeArguments";
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                }
                                String string3 = String.format(string2, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string3);
                                        break;
                                    }
                                    case 1: {
                                        runtimeException = new IllegalStateException(string3);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        };
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "method";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "substitutor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1";
                        objectArray[2] = "createCandidateInfo";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor.setIsConstructor(isConstructor);
                processor.setName(isConstructor ? containingClass.getName() : element2.getText());
                PsiExpression expression2 = reference2.getQualifierExpression();
                if (expression2 == null || !(expression2.getType() instanceof PsiArrayType) && !(expression2 instanceof PsiSuperExpression)) {
                    processor.setAccessClass(containingClass);
                }
                if (qualifierResolveResult.isReferenceTypeQualified() && MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference2)) {
                    processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                }
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
                containingClass.processDeclarations(processor, state, reference2, reference2);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    MethodReferenceResolver.$$$reportNull$$$0(4);
                }
                return javaResolveResultArray;
            }
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            MethodReferenceResolver.$$$reportNull$$$0(5);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public static boolean canBeConstructed(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MethodReferenceResolver.$$$reportNull$$$0(6);
        }
        return !psiClass.isEnum() && !psiClass.hasModifierProperty("abstract") && !(psiClass instanceof PsiTypeParameter);
    }

    private static boolean isLocatedInStaticContext(@NotNull PsiClass containingClass, @NotNull PsiMethodReferenceExpression reference2) {
        PsiClass gContainingClass;
        if (containingClass == null) {
            MethodReferenceResolver.$$$reportNull$$$0(7);
        }
        if (reference2 == null) {
            MethodReferenceResolver.$$$reportNull$$$0(8);
        }
        if ((gContainingClass = containingClass.getContainingClass()) == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass = null;
            if (PsiTreeUtil.isAncestor(gContainingClass != null ? gContainingClass : containingClass, reference2, false)) {
                aClass = gContainingClass != null ? gContainingClass : containingClass;
            }
            return PsiUtil.getEnclosingStaticElement(reference2, aClass) != null;
        }
        return false;
    }

    protected PsiConflictResolver createResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable PsiMethod interfaceMethod, @Nullable MethodSignature signature) {
        if (referenceExpression == null) {
            MethodReferenceResolver.$$$reportNull$$$0(9);
        }
        if (qualifierResolveResult == null) {
            MethodReferenceResolver.$$$reportNull$$$0(10);
        }
        return new MethodReferenceConflictResolver(referenceExpression, qualifierResolveResult, signature, interfaceMethod);
    }

    @NotNull
    private static PsiClassType composeReturnType(@NotNull PsiClass containingClass, @NotNull PsiSubstitutor substitutor2) {
        if (containingClass == null) {
            MethodReferenceResolver.$$$reportNull$$$0(11);
        }
        if (substitutor2 == null) {
            MethodReferenceResolver.$$$reportNull$$$0(12);
        }
        boolean isRawSubst = PsiUtil.isRawSubstitutor(containingClass, substitutor2);
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor2);
        if (psiClassType == null) {
            MethodReferenceResolver.$$$reportNull$$$0(13);
        }
        return psiClassType;
    }

    private static boolean arrayCreationSignature(@NotNull MethodSignature signature) {
        PsiType[] parameterTypes2;
        if (signature == null) {
            MethodReferenceResolver.$$$reportNull$$$0(14);
        }
        if ((parameterTypes2 = signature.getParameterTypes()).length == 1 && parameterTypes2[0] != null) {
            if (TypeConversionUtil.isAssignable(PsiType.INT, parameterTypes2[0])) {
                return true;
            }
            if (parameterTypes2[0] instanceof PsiClassType) {
                return ((PsiClassType)parameterTypes2[0]).resolve() instanceof PsiTypeParameter;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResolveResult";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "composeReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeConstructed";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isLocatedInStaticContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createResolver";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "composeReturnType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "arrayCreationSignature";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodReferenceConflictResolver
    extends JavaMethodsConflictResolver {
        private final MethodSignature mySignature;
        private final PsiMethod myInterfaceMethod;
        private final PsiMethodReferenceExpressionImpl myReferenceExpression;
        private final PsiMethodReferenceUtil.QualifierResolveResult myQualifierResolveResult;
        private final boolean myFunctionalMethodVarArgs;

        private MethodReferenceConflictResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature, @Nullable PsiMethod interfaceMethod) {
            if (referenceExpression == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(0);
            }
            if (qualifierResolveResult == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(1);
            }
            super(referenceExpression, signature != null ? signature.getParameterTypes() : PsiType.EMPTY_ARRAY, PsiUtil.getLanguageLevel(referenceExpression), referenceExpression.getContainingFile());
            this.myReferenceExpression = referenceExpression;
            this.myQualifierResolveResult = qualifierResolveResult;
            this.myFunctionalMethodVarArgs = interfaceMethod != null && interfaceMethod.isVarArgs();
            this.mySignature = signature;
            this.myInterfaceMethod = interfaceMethod;
        }

        @Override
        protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict, Map<MethodCandidateInfo, PsiSubstitutor> map) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(2);
            }
            return conflict.isVarargs() ? 2 : 3;
        }

        @Override
        @Nullable
        protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
            if (conflicts == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(3);
            }
            if (this.mySignature == null) {
                return null;
            }
            if (conflicts.isEmpty()) {
                return null;
            }
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            Map<MethodCandidateInfo, PsiSubstitutor> map = FactoryMap.create(key -> key.getSubstitutor(false));
            this.checkSameSignatures(conflicts, map);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            MethodReferenceConflictResolver.checkAccessStaticLevels(conflicts, true);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            PsiType[] argTypes = this.mySignature.getParameterTypes();
            boolean hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, this.myQualifierResolveResult, this.myReferenceExpression);
            ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
            ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo conflict : conflicts) {
                Boolean applicableByFirstSearch;
                if (!(conflict instanceof MethodCandidateInfo) || (applicableByFirstSearch = MethodReferenceConflictResolver.isApplicableByFirstSearch(conflict, argTypes, hasReceiver, this.myReferenceExpression, this.myFunctionalMethodVarArgs, this.myInterfaceMethod)) == null) continue;
                (applicableByFirstSearch != false ? firstCandidates : secondCandidates).add(conflict);
            }
            if (this.myQualifierResolveResult.isReferenceTypeQualified() && this.myReferenceExpression.getReferenceNameElement() instanceof PsiIdentifier) {
                int firstApplicability = this.checkApplicability(firstCandidates);
                ArrayList<CandidateInfo> firstResults = new ArrayList<CandidateInfo>(firstCandidates);
                this.checkSpecifics(firstResults, firstApplicability, map, 0);
                int secondApplicability = this.checkApplicability(secondCandidates);
                ArrayList<CandidateInfo> secondResults = new ArrayList<CandidateInfo>(secondCandidates);
                this.checkSpecifics(secondResults, secondApplicability, map, 1);
                CandidateInfo candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(firstResults, secondCandidates, true);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(secondResults, firstCandidates, false);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
                conflicts.clear();
                conflicts.addAll(firstResults);
                conflicts.addAll(secondResults);
                return null;
            }
            CandidateInfo candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, map, 3);
            if (candidateInfo != null) {
                return candidateInfo;
            }
            candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, map, 2);
            if (candidateInfo != null) {
                return candidateInfo;
            }
            if (firstCandidates.isEmpty() && secondCandidates.isEmpty()) {
                return null;
            }
            conflicts.clear();
            firstCandidates.addAll(secondCandidates);
            conflicts.addAll(firstCandidates);
            return null;
        }

        private static Boolean isApplicableByFirstSearch(@NotNull CandidateInfo conflict, PsiType @NotNull [] functionalInterfaceParamTypes, boolean hasReceiver, @NotNull PsiMethodReferenceExpression referenceExpression, boolean functionalMethodVarArgs, PsiMethod interfaceMethod) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(4);
            }
            if (referenceExpression == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(5);
            }
            if (functionalInterfaceParamTypes == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(6);
            }
            PsiMethod psiMethod = ((MethodCandidateInfo)conflict).getElement();
            PsiSubstitutor substitutor2 = ((MethodCandidateInfo)conflict).getSubstitutor(false);
            if (((MethodCandidateInfo)conflict).getInferenceErrorMessage() != null) {
                return null;
            }
            PsiType[] parameterTypes2 = psiMethod.getSignature(substitutor2).getParameterTypes();
            boolean varargs = ((MethodCandidateInfo)conflict).isVarargs();
            if (varargs && (!psiMethod.isVarArgs() || functionalMethodVarArgs)) {
                return null;
            }
            if (hasReceiver && varargs && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes2, functionalInterfaceParamTypes, interfaceMethod, true, conflict, 0) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes2, functionalInterfaceParamTypes, interfaceMethod, true, conflict, 1)) {
                return psiMethod.hasModifierProperty("static");
            }
            if ((varargs || functionalInterfaceParamTypes.length == parameterTypes2.length) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes2, functionalInterfaceParamTypes, interfaceMethod, varargs, conflict, 0)) {
                PsiClass containingClass;
                if (psiMethod.hasModifierProperty("static") && (containingClass = psiMethod.getContainingClass()) != null && containingClass.isInterface()) {
                    PsiClass qualifierClass = PsiMethodReferenceUtil.getQualifierResolveResult(referenceExpression).getContainingClass();
                    if (!containingClass.getManager().areElementsEquivalent(qualifierClass, containingClass)) {
                        return null;
                    }
                }
                return true;
            }
            if (hasReceiver && (varargs || functionalInterfaceParamTypes.length == parameterTypes2.length + 1) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes2, functionalInterfaceParamTypes, interfaceMethod, varargs, conflict, 1)) {
                return false;
            }
            return null;
        }

        private static boolean isCorrectAssignment(PsiType @NotNull [] parameterTypes2, PsiType @NotNull [] functionalInterfaceParamTypes, PsiMethod interfaceMethod, boolean varargs, @NotNull CandidateInfo conflict, int offset) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(7);
            }
            if (parameterTypes2 == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(8);
            }
            if (functionalInterfaceParamTypes == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(9);
            }
            int min = Math.min(parameterTypes2.length, functionalInterfaceParamTypes.length - offset);
            for (int i = 0; i < min; ++i) {
                PsiType argType = PsiUtil.captureToplevelWildcards(functionalInterfaceParamTypes[i + offset], interfaceMethod.getParameterList().getParameters()[i]);
                PsiType parameterType = parameterTypes2[i];
                if (varargs && i == parameterTypes2.length - 1) {
                    if (TypeConversionUtil.isAssignable(parameterType, argType) || TypeConversionUtil.isAssignable(((PsiArrayType)parameterType).getComponentType(), argType)) continue;
                    MethodReferenceConflictResolver.markNotApplicable(conflict);
                    return false;
                }
                if (TypeConversionUtil.isAssignable(parameterType, argType)) continue;
                MethodReferenceConflictResolver.markNotApplicable(conflict);
                return false;
            }
            return !varargs || parameterTypes2.length - 1 <= functionalInterfaceParamTypes.length - offset;
        }

        private static void markNotApplicable(@NotNull CandidateInfo conflict) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(10);
            }
            if (conflict instanceof MethodCandidateInfo) {
                ((MethodCandidateInfo)conflict).markNotApplicable();
            }
        }

        private CandidateInfo resolveConflicts(@NotNull List<CandidateInfo> firstCandidates, @NotNull List<CandidateInfo> secondCandidates, Map<MethodCandidateInfo, PsiSubstitutor> map, int applicabilityLevel) {
            if (firstCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(11);
            }
            if (secondCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(12);
            }
            int firstApplicability = this.checkApplicability(firstCandidates);
            this.checkSpecifics(firstCandidates, applicabilityLevel, map, 0);
            int secondApplicability = this.checkApplicability(secondCandidates);
            this.checkSpecifics(secondCandidates, applicabilityLevel, map, 1);
            if (firstApplicability < secondApplicability) {
                return secondCandidates.size() == 1 ? secondCandidates.get(0) : null;
            }
            if (secondApplicability < firstApplicability) {
                return firstCandidates.size() == 1 ? firstCandidates.get(0) : null;
            }
            return firstCandidates.size() + secondCandidates.size() == 1 ? (firstCandidates.isEmpty() ? secondCandidates.get(0) : firstCandidates.get(0)) : null;
        }

        @Override
        protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
            if (method == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(13);
            }
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(14);
            }
            if (method == conflict) {
                return true;
            }
            PsiElement psiElement = method.getElement();
            PsiElement conflictElement = conflict.getElement();
            if (psiElement instanceof PsiMethod && conflictElement instanceof PsiMethod) {
                return fixedArity && ((PsiMethod)psiElement).getParameterList().getParametersCount() != ((PsiMethod)conflictElement).getParameterList().getParametersCount();
            }
            return false;
        }

        private static CandidateInfo filterStaticCorrectCandidates(@NotNull List<CandidateInfo> firstCandidates, @NotNull List<CandidateInfo> secondCandidates, boolean shouldBeStatic) {
            boolean isStatic;
            CandidateInfo candidateInfo;
            PsiElement element2;
            if (firstCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(15);
            }
            if (secondCandidates == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(16);
            }
            if (firstCandidates.size() == 1 && (element2 = (candidateInfo = firstCandidates.get(0)).getElement()) instanceof PsiMethod && shouldBeStatic == (isStatic = ((PsiMethod)element2).hasModifierProperty("static"))) {
                for (CandidateInfo secondCandidate : secondCandidates) {
                    boolean oppositeStatic;
                    PsiElement psiElement = secondCandidate.getElement();
                    if (!(psiElement instanceof PsiMethod) || shouldBeStatic == (oppositeStatic = ((PsiMethod)psiElement).hasModifierProperty("static"))) continue;
                    return null;
                }
                return candidateInfo;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierResolveResult";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflict";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflicts";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionalInterfaceParamTypes";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterTypes";
                    break;
                }
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstCandidates";
                    break;
                }
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondCandidates";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPertinentApplicabilityLevel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guardedOverloadResolution";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicableByFirstSearch";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCorrectAssignment";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markNotApplicable";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveConflicts";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nonComparable";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "filterStaticCorrectCandidates";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

