/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.fasterxml.aalto.in.ByteSourceBootstrapper;
import com.fasterxml.aalto.in.CharSourceBootstrapper;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.stax.StreamReaderImpl;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"config", "Lcom/fasterxml/aalto/in/ReaderConfig;", "configWithCoalescing", "createConfig", "coalesce", "", "createNonCoalescingXmlStreamReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "input", "Ljava/io/InputStream;", "locationSource", "", "", "createXmlStreamReader", "reader", "Ljava/io/Reader;", "bytes", "intellij.platform.util.xmlDom"})
@JvmName(name="StaxFactory")
public final class StaxFactory {
    private static final ReaderConfig config = StaxFactory.createConfig(false);
    private static final ReaderConfig configWithCoalescing = StaxFactory.createConfig(true);

    private static final ReaderConfig createConfig(boolean coalesce) {
        ReaderConfig config = new ReaderConfig();
        config.doAutoCloseInput(true);
        config.setProperty("javax.xml.stream.supportDTD", false);
        config.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        config.setProperty("org.codehaus.stax2.internNames", false);
        config.setProperty("org.codehaus.stax2.internNsUris", false);
        config.doPreserveLocation(false);
        config.setProperty("org.codehaus.stax2.closeInputSource", true);
        config.setXmlEncoding("UTF-8");
        config.doCoalesceText(coalesce);
        config.doParseLazily(true);
        return config;
    }

    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull InputStream input) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct(ByteSourceBootstrapper.construct(configWithCoalescing.createNonShared(null, null, "UTF-8"), input));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"StreamReaderImpl.constru\u2026, null, \"UTF-8\"), input))");
        return streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull byte[] bytes) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ReaderConfig readerConfig = configWithCoalescing.createNonShared(null, null, "UTF-8");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct(ByteSourceBootstrapper.construct(readerConfig, bytes, 0, bytes.length));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"StreamReaderImpl.constru\u2026g, bytes, 0, bytes.size))");
        return streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createNonCoalescingXmlStreamReader(@NotNull InputStream input, @Nullable String locationSource) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct(ByteSourceBootstrapper.construct(config.createNonShared(null, locationSource, "UTF-8"), input));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"StreamReaderImpl.constru\u2026Source, \"UTF-8\"), input))");
        return streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createNonCoalescingXmlStreamReader(@NotNull byte[] input, @Nullable String locationSource) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct(ByteSourceBootstrapper.construct(config.createNonShared(null, locationSource, "UTF-8"), input, 0, input.length));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"StreamReaderImpl.constru\u2026), input, 0, input.size))");
        return streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull Reader reader) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct(CharSourceBootstrapper.construct(configWithCoalescing.createNonShared(null, null, "UTF-8"), reader));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"StreamReaderImpl.constru\u2026 null, \"UTF-8\"), reader))");
        return streamReaderImpl;
    }
}

