/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectHighlightsUtil {
    static final ExtensionPointName<Condition<PsiElement>> EP_NAME = ExtensionPointName.create("com.intellij.elementsToHighlightFilter");
    private static final Logger LOG = Logger.getInstance(CollectHighlightsUtil.class);
    private static final int STARTING_TREE_HEIGHT = 100;

    private CollectHighlightsUtil() {
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root, int startOffset, int endOffset) {
        if (root == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(0);
        }
        return CollectHighlightsUtil.getElementsInRange(root, startOffset, endOffset, false);
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root, int startOffset, int endOffset, boolean includeAllParents) {
        PsiElement commonParent;
        if (root == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(1);
        }
        if ((commonParent = CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset)) == null) {
            return new ArrayList<PsiElement>();
        }
        List<PsiElement> list = CollectHighlightsUtil.getElementsToHighlight(commonParent, startOffset, endOffset);
        PsiElement parent2 = commonParent;
        while (parent2 != null && parent2 != root) {
            list.add(parent2);
            parent2 = includeAllParents ? parent2.getParent() : null;
        }
        list.add(root);
        List<PsiElement> list2 = list;
        if (list2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private static List<PsiElement> getElementsToHighlight(@NotNull PsiElement parent2, int startOffset, int endOffset) {
        if (parent2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(3);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        int offset = parent2.getTextRange().getStartOffset();
        IntArrayList starts = new IntArrayList(100);
        Stack<PsiElement> elements = new Stack<PsiElement>(100);
        Stack<PsiElement> children2 = new Stack<PsiElement>(100);
        PsiElement element2 = parent2;
        PsiElement child = PsiUtilCore.NULL_PSI_ELEMENT;
        while (true) {
            boolean startChildrenVisiting;
            ProgressIndicatorProvider.checkCanceled();
            for (Condition<PsiElement> filter : EP_NAME.getExtensionList()) {
                if (filter.value(element2)) continue;
                assert (child == PsiUtilCore.NULL_PSI_ELEMENT);
                child = null;
                break;
            }
            if (child == PsiUtilCore.NULL_PSI_ELEMENT) {
                startChildrenVisiting = true;
                child = element2.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                if (startChildrenVisiting) {
                    offset += element2.getTextLength();
                }
                if (elements.isEmpty()) break;
                int start = starts.popInt();
                if (startOffset <= start && offset <= endOffset) {
                    assert (element2 != null);
                    assert (element2 != PsiUtilCore.NULL_PSI_ELEMENT);
                    result2.add(element2);
                }
                element2 = (PsiElement)elements.pop();
                child = (PsiElement)children2.pop();
                continue;
            }
            if (offset > endOffset) break;
            children2.push(child.getNextSibling());
            starts.push(offset);
            assert (element2 != null);
            assert (element2 != PsiUtilCore.NULL_PSI_ELEMENT);
            elements.push(element2);
            element2 = child;
            child = PsiUtilCore.NULL_PSI_ELEMENT;
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement root, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return null;
        }
        PsiElement left = CollectHighlightsUtil.findElementAtInRoot(root, startOffset);
        PsiElement right = CollectHighlightsUtil.findElementAtInRoot(root, endOffset - 1);
        if (left == null || right == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(left, right);
        if (commonParent == null) {
            LOG.error("No common parent for " + left + " and " + right + "; root: " + root + "; startOffset: " + startOffset + "; endOffset: " + endOffset);
        }
        LOG.assertTrue(commonParent.getTextRange() != null, commonParent);
        for (PsiElement parent2 = commonParent.getParent(); parent2 != null && commonParent.getTextRange().equals(parent2.getTextRange()); parent2 = parent2.getParent()) {
            commonParent = parent2;
        }
        return commonParent;
    }

    @Nullable
    private static PsiElement findElementAtInRoot(PsiElement root, int offset) {
        if (root instanceof PsiFile) {
            return ((PsiFile)root).getViewProvider().findElementAt(offset, root.getLanguage());
        }
        return root.findElementAt(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsInRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInRange";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToHighlight";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

