/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.java.JvmDefaultModeContainerKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmDefaultChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmDefaultChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmDefaultChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmDefaultChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,51:1\n57#2:52\n34#3:53\n*S KotlinDebug\n*F\n+ 1 FirJvmDefaultChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmDefaultChecker\n*L\n43#1:52\n43#1:53\n*E\n"})
public final class FirJvmDefaultChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmDefaultChecker INSTANCE = new FirJvmDefaultChecker();

    private FirJvmDefaultChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block6: {
            KtSourceElement source;
            block7: {
                FirAnnotation annotationWithCompatibility;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                JvmDefaultMode jvmDefaultMode2 = JvmDefaultModeContainerKt.getJvmDefaultModeState(context2.getSession());
                FirSession session = context2.getSession();
                FirAnnotation annotationNoCompatibility = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID(), session);
                if (annotationNoCompatibility != null) {
                    KtSourceElement source2 = annotationNoCompatibility.getSource();
                    if (!jvmDefaultMode2.isEnabled()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirJvmErrors.INSTANCE.getJVM_DEFAULT_IN_DECLARATION(), (Object)"JvmDefaultWithoutCompatibility", (DiagnosticContext)context2, null, 16, null);
                        return;
                    }
                }
                if ((annotationWithCompatibility = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID(), session)) == null) break block6;
                source = annotationWithCompatibility.getSource();
                if (jvmDefaultMode2 != JvmDefaultMode.ALL) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_IN_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
                    return;
                }
                if (!(declaration2 instanceof FirRegularClass)) break block7;
                FirClass $this$isInterface$iv = (FirClass)declaration2;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                if ($this$isInterface$iv$iv == ClassKind.INTERFACE) break block6;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_NOT_ON_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
    }
}

