/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.declarations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.utils.TypeUtilsKt;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDirectInheritorsProvider;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0002J(\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 *\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneFirDirectInheritorsProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDirectInheritorsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "standaloneDeclarationProviderFactory", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "getStandaloneDeclarationProviderFactory", "()Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "standaloneDeclarationProviderFactory$delegate", "Lkotlin/Lazy;", "getDirectKotlinInheritors", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "includeLocalInheritors", "", "calculateAliases", "", "aliasedName", "Lorg/jetbrains/kotlin/name/Name;", "aliases", "", "isValidInheritor", "candidate", "baseFirClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "toFirSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "ktModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "analysis-api-fir-standalone-base"})
@SourceDebugExtension(value={"SMAP\nKotlinStandaloneFirDirectInheritorsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStandaloneFirDirectInheritorsProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneFirDirectInheritorsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1368#2:115\n1454#2,5:116\n774#2:121\n865#2,2:122\n1863#2,2:124\n*S KotlinDebug\n*F\n+ 1 KotlinStandaloneFirDirectInheritorsProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneFirDirectInheritorsProvider\n*L\n49#1:115\n49#1:116,5\n69#1:121\n69#1:122,2\n73#1:124,2\n*E\n"})
public final class KotlinStandaloneFirDirectInheritorsProvider
implements KotlinDirectInheritorsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy standaloneDeclarationProviderFactory$delegate;

    public KotlinStandaloneFirDirectInheritorsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.standaloneDeclarationProviderFactory$delegate = LazyKt.lazy(() -> KotlinStandaloneFirDirectInheritorsProvider.standaloneDeclarationProviderFactory_delegate$lambda$0(this));
    }

    private final KotlinStandaloneDeclarationProviderFactory getStandaloneDeclarationProviderFactory() {
        Lazy lazy = this.standaloneDeclarationProviderFactory$delegate;
        return (KotlinStandaloneDeclarationProviderFactory)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<KtClassOrObject> getDirectKotlinInheritors(@NotNull KtClass ktClass, @NotNull GlobalSearchScope scope, boolean includeLocalInheritors) {
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ktClass, (String)"ktClass");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ClassId classId = ktClass.getClassId();
        if (classId == null) {
            return CollectionsKt.emptyList();
        }
        ClassId classId2 = classId;
        Object[] objectArray = new Name[]{classId2.getShortClassName()};
        Set aliases = SetsKt.mutableSetOf((Object[])objectArray);
        this.calculateAliases(classId2.getShortClassName(), aliases);
        Iterable $this$flatMap$iv = aliases;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Name it = (Name)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getStandaloneDeclarationProviderFactory().getDirectInheritorCandidates(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List possibleInheritors = (List)destination$iv$iv;
        if (possibleInheritors.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KtModule ktModule = ProjectStructureProvider.Companion.getModule(this.project, ktClass, null);
        KtModule baseKtModule = ktModule instanceof KtDanglingFileModule ? ((KtDanglingFileModule)ktModule).getContextModule() : ktModule;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.toFirSymbol(ktClass, classId2, baseKtModule);
        destination$iv$iv = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirClass firClass = destination$iv$iv instanceof FirClass ? (FirClass)destination$iv$iv : null;
        if (firClass == null) {
            return CollectionsKt.emptyList();
        }
        FirClass baseFirClass = firClass;
        Iterable $this$filter$iv = possibleInheritors;
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtClassOrObject it = (KtClassOrObject)element$iv$iv;
            boolean bl = false;
            if (!this.isValidInheritor(it, baseFirClass, scope, includeLocalInheritors)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final void calculateAliases(Name aliasedName, Set<Name> aliases) {
        Iterable $this$forEach$iv = this.getStandaloneDeclarationProviderFactory().getInheritableTypeAliases(aliasedName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Name aliasName;
            KtTypeAlias alias = (KtTypeAlias)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)alias.getNameAsSafeName(), (String)"getNameAsSafeName(...)");
            boolean isNewAliasName = aliases.add(aliasName);
            if (!isNewAliasName) continue;
            this.calculateAliases(aliasName, aliases);
        }
    }

    private final boolean isValidInheritor(KtClassOrObject candidate, FirClass baseFirClass, GlobalSearchScope scope, boolean includeLocalInheritors) {
        if (!includeLocalInheritors && candidate.isLocal()) {
            return false;
        }
        if (!PsiUtilsKt.contains(scope, candidate)) {
            return false;
        }
        ClassId classId = candidate.getClassId();
        if (classId == null) {
            return false;
        }
        ClassId candidateClassId = classId;
        KtModule candidateKtModule = ProjectStructureProvider.Companion.getModule(this.project, candidate, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = this.toFirSymbol(candidate, candidateClassId, candidateKtModule);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> candidateFirSymbol = firClassLikeSymbol;
        Object e = candidateFirSymbol.getFir();
        FirClass firClass = e instanceof FirClass ? (FirClass)e : null;
        if (firClass == null) {
            return false;
        }
        FirClass candidateFirClass = firClass;
        return TypeUtilsKt.isSubClassOf(candidateFirClass, baseFirClass, candidateFirClass.getModuleData().getSession(), false);
    }

    private final FirClassLikeSymbol<?> toFirSymbol(KtClassOrObject $this$toFirSymbol, ClassId classId, KtModule ktModule) {
        Project project = $this$toFirSymbol.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LLFirSession session = LLFirSessionCache.Companion.getInstance(project).getSession(ktModule, true);
        return FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId(classId);
    }

    private static final KotlinStandaloneDeclarationProviderFactory standaloneDeclarationProviderFactory_delegate$lambda$0(KotlinStandaloneFirDirectInheritorsProvider this$0) {
        KotlinDeclarationProviderFactory kotlinDeclarationProviderFactory = KotlinDeclarationProviderFactory.Companion.getInstance(this$0.project);
        KotlinStandaloneDeclarationProviderFactory kotlinStandaloneDeclarationProviderFactory = kotlinDeclarationProviderFactory instanceof KotlinStandaloneDeclarationProviderFactory ? (KotlinStandaloneDeclarationProviderFactory)kotlinDeclarationProviderFactory : null;
        if (kotlinStandaloneDeclarationProviderFactory == null) {
            throw new IllegalStateException(('`' + Reflection.getOrCreateKotlinClass(KotlinStandaloneFirDirectInheritorsProvider.class).getSimpleName() + "` expects the following declaration provider factory to be registered: `" + Reflection.getOrCreateKotlinClass(KotlinStandaloneDeclarationProviderFactory.class).getSimpleName() + '`').toString());
        }
        return kotlinStandaloneDeclarationProviderFactory;
    }
}

