/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JdkClassFinder {
    JdkClassFinder() {
    }

    @NotNull
    static List<String> findClasses(@NotNull Path jdkHome, boolean isJre) {
        if (jdkHome == null) {
            JdkClassFinder.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        if (JdkClassFinder.isExplodedModularRuntime(jdkHome)) {
            try (DirectoryStream<Path> roots2 = Files.newDirectoryStream(jdkHome.resolve("modules"));){
                for (Path root : roots2) {
                    result2.add(JdkClassFinder.getUrlForLibraryRoot(root));
                }
            }
            catch (IOException roots2) {}
        } else if (JdkClassFinder.isModularRuntime(jdkHome)) {
            String jrtBaseUrl = "jrt://" + JdkClassFinder.vfsPath(jdkHome) + "!/";
            List<String> modules = JdkClassFinder.readModulesFromReleaseFile(jdkHome);
            if (modules != null) {
                for (String module2 : modules) {
                    result2.add(jrtBaseUrl + module2);
                }
            } else {
                VirtualFile jrt = VirtualFileManager.getInstance().findFileByUrl(jrtBaseUrl);
                if (jrt != null) {
                    for (VirtualFile virtualFile : jrt.getChildren()) {
                        result2.add(virtualFile.getUrl());
                    }
                }
            }
        } else {
            for (Path root : JdkClassFinder.getJdkClassesRoots(jdkHome, isJre)) {
                result2.add(JdkClassFinder.getUrlForLibraryRoot(root));
            }
        }
        Collections.sort(result2);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            JdkClassFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static String vfsPath(@NotNull Path path) {
        if (path == null) {
            JdkClassFinder.$$$reportNull$$$0(2);
        }
        return FileUtil.toSystemIndependentName(path.toAbsolutePath().toString());
    }

    private static boolean isExplodedModularRuntime(@NotNull Path homePath) {
        if (homePath == null) {
            JdkClassFinder.$$$reportNull$$$0(3);
        }
        return Files.isDirectory(homePath.resolve("modules/java.base"), new LinkOption[0]);
    }

    private static boolean isModularRuntime(@NotNull Path homePath) {
        if (homePath == null) {
            JdkClassFinder.$$$reportNull$$$0(4);
        }
        return Files.isRegularFile(homePath.resolve("lib/jrt-fs.jar"), new LinkOption[0]) || JdkClassFinder.isExplodedModularRuntime(homePath);
    }

    @NotNull
    private static String getUrlForLibraryRoot(@NotNull Path libraryRoot) {
        if (libraryRoot == null) {
            JdkClassFinder.$$$reportNull$$$0(5);
        }
        return JdkClassFinder.getUrlForLibraryRoot(libraryRoot.toAbsolutePath().toString(), libraryRoot.getFileName().toString());
    }

    @NotNull
    private static String getUrlForLibraryRoot(@NotNull String libraryRootAbsolutePath, @NotNull String libraryRootFileName) {
        if (libraryRootAbsolutePath == null) {
            JdkClassFinder.$$$reportNull$$$0(6);
        }
        if (libraryRootFileName == null) {
            JdkClassFinder.$$$reportNull$$$0(7);
        }
        String path = FileUtil.toSystemIndependentName(libraryRootAbsolutePath);
        String string2 = FileTypeRegistry.getInstance().getFileTypeByFileName(libraryRootFileName) == ArchiveFileType.INSTANCE ? VirtualFileManager.constructUrl("jar", path + "!/") : VirtualFileManager.constructUrl("file", path);
        if (string2 == null) {
            JdkClassFinder.$$$reportNull$$$0(8);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static List<String> readModulesFromReleaseFile(@NotNull Path jrtBaseDir) {
        if (jrtBaseDir == null) {
            JdkClassFinder.$$$reportNull$$$0(9);
        }
        try (InputStream stream = Files.newInputStream(jrtBaseDir.resolve("release"), new OpenOption[0]);){
            Properties p = new Properties();
            p.load(stream);
            String modules = p.getProperty("MODULES");
            if (modules == null) return null;
            List<String> list = StringUtil.split(StringUtil.unquoteString(modules), " ");
            return list;
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }

    @NotNull
    private static List<Path> getJdkClassesRoots(@NotNull Path home, boolean isJre) {
        Path classesDir;
        Path classesZip;
        Path toolsJar;
        Path[] jarDirs;
        Path libDir;
        Path fileName2;
        if (home == null) {
            JdkClassFinder.$$$reportNull$$$0(10);
        }
        if ((fileName2 = home.getFileName()) != null && "Home".equals(fileName2.toString()) && Files.exists(home.resolve("../Classes/classes.jar"), new LinkOption[0])) {
            libDir = home.resolve("lib");
            Path classesDir2 = home.resolveSibling("Classes");
            Path libExtDir = libDir.resolve("ext");
            Path libEndorsedDir = libDir.resolve("endorsed");
            jarDirs = new Path[]{libEndorsedDir, libDir, classesDir2, libExtDir};
        } else if (Files.exists(home.resolve("lib/jrt-fs.jar"), new LinkOption[0])) {
            jarDirs = new Path[]{};
        } else {
            libDir = home.resolve(isJre ? "lib" : "jre/lib");
            Path libExtDir = libDir.resolve("ext");
            Path[] libEndorsedDir = libDir.resolve("endorsed");
            jarDirs = new Path[]{libEndorsedDir, libDir, libExtDir};
        }
        ArrayList<Path> rootFiles = new ArrayList<Path>();
        if (Registry.is("project.structure.add.tools.jar.to.new.jdk", false) && Files.isRegularFile(toolsJar = home.resolve("lib/tools.jar"), new LinkOption[0])) {
            rootFiles.add(toolsJar);
        }
        Set<String> pathFilter = CollectionFactory.createFilePathSet();
        for (Path jarDir : jarDirs) {
            if (jarDir == null || !Files.isDirectory(jarDir, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(jarDir, "*.jar");){
                for (Path jarFile : stream) {
                    String canonicalPath2;
                    String jarFileName = jarFile.getFileName().toString();
                    if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath2 = JdkClassFinder.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath2)) continue;
                    rootFiles.add(jarFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ContainerUtil.exists(rootFiles, path -> path.getFileName().toString().startsWith("ibm"))) {
            try (Stream<Path> paths22 = Files.walk(isJre ? home : home.resolve("jre"), new FileVisitOption[0]);){
                paths22.filter(path -> path.getFileName().toString().equals("vm.jar")).findFirst().ifPresent(rootFiles::add);
            }
            catch (IOException paths22) {
                // empty catch block
            }
        }
        if (Files.isRegularFile(classesZip = home.resolve("lib/classes.zip"), new LinkOption[0])) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && Files.isDirectory(classesDir = home.resolve("classes"), new LinkOption[0])) {
            rootFiles.add(classesDir);
        }
        ArrayList<Path> arrayList = rootFiles;
        if (arrayList == null) {
            JdkClassFinder.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static String getCanonicalPath(Path file2) {
        try {
            return file2.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/analysis/api/impl/base/util/JdkClassFinder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRootAbsolutePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRootFileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jrtBaseDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/analysis/api/impl/base/util/JdkClassFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlForLibraryRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "vfsPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExplodedModularRuntime";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModularRuntime";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUrlForLibraryRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readModulesFromReleaseFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJdkClassesRoots";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

