/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.xml.dom.XmlElement;
import java.text.MessageFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    public static final String DEFAULT_PLUGINS_HOST = "https://plugins.jetbrains.com";
    static final String IDEA_PLUGINS_HOST_PROPERTY = "idea.plugins.host";
    private static final String IDEA_APPLICATION_INFO_DEFAULT_DARK_LAF = "idea.application.info.default.dark.laf";
    private static final String IDEA_APPLICATION_INFO_DEFAULT_CLASSIC_DARK_LAF = "idea.application.info.default.classic.dark.laf";
    private static final String IDEA_APPLICATION_INFO_DEFAULT_LIGHT_LAF = "idea.application.info.default.light.laf";
    private static final String IDEA_APPLICATION_INFO_DEFAULT_CLASSIC_LIGHT_LAF = "idea.application.info.default.classic.light.laf";
    private static volatile ApplicationInfoImpl instance;
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private String mySplashImageUrl;
    private String myEapSplashImageUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myWelcomeScreenLogoUrl;
    private ZonedDateTime buildTime;
    private ZonedDateTime majorReleaseBuildDate;
    private String myProductUrl;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String channelListUrl;
    private String pluginDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private boolean myShowWhatsNewOnUpdate;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> essentialPluginIds;
    private String myJetBrainsTvUrl;
    private String mySubscriptionFormId;
    private boolean mySubscriptionTipsAvailable;
    private String myDefaultLightLaf;
    private String myDefaultClassicLightLaf;
    private String myDefaultDarkLaf;
    private String myDefaultClassicDarkLaf;
    private static final Logger LOG;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    @NonInjectable
    ApplicationInfoImpl(@NotNull XmlElement element2) {
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.essentialPluginIds = new ArrayList<PluginId>();
        block48: for (XmlElement child : element2.children) {
            switch (child.name) {
                case "version": {
                    this.myMajorVersion = child.getAttributeValue("major");
                    this.myMinorVersion = child.getAttributeValue("minor");
                    this.myMicroVersion = child.getAttributeValue("micro");
                    this.myPatchVersion = child.getAttributeValue("patch");
                    this.myFullVersionFormat = child.getAttributeValue("full");
                    this.myCodeName = child.getAttributeValue("codename");
                    this.myEAP = Boolean.parseBoolean(child.getAttributeValue("eap"));
                    this.myVersionSuffix = child.getAttributeValue("suffix", this.myEAP ? "EAP" : null);
                    break;
                }
                case "company": {
                    this.myCompanyName = child.getAttributeValue("name", this.myCompanyName);
                    this.myShortCompanyName = child.getAttributeValue("shortName", this.myCompanyName == null ? null : ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
                    this.myCompanyUrl = child.getAttributeValue("url", this.myCompanyUrl);
                    this.myCopyrightStart = child.getAttributeValue("copyrightStart", this.myCopyrightStart);
                    break;
                }
                case "build": {
                    this.readBuildInfo(child);
                    break;
                }
                case "logo": {
                    this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(child, "url");
                    break;
                }
                case "logo-eap": {
                    this.myEapSplashImageUrl = ApplicationInfoImpl.getAttributeValue(child, "url");
                    break;
                }
                case "icon": {
                    this.mySvgIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "icon-eap": {
                    this.mySvgEapIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgEapIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "welcome-screen": {
                    this.myWelcomeScreenLogoUrl = child.getAttributeValue("logo-url");
                    break;
                }
                case "productUrl": {
                    this.myProductUrl = child.getAttributeValue("url");
                    break;
                }
                case "help": {
                    String attValue;
                    String webHelpUrl = ApplicationInfoImpl.getAttributeValue(child, "webhelp-url");
                    if (webHelpUrl != null) {
                        this.myWebHelpUrl = webHelpUrl;
                    }
                    this.myHasHelp = (attValue = child.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
                    attValue = child.getAttributeValue("has-context-help");
                    this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
                    break;
                }
                case "update-urls": {
                    this.myUpdateUrls = new UpdateUrlsImpl(child);
                    break;
                }
                case "documentation": {
                    this.myDocumentationUrl = child.getAttributeValue("url");
                    break;
                }
                case "support": {
                    this.mySupportUrl = child.getAttributeValue("url");
                    break;
                }
                case "youtrack": {
                    this.myYoutrackUrl = child.getAttributeValue("url");
                    break;
                }
                case "feedback": {
                    this.myFeedbackUrl = child.getAttributeValue("url");
                    break;
                }
                case "whatsnew": {
                    this.myWhatsNewUrl = child.getAttributeValue("url");
                    this.myShowWhatsNewOnUpdate = Boolean.parseBoolean(child.getAttributeValue("show-on-update"));
                    break;
                }
                case "plugins": {
                    this.readPluginInfo(child);
                    break;
                }
                case "keymap": {
                    this.myWinKeymapUrl = child.getAttributeValue("win");
                    this.myMacKeymapUrl = child.getAttributeValue("mac");
                    break;
                }
                case "essential-plugin": {
                    String id = child.content;
                    if (id == null || id.isEmpty()) continue block48;
                    this.essentialPluginIds.add(PluginId.getId(id));
                    break;
                }
                case "jetbrains-tv": {
                    this.myJetBrainsTvUrl = child.getAttributeValue("url");
                    break;
                }
                case "subscriptions": {
                    this.mySubscriptionFormId = child.getAttributeValue("formid");
                    this.mySubscriptionTipsAvailable = Boolean.parseBoolean(child.getAttributeValue("tips-available"));
                    break;
                }
                case "default-laf": {
                    String laf = ApplicationInfoImpl.getAttributeValue(child, "light");
                    if (laf != null) {
                        this.myDefaultLightLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "light-classic")) != null) {
                        this.myDefaultClassicLightLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "dark")) != null) {
                        this.myDefaultDarkLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "dark-classic")) == null) break;
                    this.myDefaultClassicDarkLaf = laf.trim();
                }
            }
        }
        if (this.myPluginManagerUrl == null) {
            this.readPluginInfo(null);
        }
        Objects.requireNonNull(this.mySvgIconUrl, "Missing attribute: //icon@svg");
        Objects.requireNonNull(this.mySmallSvgIconUrl, "Missing attribute: //icon@svg-small");
        this.overrideFromProperties();
        this.essentialPluginIds.sort(null);
    }

    private void overrideFromProperties() {
        String youTrackUrlOverride = System.getProperty("application.info.youtrack.url");
        if (youTrackUrlOverride != null) {
            this.myYoutrackUrl = youTrackUrlOverride;
        }
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        return ApplicationInfoImpl.getShadowInstanceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static ApplicationInfoImpl getShadowInstanceImpl() {
        ApplicationInfoImpl result2 = instance;
        if (result2 != null) {
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(1);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result2 = instance;
            if (result2 == null) {
                Activity activity = StartUpMeasurer.startActivity("app info loading");
                try {
                    instance = result2 = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
    }

    @NotNull
    public static String orFromPluginCompatibleBuild(@Nullable BuildNumber buildNumber) {
        BuildNumber number = buildNumber == null ? ApplicationInfoImpl.getShadowInstanceImpl().getPluginCompatibleBuildAsNumber() : buildNumber;
        String string2 = number.asString();
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public Calendar getBuildDate() {
        return GregorianCalendar.from(this.getBuildTime());
    }

    @Override
    @NotNull
    public ZonedDateTime getBuildTime() {
        if (this.buildTime == null) {
            this.buildTime = ZonedDateTime.now();
        }
        ZonedDateTime zonedDateTime = this.buildTime;
        if (zonedDateTime == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        return zonedDateTime;
    }

    @Override
    @NotNull
    public Calendar getMajorReleaseBuildDate() {
        Calendar calendar = this.majorReleaseBuildDate == null ? this.getBuildDate() : GregorianCalendar.from(this.majorReleaseBuildDate);
        if (calendar == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        return calendar;
    }

    @Override
    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(6);
        }
        return buildNumber;
    }

    @Override
    @NotNull
    public String getApiVersion() {
        String string2 = this.getApiVersionAsNumber().asString();
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber build2 = this.getBuild();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getApiVersionAsNumber: build=" + build2.asString());
        }
        if (this.myApiVersion != null) {
            BuildNumber api;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getApiVersionAsNumber: myApiVersion=" + build2.asString());
            }
            if ((api = BuildNumber.fromStringWithProductCode(this.myApiVersion, build2.getProductCode())) != null) {
                BuildNumber buildNumber = api;
                if (buildNumber == null) {
                    ApplicationInfoImpl.$$$reportNull$$$0(8);
                }
                return buildNumber;
            }
        }
        BuildNumber buildNumber = build2;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return buildNumber;
    }

    @Override
    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    @Override
    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    @Override
    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    @Override
    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    @Override
    @NotNull
    public String getFullVersion() {
        String result2 = this.myFullVersionFormat != null ? MessageFormat.format(this.myFullVersionFormat, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion) : ApplicationInfoImpl.requireNonNullElse(this.myMajorVersion) + '.' + ApplicationInfoImpl.requireNonNullElse(this.myMinorVersion);
        if (this.myVersionSuffix != null && !this.myVersionSuffix.isEmpty()) {
            result2 = result2 + " " + this.myVersionSuffix;
        }
        String string2 = result2;
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getStrictVersion() {
        String string2 = this.myMajorVersion + "." + this.myMinorVersion + "." + ApplicationInfoImpl.requireNonNullElse(this.myMicroVersion) + "." + ApplicationInfoImpl.requireNonNullElse(this.myPatchVersion);
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && this.myCodeName != null && !this.myCodeName.isEmpty()) {
            fullName = fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    @Override
    public String getShortCompanyName() {
        return this.myShortCompanyName;
    }

    @Override
    public String getCompanyName() {
        return this.myCompanyName;
    }

    @Override
    public String getCompanyURL() {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.myCompanyUrl);
    }

    @Override
    public String getSplashImageUrl() {
        return this.isEAP() && this.myEapSplashImageUrl != null ? this.myEapSplashImageUrl : this.mySplashImageUrl;
    }

    @Override
    @NotNull
    public String getApplicationSvgIconUrl() {
        String string2 = this.getApplicationSvgIconUrl(this.isEAP());
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public String getApplicationSvgIconUrl(boolean isEap) {
        String string2 = isEap && this.mySvgEapIconUrl != null ? this.mySvgEapIconUrl : this.mySvgIconUrl;
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getSmallApplicationSvgIconUrl() {
        String string2 = this.getSmallApplicationSvgIconUrl(this.isEAP());
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public String getSmallApplicationSvgIconUrl(boolean isEap) {
        String string2 = isEap && this.mySmallSvgEapIconUrl != null ? this.mySmallSvgEapIconUrl : this.mySmallSvgIconUrl;
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @Override
    @Nullable
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public boolean isMajorEAP() {
        return this.myEAP && (this.myMinorVersion == null || this.myMinorVersion.indexOf(46) < 0);
    }

    @Override
    public boolean isPreview() {
        return !this.myEAP && this.myVersionSuffix != null && ("Preview".equalsIgnoreCase(this.myVersionSuffix) || this.myVersionSuffix.startsWith("RC"));
    }

    @Override
    public String getProductUrl() {
        return this.myProductUrl;
    }

    @Override
    @Nullable
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getYoutrackUrl() {
        return this.myYoutrackUrl;
    }

    @Override
    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }

    @Override
    @NotNull
    public String getPluginManagerUrl() {
        String string2 = this.myPluginManagerUrl;
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @Override
    public boolean usesJetBrainsPluginRepository() {
        return DEFAULT_PLUGINS_HOST.equalsIgnoreCase(this.myPluginManagerUrl);
    }

    @Override
    @NotNull
    public String getPluginsListUrl() {
        String string2 = this.myPluginsListUrl;
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @Override
    public String getChannelListUrl() {
        return this.channelListUrl;
    }

    @Override
    @NotNull
    public String getPluginDownloadUrl() {
        String string2 = this.pluginDownloadUrl;
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    @Override
    public boolean hasHelp() {
        return this.myHasHelp;
    }

    @Override
    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public boolean isShowWhatsNewOnUpdate() {
        return this.myShowWhatsNewOnUpdate;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public String getFullApplicationName() {
        return this.getVersionName() + " " + this.getFullVersion();
    }

    @Override
    public String getCopyrightStart() {
        return this.myCopyrightStart;
    }

    @Override
    public String getJetBrainsTvUrl() {
        return this.myJetBrainsTvUrl;
    }

    @Override
    public String getSubscriptionFormId() {
        return this.mySubscriptionFormId;
    }

    @Override
    public boolean areSubscriptionTipsAvailable() {
        return this.mySubscriptionTipsAvailable;
    }

    @NotNull
    @NlsSafe
    public String getPluginCompatibleBuild() {
        String string2 = this.getPluginCompatibleBuildAsNumber().asString();
        if (string2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @NotNull
    public BuildNumber getPluginCompatibleBuildAsNumber() {
        BuildNumber version;
        BuildNumber compatibleBuild = BuildNumber.fromPluginCompatibleBuild();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getPluginsCompatibleBuildAsNumber: compatibleBuild=" + (compatibleBuild == null ? "null" : compatibleBuild.asString()));
        }
        BuildNumber buildNumber = version = compatibleBuild == null ? this.getApiVersionAsNumber() : compatibleBuild;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getPluginsCompatibleBuildAsNumber: version=" + version.asString());
        }
        BuildNumber buildNumber2 = BuildNumber.fromStringWithProductCode(version.asString(), this.getBuild().getProductCode());
        BuildNumber buildNumber3 = Objects.requireNonNull(buildNumber2);
        if (buildNumber3 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(20);
        }
        return buildNumber3;
    }

    @Nullable
    private static String getAttributeValue(XmlElement element2, String name2) {
        String value2 = element2.getAttributeValue(name2);
        return value2 == null || value2.isEmpty() ? null : value2;
    }

    private void readBuildInfo(XmlElement element2) {
        String majorReleaseDateString;
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element2, "number");
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element2, "apiVersion");
        String dateString = element2.getAttributeValue("date");
        if (dateString != null && !dateString.equals("__BUILD_DATE__")) {
            this.buildTime = ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element2.getAttributeValue("majorReleaseDate")) != null) {
            this.majorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable XmlElement element2) {
        String pluginHost;
        String pluginManagerUrl = DEFAULT_PLUGINS_HOST;
        String pluginListUrl = null;
        this.channelListUrl = null;
        this.pluginDownloadUrl = null;
        if (element2 != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element2.getAttributeValue("url");
            if (url != null) {
                String string2 = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element2.getAttributeValue("list-url")) != null) {
                pluginListUrl = listUrl;
            }
            if ((channelListUrl = element2.getAttributeValue("channel-list-url")) != null) {
                this.channelListUrl = channelListUrl;
            }
            if ((downloadUrl = element2.getAttributeValue("download-url")) != null) {
                this.pluginDownloadUrl = downloadUrl;
            }
            if ((builtinPluginsUrl = element2.getAttributeValue("builtin-url")) != null && !builtinPluginsUrl.isEmpty()) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginHost = System.getProperty(IDEA_PLUGINS_HOST_PROPERTY)) != null) {
            pluginManagerUrl = pluginHost.endsWith("/") ? pluginHost.substring(0, pluginHost.length() - 1) : pluginHost;
            this.pluginDownloadUrl = null;
            this.channelListUrl = null;
            pluginListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string3 = this.myPluginsListUrl = pluginListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginListUrl;
        if (this.channelListUrl == null) {
            this.channelListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.pluginDownloadUrl == null) {
            this.pluginDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    private static String shortenCompanyName(String name2) {
        if (name2.endsWith(" s.r.o.")) {
            name2 = name2.substring(0, name2.length() - " s.r.o.".length());
        }
        if (name2.endsWith(" Inc.")) {
            name2 = name2.substring(0, name2.length() - " Inc.".length());
        }
        return name2;
    }

    @Nullable
    private static ZonedDateTime parseDate(@NotNull String dateString) {
        if (dateString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(21);
        }
        try {
            int minute;
            int hour;
            int year = Integer.parseInt(dateString.substring(0, 4));
            int month = Integer.parseInt(dateString.substring(4, 6));
            int dayOfMonth = Integer.parseInt(dateString.substring(6, 8));
            if (dateString.length() > 8) {
                hour = Integer.parseInt(dateString.substring(8, 10));
                minute = Integer.parseInt(dateString.substring(10, 12));
            } else {
                hour = 0;
                minute = 0;
            }
            return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, 0, 0, ZoneOffset.UTC);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static String requireNonNullElse(String s) {
        return s != null ? s : "0";
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(22);
        }
        return "com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId(pluginId));
    }

    @Override
    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(23);
        }
        return PluginManagerCore.CORE_ID.equals(pluginId) || Collections.binarySearch(this.essentialPluginIds, pluginId) >= 0;
    }

    @Override
    @NotNull
    public List<PluginId> getEssentialPluginIds() {
        List<PluginId> list = this.essentialPluginIds;
        if (list == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDefaultLightLaf() {
        String override = System.getProperty(IDEA_APPLICATION_INFO_DEFAULT_LIGHT_LAF);
        return override != null ? override : this.myDefaultLightLaf;
    }

    @Override
    @Nullable
    public String getDefaultClassicLightLaf() {
        String override = System.getProperty(IDEA_APPLICATION_INFO_DEFAULT_CLASSIC_LIGHT_LAF);
        return override != null ? override : this.myDefaultClassicLightLaf;
    }

    @Override
    @Nullable
    public String getDefaultDarkLaf() {
        String override = System.getProperty(IDEA_APPLICATION_INFO_DEFAULT_DARK_LAF);
        return override != null ? override : this.myDefaultDarkLaf;
    }

    @Override
    @Nullable
    public String getDefaultClassicDarkLaf() {
        String override = System.getProperty(IDEA_APPLICATION_INFO_DEFAULT_CLASSIC_DARK_LAF);
        return override != null ? override : this.myDefaultClassicDarkLaf;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isInStressTest() {
        return ApplicationManagerEx.isInStressTest();
    }

    static {
        LOG = Logger.getInstance(ApplicationInfoImpl.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateString";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstanceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "orFromPluginCompatibleBuild";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorReleaseBuildDate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationSvgIconUrl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallApplicationSvgIconUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginManagerUrl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsListUrl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDownloadUrl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginCompatibleBuild";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginCompatibleBuildAsNumber";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(XmlElement element2) {
            this.myCheckingUrl = element2.getAttributeValue("check");
            this.myPatchesUrl = element2.getAttributeValue("patches");
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }
    }
}

