/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProvider;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J)\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "generatedDeclarationProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirSwitchableExtensionDeclarationsSymbolProvider;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "generateAndUpdateCompanion", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "generateCompanion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCompanionGenerationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompanionGenerationProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 FirScope.kt\norg/jetbrains/kotlin/fir/scopes/FirScopeKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n155#2,4:97\n54#3:101\n101#4,2:102\n1#5:104\n*S KotlinDebug\n*F\n+ 1 FirCompanionGenerationProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer\n*L\n48#1:97,4\n67#1:101\n69#1:102,2\n*E\n"})
public final class FirCompanionGenerationTransformer
extends FirTransformer {
    @NotNull
    private final FirSession session;
    @Nullable
    private final FirSwitchableExtensionDeclarationsSymbolProvider generatedDeclarationProvider;

    public FirCompanionGenerationTransformer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        this.generatedDeclarationProvider = FirSwitchableExtensionDeclarationsSymbolProviderKt.getGeneratedDeclarationsSymbolProvider(this.session);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(element2, "element");
        return element2;
    }

    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Void data2) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter(file2, "file");
        if (this.generatedDeclarationProvider == null) {
            return file2;
        }
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            firFile = file2.transformDeclarations(this, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw null;
        }
        return firFile;
    }

    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        this.generateAndUpdateCompanion(regularClass);
        return regularClass.transformDeclarations(this, data2);
    }

    public final void generateAndUpdateCompanion(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        FirRegularClassSymbol companionSymbol = this.generateCompanion(regularClass);
        if (companionSymbol != null) {
            regularClass.replaceCompanionObjectSymbol(companionSymbol);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirRegularClassSymbol generateCompanion(FirRegularClass regularClass) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol generatedCompanion2;
        Object object;
        Object object2;
        if (this.generatedDeclarationProvider == null) {
            return null;
        }
        FirClassLikeDeclaration $this$isLocal$iv = regularClass;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.session, regularClass);
            if (firNestedClassifierScope != null) {
                void name$iv;
                void $this$processClassifiersByName$iv;
                object2 = firNestedClassifierScope;
                Name name2 = SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT;
                Function1 processor$iv = new Function1<FirClassifierSymbol<?>, Unit>(result2){
                    final /* synthetic */ Ref.ObjectRef<FirClassLikeSymbol<?>> $result;
                    {
                        this.$result = $result;
                        super(1);
                    }

                    public final void invoke(@NotNull FirClassifierSymbol<?> it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (it instanceof FirClassLikeSymbol && it.getOrigin().getGenerated()) {
                            this.$result.element = it;
                        }
                    }
                };
                boolean $i$f$processClassifiersByName = false;
                $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution((Name)name$iv, new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
                    final /* synthetic */ Function1 $processor;
                    {
                        this.$processor = $processor;
                        super(2);
                    }

                    public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor coneSubstitutor) {
                        Intrinsics.checkNotNullParameter(symbol2, "symbol");
                        Intrinsics.checkNotNullParameter(coneSubstitutor, "<anonymous parameter 1>");
                        this.$processor.invoke(symbol2);
                    }
                });
            }
            object = (FirClassLikeSymbol)result2.element;
        } else {
            ClassId classId = FirDeclarationUtilKt.getClassId(regularClass).createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue(classId, "createNestedClassId(...)");
            ClassId companionClassId = classId;
            FirClassLikeSymbol<?> firClassLikeSymbol = this.generatedDeclarationProvider.getClassLikeSymbolByClassId(companionClassId);
            if (firClassLikeSymbol != null) {
                Object it = object2 = firClassLikeSymbol;
                boolean bl = false;
                object = ((FirBasedSymbol)it).getOrigin().getGenerated() ? object2 : null;
            } else {
                object = null;
            }
        }
        FirClassLikeSymbol firClassLikeSymbol = generatedCompanion2 = object;
        if (firClassLikeSymbol == null) {
            firRegularClassSymbol = null;
        } else if (firClassLikeSymbol instanceof FirRegularClassSymbol) {
            if (regularClass.getCompanionObjectSymbol() != null) {
                throw new IllegalStateException(("Plugin generated companion object for class " + regularClass + ", but it is already present in class").toString());
            }
            firRegularClassSymbol = (FirRegularClassSymbol)generatedCompanion2;
        } else {
            throw new IllegalStateException("Plugin generated non regular class as companion object".toString());
        }
        return firRegularClassSymbol;
    }
}

