/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001aX\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00012\"\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000bH\u0000\u001a\u0016\u0010\u000f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012\".\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\b\u0010\u0000\u001a\u0004\u0018\u00010\u00018\u00c0\u0002@\u00c0\u0002X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resultType", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "setResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "remapArgumentsWithVararg", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "varargParameter", "varargArrayType", "argumentMapping", "expectedConeType", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "writeResultType", "", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolve"})
@SourceDebugExtension(value={"SMAP\nBodyResolveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n+ 2 FirVarargArgumentsExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirVarargArgumentsExpressionBuilderKt\n*L\n1#1,125:1\n26#1:130\n28#1,2:131\n51#2,4:126\n*S KotlinDebug\n*F\n+ 1 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n*L\n93#1:130\n90#1:131,2\n44#1:126,4\n*E\n"})
public final class BodyResolveUtilsKt {
    @Nullable
    public static final ConeKotlinType getResultType(@NotNull FirExpression $this$resultType) {
        Intrinsics.checkNotNullParameter($this$resultType, "<this>");
        boolean $i$f$getResultType = false;
        return $this$resultType.getConeTypeOrNull();
    }

    public static final void setResultType(@NotNull FirExpression $this$resultType, @Nullable ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter($this$resultType, "<this>");
        boolean $i$f$setResultType = false;
        $this$resultType.replaceConeTypeOrNull(type2);
    }

    @NotNull
    public static final LinkedHashMap<FirExpression, FirValueParameter> remapArgumentsWithVararg(@NotNull FirValueParameter varargParameter, @NotNull ConeKotlinType varargArrayType, @NotNull LinkedHashMap<FirExpression, FirValueParameter> argumentMapping) {
        FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
        Intrinsics.checkNotNullParameter(varargParameter, "varargParameter");
        Intrinsics.checkNotNullParameter(varargArrayType, "varargArrayType");
        Intrinsics.checkNotNullParameter(argumentMapping, "argumentMapping");
        FirTypeRef varargParameterTypeRef = varargParameter.getReturnTypeRef();
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType$default(varargArrayType, false, 1, null);
        ConeKotlinType varargElementType2 = coneKotlinType != null ? ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType$default(coneKotlinType, null, 1, null) : null;
        Set<FirExpression> set = argumentMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        List argumentList2 = CollectionsKt.toList((Iterable)set);
        int indexAfterVarargs = 0;
        indexAfterVarargs = argumentList2.size();
        LinkedHashMap<FirExpression, FirValueParameter> newArgumentMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        boolean $i$f$buildVarargArgumentsExpression = false;
        FirVarargArgumentsExpressionBuilder $this$remapArgumentsWithVararg_u24lambda_u240 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
        boolean bl = false;
        $this$remapArgumentsWithVararg_u24lambda_u240.setVarargElementType(TypeUtilsKt.withReplacedConeType(varargParameterTypeRef, varargElementType2, KtFakeSourceElementKind.VarargArgument.INSTANCE));
        $this$remapArgumentsWithVararg_u24lambda_u240.setConeTypeOrNull(varargArrayType);
        int startOffset = Integer.MAX_VALUE;
        int endOffset = 0;
        KtSourceElement firstVarargElementSource = null;
        Iterator iterator2 = argumentList2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            FirExpression arg = (FirExpression)iterator2.next();
            Map map = argumentMapping;
            Intrinsics.checkNotNull(arg);
            FirValueParameter valueParameter2 = (FirValueParameter)MapsKt.getValue(map, arg);
            if (Intrinsics.areEqual(valueParameter2, varargParameter) || valueParameter2.isVararg() && !(arg instanceof FirNamedArgumentExpression)) {
                ((Collection)$this$remapArgumentsWithVararg_u24lambda_u240.getArguments()).add(arg);
                KtSourceElement ktSourceElement = arg.getSource();
                int n2 = ktSourceElement != null ? ktSourceElement.getStartOffset() : Integer.MAX_VALUE;
                startOffset = Math.min(startOffset, n2);
                KtSourceElement ktSourceElement2 = arg.getSource();
                n2 = ktSourceElement2 != null ? ktSourceElement2.getEndOffset() : 0;
                endOffset = Math.max(endOffset, n2);
                if (firstVarargElementSource != null) continue;
                firstVarargElementSource = arg.getSource();
                continue;
            }
            if ($this$remapArgumentsWithVararg_u24lambda_u240.getArguments().isEmpty()) {
                ((Map)newArgumentMapping).put(arg, valueParameter2);
                continue;
            }
            indexAfterVarargs = i;
            break;
        }
        KtSourceElement ktSourceElement = firstVarargElementSource;
        $this$remapArgumentsWithVararg_u24lambda_u240.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.VarargArgument.INSTANCE, startOffset, endOffset) : null);
        FirVarargArgumentsExpression varargArgument = firVarargArgumentsExpressionBuilder.build();
        ((Map)newArgumentMapping).put(varargArgument, varargParameter);
        int n3 = argumentList2.size();
        for (int i = indexAfterVarargs; i < n3; ++i) {
            Object t = argumentList2.get(i);
            Intrinsics.checkNotNullExpressionValue(t, "get(...)");
            FirExpression arg = (FirExpression)t;
            ((Map)newArgumentMapping).put(arg, MapsKt.getValue((Map)argumentMapping, arg));
        }
        return newArgumentMapping;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeResultType(@NotNull FirBlock $this$writeResultType, @NotNull FirSession session2) {
        void type$iv;
        void $this$resultType$iv;
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$writeResultType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirStatement statement2 = CollectionsKt.lastOrNull($this$writeResultType.getStatements());
        FirExpression resultExpression2 = statement2 instanceof FirExpression ? (FirExpression)statement2 : null;
        statement2 = $this$writeResultType;
        if (resultExpression2 == null) {
            coneKotlinType = session2.getBuiltinTypes().getUnitType().getType();
        } else {
            FirExpression $this$resultType$iv2 = resultExpression2;
            boolean $i$f$getResultType = false;
            coneKotlinType = $this$resultType$iv2.getConeTypeOrNull();
            if (coneKotlinType == null) {
                coneKotlinType = new ConeErrorType(new ConeSimpleDiagnostic("No type for block", DiagnosticKind.InferenceError), false, null, null, 14, null);
            }
        }
        ConeKotlinType coneKotlinType2 = coneKotlinType;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull((ConeKotlinType)type$iv);
    }

    @NotNull
    public static final ConeKotlinType expectedConeType(@NotNull ConstantValueKind<?> $this$expectedConeType, @NotNull FirSession session2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$expectedConeType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConstantValueKind<?> constantValueKind = $this$expectedConeType;
        if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Null.INSTANCE)) {
            coneKotlinType = session2.getBuiltinTypes().getNullableNothingType().getType();
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Boolean.INSTANCE)) {
            coneKotlinType = session2.getBuiltinTypes().getBooleanType().getType();
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Char.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getChar(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Byte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Short.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Int.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Long.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getLong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.String.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getString(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Float.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getFloat(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Double.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getDouble(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedByte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getUByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedShort.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getUShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedInt.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedLong.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getULong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.IntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session2, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else {
            if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Error.INSTANCE)) {
                throw new IllegalStateException("Unexpected error ConstantValueKind".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    private static final ConeKotlinType expectedConeType$constructLiteralType(FirSession $session, ClassId classId, boolean isNullable) {
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($session).getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null) {
            return new ConeErrorType(new ConeSimpleDiagnostic("Missing stdlib class: " + classId, DiagnosticKind.MissingStdlibClass), false, null, null, 14, null);
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        return TypeConstructionUtilsKt.constructClassType$default(symbol2.toLookupTag(), ConeTypeProjection.Companion.getEMPTY_ARRAY(), isNullable, null, 4, null);
    }

    static /* synthetic */ ConeKotlinType expectedConeType$constructLiteralType$default(FirSession firSession, ClassId classId, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return BodyResolveUtilsKt.expectedConeType$constructLiteralType(firSession, classId, bl);
    }
}

