/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirContextReceiverBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferReceiverParameterType;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferValueParameterType;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.FirRegularTowerDataContexts;
import org.jetbrains.kotlin.fir.resolve.FirTowerDataMode;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FirAnonymousFunctionReturnExpressionInfo;
import org.jetbrains.kotlin.fir.resolve.inference.CompletionModeCalculatorKt;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.fir.resolve.inference.FirBuilderInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.FirCallCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.FirDelegatedPropertyInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.FirInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.LambdaAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ReturnArgumentsAnalysisResult;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirCallCompletionResultsWriterTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.InvocationKindTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformerDispatcher;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J)\u0010\u0019\u001a\u0002H\u001a\"\f\b\u0000\u0010\u001a*\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001a2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u0014JE\u0010,\u001a\u00020\u0012\"\f\b\u0000\u0010\u001a*\u00020\u001b*\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001d\u001a\u0002H\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010/\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u00100J\u0016\u00101\u001a\u00020\u0016*\u00020\u00162\b\u00102\u001a\u0004\u0018\u000103H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;", "", "transformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "components", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;)V", "completer", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "getCompleter", "()Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "inferenceSession", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "getInferenceSession", "()Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "addConstraintFromExpectedType", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "initialType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolutionMode", "Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;", "completeCall", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "call", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;)Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "createCompletionResultsWriter", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "mode", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer$Mode;", "createPostponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "prepareLambdaAtomForFactoryPattern", "atom", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "runCompletionForCall", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "analyzer", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;)V", "approximateLambdaInputType", "valueParameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "LambdaAnalyzerImpl", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCallCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter\n+ 2 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n28#2,2:417\n25#3,4:419\n1#4:423\n*S KotlinDebug\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter\n*L\n68#1:417,2\n135#1:419,4\n*E\n"})
public final class FirCallCompleter {
    @NotNull
    private final FirAbstractBodyResolveTransformerDispatcher transformer;
    @NotNull
    private final FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components;
    @NotNull
    private final FirSession session;
    @NotNull
    private final ConstraintSystemCompleter completer;

    public FirCallCompleter(@NotNull FirAbstractBodyResolveTransformerDispatcher transformer2, @NotNull FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        Intrinsics.checkNotNullParameter(components2, "components");
        this.transformer = transformer2;
        this.components = components2;
        this.session = this.components.getSession();
        this.completer = new ConstraintSystemCompleter(this.components, this.transformer.getContext());
    }

    private final FirInferenceSession getInferenceSession() {
        return this.transformer.getContext().getInferenceSession();
    }

    @NotNull
    public final ConstraintSystemCompleter getCompleter() {
        return this.completer;
    }

    @NotNull
    public final <T extends FirResolvable & FirStatement> T completeCall(@NotNull T call2, @NotNull ResolutionMode resolutionMode) {
        Object object;
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(resolutionMode, "resolutionMode");
        FirResolvedTypeRef typeRef = ResolveUtilsKt.typeFromCallee(this.components, call2);
        FirReference firReference = call2.getCalleeReference();
        FirNamedReferenceWithCandidate firNamedReferenceWithCandidate = firReference instanceof FirNamedReferenceWithCandidate ? (FirNamedReferenceWithCandidate)firReference : null;
        if (firNamedReferenceWithCandidate == null) {
            return call2;
        }
        FirNamedReferenceWithCandidate reference2 = firNamedReferenceWithCandidate;
        Candidate candidate2 = reference2.getCandidate();
        ConeKotlinType initialType = ResolveUtilsKt.initialTypeOfCandidate(typeRef, candidate2);
        if (call2 instanceof FirExpression) {
            FirExpression $this$resultType$iv = (FirExpression)call2;
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceConeTypeOrNull(initialType);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, initialType, call2.getSource(), this.components.getContext().getFile().getSource());
            }
        }
        this.addConstraintFromExpectedType(candidate2, initialType, resolutionMode);
        ConstraintSystemCompletionMode completionMode = CompletionModeCalculatorKt.computeCompletionMode(candidate2, InferenceComponentsKt.getInferenceComponents(this.session), resolutionMode, initialType);
        PostponedArgumentsAnalyzer analyzer2 = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        if (call2 instanceof FirFunctionCall) {
            InvocationKindTransformerKt.replaceLambdaArgumentInvocationKinds((FirFunctionCall)call2, this.session);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[completionMode.ordinal()]) {
            case 1: {
                if (this.getInferenceSession().shouldRunCompletion(call2)) {
                    this.runCompletionForCall(candidate2, completionMode, call2, initialType, analyzer2);
                    TypeSubstitutorMarker typeSubstitutorMarker = InferenceUtilsKt.buildAbstractResultingSubstitutor$default(candidate2.getSystem().asReadOnlyStorage(), TypeComponentsKt.getTypeContext(this.session), false, 2, null);
                    Intrinsics.checkNotNull(typeSubstitutorMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor");
                    ConeSubstitutor finalSubstitutor = (ConeSubstitutor)typeSubstitutorMarker;
                    FirResolvable completedCall = (FirResolvable)FirTransformerUtilKt.transformSingle(call2, new FirCallCompletionResultsWriterTransformer(this.session, finalSubstitutor, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), this.components.getIntegerLiteralAndOperatorApproximationTransformer(), this.components.getSamResolver(), this.components.getContext(), null, 256, null), null);
                    this.getInferenceSession().addCompletedCall(completedCall, candidate2);
                    object = completedCall;
                    break;
                }
                this.getInferenceSession().addPartiallyResolvedCall(call2);
                object = call2;
                break;
            }
            case 2: {
                this.runCompletionForCall(candidate2, completionMode, call2, initialType, analyzer2);
                if (resolutionMode instanceof ResolutionMode.ContextDependent.Delegate) {
                    if (!(this.getInferenceSession() instanceof FirDelegatedPropertyInferenceSession)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.getInferenceSession().addPartiallyResolvedCall(call2);
                }
                object = call2;
                break;
            }
            case 3: {
                throw new IllegalStateException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final void addConstraintFromExpectedType(Candidate candidate2, ConeKotlinType initialType, ResolutionMode resolutionMode) {
        if (!(resolutionMode instanceof ResolutionMode.WithExpectedType)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = ((ResolutionMode.WithExpectedType)resolutionMode).getExpectedTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType expectedType = coneKotlinType;
        NewConstraintSystemImpl system2 = candidate2.getSystem();
        if (!((ResolutionMode.WithExpectedType)resolutionMode).getShouldBeStrictlyEnforced() || ((ResolutionMode.WithExpectedType)resolutionMode).getExpectedTypeMismatchIsReportedInChecker()) {
            ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(system2, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        } else if (((ResolutionMode.WithExpectedType)resolutionMode).getFromCast()) {
            if (FirCallCompleterKt.access$isFunctionForExpectTypeFromCastFeature(candidate2)) {
                system2.addSubtypeConstraint(initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
            }
        } else if (!CallableReferenceResolutionKt.isUnitOrFlexibleUnit(expectedType) || !((ResolutionMode.WithExpectedType)resolutionMode).getMayBeCoercionToUnitApplied()) {
            system2.addSubtypeConstraint(initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        } else {
            if (system2.getNotFixedTypeVariables().isEmpty()) {
                return;
            }
            if (ConeBuiltinTypeUtilsKt.isUnit(expectedType)) {
                ConstraintSystemBuilderKt.addEqualityConstraintIfCompatible(system2, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
            } else {
                ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(system2, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
            }
        }
    }

    public final <T extends FirResolvable & FirStatement> void runCompletionForCall(@NotNull Candidate candidate2, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull T call2, @NotNull ConeKotlinType initialType, @Nullable PostponedArgumentsAnalyzer analyzer2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter((Object)completionMode, "completionMode");
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(initialType, "initialType");
        PostponedArgumentsAnalyzer postponedArgumentsAnalyzer = analyzer2;
        if (postponedArgumentsAnalyzer == null) {
            postponedArgumentsAnalyzer = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        }
        PostponedArgumentsAnalyzer analyzer3 = postponedArgumentsAnalyzer;
        ConstraintSystemCompleter.complete$default(this.completer, candidate2.getSystem().asConstraintSystemCompleterContext(), completionMode, CollectionsKt.listOf(call2), initialType, this.transformer.getResolutionContext(), false, new Function1<PostponedResolvedAtom, Unit>(analyzer3, candidate2, completionMode){
            final /* synthetic */ PostponedArgumentsAnalyzer $analyzer;
            final /* synthetic */ Candidate $candidate;
            final /* synthetic */ ConstraintSystemCompletionMode $completionMode;
            {
                this.$analyzer = $analyzer;
                this.$candidate = $candidate;
                this.$completionMode = $completionMode;
                super(1);
            }

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$analyzer.analyze(this.$candidate.getSystem(), it, this.$candidate, this.$completionMode);
            }
        }, 32, null);
    }

    public static /* synthetic */ void runCompletionForCall$default(FirCallCompleter firCallCompleter, Candidate candidate2, ConstraintSystemCompletionMode constraintSystemCompletionMode, FirResolvable firResolvable, ConeKotlinType coneKotlinType, PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, int n, Object object) {
        if ((n & 0x10) != 0) {
            postponedArgumentsAnalyzer = null;
        }
        firCallCompleter.runCompletionForCall(candidate2, constraintSystemCompletionMode, firResolvable, coneKotlinType, postponedArgumentsAnalyzer);
    }

    public final void prepareLambdaAtomForFactoryPattern(@NotNull ResolvedLambdaAtom atom, @NotNull Candidate candidate2) {
        Intrinsics.checkNotNullParameter(atom, "atom");
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        ConeTypeVariableForLambdaReturnType returnVariable = new ConeTypeVariableForLambdaReturnType(atom.getAtom(), "_R");
        NewConstraintSystemImpl csBuilder = candidate2.getSystem().getBuilder();
        csBuilder.registerVariable(returnVariable);
        TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = csBuilder;
        ConeKotlinType coneKotlinType = atom.getExpectedType();
        Intrinsics.checkNotNull(coneKotlinType);
        KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(typeSubstitutorMarker, typeSystemInferenceExtensionContext, coneKotlinType);
        Intrinsics.checkNotNull(kotlinTypeMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
        ConeClassLikeType functionalType = (ConeClassLikeType)kotlinTypeMarker;
        int size = functionalType.getTypeArguments().length;
        ConeTypeProjection[] coneTypeProjectionArray = new ConeTypeProjection[size];
        ConeClassLikeLookupTag coneClassLikeLookupTag = functionalType.getLookupTag();
        for (int i = 0; i < size; ++i) {
            int n = i;
            coneTypeProjectionArray[n] = n != size - 1 ? functionalType.getTypeArguments()[n] : (ConeTypeProjection)returnVariable.getDefaultType();
        }
        ConeAttributes coneAttributes = functionalType.getAttributes();
        boolean bl = ConeTypeUtilsKt.isNullable(functionalType);
        ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
        ConeClassLikeTypeImpl expectedType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneTypeProjectionArray2, bl, coneAttributes);
        csBuilder.addSubtypeConstraint(expectedType, functionalType, new ConeArgumentConstraintPosition(atom.getAtom()));
        atom.replaceExpectedType(expectedType, returnVariable.getDefaultType());
        atom.replaceTypeVariableForLambdaReturnType(returnVariable);
    }

    @NotNull
    public final FirCallCompletionResultsWriterTransformer createCompletionResultsWriter(@NotNull ConeSubstitutor substitutor2, @NotNull FirCallCompletionResultsWriterTransformer.Mode mode) {
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        return new FirCallCompletionResultsWriterTransformer(this.session, substitutor2, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), this.components.getIntegerLiteralAndOperatorApproximationTransformer(), this.components.getSamResolver(), this.components.getContext(), mode);
    }

    public static /* synthetic */ FirCallCompletionResultsWriterTransformer createCompletionResultsWriter$default(FirCallCompleter firCallCompleter, ConeSubstitutor coneSubstitutor, FirCallCompletionResultsWriterTransformer.Mode mode, int n, Object object) {
        if ((n & 2) != 0) {
            mode = FirCallCompletionResultsWriterTransformer.Mode.Normal;
        }
        return firCallCompleter.createCompletionResultsWriter(coneSubstitutor, mode);
    }

    @NotNull
    public final PostponedArgumentsAnalyzer createPostponedArgumentsAnalyzer(@NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        LambdaAnalyzerImpl lambdaAnalyzer = new LambdaAnalyzerImpl();
        return new PostponedArgumentsAnalyzer(context2, lambdaAnalyzer, InferenceComponentsKt.getInferenceComponents(this.session), this.transformer.getComponents().getCallResolver());
    }

    private final ConeKotlinType approximateLambdaInputType(ConeKotlinType $this$approximateLambdaInputType, FirValueParameterSymbol valueParameter2) {
        if ($this$approximateLambdaInputType instanceof ConeTypeVariableType) {
            ConeDiagnostic coneDiagnostic;
            FirValueParameterSymbol firValueParameterSymbol = valueParameter2;
            if (firValueParameterSymbol != null) {
                FirValueParameterSymbol p0 = firValueParameterSymbol;
                boolean bl = false;
                coneDiagnostic = new ConeCannotInferValueParameterType(p0, null, 2, null);
            } else {
                coneDiagnostic = new ConeCannotInferReceiverParameterType(null, 1, null);
            }
            ConeDiagnostic diagnostic = coneDiagnostic;
            return new ConeErrorType(diagnostic, false, null, null, 14, null);
        }
        ConeKotlinType coneKotlinType = TypeComponentsKt.getTypeApproximator(this.session).approximateToSuperType($this$approximateLambdaInputType, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
        if (coneKotlinType == null) {
            coneKotlinType = $this$approximateLambdaInputType;
        }
        return coneKotlinType;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl;", "Lorg/jetbrains/kotlin/fir/resolve/inference/LambdaAnalyzer;", "(Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;)V", "analyzeAndGetLambdaReturnArguments", "Lorg/jetbrains/kotlin/fir/resolve/inference/ReturnArgumentsAnalysisResult;", "lambdaAtom", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "receiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "contextReceivers", "", "parameters", "expectedReturnType", "stubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirCallCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirContextReceiverBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirContextReceiverBuilderKt\n+ 6 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 7 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n+ 8 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 9 BodyResolveContext.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveContext\n*L\n1#1,416:1\n1#2:417\n100#3,4:418\n1549#4:422\n1620#4,2:423\n1622#4:433\n1864#4,2:434\n1866#4:440\n1549#4:480\n1620#4,3:481\n44#5,4:425\n49#6,4:429\n55#7,4:436\n226#8:441\n315#9,11:442\n304#9,7:453\n326#9:460\n166#9,3:461\n327#9:464\n96#9,4:465\n304#9,7:469\n101#9,2:476\n170#9,2:478\n*S KotlinDebug\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl\n*L\n264#1:418,4\n298#1:422\n298#1:423,2\n298#1:433\n317#1:434,2\n317#1:440\n366#1:480\n366#1:481,3\n299#1:425,4\n300#1:429,4\n322#1:436,4\n346#1:441\n355#1:442,11\n357#1:453,7\n355#1:460\n355#1:461,3\n355#1:464\n355#1:465,4\n357#1:469,7\n355#1:476,2\n355#1:478,2\n*E\n"})
    private final class LambdaAnalyzerImpl
    implements LambdaAnalyzer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ReturnArgumentsAnalysisResult analyzeAndGetLambdaReturnArguments(@NotNull ResolvedLambdaAtom lambdaAtom, @Nullable ConeKotlinType receiverType2, @NotNull List<? extends ConeKotlinType> contextReceivers2, @NotNull List<? extends ConeKotlinType> parameters2, @Nullable ConeKotlinType expectedReturnType, @NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> stubsForPostponedVariables, @NotNull Candidate candidate2) {
            void $this$mapTo$iv$iv;
            FirInferenceSession oldSession$iv;
            void symbol$iv;
            void this_$iv;
            FirBuilderInferenceSession firBuilderInferenceSession;
            void condition$iv232;
            FirTypeRef firTypeRef;
            void $this$forEachIndexed$iv;
            List<ConeKotlinType> list2;
            FirAnnotationContainerBuilder $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245_u24lambda_u244;
            Object object;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder;
            Object object2;
            int $i$f$buildContextReceiver;
            Iterable<FirContextReceiver> destination$iv$iv;
            Object object3;
            FirResolvedTypeRef firResolvedTypeRef;
            FirValueParameter firValueParameter;
            Object itType;
            FirValueParameter matchedParameter;
            FirPureAbstractElement firPureAbstractElement;
            FirValueParameter firValueParameter2;
            Object currentArgument;
            boolean needItParam;
            FirAnonymousFunction lambdaArgument;
            block46: {
                Intrinsics.checkNotNullParameter(lambdaAtom, "lambdaAtom");
                Intrinsics.checkNotNullParameter(contextReceivers2, "contextReceivers");
                Intrinsics.checkNotNullParameter(parameters2, "parameters");
                Intrinsics.checkNotNullParameter(stubsForPostponedVariables, "stubsForPostponedVariables");
                Intrinsics.checkNotNullParameter(candidate2, "candidate");
                lambdaArgument = lambdaAtom.getAtom();
                needItParam = lambdaArgument.getValueParameters().isEmpty() && parameters2.size() == 1;
                LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = candidate2.getArgumentMapping();
                if (linkedHashMap != null) {
                    for (Map.Entry entry : ((Map)linkedHashMap).entrySet()) {
                        FirAnonymousFunction currentLambdaArgument;
                        boolean bl2 = false;
                        currentArgument = (FirExpression)entry.getKey();
                        FirValueParameter currentValueParameter = (FirValueParameter)entry.getValue();
                        FirLambdaArgumentExpression firLambdaArgumentExpression = currentArgument instanceof FirLambdaArgumentExpression ? (FirLambdaArgumentExpression)currentArgument : null;
                        FirExpression firExpression2 = firLambdaArgumentExpression != null ? firLambdaArgumentExpression.getExpression() : null;
                        FirAnonymousFunctionExpression firAnonymousFunctionExpression = firExpression2 instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression2 : null;
                        FirAnonymousFunction firAnonymousFunction = currentLambdaArgument = firAnonymousFunctionExpression != null ? firAnonymousFunctionExpression.getAnonymousFunction() : null;
                        FirValueParameter object5 = currentLambdaArgument == lambdaArgument ? currentValueParameter : null;
                        if (object5 == null) continue;
                        firValueParameter2 = object5;
                        break block46;
                    }
                    firValueParameter2 = null;
                } else {
                    firValueParameter2 = null;
                }
            }
            ClassMembersKt.setMatchingParameterFunctionType(lambdaArgument, (firPureAbstractElement = (matchedParameter = firValueParameter2)) != null && (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null);
            if (needItParam) {
                Name name2 = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME;
                itType = CollectionsKt.single(parameters2);
                FirCallCompleter firCallCompleter = FirCallCompleter.this;
                boolean $i$f$buildValueParameter = false;
                Object $this$analyzeAndGetLambdaReturnArguments_u24lambda_u241 = currentArgument = new FirValueParameterBuilder();
                boolean bl3 = false;
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setResolvePhase(FirResolvePhase.BODY_RESOLVE);
                KtSourceElement ktSourceElement = lambdaAtom.getAtom().getSource();
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ItLambdaParameter.INSTANCE, 0, 0, 6, null) : null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setContainingFunctionSymbol(lambdaArgument.getSymbol());
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setModuleData(FirModuleDataKt.getModuleData(firCallCompleter.session));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setName(name2);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setSymbol(new FirValueParameterSymbol(name2));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setReturnTypeRef(TypeUtilsKt.toFirResolvedTypeRef$default(firCallCompleter.approximateLambdaInputType((ConeKotlinType)itType, ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).getSymbol()), null, null, 3, null));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setDefaultValue(null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setCrossinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setNoinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setVararg(false);
                firValueParameter = ((FirValueParameterBuilder)currentArgument).build();
            } else {
                firValueParameter = null;
            }
            FirValueParameter itParam = firValueParameter;
            ConeKotlinType coneKotlinType = expectedReturnType;
            if (coneKotlinType != null) {
                ConeKotlinType coneKotlinType2 = coneKotlinType;
                boolean bl4 = false;
                firResolvedTypeRef = CopyUtilsKt.resolvedTypeFromPrototype$default(lambdaArgument.getReturnTypeRef(), coneKotlinType2, null, 2, null);
            } else {
                firResolvedTypeRef = null;
            }
            FirResolvedTypeRef expectedReturnTypeRef = firResolvedTypeRef;
            if (receiverType2 == null) {
                lambdaArgument.replaceReceiverParameter(null);
            } else if (!lambdaAtom.getCoerceFirstParameterToExtensionReceiver()) {
                FirReceiverParameter firReceiverParameter = lambdaArgument.getReceiverParameter();
                if (firReceiverParameter != null) {
                    FirReceiverParameter firReceiverParameter2 = firReceiverParameter;
                    FirCallCompleter bl4 = FirCallCompleter.this;
                    FirReceiverParameter $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243 = firReceiverParameter2;
                    boolean bl5 = false;
                    ConeKotlinType type2 = bl4.approximateLambdaInputType(receiverType2, null);
                    KtSourceElement ktSourceElement = $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243.getSource();
                    KtSourceElement source = ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE, 0, 0, 6, null) : null;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype($this$analyzeAndGetLambdaReturnArguments_u24lambda_u243.getTypeRef(), type2, source));
                }
            } else {
                lambdaArgument.replaceReceiverParameter(null);
            }
            if (!((Collection)contextReceivers2).isEmpty()) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                itType = contextReceivers2;
                object3 = lambdaArgument;
                boolean bl = false;
                void bl4 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo232 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    Iterator contextReceiverType;
                    ConeKotlinType coneKotlinType3 = (ConeKotlinType)item$iv$iv;
                    Iterable<FirContextReceiver> iterable = destination$iv$iv;
                    boolean bl6 = false;
                    $i$f$buildContextReceiver = 0;
                    object2 = new FirContextReceiverBuilder();
                    FirContextReceiverBuilder $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245 = object2;
                    boolean bl7 = false;
                    boolean $i$f$buildResolvedTypeRef = false;
                    firAnnotationContainerBuilder = new FirResolvedTypeRefBuilder();
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = firAnnotationContainerBuilder;
                    object = $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245;
                    boolean bl8 = false;
                    ((FirResolvedTypeRefBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245_u24lambda_u244).setType((ConeKotlinType)((Object)contextReceiverType));
                    ((FirContextReceiverBuilder)object).setTypeRef(((FirResolvedTypeRefBuilder)firAnnotationContainerBuilder).build());
                    iterable.add(((FirContextReceiverBuilder)object2).build());
                }
                ((FirAnonymousFunction)object3).replaceContextReceivers((List)destination$iv$iv);
            }
            FirLookupTrackerComponent lookupTracker = FirLookupTrackerComponentKt.getLookupTracker(FirCallCompleter.this.session);
            KtSourceElement ktSourceElement = FirCallCompleter.this.components.getFile().getSource();
            if (lambdaAtom.getCoerceFirstParameterToExtensionReceiver()) {
                if (receiverType2 == null) {
                    throw new IllegalStateException("Coercion to extension receiver while no receiver present".toString());
                }
                list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf(receiverType2), (Iterable)parameters2);
            } else {
                list2 = parameters2;
            }
            List<? extends ConeKotlinType> theParameters = list2;
            destination$iv$iv = lambdaArgument.getValueParameters();
            Object $i$f$mapTo232 = FirCallCompleter.this;
            boolean $i$f$forEachIndexed22 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                FirResolvedTypeRef firResolvedTypeRef2;
                void parameter2;
                if (($i$f$buildContextReceiver = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object2 = (FirValueParameter)item$iv;
                int index2 = $i$f$buildContextReceiver;
                boolean bl9 = false;
                if (index2 >= theParameters.size()) {
                    void $this$analyzeAndGetLambdaReturnArguments_u24lambda_u248_u24lambda_u247;
                    boolean $i$f$buildErrorTypeRef = false;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245_u24lambda_u244 = firAnnotationContainerBuilder = new FirErrorTypeRefBuilder();
                    object = parameter2;
                    boolean bl10 = false;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u248_u24lambda_u247.setDiagnostic(new ConeCannotInferValueParameterType(parameter2.getSymbol(), "Lambda or anonymous function has more parameters than expected"));
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u248_u24lambda_u247.setSource(parameter2.getSource());
                    ((FirValueParameter)object).replaceReturnTypeRef(((FirErrorTypeRefBuilder)firAnnotationContainerBuilder).build());
                    continue;
                }
                ConeKotlinType newReturnType = ((FirCallCompleter)$i$f$mapTo232).approximateLambdaInputType(theParameters.get(index2), parameter2.getSymbol());
                if (parameter2.getReturnTypeRef() instanceof FirImplicitTypeRef) {
                    KtSourceElement ktSourceElement2 = parameter2.getSource();
                    firResolvedTypeRef2 = TypeUtilsKt.toFirResolvedTypeRef$default(newReturnType, ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.ImplicitReturnTypeOfLambdaValueParameter.INSTANCE, 0, 0, 6, null) : null, null, 2, null);
                } else {
                    firResolvedTypeRef2 = CopyUtilsKt.resolvedTypeFromPrototype$default(parameter2.getReturnTypeRef(), newReturnType, null, 2, null);
                }
                FirResolvedTypeRef newReturnTypeRef = firResolvedTypeRef2;
                parameter2.replaceReturnTypeRef(newReturnTypeRef);
                FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
                if (firLookupTrackerComponent == null) continue;
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, newReturnTypeRef, parameter2.getSource(), ktSourceElement);
            }
            lambdaArgument.replaceValueParameters(CollectionsKt.plus((Collection)lambdaArgument.getValueParameters(), (Iterable)CollectionsKt.listOfNotNull(itParam)));
            FirAnonymousFunction firAnonymousFunction = lambdaArgument;
            FirResolvedTypeRef firResolvedTypeRef3 = expectedReturnTypeRef;
            if (firResolvedTypeRef3 != null) {
                Object $i$f$forEachIndexed22 = $i$f$mapTo232 = firResolvedTypeRef3;
                object3 = firAnonymousFunction;
                boolean bl11 = false;
                FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
                if (firLookupTrackerComponent != null) {
                    void it2;
                    FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, (FirTypeRef)it2, lambdaArgument.getSource(), ktSourceElement);
                }
                firAnonymousFunction = object3;
                firTypeRef = (FirTypeRef)$i$f$mapTo232;
            } else {
                firTypeRef = FirCallCompleter.this.components.getNoExpectedType();
            }
            firAnonymousFunction.replaceReturnTypeRef(firTypeRef);
            boolean $i$f$mapTo232 = !stubsForPostponedVariables.isEmpty();
            Object it2 = FirCallCompleter.this;
            boolean $i$f$runIf232 = false;
            if (condition$iv232 != false) {
                boolean bl12 = false;
                firBuilderInferenceSession = new FirBuilderInferenceSession(lambdaArgument, ((FirCallCompleter)it2).transformer.getResolutionContext(), stubsForPostponedVariables);
            } else {
                firBuilderInferenceSession = null;
            }
            FirBuilderInferenceSession builderInferenceSession = firBuilderInferenceSession;
            BodyResolveContext condition$iv232 = FirCallCompleter.this.transformer.getContext();
            it2 = lambdaArgument.getSymbol();
            FirCallCompleter $i$f$runIf232 = FirCallCompleter.this;
            boolean $i$f$withAnonymousFunctionTowerDataContext232 = false;
            void item$iv = this_$iv;
            FirTowerDataContext newContext$iv$iv = this_$iv.getSpecialTowerDataContexts().getAnonymousFunctionContext((FirAnonymousFunctionSymbol)symbol$iv);
            boolean $i$f$withTemporaryRegularContext = false;
            if (newContext$iv$iv == null) {
                boolean bl = false;
                if (builderInferenceSession != null) {
                    BodyResolveContext this_$iv2 = $i$f$runIf232.transformer.getContext();
                    boolean $i$f$withInferenceSession = false;
                    oldSession$iv = this_$iv2.getInferenceSession();
                    this_$iv2.setInferenceSession(builderInferenceSession);
                    try {
                        boolean bl13 = false;
                        object = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, $i$f$runIf232.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                    }
                    finally {
                        this_$iv2.setInferenceSession(oldSession$iv);
                    }
                } else {
                    FirAnonymousFunction cfr_ignored_0 = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, $i$f$runIf232.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                }
            } else {
                void this_$iv$iv;
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    FirAnonymousFunction firAnonymousFunction2;
                    void this_$iv$iv$iv2;
                    boolean bl14 = false;
                    void var35_88 = this_$iv$iv;
                    FirRegularTowerDataContexts newContexts$iv$iv$iv = this_$iv$iv.getRegularTowerDataContexts().replaceAndSetActiveRegularContext(newContext$iv$iv);
                    boolean $i$f$withTowerDataContexts = false;
                    FirRegularTowerDataContexts old$iv$iv$iv = this_$iv$iv$iv2.getRegularTowerDataContexts();
                    this_$iv$iv$iv2.setRegularTowerDataContexts(newContexts$iv$iv$iv);
                    try {
                        Object object4;
                        boolean bl = false;
                        if (builderInferenceSession != null) {
                            BodyResolveContext this_$iv3 = $i$f$runIf232.transformer.getContext();
                            boolean $i$f$withInferenceSession = false;
                            oldSession$iv = this_$iv3.getInferenceSession();
                            this_$iv3.setInferenceSession(builderInferenceSession);
                            try {
                                boolean bl15 = false;
                                object = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, $i$f$runIf232.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                            }
                            finally {
                                this_$iv3.setInferenceSession(oldSession$iv);
                            }
                            object4 = object;
                        } else {
                            object4 = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, $i$f$runIf232.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                        }
                        firAnonymousFunction2 = object4;
                    }
                    finally {
                        this_$iv$iv$iv2.setRegularTowerDataContexts(old$iv$iv$iv);
                    }
                    FirAnonymousFunction firAnonymousFunction3 = firAnonymousFunction2;
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            }
            FirCallCompleter.this.transformer.getContext().dropContextForAnonymousFunction(lambdaArgument);
            Iterable $this$map$iv = FirCallCompleter.this.components.getDataFlowAnalyzer().returnExpressionsOfAnonymousFunction(lambdaArgument);
            boolean $i$f$map = false;
            Iterable $i$f$withAnonymousFunctionTowerDataContext232 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                FirAnonymousFunctionReturnExpressionInfo this_$iv3 = (FirAnonymousFunctionReturnExpressionInfo)item$iv$iv;
                object3 = destination$iv$iv2;
                boolean bl16 = false;
                object3.add(it3.getExpression());
            }
            List returnArguments = (List)destination$iv$iv2;
            return new ReturnArgumentsAnalysisResult(returnArguments, builderInferenceSession);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintSystemCompletionMode.values().length];
            try {
                nArray[ConstraintSystemCompletionMode.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemCompletionMode.PARTIAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemCompletionMode.UNTIL_FIRST_LAMBDA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

