/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirDefaultParametersResolver;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "()V", "declaresDefaultValue", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "index", "", "resolve"})
public final class FirDefaultParametersResolver
implements FirSessionComponent {
    public final boolean declaresDefaultValue(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull FirFunction function2, @Nullable FirScope originScope, int index2) {
        FirTypeScope firTypeScope;
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(function2, "function");
        if (DeclarationUtilsKt.itOrExpectHasDefaultParameterValue(function2, index2)) {
            return true;
        }
        if (!(function2 instanceof FirSimpleFunction)) {
            return false;
        }
        FirNamedFunctionSymbol symbol2 = ((FirSimpleFunction)function2).getSymbol();
        FirScope firScope2 = originScope;
        if (firScope2 instanceof FirTypeScope) {
            firTypeScope = (FirTypeScope)originScope;
        } else if (firScope2 instanceof FirAbstractImportingScope) {
            FirRegularClass firRegularClass = ResolveUtilsKt.getContainingClass(function2, session2);
            if (firRegularClass == null) {
                return false;
            }
            FirRegularClass containingClass = firRegularClass;
            firTypeScope = FirKotlinScopeProviderKt.scopeForClass(containingClass, ConeSubstitutor.Empty.INSTANCE, session2, scopeSession, containingClass.getSymbol().toLookupTag(), null);
        } else {
            return false;
        }
        FirTypeScope typeScope = firTypeScope;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(typeScope, symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)new Function1<FirNamedFunctionSymbol, ProcessorAction>(index2, result2){
            final /* synthetic */ int $index;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$index = $index;
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol overridden) {
                Intrinsics.checkNotNullParameter(overridden, "overridden");
                if (DeclarationUtilsKt.itOrExpectHasDefaultParameterValue((FirFunction)overridden.getFir(), this.$index)) {
                    this.$result.element = true;
                    return ProcessorAction.STOP;
                }
                return ProcessorAction.NEXT;
            }
        });
        return result2.element;
    }
}

