/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\u001b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c*\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001eH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkParameterBounds", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkSupertypes", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,232:1\n28#2:233\n28#2:238\n28#2:239\n28#2:240\n49#2:241\n28#2:246\n28#2:247\n25#3,4:234\n1#4:242\n1864#5,3:243\n45#6:248\n45#6:249\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n46#1:233\n71#1:238\n91#1:239\n110#1:240\n111#1:241\n150#1:246\n186#1:247\n52#1:234,4\n130#1:243,3\n208#1:248\n209#1:249\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration2, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration2, reporter, context2);
        this.checkParameterBounds(declaration2, reporter, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(classVisibility = object2, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes2 = declaration2.getSuperTypeRefs();
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        object = supertypes2.iterator();
        while (object.hasNext()) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            FirRegularClassSymbol classSymbol2;
            boolean superIsInterface;
            ConeClassLikeType supertype2;
            FirTypeRef supertypeRef;
            FirTypeRef $this$coneTypeSafe$iv = supertypeRef = (FirTypeRef)object.next();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null || TypeUtilsKt.toRegularClassSymbol(supertype2, context2.getSession()) == null || (superIsInterface = classSymbol2.getClassKind() == ClassKind.INTERFACE) != isInterface || this.findVisibilityExposure(supertype2, context2, (EffectiveVisibility)classVisibility) == null) continue;
            FirBasedSymbol<?> restricting = pair.component1();
            EffectiveVisibility restrictingVisibility = pair.component2();
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = declaration2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(classVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter2 : declaration2.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter2.getSymbol().getResolvedBounds()) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
                if (this.findVisibilityExposure(FirTypeUtilsKt.getConeType(bound), context2, (EffectiveVisibility)classVisibility) == null) continue;
                FirBasedSymbol<?> restricting = pair.component1();
                EffectiveVisibility restrictingVisibility = pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), classVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object typeAliasVisibility;
        ConeClassLikeType expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(typeAliasVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Object object2 = expandedType2;
        if (object2 == null || (object2 = this.findVisibilityExposure((ConeKotlinType)object2, context2, (EffectiveVisibility)typeAliasVisibility)) == null) {
            return;
        }
        Object object3 = object2;
        FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object3).component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)((Pair)object3).component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(FirFunction declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object functionVisibility = null;
        Intrinsics.checkNotNull(declaration2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration2 instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration2;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        if (Intrinsics.areEqual(functionVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        if (!(declaration2 instanceof FirConstructor) && !(declaration2 instanceof FirPropertyAccessor)) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = this.findVisibilityExposure(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility);
            if (pair != null) {
                object = pair;
                boolean bl = false;
                FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object).component1();
                EffectiveVisibility restrictingVisibility = (EffectiveVisibility)((Pair)object).component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
        if (!(declaration2 instanceof FirPropertyAccessor)) {
            Iterable $this$forEachIndexed$iv = declaration2.getValueParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
                void valueParameter2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FirValueParameter firValueParameter = (FirValueParameter)item$iv;
                int i = n;
                boolean bl = false;
                if (i >= declaration2.getValueParameters().size() || INSTANCE.findVisibilityExposure(FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility) == null) continue;
                FirBasedSymbol<?> restricting = pair.component1();
                EffectiveVisibility restrictingVisibility = pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), functionVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
        FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
        this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration2 : null, reporter, context2);
    }

    private final void checkProperty(FirProperty declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object propertyVisibility;
        if (declaration2.isLocal()) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(propertyVisibility = object2, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = this.findVisibilityExposure(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility);
        if (pair != null) {
            object = pair;
            boolean bl = false;
            FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object).component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)((Pair)object).component2();
            if (Intrinsics.areEqual(DeclarationAttributesKt.getFromPrimaryConstructor(declaration2), true)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
        FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
        this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2, reporter, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(memberVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = this.findVisibilityExposure(receiverParameterType, context2, (EffectiveVisibility)memberVisibility);
        if (pair == null) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
        FirBasedSymbol<?> restricting = pair2.component1();
        EffectiveVisibility restrictingVisibility = pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        ConeTypeProjection[] $this$effectiveVisibility$iv;
        ConeClassLikeType coneClassLikeType = $this$findVisibilityExposure instanceof ConeClassLikeType ? (ConeClassLikeType)$this$findVisibilityExposure : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        ConeTypeProjection[] coneTypeProjectionArray = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (coneTypeProjectionArray == null) {
            return null;
        }
        ConeTypeProjection[] classSymbol2 = coneTypeProjectionArray;
        ConeTypeProjection[] coneTypeProjectionArray2 = classSymbol2;
        if (coneTypeProjectionArray2 instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol2;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (coneTypeProjectionArray2 instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol2;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base, TypeComponentsKt.getTypeContext(context2.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return TuplesKt.to(classSymbol2, effectiveVisibility);
                }
            }
        }
        for (ConeTypeProjection it : type2.getTypeArguments()) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            ConeClassLikeType coneClassLikeType2;
            ConeClassLikeType coneClassLikeType3 = coneClassLikeType2 = it instanceof ConeClassLikeType ? (ConeClassLikeType)it : null;
            if (coneClassLikeType2 == null || (pair = this.findVisibilityExposure(coneClassLikeType2, context2, base)) == null) continue;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> it2 = pair;
            boolean bl = false;
            return it2;
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            try {
                nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

