/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,60:1\n37#2:61\n37#2:62\n21#2:63\n70#2:64\n*S KotlinDebug\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n*L\n30#1:61\n39#1:62\n51#1:63\n55#1:64\n*E\n"})
public final class FirExpectConsistencyChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectConsistencyChecker INSTANCE = new FirExpectConsistencyChecker();

    private FirExpectConsistencyChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtSourceElement source;
        block18: {
            block17: {
                boolean isInsideClass;
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                KtSourceElement ktSourceElement = declaration2.getSource();
                if (ktSourceElement == null) {
                    return;
                }
                source = ktSourceElement;
                if (source.getKind() instanceof KtFakeSourceElementKind) {
                    return;
                }
                boolean isTopLevel2 = context2.getContainingDeclarations().size() == 1;
                FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                FirClass lastClass = firDeclaration instanceof FirClass ? (FirClass)firDeclaration : null;
                boolean bl = isInsideClass = lastClass != null;
                if (declaration2 instanceof FirAnonymousInitializer) {
                    boolean bl2;
                    FirClass firClass = lastClass;
                    if (firClass != null) {
                        FirMemberDeclaration $this$isExpect$iv = firClass;
                        boolean $i$f$isExpect = false;
                        bl2 = $this$isExpect$iv.getStatus().isExpect();
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
                    }
                    return;
                }
                if (!(declaration2 instanceof FirMemberDeclaration) || !isTopLevel2 && !isInsideClass) break block17;
                FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect()) break block18;
            }
            return;
        }
        if (declaration2 instanceof FirConstructor) {
            if (!((FirConstructor)declaration2).isPrimary()) {
                KtSourceElement delegatedConstructorSource;
                FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)declaration2).getDelegatedConstructor();
                KtSourceElement ktSourceElement = delegatedConstructorSource = firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getSource() : null;
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegatedConstructorSource, FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$getVisibility = false;
            if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (declaration2 instanceof FirFunction) {
            FirFunction $this$hasBody$iv = (FirFunction)declaration2;
            boolean $i$f$getHasBody = false;
            if ($this$hasBody$iv.getBody() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

