/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016JH\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010#\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "explicitReceiverOfQualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getExplicitReceiverOfQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "resolvedVariable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "getResolvedVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "unwrapped", "getUnwrapped", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkComponentCall", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "destructuringDeclarationType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "property", "componentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "destructuringDeclaration", "checkInitializer", "initializer", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDestructuringDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1549#2:208\n1620#2,3:209\n*S KotlinDebug\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n*L\n142#1:208\n142#1:209,3\n*E\n"})
public final class FirDestructuringDeclarationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDestructuringDeclarationChecker INSTANCE = new FirDestructuringDeclarationChecker();

    private FirDestructuringDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeDiagnostic diagnostic;
        FirElement firElement;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual(declaration2.getName(), SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
            return;
        }
        if (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            this.checkInitializer(source, declaration2.getInitializer(), reporter, context2);
            return;
        }
        if (!Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        FirExpression firExpression2 = declaration2.getInitializer();
        FirComponentCall firComponentCall = firExpression2 instanceof FirComponentCall ? (FirComponentCall)firExpression2 : null;
        if (firComponentCall == null) {
            return;
        }
        FirComponentCall componentCall = firComponentCall;
        FirQualifiedAccessExpression firQualifiedAccessExpression = this.getExplicitReceiverOfQualifiedAccess(componentCall);
        if (firQualifiedAccessExpression == null) {
            return;
        }
        FirQualifiedAccessExpression originalExpression = firQualifiedAccessExpression;
        FirVariable firVariable = this.getResolvedVariable(originalExpression);
        if (firVariable == null) {
            return;
        }
        FirVariable originalDestructuringDeclaration = firVariable;
        FirVariable firVariable2 = originalDestructuringDeclaration;
        if (firVariable2 instanceof FirProperty) {
            FirExpression firExpression3;
            Object object = originalDestructuringDeclaration.getInitializer();
            if (Intrinsics.areEqual(object != null && (object = ((FirExpression)object).getSource()) != null ? ((KtSourceElement)object).getElementType() : null, KtNodeTypes.FOR)) {
                FirQualifiedAccessExpression iterator2;
                FirExpression firExpression4 = originalDestructuringDeclaration.getInitializer();
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = iterator2 = firExpression4 != null ? this.getExplicitReceiverOfQualifiedAccess(firExpression4) : null;
                FirVariable firVariable3 = firQualifiedAccessExpression2 != null ? this.getResolvedVariable(firQualifiedAccessExpression2) : null;
                FirPureAbstractElement firPureAbstractElement = firVariable3 instanceof FirProperty ? (FirProperty)firVariable3 : null;
                firExpression3 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null ? this.getExplicitReceiverOfQualifiedAccess((FirExpression)firPureAbstractElement) : null;
            } else {
                firExpression3 = originalDestructuringDeclaration.getInitializer();
            }
            firElement = firExpression3;
        } else {
            firElement = firVariable2 instanceof FirValueParameter ? (FirElement)originalDestructuringDeclaration : null;
        }
        if (firElement == null) {
            return;
        }
        FirElement originalDestructuringDeclarationOrInitializer = firElement;
        KtSourceElement ktSourceElement2 = ((FirPureAbstractElement)originalDestructuringDeclarationOrInitializer).getSource();
        if (ktSourceElement2 == null) {
            return;
        }
        KtSourceElement originalDestructuringDeclarationOrInitializerSource = ktSourceElement2;
        FirElement firElement2 = originalDestructuringDeclarationOrInitializer;
        ConeKotlinType coneKotlinType = firElement2 instanceof FirVariable ? FirTypeUtilsKt.getConeType(((FirVariable)originalDestructuringDeclarationOrInitializer).getReturnTypeRef()) : (firElement2 instanceof FirExpression ? FirTypeUtilsKt.getResolvedType((FirExpression)originalDestructuringDeclarationOrInitializer) : null);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType originalDestructuringDeclarationType = coneKotlinType;
        FirNamedReference reference2 = componentCall.getCalleeReference();
        ConeDiagnostic coneDiagnostic = diagnostic = FirReferenceUtilsKt.isError(reference2) ? ((FirDiagnosticHolder)((Object)reference2)).getDiagnostic() : null;
        if (diagnostic != null) {
            this.checkComponentCall(originalDestructuringDeclarationOrInitializerSource, originalDestructuringDeclarationType, diagnostic, declaration2, componentCall, originalDestructuringDeclaration, reporter, context2);
        }
    }

    private final void checkInitializer(KtSourceElement source, FirExpression initializer2, DiagnosticReporter reporter, CheckerContext context2) {
        boolean needToReport;
        FirExpression firExpression2 = initializer2;
        boolean bl = firExpression2 == null ? true : (needToReport = firExpression2 instanceof FirErrorExpression ? ((FirErrorExpression)initializer2).getDiagnostic() instanceof ConeSyntaxDiagnostic : false);
        if (needToReport) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkComponentCall(KtSourceElement source, ConeKotlinType destructuringDeclarationType, ConeDiagnostic diagnostic, FirProperty property, FirComponentCall componentCall, FirVariable destructuringDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        ConeDiagnostic coneDiagnostic = diagnostic;
        if (coneDiagnostic instanceof ConeUnresolvedNameError) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeUnresolvedNameError)diagnostic).getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context2, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableWrongReceiver) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCandidate)CollectionsKt.first((Iterable)((ConeInapplicableWrongReceiver)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context2, null, 32, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError) {
            Collection<FirBasedSymbol<?>> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
            Name name2 = ((ConeAmbiguityError)diagnostic).getName();
            KtDiagnosticFactory2<Name, Collection<FirBasedSymbol<?>>> ktDiagnosticFactory2 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY();
            AbstractKtSourceElement abstractKtSourceElement = source;
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$map = false;
            void var12_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)name2, collection, (DiagnosticContext)context2, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
            if (ConeTypeUtilsKt.isNullable(destructuringDeclarationType)) {
                AbstractKtSourceElement abstractKtSourceElement = source;
                KtDiagnosticFactory1<Name> ktDiagnosticFactory1 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_ON_NULLABLE();
                FirBasedSymbol<?> firBasedSymbol = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol();
                Intrinsics.checkNotNull(firBasedSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)((FirNamedFunctionSymbol)firBasedSymbol).getCallableId().getCallableName(), (DiagnosticContext)context2, null, 16, null);
            }
        } else if (coneDiagnostic instanceof ConeConstraintSystemHasContradiction) {
            ConeKotlinType componentType = FirTypeUtilsKt.getResolvedType(componentCall);
            if (componentType instanceof ConeErrorType) {
                return;
            }
            ConeKotlinType expectedType = FirTypeUtilsKt.getConeType(property.getReturnTypeRef());
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)componentType, (KotlinTypeMarker)expectedType, false, 8, null)) {
                KtSourceElement typeMismatchSource = destructuringDeclaration instanceof FirValueParameter ? property.getSource() : source;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeMismatchSource, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)((ConeConstraintSystemHasContradiction)diagnostic).getCandidate().getCallInfo().getName(), (Object)componentType, (Object)expectedType, (DiagnosticContext)context2, null, 64, null);
            }
        } else if (coneDiagnostic instanceof ConeVisibilityError) {
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(((ConeVisibilityError)diagnostic).getSymbol(), property.getSource()), context2);
        } else {
            throw new IllegalStateException("Unhandled error during a component function call".toString());
        }
    }

    private final FirQualifiedAccessExpression getExplicitReceiverOfQualifiedAccess(FirExpression $this$explicitReceiverOfQualifiedAccess) {
        FirExpression firExpression2 = $this$explicitReceiverOfQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$explicitReceiverOfQualifiedAccess : null;
        FirExpression firExpression3 = firExpression2 != null && (firExpression2 = firExpression2.getExplicitReceiver()) != null ? this.getUnwrapped(firExpression2) : null;
        return firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
    }

    private final FirExpression getUnwrapped(FirExpression $this$unwrapped) {
        FirExpression firExpression2 = $this$unwrapped;
        return firExpression2 instanceof FirSmartCastExpression ? ((FirSmartCastExpression)$this$unwrapped).getOriginalExpression() : (firExpression2 instanceof FirWrappedExpression ? ((FirWrappedExpression)$this$unwrapped).getExpression() : $this$unwrapped);
    }

    private final FirVariable getResolvedVariable(FirQualifiedAccessExpression $this$resolvedVariable) {
        FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default($this$resolvedVariable.getCalleeReference(), false, 1, null);
        if (firVariableSymbol == null) {
            return null;
        }
        FirVariableSymbol symbol2 = firVariableSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(symbol2, FirResolvePhase.BODY_RESOLVE);
        return (FirVariable)symbol2.getFir();
    }
}

