/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "pendingTransformations", "", "Lkotlin/Function0;", "", "lower", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nObjectClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
final class ObjectClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final List<Function0<Unit>> pendingTransformations;

    public ObjectClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.pendingTransformations = new ArrayList();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        ClassLoweringPass.super.lower(irFile);
        for (Function0<Unit> transformation : this.pendingTransformations) {
            transformation.invoke();
        }
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        IrConstructor irConstructor;
        IrField privateInstanceField;
        IrField publicInstanceField;
        block6: {
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            if (!IrUtilsKt.isObject(irClass2)) {
                return;
            }
            publicInstanceField = this.context.getCachedDeclarations().getFieldForObjectInstance(irClass2);
            privateInstanceField = this.context.getCachedDeclarations().getPrivateFieldForObjectInstance(irClass2);
            Sequence<IrConstructor> sequence2 = IrUtilsKt.getConstructors(irClass2);
            Iterator<IrConstructor> iterator2 = sequence2.iterator();
            while (iterator2.hasNext()) {
                IrConstructor irConstructor2;
                IrConstructor it = irConstructor2 = iterator2.next();
                boolean bl = false;
                if (!it.isPrimary()) continue;
                irConstructor = irConstructor2;
                break block6;
            }
            irConstructor = null;
        }
        IrConstructor irConstructor3 = irConstructor;
        if (irConstructor3 == null) {
            throw new AssertionError((Object)("Object should have a primary constructor: " + irClass2.getName()));
        }
        IrConstructor constructor2 = irConstructor3;
        if (!Intrinsics.areEqual(privateInstanceField, publicInstanceField)) {
            DeclarationIrBuilder $this$lower_u24lambda_u241 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)privateInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            privateInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$lower_u24lambda_u241, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lower_u24lambda_u241, constructor2.getSymbol())));
            DeclarationIrBuilder $this$lower_u24lambda_u242 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)publicInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl2 = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$lower_u24lambda_u242, ExpressionHelpersKt.irGetField$default($this$lower_u24lambda_u242, null, privateInstanceField, null, 4, null)));
            this.pendingTransformations.add(new Function0<Unit>(privateInstanceField){
                final /* synthetic */ IrField $privateInstanceField;
                {
                    this.$privateInstanceField = $privateInstanceField;
                    super(0);
                }

                public final void invoke() {
                    IrDeclarationParent irDeclarationParent = this.$privateInstanceField.getParent();
                    Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                    ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, this.$privateInstanceField);
                }
            });
        } else {
            DeclarationIrBuilder $this$lower_u24lambda_u243 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)publicInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$lower_u24lambda_u243, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lower_u24lambda_u243, constructor2.getSymbol())));
        }
        if (!this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField) && (Intrinsics.areEqual(irClass2.getVisibility(), DescriptorVisibilities.PRIVATE) || Intrinsics.areEqual(irClass2.getVisibility(), DescriptorVisibilities.PROTECTED))) {
            JvmIrBuilder $this$lower_u24lambda_u244 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, irClass2.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            publicInstanceField.setAnnotations(CollectionsKt.plus((Collection)AdditionalIrUtilsKt.filterOutAnnotations(DeprecationResolver.Companion.getJAVA_DEPRECATED(), publicInstanceField.getAnnotations()), ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lower_u24lambda_u244, $this$lower_u24lambda_u244.getIrSymbols().getJavaLangDeprecatedConstructorWithDeprecatedFlag())));
        }
        this.pendingTransformations.add(new Function0<Unit>(publicInstanceField){
            final /* synthetic */ IrField $publicInstanceField;
            {
                this.$publicInstanceField = $publicInstanceField;
                super(0);
            }

            public final void invoke() {
                IrDeclarationParent irDeclarationParent = this.$publicInstanceField.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, this.$publicInstanceField);
            }
        });
    }
}

