/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000fJ\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001fJ\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010!\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fJ\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\u0014\u0010%\u001a\u00020\u0016*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR0\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "globalTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;)V", "globalDeclarationTable", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "table", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/HashMap;", "getTable", "()Ljava/util/HashMap;", "allocateIndexedSignature", "declaration", "compatibleMode", "", "assumeDeclarationSignature", "", "signature", "computeSignatureByDeclaration", "inFile", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "isExportedDeclaration", "privateDeclarationSignature", "builder", "signatureByDeclaration", "tryComputeBackendSpecificSignature", "isLocalDeclaration", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n372#2,7:105\n372#2,7:113\n1#3:112\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n*L\n76#1:105,7\n88#1:113,7\n*E\n"})
public class DeclarationTable {
    @NotNull
    private final HashMap<IrDeclaration, IdSignature> table;
    @NotNull
    private final GlobalDeclarationTable globalDeclarationTable;
    @NotNull
    private final IdSignatureSerializer signaturer;

    public DeclarationTable(@NotNull GlobalDeclarationTable globalTable) {
        Intrinsics.checkNotNullParameter(globalTable, "globalTable");
        this.table = new HashMap();
        this.globalDeclarationTable = globalTable;
        this.signaturer = new IdSignatureSerializer(globalTable.getPublicIdSignatureComputer(), this);
    }

    @NotNull
    protected final HashMap<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    @NotNull
    protected GlobalDeclarationTable getGlobalDeclarationTable() {
        return this.globalDeclarationTable;
    }

    @NotNull
    public IdSignatureSerializer getSignaturer() {
        return this.signaturer;
    }

    public final void inFile(@Nullable IrFile file2, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        IrFile irFile = file2;
        this.getSignaturer().inFile(irFile != null ? irFile.getSymbol() : null, block);
    }

    private final boolean isLocalDeclaration(IrDeclaration $this$isLocalDeclaration, boolean compatibleMode) {
        return !this.isExportedDeclaration($this$isLocalDeclaration, compatibleMode);
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.getGlobalDeclarationTable().isExportedDeclaration(declaration2, compatibleMode);
    }

    @Nullable
    protected IdSignature tryComputeBackendSpecificSignature(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return null;
    }

    private final IdSignature allocateIndexedSignature(IrDeclaration declaration2, boolean compatibleMode) {
        Object object;
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature answer$iv = this.getSignaturer().composeFileLocalIdSignature(declaration2, compatibleMode);
            $this$getOrPut$iv.put(declaration2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    private final IdSignature computeSignatureByDeclaration(IrDeclaration declaration2, boolean compatibleMode) {
        IdSignature idSignature = this.tryComputeBackendSpecificSignature(declaration2);
        if (idSignature != null) {
            IdSignature it = idSignature;
            boolean bl = false;
            return it;
        }
        return this.isLocalDeclaration(declaration2, compatibleMode) ? this.allocateIndexedSignature(declaration2, compatibleMode) : this.getGlobalDeclarationTable().computeSignatureByDeclaration(declaration2, compatibleMode);
    }

    @NotNull
    public final IdSignature privateDeclarationSignature(@NotNull IrDeclaration declaration2, boolean compatibleMode, @NotNull Function0<? extends IdSignature> builder2) {
        Object object;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        boolean bl = this.isLocalDeclaration(declaration2, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            boolean bl2 = false;
            IdSignature answer$iv = builder2.invoke();
            $this$getOrPut$iv.put(declaration2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    @NotNull
    public IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.computeSignatureByDeclaration(declaration2, compatibleMode);
    }

    public final void assumeDeclarationSignature(@NotNull IrDeclaration declaration2, @NotNull IdSignature signature2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        boolean bl2 = bl = this.table.get(declaration2) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Declaration table already has signature for " + RenderIrElementKt.render$default(declaration2, null, 1, null);
            throw new AssertionError((Object)string2);
        }
        this.table.put(declaration2, signature2);
    }
}

