/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector;", "", "()V", "actualClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "actualTopLevels", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "actualTypeAliasesWithoutExpansion", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "visitedActualClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "collect", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "recordActualCallable", "callableDeclaration", "callableId", "Companion", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,238:1\n372#2,7:239\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n*L\n156#1:239,7\n*E\n"})
final class ActualDeclarationsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ClassId, IrClassSymbol> actualClasses = new LinkedHashMap();
    @NotNull
    private final Map<ClassId, IrTypeAliasSymbol> actualTypeAliasesWithoutExpansion = new LinkedHashMap();
    @NotNull
    private final Map<CallableId, List<IrDeclarationWithName>> actualTopLevels = new LinkedHashMap();
    @NotNull
    private final Set<IrClass> visitedActualClasses = new LinkedHashSet();

    private final void collect(IrElement element2) {
        IrElement irElement = element2;
        if (irElement instanceof IrModuleFragment) {
            for (IrFile file2 : ((IrModuleFragment)element2).getFiles()) {
                this.collect(file2);
            }
        } else if (irElement instanceof IrTypeAlias) {
            if (!((IrTypeAlias)element2).isActual()) {
                return;
            }
            ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail((IrTypeAlias)element2);
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(((IrTypeAlias)element2).getExpandedType());
            Intrinsics.checkNotNull(irClassifierSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            IrClassSymbol expandedTypeSymbol = (IrClassSymbol)irClassifierSymbol;
            this.actualClasses.put(classId, expandedTypeSymbol);
            this.actualTypeAliasesWithoutExpansion.put(classId, ((IrTypeAlias)element2).getSymbol());
            this.collect(expandedTypeSymbol.getOwner());
        } else if (irElement instanceof IrClass) {
            if (((IrClass)element2).isExpect() || !this.visitedActualClasses.add((IrClass)element2)) {
                return;
            }
            this.actualClasses.put(AdditionalIrUtilsKt.getClassIdOrFail((IrClass)element2), ((IrClass)element2).getSymbol());
            for (IrDeclaration declaration2 : ((IrClass)element2).getDeclarations()) {
                this.collect(declaration2);
            }
        } else if (irElement instanceof IrDeclarationContainer) {
            for (IrDeclaration declaration3 : ((IrDeclarationContainer)element2).getDeclarations()) {
                this.collect(declaration3);
            }
        } else if (irElement instanceof IrEnumEntry) {
            this.recordActualCallable((IrDeclarationWithName)element2, AdditionalIrUtilsKt.getCallableId((IrEnumEntry)element2));
        } else if (irElement instanceof IrProperty) {
            if (((IrProperty)element2).isExpect()) {
                return;
            }
            this.recordActualCallable((IrDeclarationWithName)element2, AdditionalIrUtilsKt.getCallableId((IrProperty)element2));
        } else if (irElement instanceof IrFunction) {
            if (((IrFunction)element2).isExpect()) {
                return;
            }
            this.recordActualCallable((IrDeclarationWithName)element2, AdditionalIrUtilsKt.getCallableId((IrFunction)element2));
        }
    }

    private final void recordActualCallable(IrDeclarationWithName callableDeclaration, CallableId callableId) {
        if (callableId.getClassId() == null) {
            List list2;
            Map<CallableId, List<IrDeclarationWithName>> $this$getOrPut$iv = this.actualTopLevels;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(callableId);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(callableId, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list2.add((IrDeclarationWithName)callableDeclaration);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector$Companion;", "", "()V", "collectActualsFromFragments", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "fragments", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassActualizationInfo collectActualsFromFragments(@NotNull List<? extends IrModuleFragment> fragments2) {
            Intrinsics.checkNotNullParameter(fragments2, "fragments");
            ActualDeclarationsCollector collector2 = new ActualDeclarationsCollector();
            for (IrModuleFragment irModuleFragment : fragments2) {
                collector2.collect(irModuleFragment);
            }
            return new ClassActualizationInfo(collector2.actualClasses, collector2.actualTypeAliasesWithoutExpansion, collector2.actualTopLevels);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

