/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ChangeType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.InBlockModificationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.LLFirDeclarationModificationService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.LLFirDeclarationModificationServiceKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSessionKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinTopics;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;

@LLFirInternals
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "elementModified", "", "element", "Lcom/intellij/psi/PsiElement;", "modificationType", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType;", "elementToRehighlight", "changedElement", "inBlockModification", "declaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "outOfBlockModification", "Companion", "ModificationType", "low-level-api-fir"})
public final class LLFirDeclarationModificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public LLFirDeclarationModificationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void elementModified(@NotNull PsiElement element2, @NotNull ModificationType modificationType) {
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(modificationType, "modificationType");
        ApplicationManager.getApplication().assertIsWriteThread();
        ChangeType changeType = LLFirDeclarationModificationServiceKt.access$calculateChangeType(element2, modificationType);
        if (!(changeType instanceof ChangeType.Invisible)) {
            if (changeType instanceof ChangeType.InBlock) {
                this.inBlockModification(((ChangeType.InBlock)changeType).getBlockOwner());
            } else if (changeType instanceof ChangeType.OutOfBlock) {
                this.outOfBlockModification(element2);
            }
        }
    }

    public static /* synthetic */ void elementModified$default(LLFirDeclarationModificationService lLFirDeclarationModificationService, PsiElement psiElement, ModificationType modificationType, int n, Object object) {
        if ((n & 2) != 0) {
            modificationType = ModificationType.Unknown.INSTANCE;
        }
        lLFirDeclarationModificationService.elementModified(psiElement, modificationType);
    }

    private final void inBlockModification(KtElement declaration2) {
        FirDeclaration firDeclaration;
        KtModule ktModule = ProjectStructureProvider.Companion.getModule(this.project, declaration2, null);
        LLFirResolveSession resolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(ktModule, this.project);
        KtElement ktElement = declaration2;
        if (ktElement instanceof KtCodeFragment) {
            firDeclaration = DeclarationUtilsKt.getCodeFragment(LowLevelFirApiFacadeKt.getOrBuildFirFile((KtFile)declaration2, resolveSession));
        } else if (ktElement instanceof KtDeclaration) {
            firDeclaration = LowLevelFirApiFacadeKt.resolveToFirSymbol$default((KtDeclaration)declaration2, resolveSession, null, 2, null).getFir();
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unexpected declaration kind: " + Reflection.getOrCreateKotlinClass(declaration2.getClass()).getSimpleName(), null, null, null, declaration2, null, 46, null);
            throw null;
        }
        FirDeclaration firDeclaration2 = firDeclaration;
        InBlockModificationKt.invalidateAfterInBlockModification(firDeclaration2);
        LLFirResolvableModuleSession lLFirResolvableModuleSession = LLFirResolvableModuleSessionKt.getLlFirResolvableSession(firDeclaration2);
        if (lLFirResolvableModuleSession == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default(Reflection.getOrCreateKotlinClass(LLFirResolvableModuleSession.class).getSimpleName() + " is not found", null, firDeclaration2, null, declaration2, new Function1<ExceptionAttachmentBuilder, Unit>(resolveSession){
                final /* synthetic */ LLFirResolveSession $resolveSession;
                {
                    this.$resolveSession = $resolveSession;
                    super(1);
                }

                public final void invoke(@NotNull ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
                    Intrinsics.checkNotNullParameter($this$errorWithFirSpecificEntries, "$this$errorWithFirSpecificEntries");
                    $this$errorWithFirSpecificEntries.withEntry("session", this.$resolveSession, inBlockModification.moduleSession.1.INSTANCE);
                }
            }, 10, null);
            throw null;
        }
        LLFirResolvableModuleSession moduleSession2 = lLFirResolvableModuleSession;
        FileStructureCache fileStructureCache = moduleSession2.getModuleComponents$low_level_api_fir().getFileStructureCache();
        KtFile ktFile = declaration2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
        FileStructure fileStructure = fileStructureCache.getCachedFileStructure(ktFile);
        if (fileStructure == null) {
            return;
        }
        FileStructure fileStructure2 = fileStructure;
        fileStructure2.invalidateElement(declaration2);
    }

    private final void outOfBlockModification(PsiElement element2) {
        KtModule ktModule = ProjectStructureProvider.Companion.getModule(this.project, element2, null);
        KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION()).onModification(ktModule);
    }

    @Nullable
    public final PsiElement elementToRehighlight(@NotNull PsiElement changedElement) {
        Intrinsics.checkNotNullParameter(changedElement, "changedElement");
        return LLFirDeclarationModificationServiceKt.access$nonLocalDeclarationForLocalChange(changedElement);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirDeclarationModificationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            LLFirDeclarationModificationService lLFirDeclarationModificationService = project.getService(LLFirDeclarationModificationService.class);
            Intrinsics.checkNotNullExpressionValue(lLFirDeclarationModificationService, "getService(...)");
            return lLFirDeclarationModificationService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType;", "", "()V", "NewElement", "Unknown", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType$NewElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType$Unknown;", "low-level-api-fir"})
    public static abstract class ModificationType {
        private ModificationType() {
        }

        public /* synthetic */ ModificationType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType$NewElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType;", "()V", "low-level-api-fir"})
        public static final class NewElement
        extends ModificationType {
            @NotNull
            public static final NewElement INSTANCE = new NewElement();

            private NewElement() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType$Unknown;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$ModificationType;", "()V", "low-level-api-fir"})
        public static final class Unknown
        extends ModificationType {
            @NotNull
            public static final Unknown INSTANCE = new Unknown();

            private Unknown() {
                super(null);
            }
        }
    }
}

