/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.initializer.InitializerVisitor;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

public final class ClassInitializerTranslator
extends AbstractTranslator {
    @NotNull
    private final KtPureClassOrObject classDeclaration;
    @NotNull
    private final JsFunction initFunction;
    @NotNull
    private final TranslationContext context;
    @NotNull
    private final ClassDescriptor classDescriptor;
    private final ConstructorDescriptor primaryConstructor;
    private int ordinal;

    public ClassInitializerTranslator(@NotNull KtPureClassOrObject classDeclaration, @NotNull TranslationContext context2, @NotNull JsFunction initFunction) {
        if (classDeclaration == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(1);
        }
        if (initFunction == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(2);
        }
        super(context2);
        this.classDeclaration = classDeclaration;
        this.initFunction = initFunction;
        this.context = context2.contextWithScope(initFunction);
        this.classDescriptor = BindingUtils.getClassDescriptor(this.bindingContext(), classDeclaration);
        this.primaryConstructor = this.classDescriptor.getUnsubstitutedPrimaryConstructor();
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @NotNull
    protected TranslationContext context() {
        TranslationContext translationContext = this.context;
        if (translationContext == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(3);
        }
        return translationContext;
    }

    public void generateInitializeMethod(DelegationTranslator delegationTranslator) {
        this.addOuterClassReference(this.classDescriptor);
        if (this.primaryConstructor != null) {
            this.initFunction.getBody().getStatements().addAll(FunctionBodyTranslator.setDefaultValueForArguments(this.primaryConstructor, this.context()));
            this.mayBeAddCallToSuperMethod(this.initFunction);
            this.initFunction.getParameters().addAll(this.translatePrimaryConstructorParameters());
            if (this.classDescriptor.getKind() == ClassKind.ENUM_CLASS && this.classDeclaration instanceof PsiElement) {
                ClassInitializerTranslator.addEnumClassParameters(this.initFunction, (PsiElement)((Object)this.classDeclaration));
            }
        }
        this.addThrowableCall();
        delegationTranslator.addInitCode(this.initFunction.getBody().getStatements());
        new InitializerVisitor().traverseContainer(this.classDeclaration, this.context().innerBlock(this.initFunction.getBody()));
    }

    private static void addEnumClassParameters(JsFunction constructorFunction, PsiElement psiElement) {
        JsName nameParamName = constructorFunction.getScope().declareFreshName("name");
        JsName ordinalParamName = constructorFunction.getScope().declareFreshName("ordinal");
        constructorFunction.getParameters().addAll(0, Arrays.asList(new JsParameter(nameParamName), new JsParameter(ordinalParamName)));
        JsStatement nameAssignment = JsAstUtils.assignmentToThisField("name$", nameParamName.makeRef().source(psiElement));
        constructorFunction.getBody().getStatements().add(nameAssignment);
        JsStatement ordinalAssignment = JsAstUtils.assignmentToThisField("ordinal$", ordinalParamName.makeRef().source(psiElement));
        constructorFunction.getBody().getStatements().add(ordinalAssignment);
    }

    private void addOuterClassReference(ClassDescriptor classDescriptor) {
        JsName outerName = this.context.getOuterClassReference(classDescriptor);
        if (outerName == null) {
            return;
        }
        this.initFunction.getParameters().add(0, new JsParameter(outerName));
        JsNameRef paramRef = JsAstUtils.pureFqn(outerName, null);
        JsExpression assignment = JsAstUtils.assignment(JsAstUtils.pureFqn(outerName, (JsExpression)new JsThisRef()), paramRef).source(this.classDeclaration);
        this.initFunction.getBody().getStatements().add(new JsExpressionStatement(assignment));
    }

    @NotNull
    public static JsExpression generateEnumEntryInstanceCreation(@NotNull TranslationContext context2, @NotNull KtEnumEntry enumEntry, int ordinal) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        if (context2 == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(4);
        }
        if (enumEntry == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(5);
        }
        if ((resolvedCall2 = BindingUtils.getSuperCall(context2.bindingContext(), enumEntry)) == null) {
            assert (enumEntry.getInitializerList() == null) : "Super call is missing on an enum entry with explicit initializer list " + PsiUtilsKt.getTextWithLocation(enumEntry);
            resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(enumEntry, context2.bindingContext());
        }
        JsStringLiteral nameArg = new JsStringLiteral(enumEntry.getName());
        JsIntLiteral ordinalArg = new JsIntLiteral(ordinal);
        List<JsExpression> additionalArgs = Arrays.asList(nameArg, ordinalArg);
        JsExpression call2 = CallTranslator.translate(context2, resolvedCall2);
        if (call2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)call2;
            invocation.getArguments().addAll(0, additionalArgs);
        } else if (call2 instanceof JsNew) {
            JsNew invocation = (JsNew)call2;
            invocation.getArguments().addAll(0, additionalArgs);
        }
        JsExpression jsExpression = call2.source(enumEntry);
        if (jsExpression == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(6);
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private void mayBeAddCallToSuperMethod(JsFunction initializer) {
        if (this.classDeclaration instanceof KtClassOrObject && ((KtClassOrObject)this.classDeclaration).hasModifier(KtTokens.ENUM_KEYWORD)) {
            this.addCallToSuperMethod(Collections.emptyList(), initializer, this.classDeclaration);
        } else if (BindingUtils.hasAncestorClass(this.bindingContext(), this.classDeclaration)) {
            ResolvedCall<FunctionDescriptor> superCall = BindingUtils.getSuperCall(this.bindingContext(), this.classDeclaration);
            if (superCall == null) {
                if (DescriptorUtils.isEnumEntry(this.classDescriptor)) {
                    this.addCallToSuperMethod(this.getAdditionalArgumentsForEnumConstructor(), initializer, this.classDeclaration);
                }
                return;
            }
            if (JsDescriptorUtils.isImmediateSubtypeOfError(this.classDescriptor)) {
                ClassInitializerTranslator.emulateSuperCallToNativeError(this.context, this.classDescriptor, superCall, new JsThisRef());
                return;
            }
            if (this.classDeclaration instanceof KtEnumEntry) {
                JsExpression expression2 = CallTranslator.translate(this.context(), superCall, null);
                expression2.setSource(this.classDeclaration);
                JsExpression fixedInvocation = AstUtilsKt.toInvocationWith(expression2, this.getAdditionalArgumentsForEnumConstructor(), 0, new JsThisRef());
                this.initFunction.getBody().getStatements().add(fixedInvocation.makeStmt());
            } else {
                UsageTracker tracker;
                List<DeclarationDescriptor> superclassClosure;
                ArrayList<JsExpression> arguments2 = new ArrayList<JsExpression>();
                ConstructorDescriptor superDescriptor = (ConstructorDescriptor)superCall.getResultingDescriptor();
                if (superDescriptor instanceof TypeAliasConstructorDescriptor) {
                    superDescriptor = ((TypeAliasConstructorDescriptor)superDescriptor).getUnderlyingConstructorDescriptor();
                }
                if ((superclassClosure = this.context.getClassOrConstructorClosure(superDescriptor)) != null && (tracker = this.context.usageTracker()) != null) {
                    for (DeclarationDescriptor capturedValue : superclassClosure) {
                        tracker.used(capturedValue);
                        arguments2.add(tracker.getCapturedDescriptorToJsName().get(capturedValue).makeRef());
                    }
                }
                if (superCall.getDispatchReceiver() != null) {
                    JsExpression receiver = this.context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(superCall.getDispatchReceiver()));
                    arguments2.add(receiver);
                }
                if (!DescriptorUtils.isAnonymousObject(this.classDescriptor)) {
                    arguments2.addAll(CallArgumentTranslator.translate(superCall, null, this.context()).getTranslateArguments());
                } else {
                    for (ValueParameterDescriptor valueParameterDescriptor : superDescriptor.getValueParameters()) {
                        JsName parameterName = JsScope.declareTemporaryName(valueParameterDescriptor.getName().asString());
                        arguments2.add(parameterName.makeRef());
                        initializer.getParameters().add(new JsParameter(parameterName));
                    }
                }
                if (superDescriptor.isPrimary() || superDescriptor.getConstructedClass().isExternal()) {
                    this.addCallToSuperMethod(arguments2, initializer, superCall.getCall().getCallElement());
                } else {
                    if (!DescriptorUtils.isAnonymousObject(this.classDescriptor)) {
                        void var7_15;
                        int maxValueArgumentIndex = 0;
                        for (ValueParameterDescriptor arg : superCall.getValueArguments().keySet()) {
                            ResolvedValueArgument resolvedArg = superCall.getValueArguments().get(arg);
                            if (resolvedArg instanceof DefaultValueArgument) continue;
                            maxValueArgumentIndex = Math.max(maxValueArgumentIndex, arg.getIndex() + 1);
                        }
                        int n = superDescriptor.getValueParameters().size() - maxValueArgumentIndex;
                        while (--var7_15 > 0) {
                            arguments2.add(Namer.getUndefinedExpression());
                        }
                    }
                    this.addCallToSuperSecondaryConstructor(arguments2, superDescriptor);
                }
            }
        }
    }

    public static void emulateSuperCallToNativeError(@NotNull TranslationContext context2, @NotNull ClassDescriptor classDescriptor, @NotNull ResolvedCall<? extends FunctionDescriptor> superCall, @NotNull JsExpression receiver) {
        JsExpression correctedMessage;
        if (context2 == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(7);
        }
        if (classDescriptor == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(8);
        }
        if (superCall == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(9);
        }
        if (receiver == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(10);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(classDescriptor);
        JsExpression superClassRef = ReferenceTranslator.translateAsTypeReference(superClass, context2);
        JsInvocation superInvocation = new JsInvocation((JsExpression)Namer.getFunctionCallRef(superClassRef), receiver.deepCopy());
        List<JsStatement> statements = context2.getCurrentBlock().getStatements();
        statements.add(JsAstUtils.asSyntheticStatement(superInvocation));
        JsExpression messageArgument = Namer.getUndefinedExpression();
        JsExpression causeArgument = new JsNullLiteral();
        for (ValueParameterDescriptor param : superCall.getResultingDescriptor().getValueParameters()) {
            ResolvedValueArgument argument = superCall.getValueArguments().get(param);
            if (!(argument instanceof ExpressionValueArgument)) continue;
            ExpressionValueArgument exprArgument = (ExpressionValueArgument)argument;
            assert (exprArgument.getValueArgument() != null);
            KtExpression value2 = exprArgument.getValueArgument().getArgumentExpression();
            assert (value2 != null);
            JsExpression jsValue = Translation.translateAsExpression(value2, context2);
            if (KotlinBuiltIns.isStringOrNullableString(param.getType())) {
                messageArgument = context2.cacheExpressionIfNeeded(jsValue);
                continue;
            }
            if (KotlinBuiltIns.isThrowableOrNullableThrowable(param.getType())) {
                causeArgument = context2.cacheExpressionIfNeeded(jsValue);
                continue;
            }
            statements.add(JsAstUtils.asSyntheticStatement(jsValue));
        }
        PropertyDescriptor messageProperty = DescriptorUtils.getPropertyByName(classDescriptor.getUnsubstitutedMemberScope(), Name.identifier("message"));
        JsNameRef messageRef = JsAstUtils.pureFqn(context2.getNameForBackingField(messageProperty), receiver.deepCopy());
        JsBinaryOperation messageIsUndefined = JsAstUtils.typeOfIs(messageArgument, new JsStringLiteral("undefined"));
        JsBinaryOperation causeIsNull = new JsBinaryOperation(JsBinaryOperator.NEQ, causeArgument, new JsNullLiteral());
        JsBinaryOperation causeToStringCond = JsAstUtils.and(messageIsUndefined, causeIsNull);
        JsInvocation causeToString = new JsInvocation((JsExpression)JsAstUtils.pureFqn("toString", (JsExpression)Namer.kotlinObject()), causeArgument.deepCopy());
        if (causeArgument instanceof JsNullLiteral) {
            correctedMessage = messageArgument.deepCopy();
        } else {
            if (JsAstUtils.isUndefinedExpression(messageArgument)) {
                causeToStringCond = causeIsNull;
            }
            correctedMessage = new JsConditional(causeToStringCond, causeToString, messageArgument);
        }
        statements.add(JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(messageRef, correctedMessage)));
        PropertyDescriptor causeProperty = DescriptorUtils.getPropertyByName(classDescriptor.getUnsubstitutedMemberScope(), Name.identifier("cause"));
        JsNameRef causeRef = JsAstUtils.pureFqn(context2.getNameForBackingField(causeProperty), receiver.deepCopy());
        statements.add(JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(causeRef, causeArgument.deepCopy())));
    }

    @NotNull
    private List<JsExpression> getAdditionalArgumentsForEnumConstructor() {
        ArrayList<JsExpression> additionalArguments = new ArrayList<JsExpression>();
        additionalArguments.add(new JsStringLiteral(this.classDescriptor.getName().asString()));
        additionalArguments.add(new JsIntLiteral(this.ordinal));
        ArrayList<JsExpression> arrayList = additionalArguments;
        if (arrayList == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private void addCallToSuperMethod(@NotNull List<JsExpression> arguments2, @NotNull JsFunction initializer, @NotNull KtPureElement psi) {
        if (arguments2 == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(12);
        }
        if (initializer == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(13);
        }
        if (psi == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(14);
        }
        if (initializer.getName() == null) {
            JsName ref = this.context().scope().declareName("$fun");
            initializer.setName(ref);
        }
        ClassDescriptor superclassDescriptor = DescriptorUtilsKt.getSuperClassOrAny(this.classDescriptor);
        JsExpression superConstructorRef = this.context().getInnerReference(superclassDescriptor);
        JsInvocation call2 = new JsInvocation((JsExpression)Namer.getFunctionCallRef(superConstructorRef), new JsExpression[0]);
        call2.setSource(psi);
        call2.getArguments().add(new JsThisRef());
        call2.getArguments().addAll(arguments2);
        this.initFunction.getBody().getStatements().add(call2.makeStmt());
    }

    private void addCallToSuperSecondaryConstructor(@NotNull List<JsExpression> arguments2, @NotNull ConstructorDescriptor descriptor) {
        if (arguments2 == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(15);
        }
        if (descriptor == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(16);
        }
        JsExpression reference2 = this.context.getInnerReference(descriptor);
        JsInvocation call2 = new JsInvocation(reference2, new JsExpression[0]);
        call2.getArguments().addAll(arguments2);
        call2.getArguments().add(new JsThisRef());
        this.initFunction.getBody().getStatements().add(call2.makeStmt());
    }

    @NotNull
    private List<JsParameter> translatePrimaryConstructorParameters() {
        List<KtParameter> parameterList2 = PsiUtils.getPrimaryConstructorParameters(this.classDeclaration);
        ArrayList<JsParameter> result2 = new ArrayList<JsParameter>();
        for (KtParameter ktParameter : parameterList2) {
            result2.add(this.translateParameter(ktParameter));
        }
        ArrayList<JsParameter> arrayList = result2;
        if (arrayList == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private JsParameter translateParameter(@NotNull KtParameter ktParameter) {
        if (ktParameter == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(18);
        }
        DeclarationDescriptor parameterDescriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), ktParameter);
        JsName parameterName = this.context().getNameForDescriptor(parameterDescriptor);
        JsParameter jsParameter = new JsParameter(parameterName);
        this.mayBeAddInitializerStatementForProperty(jsParameter, ktParameter);
        JsParameter jsParameter2 = jsParameter;
        if (jsParameter2 == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(19);
        }
        return jsParameter2;
    }

    private void mayBeAddInitializerStatementForProperty(@NotNull JsParameter jsParameter, @NotNull KtParameter jetParameter) {
        PropertyDescriptor propertyDescriptor;
        if (jsParameter == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(20);
        }
        if (jetParameter == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(21);
        }
        if ((propertyDescriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), jetParameter)) == null) {
            return;
        }
        JsExpression initialValueForProperty = jsParameter.getName().makeRef();
        MetadataProperties.setType(initialValueForProperty, propertyDescriptor.getType());
        initialValueForProperty = TranslationUtils.coerce(this.context(), initialValueForProperty, TranslationUtils.getReturnTypeForCoercion(propertyDescriptor));
        this.addInitializerOrPropertyDefinition(initialValueForProperty, propertyDescriptor);
    }

    private void addInitializerOrPropertyDefinition(@NotNull JsExpression initialValue, @NotNull PropertyDescriptor propertyDescriptor) {
        if (initialValue == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(22);
        }
        if (propertyDescriptor == null) {
            ClassInitializerTranslator.$$$reportNull$$$0(23);
        }
        this.initFunction.getBody().getStatements().add(InitializerUtils.generateInitializerForProperty(this.context(), propertyDescriptor, initialValue));
    }

    private void addThrowableCall() {
        if (!JsDescriptorUtils.isExceptionClass(this.classDescriptor)) {
            return;
        }
        if (JsDescriptorUtils.isImmediateSubtypeOfError(this.classDescriptor)) {
            ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(this.classDescriptor);
            JsInvocation invocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn("captureStack", (JsExpression)Namer.kotlinObject()), ReferenceTranslator.translateAsTypeReference(superClass, this.context()), new JsThisRef());
            this.initFunction.getBody().getStatements().add(JsAstUtils.asSyntheticStatement(invocation));
        }
        JsStringLiteral nameLiteral = new JsStringLiteral(this.context.getInnerNameForDescriptor(this.classDescriptor).getIdent());
        JsBinaryOperation nameAssignment = JsAstUtils.assignment(JsAstUtils.pureFqn("name", (JsExpression)new JsThisRef()), nameLiteral);
        this.initFunction.getBody().getStatements().add(JsAstUtils.asSyntheticStatement(nameAssignment));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 17: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initFunction";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumEntry";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superCall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktParameter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsParameter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetParameter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialValue";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "context";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateEnumEntryInstanceCreation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalArgumentsForEnumConstructor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "translatePrimaryConstructorParameters";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "translateParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 17: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateEnumEntryInstanceCreation";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "emulateSuperCallToNativeError";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addCallToSuperMethod";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCallToSuperSecondaryConstructor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "translateParameter";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "mayBeAddInitializerStatementForProperty";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addInitializerOrPropertyDefinition";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

