/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DefaultPropertyTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/PropertyTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "translate", "", "result", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "generateGetter", "generateSetter", "getCustomGetterDeclaration", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getCustomSetterDeclaration", "generateDefaultGetter", "generateDefaultSetter", "generateDefaultAccessor", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "translateCustomAccessor", "expression", "createFunction", "accessorDescription", "", "js.translator"})
final class PropertyTranslator
extends AbstractTranslator {
    @NotNull
    private final VariableDescriptorWithAccessors descriptor;
    @Nullable
    private final KtProperty declaration;

    public PropertyTranslator(@NotNull VariableDescriptorWithAccessors descriptor, @Nullable KtProperty declaration2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.descriptor = descriptor;
        this.declaration = declaration2;
    }

    @NotNull
    public final VariableDescriptorWithAccessors getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public final KtProperty getDeclaration() {
        return this.declaration;
    }

    public final void translate(@NotNull List<JsPropertyInitializer> result2) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PropertyTranslatorKt.addGetterAndSetter(result2, this.descriptor, (Function0<? extends JsPropertyInitializer>)((Function0)() -> PropertyTranslator.translate$lambda$0(this)), (Function0<? extends JsPropertyInitializer>)((Function0)() -> PropertyTranslator.translate$lambda$1(this)));
    }

    private final JsPropertyInitializer generateGetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? PropertyTranslatorKt.hasCustomGetter(ktProperty) : false) ? this.translateCustomAccessor(this.getCustomGetterDeclaration()) : this.generateDefaultGetter();
    }

    private final JsPropertyInitializer generateSetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? PropertyTranslatorKt.hasCustomSetter(ktProperty) : false) ? this.translateCustomAccessor(this.getCustomSetterDeclaration()) : this.generateDefaultSetter();
    }

    private final KtPropertyAccessor getCustomGetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getGetter()) == null) {
            throw new IllegalStateException("declaration and getter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        return ktDeclarationStub;
    }

    private final KtPropertyAccessor getCustomSetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getSetter()) == null) {
            throw new IllegalStateException("declaration and setter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        return ktDeclarationStub;
    }

    private final JsPropertyInitializer generateDefaultGetter() {
        JsFunction jsFunction;
        VariableAccessorDescriptor variableAccessorDescriptor = this.descriptor.getGetter();
        if (variableAccessorDescriptor == null) {
            throw new IllegalStateException("Getter descriptor should not be null");
        }
        VariableAccessorDescriptor getterDescriptor = variableAccessorDescriptor;
        JsFunction $this$generateDefaultGetter_u24lambda_u242 = jsFunction = this.createFunction(getterDescriptor);
        boolean bl = false;
        JsNameRef delegateRef = new JsNameRef(this.context().getNameForBackingField(this.descriptor), (JsExpression)new JsThisRef());
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context(...)");
        new DefaultPropertyTranslator(this.descriptor, translationContext, delegateRef).generateDefaultGetterFunction(getterDescriptor, $this$generateDefaultGetter_u24lambda_u242);
        JsFunction defaultFunction = jsFunction;
        return this.generateDefaultAccessor(getterDescriptor, defaultFunction);
    }

    private final JsPropertyInitializer generateDefaultSetter() {
        JsFunction jsFunction;
        VariableAccessorDescriptor variableAccessorDescriptor = this.descriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw new IllegalStateException("Setter descriptor should not be null");
        }
        VariableAccessorDescriptor setterDescriptor = variableAccessorDescriptor;
        JsFunction $this$generateDefaultSetter_u24lambda_u243 = jsFunction = this.createFunction(setterDescriptor);
        boolean bl = false;
        JsNameRef delegateRef = new JsNameRef(this.context().getNameForBackingField(this.descriptor), (JsExpression)new JsThisRef());
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context(...)");
        new DefaultPropertyTranslator(this.descriptor, translationContext, delegateRef).generateDefaultSetterFunction(setterDescriptor, $this$generateDefaultSetter_u24lambda_u243);
        JsFunction defaultFunction = jsFunction;
        return this.generateDefaultAccessor(setterDescriptor, defaultFunction);
    }

    private final JsPropertyInitializer generateDefaultAccessor(VariableAccessorDescriptor accessorDescriptor, JsFunction function2) {
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function2, accessorDescriptor, this.context());
        Intrinsics.checkNotNullExpressionValue((Object)jsPropertyInitializer, (String)"translateFunctionAsEcma5PropertyDescriptor(...)");
        return jsPropertyInitializer;
    }

    private final JsPropertyInitializer translateCustomAccessor(KtPropertyAccessor expression2) {
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(this.bindingContext(), expression2);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionDescriptor(...)");
        FunctionDescriptor descriptor = functionDescriptor;
        JsFunction function2 = new JsFunction(this.context().getScopeForDescriptor(descriptor), new JsBlock(), descriptor.toString());
        function2.setSource(expression2);
        PsiElement psiElement = UtilsKt.getFinalElement(expression2);
        function2.getBody().setSource(psiElement instanceof LeafPsiElement ? (LeafPsiElement)psiElement : null);
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context(...)");
        List<JsParameter> list = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        FunctionTranslatorKt.translateFunction(FunctionTranslatorKt.translateAndAliasParameters(translationContext, descriptor, list), expression2, function2);
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function2, descriptor, this.context());
        Intrinsics.checkNotNullExpressionValue((Object)jsPropertyInitializer, (String)"translateFunctionAsEcma5PropertyDescriptor(...)");
        return jsPropertyInitializer;
    }

    private final JsFunction createFunction(VariableAccessorDescriptor descriptor) {
        JsFunction function2 = new JsFunction(this.context().getScopeForDescriptor(descriptor), new JsBlock(), this.accessorDescription(descriptor));
        SourceElement sourceElement = descriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psi = PsiSourceElementKt.getPsi(sourceElement);
        function2.setSource(psi);
        PsiElement psiElement = psi;
        PsiElement psiElement2 = psiElement != null ? UtilsKt.getFinalElement(psiElement) : null;
        function2.getBody().setSource(psiElement2 instanceof LeafPsiElement ? (LeafPsiElement)psiElement2 : null);
        return function2;
    }

    private final String accessorDescription(VariableAccessorDescriptor accessorDescriptor) {
        String string2;
        VariableAccessorDescriptor variableAccessorDescriptor = accessorDescriptor;
        if (variableAccessorDescriptor instanceof PropertyGetterDescriptor || variableAccessorDescriptor instanceof LocalVariableAccessorDescriptor.Getter) {
            string2 = "getter";
        } else if (variableAccessorDescriptor instanceof PropertySetterDescriptor || variableAccessorDescriptor instanceof LocalVariableAccessorDescriptor.Setter) {
            string2 = "setter";
        } else {
            throw new IllegalArgumentException("Unknown accessor type " + accessorDescriptor.getClass());
        }
        String accessorType = string2;
        String string3 = accessorDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        String name2 = string3;
        return accessorType + " for " + name2;
    }

    private static final JsPropertyInitializer translate$lambda$0(PropertyTranslator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.generateGetter();
    }

    private static final JsPropertyInitializer translate$lambda$1(PropertyTranslator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.generateSetter();
    }
}

