/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "computeMissingCases", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "ConditionChecker", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,496:1\n1619#2:497\n1863#2:498\n1864#2:500\n1620#2:501\n1628#2,3:502\n1#3:499\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker\n*L\n303#1:497\n303#1:498\n303#1:500\n303#1:501\n307#1:502,3\n303#1:499\n*E\n"})
final class WhenOnEnumExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnEnumExhaustivenessChecker INSTANCE = new WhenOnEnumExhaustivenessChecker();

    private WhenOnEnumExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(subjectType, session);
        FirRegularClassSymbol firRegularClassSymbol = firClassifierSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassifierSymbol : null;
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        return ((FirRegularClass)symbol.getFir()).getClassKind() == ClassKind.ENUM_CLASS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        void destination$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(subjectType, session);
        Intrinsics.checkNotNull(firClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol");
        FirRegularClass enumClass = (FirRegularClass)((FirRegularClassSymbol)firClassifierSymbol).getFir();
        Iterable iterable = enumClass.getDeclarations();
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirEnumEntry it$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if ((it instanceof FirEnumEntry ? (FirEnumEntry)it : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set allEntries = (Set)destination$iv;
        Set checkedEntries = new LinkedHashSet();
        whenExpression.accept(ConditionChecker.INSTANCE, checkedEntries);
        Set notCheckedEntries = SetsKt.minus((Set)allEntries, (Iterable)checkedEntries);
        Iterable $this$mapTo$iv = notCheckedEntries;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            element$iv$iv = (FirEnumEntry)item$iv;
            Collection<WhenMissingCase> collection2 = destination;
            boolean bl = false;
            collection2.add(new WhenMissingCase.EnumCheckIsMissing(it.getSymbol().getCallableId()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "<init>", "()V", "visitEqualityOperatorCall", "", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "data", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker$ConditionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,496:1\n1#2:497\n43#3:498\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker$ConditionChecker\n*L\n313#1:498\n*E\n"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Set<FirEnumEntry>> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Set<FirEnumEntry> data) {
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirOperation it = equalityOperatorCall.getOperation();
            boolean bl = false;
            if (!(it == FirOperation.EQ || it == FirOperation.IDENTITY)) {
                return;
            }
            FirCall $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
            FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReferenceUnsafe(argument);
            FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            FirVariableSymbol firVariableSymbol = firBasedSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firBasedSymbol : null;
            if (firVariableSymbol == null) {
                return;
            }
            FirVariableSymbol symbol = firVariableSymbol;
            Object e = symbol.getFir();
            FirEnumEntry firEnumEntry = e instanceof FirEnumEntry ? (FirEnumEntry)e : null;
            if (firEnumEntry == null) {
                return;
            }
            FirEnumEntry checkedEnumEntry = firEnumEntry;
            data.add(checkedEnumEntry);
        }
    }
}

