/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.resolve.jvm.checkers.PolymorphicSignatureCallChecker;

@PhaseDescription(name="PolymorphicSignature", description="Replace polymorphic methods with fake ones according to types at the call site")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\f\u0010!\u001a\u00020\u000f*\u00020 H\u0002J\u0016\u0010\"\u001a\u00020 *\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "isCast", "", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "data", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isPolymorphicCall", "transform", "castReturnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Data", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nPolymorphicSignatureLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolymorphicSignatureLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,140:1\n1557#2:141\n1628#2,3:142\n1872#2,3:149\n237#3,4:145\n*S KotlinDebug\n*F\n+ 1 PolymorphicSignatureLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering\n*L\n107#1:141\n107#1:142,3\n135#1:149,3\n114#1:145,4\n*E\n"})
public final class PolymorphicSignatureLowering
implements IrElementTransformer<Data>,
FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public PolymorphicSignatureLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.PolymorphicSignature)) {
            irFile.transformChildren(this, new Data(null));
        }
    }

    private final boolean isCast(IrTypeOperatorCall $this$isCast) {
        return $this$isCast.getOperator() != IrTypeOperator.INSTANCEOF && $this$isCast.getOperator() != IrTypeOperator.NOT_INSTANCEOF;
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        element2.transformChildren(this, Data.Companion.getNO_COERCION());
        return element2;
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpression argument = expression2.getArgument();
        if (this.isCast(expression2)) {
            IrTypeOperatorCall irTypeOperatorCall;
            IrElement result2 = argument.transform((IrElementTransformer)this, new Data(expression2.getTypeOperand()));
            if (argument instanceof IrCall && this.isPolymorphicCall((IrCall)argument)) {
                return result2;
            }
            IrTypeOperatorCall $this$visitTypeOperator_u24lambda_u240 = irTypeOperatorCall = expression2;
            boolean bl = false;
            $this$visitTypeOperator_u24lambda_u240.setArgument((IrExpression)result2);
            return irTypeOperatorCall;
        }
        return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        aTry.setTryResult((IrExpression)aTry.getTryResult().transform((IrElementTransformer)this, data));
        TransformKt.transformInPlace(aTry.getCatches(), (IrElementTransformer)this, data);
        IrExpression irExpression = aTry.getFinallyExpression();
        aTry.setFinallyExpression((IrExpression)(irExpression != null ? irExpression.transform((IrElementTransformer)this, Data.Companion.getNO_COERCION()) : null));
        return aTry;
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TransformKt.transformInPlace(expression2.getBranches(), (IrElementTransformer)this, data);
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List<IrStatement> statements = expression2.getStatements();
        int n = statements.size();
        for (int i = 0; i < n; ++i) {
            Data newData = i == CollectionsKt.getLastIndex(statements) ? data : Data.Companion.getNO_COERCION();
            IrElement irElement = statements.get(i).transform(this, newData);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
            statements.set(i, (IrStatement)irElement);
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.isPolymorphicCall(expression2) ? (IrElement)this.transform(expression2, data.getCoerceToType()) : IrElementTransformer.DefaultImpls.visitCall(this, expression2, Data.Companion.getNO_COERCION());
    }

    private final boolean isPolymorphicCall(IrCall $this$isPolymorphicCall) {
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isPolymorphicCall.getSymbol().getOwner(), PolymorphicSignatureCallChecker.polymorphicSignatureFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall transform(IrCall $this$transform, IrType castReturnType) {
        IrType irType;
        List list;
        IrExpression it;
        boolean bl;
        IrSimpleFunction function2 = (IrSimpleFunction)$this$transform.getSymbol().getOwner();
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(function2.getValueParameters());
        boolean bl2 = bl = (irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PolymorphicSignatureLowering$transform$22 = false;
            String $i$a$-assert-PolymorphicSignatureLowering$transform$22 = "@PolymorphicSignature methods should only have a single vararg argument: " + DumpIrTreeKt.dump$default($this$transform, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-PolymorphicSignatureLowering$transform$22);
        }
        Object object = (IrVararg)$this$transform.getValueArgument(0);
        if (object != null && (object = ((IrVararg)object).getElements()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrExpression irExpression;
                IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                IrExpression irExpression2 = it;
                if (irExpression2 instanceof IrExpression) {
                    irExpression = it;
                } else if (irExpression2 instanceof IrSpreadElement) {
                    irExpression = ((IrSpreadElement)((Object)it)).getExpression();
                } else {
                    throw new AssertionError((Object)("unknown IrVarargElement: " + it));
                }
                collection.add(irExpression);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List values2 = list;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$transform_u24lambda_u2462 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl4 = false;
        $this$transform_u24lambda_u2462.updateFrom(function2);
        $this$transform_u24lambda_u2462.setName(function2.getName());
        $this$transform_u24lambda_u2462.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getPOLYMORPHIC_SIGNATURE_INSTANTIATION());
        if (IrTypePredicatesKt.isNullableAny(function2.getReturnType())) {
            irType = castReturnType;
            if (irType == null) {
                irType = function2.getReturnType();
            }
        } else {
            irType = function2.getReturnType();
        }
        $this$transform_u24lambda_u2462.setReturnType(irType);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        IrSimpleFunction $this$transform_u24lambda_u244 = irElementBase;
        boolean bl5 = false;
        $this$transform_u24lambda_u244.setParent(function2.getParent());
        IrUtilsKt.copyTypeParametersFrom$default($this$transform_u24lambda_u244, function2, null, null, 6, null);
        $this$transform_u24lambda_u244.setDispatchReceiverParameter(function2.getDispatchReceiverParameter());
        $this$transform_u24lambda_u244.setExtensionReceiverParameter(function2.getExtensionReceiverParameter());
        Iterator $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = ((Iterable)values2).iterator();
        int $this$transform_u24lambda_u2462 = 0;
        while ($i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.hasNext()) {
            int i = $this$transform_u24lambda_u2462++;
            IrExpression value2 = (IrExpression)$i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.next();
            DeclarationBuildersKt.addValueParameter((IrFunction)$this$transform_u24lambda_u244, "" + '$' + i, value2.getType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getPOLYMORPHIC_SIGNATURE_INSTANTIATION());
        }
        IrSimpleFunction fakeFunction = irElementBase;
        IrElementBase $this$transform_u24lambda_u245 = irElementBase = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$transform.getStartOffset(), $this$transform.getEndOffset(), fakeFunction.getReturnType(), fakeFunction.getSymbol(), 0, 0, $this$transform.getOrigin(), $this$transform.getSuperQualifierSymbol(), 48, null);
        boolean bl6 = false;
        IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$transform_u24lambda_u245, $this$transform, 0, 2, null);
        ((IrCallImpl)$this$transform_u24lambda_u245).setDispatchReceiver($this$transform.getDispatchReceiver());
        ((IrCallImpl)$this$transform_u24lambda_u245).setExtensionReceiver($this$transform.getExtensionReceiver());
        Iterable $this$forEachIndexed$iv = values2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p1;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (IrExpression)item$iv;
            int p0 = n;
            boolean bl7 = false;
            ((IrMemberAccessExpression)$this$transform_u24lambda_u245).putValueArgument(p0, (IrExpression)p1);
        }
        ((IrMemberAccessExpression)$this$transform_u24lambda_u245).transformChildren(this, Data.Companion.getNO_COERCION());
        return (IrCall)irElementBase;
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "", "coerceToType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getCoerceToType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "Companion", "backend.jvm.lower"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final IrType coerceToType;
        @NotNull
        private static final Data NO_COERCION = new Data(null);

        public Data(@Nullable IrType coerceToType) {
            this.coerceToType = coerceToType;
        }

        @Nullable
        public final IrType getCoerceToType() {
            return this.coerceToType;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data$Companion;", "", "<init>", "()V", "NO_COERCION", "Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "getNO_COERCION", "()Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "backend.jvm.lower"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Data getNO_COERCION() {
                return NO_COERCION;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

