/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmOverloadsAnnotationLowering;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@PhaseDescription(name="MainMethodGeneration", description="Generate main bridges to parameterless mains, and wrappers for suspend mains.", prerequisite={JvmOverloadsAnnotationLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u000b*\u00020\fH\u0002J1\u0010\u000e\u001a\u00020\f*\u00020\t2#\u0010\u000f\u001a\u001f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0002\b\u0013H\u0002J&\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/MainMethodGenerationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isParameterlessMainMethod", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isMainMethod", "generateMainMethod", "makeBody", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/ExtensionFunctionType;", "irRunSuspend", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "target", "args", "newMain", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nMainMethodGenerationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainMethodGenerationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/MainMethodGenerationLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,211:1\n1#2:212\n249#3:213\n243#3:214\n237#3,10:215\n351#3,9:225\n50#3,4:260\n80#3:264\n74#3,10:265\n289#3:287\n283#3,13:288\n416#4,10:234\n388#4,13:246\n416#4,10:275\n416#4,10:301\n72#5,2:244\n72#5,2:285\n72#5,2:311\n98#6:259\n99#6:313\n*S KotlinDebug\n*F\n+ 1 MainMethodGenerationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/MainMethodGenerationLowering\n*L\n115#1:213\n115#1:214\n115#1:215,10\n122#1:225,9\n136#1:260,4\n155#1:264\n155#1:265,10\n176#1:287\n176#1:288,13\n126#1:234,10\n135#1:246,13\n167#1:275,10\n183#1:301,10\n126#1:244,2\n167#1:285,2\n183#1:311,2\n135#1:259\n135#1:313\n*E\n"})
public final class MainMethodGenerationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public MainMethodGenerationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        block8: {
            Object v1;
            block7: {
                Sequence<IrSimpleFunction> mainMethod;
                Object v0;
                IrSimpleFunction it;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
                    if (!this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                        return;
                    }
                    if (!IrUtilsKt.isFileClass(irClass)) {
                        return;
                    }
                    Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions(irClass);
                    for (Object e : sequence2) {
                        it = (IrSimpleFunction)e;
                        boolean bl = false;
                        if (!this.isMainMethod(it)) continue;
                        v0 = e;
                        break block6;
                    }
                    v0 = null;
                }
                Sequence<IrSimpleFunction> sequence3 = v0;
                if (sequence3 != null) {
                    mainMethod = sequence3;
                    boolean bl = false;
                    if (mainMethod.isSuspend()) {
                        this.generateMainMethod(irClass, (Function3<? super IrBlockBodyBuilder, ? super IrSimpleFunction, ? super IrValueParameter, Unit>)((Function3)(arg_0, arg_1, arg_2) -> MainMethodGenerationLowering.lower$lambda$2$lambda$1(this, mainMethod, arg_0, arg_1, arg_2)));
                    }
                    return;
                }
                mainMethod = IrUtilsKt.getFunctions(irClass);
                for (Object e : mainMethod) {
                    it = (IrSimpleFunction)e;
                    boolean bl = false;
                    if (!this.isParameterlessMainMethod(it)) continue;
                    v1 = e;
                    break block7;
                }
                v1 = null;
            }
            IrSimpleFunction irSimpleFunction = v1;
            if (irSimpleFunction == null) break block8;
            IrSimpleFunction parameterlessMainMethod = irSimpleFunction;
            boolean bl = false;
            this.generateMainMethod(irClass, (Function3<? super IrBlockBodyBuilder, ? super IrSimpleFunction, ? super IrValueParameter, Unit>)((Function3)(arg_0, arg_1, arg_2) -> MainMethodGenerationLowering.lower$lambda$5$lambda$4(parameterlessMainMethod, this, arg_0, arg_1, arg_2)));
        }
    }

    private final boolean isParameterlessMainMethod(IrSimpleFunction $this$isParameterlessMainMethod) {
        return $this$isParameterlessMainMethod.getTypeParameters().isEmpty() && $this$isParameterlessMainMethod.getExtensionReceiverParameter() == null && $this$isParameterlessMainMethod.getValueParameters().isEmpty() && IrTypePredicatesKt.isUnit($this$isParameterlessMainMethod.getReturnType()) && Intrinsics.areEqual((Object)$this$isParameterlessMainMethod.getName().asString(), (Object)"main");
    }

    private final boolean isMainMethod(IrSimpleFunction $this$isMainMethod) {
        boolean bl;
        IrTypeArgument argType;
        String string2 = JvmIrUtilsKt.getJvmNameFromAnnotation($this$isMainMethod);
        if (string2 == null) {
            String string3 = $this$isMainMethod.getName().asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        }
        if (!Intrinsics.areEqual((Object)string2, (Object)"main")) {
            return false;
        }
        if (!IrTypePredicatesKt.isUnit($this$isMainMethod.getReturnType())) {
            return false;
        }
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(IrUtilsKt.getAllParameters($this$isMainMethod));
        if (irValueParameter == null) {
            return false;
        }
        IrValueParameter parameter2 = irValueParameter;
        if (!IrTypePredicatesKt.isArray(parameter2.getType()) && !IrTypePredicatesKt.isNullableArray(parameter2.getType())) {
            return false;
        }
        IrType irType = parameter2.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrTypeArgument irTypeArgument = argType = (IrTypeArgument)CollectionsKt.first(((IrSimpleType)irType).getArguments());
        if (irTypeArgument instanceof IrTypeProjection) {
            bl = ((IrTypeProjection)argType).getVariance() != Variance.IN_VARIANCE && IrTypePredicatesKt.isStringClassType(((IrTypeProjection)argType).getType());
        } else if (irTypeArgument instanceof IrStarProjection) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateMainMethod(IrClass $this$generateMainMethod, Function3<? super IrBlockBodyBuilder, ? super IrSimpleFunction, ? super IrValueParameter, Unit> makeBody) {
        void $this$generateMainMethod_u24lambda_u249_u24lambda_u248;
        void this_$iv$iv;
        IrValueParameter irValueParameter;
        Object object;
        IrClass $this$addFunction$iv = $this$generateMainMethod;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$generateMainMethod_u24lambda_u246 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
        boolean $i$a$-addFunction-MainMethodGenerationLowering$generateMainMethod$22 = false;
        $this$generateMainMethod_u24lambda_u246.setName(Name.identifier("main"));
        $this$generateMainMethod_u24lambda_u246.setVisibility(DescriptorVisibilities.PUBLIC);
        $this$generateMainMethod_u24lambda_u246.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$generateMainMethod_u24lambda_u246.setModality(Modality.OPEN);
        $this$generateMainMethod_u24lambda_u246.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_EXTENDED_MAIN());
        Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2420$iv$iv$iv);
        boolean bl2 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        ((IrDeclarationBase)function$iv$iv).setParent($this$addFunction$iv);
        Object $this$generateMainMethod_u24lambda_u249 = object = $this$buildFun$iv$iv$iv;
        boolean bl3 = false;
        IrFunction $this$addValueParameter$iv = (IrFunction)$this$generateMainMethod_u24lambda_u249;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv = new IrValueParameterBuilder();
        boolean bl4 = false;
        Object $this$generateMainMethod_u24lambda_u249_u24lambda_u247 = $this$addValueParameter_u24lambda_u2432$iv;
        boolean bl5 = false;
        ((IrDeclarationBuilder)$this$generateMainMethod_u24lambda_u249_u24lambda_u247).setName(Name.identifier("args"));
        IrType[] $i$a$-addFunction-MainMethodGenerationLowering$generateMainMethod$22 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        ((IrValueParameterBuilder)$this$generateMainMethod_u24lambda_u249_u24lambda_u247).setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), $i$a$-addFunction-MainMethodGenerationLowering$generateMainMethod$22));
        if ($this$addValueParameter_u24lambda_u2432$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2432$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2432$iv, $this$addValueParameter$iv);
        boolean bl6 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        IrValueParameter args = irValueParameter;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrSimpleFunction)$this$generateMainMethod_u24lambda_u249).getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        $this$generateMainMethod_u24lambda_u249_u24lambda_u247 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        $i$a$-addFunction-MainMethodGenerationLowering$generateMainMethod$22 = this_$iv$iv;
        Object object2 = $this$generateMainMethod_u24lambda_u249;
        boolean bl7 = false;
        makeBody.invoke((Object)$this$generateMainMethod_u24lambda_u249_u24lambda_u248, $this$generateMainMethod_u24lambda_u249, (Object)args);
        ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression irRunSuspend(IrBuilderWithScope $this$irRunSuspend, IrSimpleFunction target, IrValueParameter args, IrSimpleFunction newMain) {
        void $this$irRunSuspend_u24lambda_u2424_u24lambda_u2423;
        void it;
        void $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
        void this_$iv$iv;
        IrValueParameter irValueParameter;
        void $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2415_u24lambda_u2414;
        IrCall irCall;
        void this_$iv$iv2;
        Object object;
        void this_$iv$iv3;
        JvmBackendContext backendContext = this.context;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$irRunSuspend;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$irRunSuspend_u24lambda_u2424 = this_$iv$iv3;
        boolean bl = false;
        IrFactory $this$buildClass$iv = backendContext.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl2 = false;
        IrClassBuilder $this$irRunSuspend_u24lambda_u2424_u24lambda_u2410 = $this$buildClass_u24lambda_u241$iv;
        boolean $i$a$-buildClass-MainMethodGenerationLowering$irRunSuspend$1$wrapperConstructor$22 = false;
        $this$irRunSuspend_u24lambda_u2424_u24lambda_u2410.setName(Name.special("<main-wrapper>"));
        $this$irRunSuspend_u24lambda_u2424_u24lambda_u2410.setVisibility(JavaDescriptorVisibilities.PACKAGE_VISIBILITY);
        $this$irRunSuspend_u24lambda_u2424_u24lambda_u2410.setModality(Modality.FINAL);
        $this$irRunSuspend_u24lambda_u2424_u24lambda_u2410.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL());
        IrElementBase wrapper = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        $this$irRunSuspend_u24lambda_u2424.unaryPlus((IrStatement)((Object)wrapper));
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor(wrapper);
        IrClassSymbol lambdaSuperClass = backendContext.getIr().getSymbols().getLambdaClass();
        Object functionClass = backendContext.getIr().getSymbols().getJvmSuspendFunctionClass(0);
        wrapper.setSuperTypes(CollectionsKt.plus((Collection)wrapper.getSuperTypes(), (Object)IrTypesKt.getDefaultType(lambdaSuperClass)));
        IrType[] $i$a$-buildClass-MainMethodGenerationLowering$irRunSuspend$1$wrapperConstructor$22 = new IrType[]{backendContext.getIrBuiltIns().getAnyNType()};
        wrapper.setSuperTypes(CollectionsKt.plus((Collection)wrapper.getSuperTypes(), (Object)IrTypesKt.typeWith((IrClassifierSymbol)functionClass, $i$a$-buildClass-MainMethodGenerationLowering$irRunSuspend$1$wrapperConstructor$22)));
        wrapper.setParent(newMain);
        IrType[] irTypeArray = new IrType[]{backendContext.getIrBuiltIns().getStringType()};
        IrSimpleType stringArrayType = IrTypesKt.typeWith((IrClassifierSymbol)backendContext.getIrBuiltIns().getArrayClass(), irTypeArray);
        IrValueParameter irValueParameter2 = args;
        if (irValueParameter2 != null) {
            IrValueParameter it2 = irValueParameter2;
            boolean bl4 = false;
            IrClass $this$addField$iv = wrapper;
            boolean $i$f$addField = false;
            Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
            boolean bl5 = false;
            IrFieldBuilder $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2412_u24lambda_u2411 = $this$buildField_u24lambda_u244$iv$iv;
            boolean bl6 = false;
            $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2412_u24lambda_u2411.setName(Name.identifier("args"));
            $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2412_u24lambda_u2411.setType(stringArrayType);
            $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2412_u24lambda_u2411.setVisibility(DescriptorVisibilities.PRIVATE);
            $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2412_u24lambda_u2411.setOrigin(LocalDeclarationsLowering.Companion.getDECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE());
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
            boolean bl7 = false;
            ((IrDeclarationBase)field$iv).setParent($this$addField$iv);
            $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
            object = $this$buildField$iv$iv;
        } else {
            object = null;
        }
        Object argsField = object;
        Object object2 = DeclarationBuildersKt.addFunction$default(wrapper, "invoke", backendContext.getIrBuiltIns().getAnyNType(), null, null, false, true, false, false, null, 0, 0, 2012, null);
        IrSimpleFunction invoke2 = object2;
        boolean bl8 = false;
        IrSimpleFunctionSymbol invokeToOverride = (IrSimpleFunctionSymbol)SequencesKt.single(IrUtilsKt.getFunctions((IrClassSymbol)functionClass));
        invoke2.setOverriddenSymbols(CollectionsKt.plus((Collection)invoke2.getOverriddenSymbols(), (Object)invokeToOverride));
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(backendContext, (IrSymbol)invoke2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv2 = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv2 = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder bl5 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv2, endOffset$iv2);
        boolean $i$f$blockBody = false;
        void bl6 = this_$iv$iv2;
        IrSimpleFunction irSimpleFunction = invoke2;
        boolean bl9 = false;
        IrFunctionAccessExpression irFunctionAccessExpression = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2415_u24lambda_u2414, target.getSymbol());
        Object object3 = (IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2415_u24lambda_u2414;
        void var39_70 = $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2415_u24lambda_u2414;
        boolean bl10 = false;
        if (args != null) {
            void call2;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2415_u24lambda_u2414;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2415_u24lambda_u2414;
            IrValueParameter irValueParameter3 = invoke2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter3);
            IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter3);
            Object object4 = argsField;
            Intrinsics.checkNotNull((Object)object4);
            call2.putValueArgument(0, ExpressionHelpersKt.irGetField$default(irBuilderWithScope, irExpression, (IrField)object4, null, 4, null));
        }
        Unit unit = Unit.INSTANCE;
        var39_70.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)object3, irCall));
        irSimpleFunction.setBody(this_$iv$iv2.doBuild());
        IrClass $this$addConstructor$iv = wrapper;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
        boolean bl11 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
        boolean bl12 = false;
        IrFunctionBuilder $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2416 = $this$addConstructor_u24lambda_u2425$iv;
        boolean $i$a$-addConstructor-MainMethodGenerationLowering$irRunSuspend$1$wrapperConstructor$2$32 = false;
        $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2416.setPrimary(true);
        $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2416.setVisibility(JavaDescriptorVisibilities.PACKAGE_VISIBILITY);
        $this$addConstructor_u24lambda_u2425$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2424$iv$iv);
        boolean bl13 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        ((IrDeclarationBase)constructor$iv).setParent($this$addConstructor$iv);
        Object constructor = object2 = $this$buildConstructor$iv$iv;
        boolean bl14 = false;
        IrConstructor superClassConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)lambdaSuperClass.getOwner()));
        IrValueParameter irValueParameter4 = args;
        if (irValueParameter4 != null) {
            IrValueParameter it3 = irValueParameter4;
            boolean bl15 = false;
            irValueParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)constructor, "args", (IrType)stringArrayType, null, 4, null);
        } else {
            irValueParameter = null;
        }
        IrValueParameter param = irValueParameter;
        IrBuilderWithScope $this$irBlockBody_u24default$iv2 = LowerUtilsKt.createIrBuilder$default(backendContext, (IrSymbol)((IrConstructor)constructor).getSymbol(), 0, 0, 6, null);
        int startOffset$iv3 = $this$irBlockBody_u24default$iv2.getStartOffset();
        int endOffset$iv3 = $this$irBlockBody_u24default$iv2.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder $i$a$-addConstructor-MainMethodGenerationLowering$irRunSuspend$1$wrapperConstructor$2$32 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv2.getContext(), $this$irBlockBody_u24default$iv2.getScope(), startOffset$iv3, endOffset$iv3);
        boolean $i$f$blockBody2 = false;
        irSimpleFunction = this_$iv$iv;
        Object object5 = constructor;
        boolean bl16 = false;
        irFunctionAccessExpression = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419, superClassConstructor);
        object3 = irFunctionAccessExpression;
        var39_70 = $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
        boolean bl17 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419, 1, null, 2, null));
        var39_70.unaryPlus(irFunctionAccessExpression);
        if (args != null) {
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
            IrValueParameter irValueParameter5 = wrapper.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter5);
            IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope3, irValueParameter5);
            Object object6 = argsField;
            Intrinsics.checkNotNull((Object)object6);
            IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
            IrValueParameter irValueParameter6 = param;
            Intrinsics.checkNotNull((Object)irValueParameter6);
            $this$irRunSuspend_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, irExpression, (IrField)object6, ExpressionHelpersKt.irGet(irBuilderWithScope4, irValueParameter6), null, 8, null));
        }
        ((IrFunction)object5).setBody(this_$iv$iv.doBuild());
        Object wrapperConstructor = object2;
        IrCall irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424, backendContext.getIr().getSymbols().getRunSuspendFunction());
        wrapper = irCall2;
        void var43_74 = $this$irRunSuspend_u24lambda_u2424;
        boolean bl18 = false;
        IrConstructorCallImpl irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, ((IrFunction)wrapperConstructor).getReturnType(), ((IrConstructor)wrapperConstructor).getSymbol(), null, 16, null);
        functionClass = irConstructorCallImpl;
        int n = 0;
        irTypeArray = $this$irRunSuspend_u24lambda_u2424_u24lambda_u2423;
        boolean bl19 = false;
        if (args != null) {
            void it4;
            it4.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$irRunSuspend_u24lambda_u2424, args));
        }
        Unit unit2 = Unit.INSTANCE;
        irTypeArray.putValueArgument(n, irConstructorCallImpl);
        var43_74.unaryPlus(irCall2);
        return this_$iv$iv3.doBuild();
    }

    private static final Unit lower$lambda$2$lambda$1(MainMethodGenerationLowering this$0, IrSimpleFunction $mainMethod, IrBlockBodyBuilder $this$generateMainMethod, IrSimpleFunction newMain, IrValueParameter args) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mainMethod, (String)"$mainMethod");
        Intrinsics.checkNotNullParameter((Object)$this$generateMainMethod, (String)"$this$generateMainMethod");
        Intrinsics.checkNotNullParameter((Object)newMain, (String)"newMain");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        $this$generateMainMethod.unaryPlus(this$0.irRunSuspend($this$generateMainMethod, $mainMethod, args, newMain));
        return Unit.INSTANCE;
    }

    private static final Unit lower$lambda$5$lambda$4(IrSimpleFunction $parameterlessMainMethod, MainMethodGenerationLowering this$0, IrBlockBodyBuilder $this$generateMainMethod, IrSimpleFunction newMain, IrValueParameter irValueParameter) {
        Intrinsics.checkNotNullParameter((Object)$parameterlessMainMethod, (String)"$parameterlessMainMethod");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$generateMainMethod, (String)"$this$generateMainMethod");
        Intrinsics.checkNotNullParameter((Object)newMain, (String)"newMain");
        Intrinsics.checkNotNullParameter((Object)irValueParameter, (String)"<unused var>");
        if ($parameterlessMainMethod.isSuspend()) {
            $this$generateMainMethod.unaryPlus(this$0.irRunSuspend($this$generateMainMethod, $parameterlessMainMethod, null, newMain));
        } else {
            $this$generateMainMethod.unaryPlus(ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateMainMethod, $parameterlessMainMethod));
        }
        return Unit.INSTANCE;
    }
}

