/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithArgs;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ContextReceiversListStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilderKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFlexibleTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinNameReferenceExpressionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeArgumentBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeProjectionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JP\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u001a\b\u0002\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u0012J \u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J2\u0010\u0016\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J&\u0010\u001a\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J*\u0010\u001f\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u001e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ*\u0010!\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000fH\u0002J\f\u0010*\u001a\u00020+*\u00020,H\u0002J8\u0010-\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u000202H\u0002J>\u00103\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u000f2\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020;J6\u0010<\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\f0=0\u000f2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u000fJ0\u0010@\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0018\u0010A\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\f0=0\u000fJ\u0018\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020?H\u0002J\f\u0010F\u001a\u00020/*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder;", "", "c", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "<init>", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;)V", "createTypeReferenceStub", "", "parent", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "type", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "additionalAnnotations", "Lkotlin/Function0;", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithTarget;", "loadTypeAnnotations", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithArgs;", "nullableTypeParent", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl;", "createTypeParameterStub", "name", "Lorg/jetbrains/kotlin/name/Name;", "annotations", "createDefinitelyNotNullTypeStub", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "upperBoundType", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;", "createClassReferenceTypeStub", "createKotlinTypeBean", "createTypeAnnotationStubs", "getTypeModifiersAsWritten", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "createTypeArgumentListStub", "typeStub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinUserTypeStub;", "typeArgumentProtoList", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "toProjectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument$Projection;", "createFunctionTypeStub", "isExtensionFunctionType", "", "isSuspend", "numContextReceivers", "", "createValueParameterListStub", "callableProto", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "parameters", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "container", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "callableKind", "Lorg/jetbrains/kotlin/serialization/deserialization/AnnotatedCallableKind;", "createTypeParameterListStub", "Lkotlin/Pair;", "typeParameterProtoList", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "createTypeConstraintListStub", "protosForTypeConstraintList", "createTypeParameterModifierListStub", "typeParameterStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeParameterStubImpl;", "typeParameterProto", "isDefaultUpperBound", "decompiler-to-stubs"})
@SourceDebugExtension(value={"SMAP\nTypeClsStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n827#2:454\n855#2,2:455\n1557#2:457\n1628#2,3:458\n2632#2,3:461\n3193#2,10:464\n3193#2,10:474\n1557#2:485\n1628#2,3:486\n1863#2,2:489\n1557#2:491\n1628#2,3:492\n1557#2:495\n1628#2,3:496\n1#3:484\n*S KotlinDebug\n*F\n+ 1 TypeClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder\n*L\n51#1:454\n51#1:455,2\n56#1:457\n56#1:458,3\n115#1:461,3\n117#1:464,10\n121#1:474,10\n183#1:485\n183#1:486,3\n224#1:489,2\n259#1:491\n259#1:492,3\n398#1:495\n398#1:496,3\n*E\n"})
public final class TypeClsStubBuilder {
    @NotNull
    private final ClsStubBuilderContext c;

    public TypeClsStubBuilder(@NotNull ClsStubBuilderContext c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.c = c;
    }

    /*
     * WARNING - void declaration
     */
    public final void createTypeReferenceStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ProtoBuf.Type type2, @NotNull Function0<? extends List<AnnotationWithTarget>> additionalAnnotations, @NotNull Function1<? super ProtoBuf.Type, ? extends List<AnnotationWithArgs>> loadTypeAnnotations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(additionalAnnotations, (String)"additionalAnnotations");
        Intrinsics.checkNotNullParameter(loadTypeAnnotations, (String)"loadTypeAnnotations");
        ProtoBuf.Type abbreviatedType = ProtoTypeTableUtilKt.abbreviatedType(type2, this.c.getTypeTable());
        if (abbreviatedType != null) {
            TypeClsStubBuilder.createTypeReferenceStub$default(this, parent2, abbreviatedType, additionalAnnotations, null, 8, null);
            return;
        }
        KotlinPlaceHolderStubImpl typeReference = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.TYPE_REFERENCE);
        List allAnnotationsInType = (List)loadTypeAnnotations.invoke((Object)type2);
        Iterable $this$filterNot$iv = allAnnotationsInType;
        boolean $i$f$filterNot22 = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AnnotationWithArgs it = (AnnotationWithArgs)element$iv$iv;
            boolean bl = false;
            boolean isTopLevelClass = !it.getClassId().isNestedClass();
            if (isTopLevelClass && TypeClsStubBuilderKt.access$getANNOTATIONS_NOT_LOADED_FOR_TYPES$p().contains(it.getClassId().asSingleFqName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List annotations2 = (List)destination$iv$iv;
        Iterable $i$f$filterNot22 = annotations2;
        Collection collection = (Collection)additionalAnnotations.invoke();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnnotationWithArgs bl = (AnnotationWithArgs)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(new AnnotationWithTarget((AnnotationWithArgs)it, null));
        }
        List allAnnotations = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
        if (type2.hasClassName() || type2.hasTypeAliasName()) {
            this.createClassReferenceTypeStub(typeReference, type2, allAnnotations);
        } else if (type2.hasTypeParameter()) {
            this.createTypeParameterStub(typeReference, type2, this.c.getTypeParameters().get(type2.getTypeParameter()), allAnnotations);
        } else if (type2.hasTypeParameterName()) {
            this.createTypeParameterStub(typeReference, type2, NameResolverUtilKt.getName(this.c.getNameResolver(), type2.getTypeParameterName()), allAnnotations);
        } else {
            FunctionsKt.doNothing();
        }
    }

    public static /* synthetic */ void createTypeReferenceStub$default(TypeClsStubBuilder typeClsStubBuilder, StubElement stubElement, ProtoBuf.Type type2, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = TypeClsStubBuilder::createTypeReferenceStub$lambda$0;
        }
        if ((n & 8) != 0) {
            function1 = arg_0 -> TypeClsStubBuilder.createTypeReferenceStub$lambda$1(typeClsStubBuilder, arg_0);
        }
        typeClsStubBuilder.createTypeReferenceStub(stubElement, type2, (Function0<? extends List<AnnotationWithTarget>>)function0, (Function1<? super ProtoBuf.Type, ? extends List<AnnotationWithArgs>>)function1);
    }

    private final KotlinStubBaseImpl<?> nullableTypeParent(KotlinStubBaseImpl<?> parent2, ProtoBuf.Type type2) {
        return type2.getNullable() ? (KotlinStubBaseImpl)new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.NULLABLE_TYPE) : parent2;
    }

    private final void createTypeParameterStub(KotlinStubBaseImpl<?> parent2, ProtoBuf.Type type2, Name name2, List<AnnotationWithTarget> annotations2) {
        KotlinTypeBean kotlinTypeBean;
        this.createTypeAnnotationStubs(parent2, type2, annotations2);
        if (type2.hasFlexibleTypeCapabilitiesId()) {
            ProtoBuf.Type type3 = ProtoTypeTableUtilKt.flexibleUpperBound(type2, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type3);
            kotlinTypeBean = this.createKotlinTypeBean(type3);
        } else {
            kotlinTypeBean = null;
        }
        KotlinTypeBean upperBoundType = kotlinTypeBean;
        FqName fqName = FqName.topLevel(name2);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"topLevel(...)");
        ClassId typeParameterClassId = ClassId.Companion.topLevel(fqName);
        if (Flags.DEFINITELY_NOT_NULL_TYPE.get(type2.getFlags()).booleanValue()) {
            this.createDefinitelyNotNullTypeStub(parent2, typeParameterClassId, upperBoundType);
        } else {
            KotlinStubBaseImpl<?> nullableParentWrapper = this.nullableTypeParent(parent2, type2);
            ClsStubBuildingKt.createStubForTypeName$default(typeParameterClassId, nullableParentWrapper, arg_0 -> TypeClsStubBuilder.createTypeParameterStub$lambda$4(upperBoundType, arg_0), null, 8, null);
        }
    }

    private final void createDefinitelyNotNullTypeStub(KotlinStubBaseImpl<?> parent2, ClassId classId, KotlinTypeBean upperBoundType) {
        KotlinPlaceHolderStubImpl intersectionType = new KotlinPlaceHolderStubImpl(parent2, KtStubElementTypes.INTERSECTION_TYPE);
        KotlinPlaceHolderStubImpl leftReference = new KotlinPlaceHolderStubImpl((StubElement)intersectionType, KtStubElementTypes.TYPE_REFERENCE);
        ClsStubBuildingKt.createStubForTypeName$default(classId, leftReference, arg_0 -> TypeClsStubBuilder.createDefinitelyNotNullTypeStub$lambda$5(upperBoundType, arg_0), null, 8, null);
        KotlinPlaceHolderStubImpl rightReference = new KotlinPlaceHolderStubImpl((StubElement)intersectionType, KtStubElementTypes.TYPE_REFERENCE);
        KotlinUserTypeStubImpl userType = new KotlinUserTypeStubImpl(rightReference, null, 2, null);
        StubElement stubElement = userType;
        Name name2 = StandardNames.FqNames.any.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
        new KotlinNameReferenceExpressionStubImpl(stubElement, ClsStubBuildingKt.ref(name2), true);
    }

    /*
     * Unable to fully structure code
     */
    private final void createClassReferenceTypeStub(KotlinStubBaseImpl<?> parent, ProtoBuf.Type type, List<AnnotationWithTarget> annotations) {
        block17: {
            if (type.hasFlexibleTypeCapabilitiesId() && Intrinsics.areEqual((Object)(id = this.c.getNameResolver().getString(type.getFlexibleTypeCapabilitiesId())), (Object)"kotlin.DynamicType")) {
                new KotlinPlaceHolderStubImpl<T>(this.nullableTypeParent(parent, type), KtStubElementTypes.DYNAMIC_TYPE);
                return;
            }
            v0 = id = type.hasClassName() != false || type.hasTypeAliasName() != false;
            if (_Assertions.ENABLED && !id) {
                $i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1 = false;
                $i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1 = "Class reference stub must have either class or type alias name";
                throw new AssertionError((Object)$i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1);
            }
            classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), type.hasClassName() != false ? type.getClassName() : type.getTypeAliasName());
            if (!FunctionTypesKt.isBuiltinFunctionClass(classId)) ** GOTO lbl-1000
            v1 = type.getArgumentList();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"getArgumentList(...)");
            $this$none$iv = v1;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (ProtoBuf.Type.Argument)element$iv;
                    $i$a$-none-TypeClsStubBuilder$createClassReferenceTypeStub$shouldBuildAsFunctionType$1 = false;
                    if (!(it.getProjection() == ProtoBuf.Type.Argument.Projection.STAR)) continue;
                    v2 = false;
                    break block17;
                }
                v2 = true;
            }
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = shouldBuildAsFunctionType = false;
        }
        if (shouldBuildAsFunctionType) {
            $this$partition$iv = annotations;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (AnnotationWithTarget)element$iv;
                $i$a$-partition-TypeClsStubBuilder$createClassReferenceTypeStub$2 = false;
                if (Intrinsics.areEqual((Object)it.getAnnotationWithArgs().getClassId().asSingleFqName(), (Object)StandardNames.FqNames.extensionFunctionType)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            $this$none$iv = new Pair(first$iv, second$iv);
            extensionAnnotations = (List)$this$none$iv.component1();
            notExtensionAnnotations = (List)$this$none$iv.component2();
            $this$partition$iv = notExtensionAnnotations;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (AnnotationWithTarget)element$iv;
                $i$a$-partition-TypeClsStubBuilder$createClassReferenceTypeStub$3 = false;
                if (Intrinsics.areEqual((Object)it.getAnnotationWithArgs().getClassId().asSingleFqName(), (Object)StandardNames.FqNames.contextFunctionTypeParams)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            var9_16 = new Pair(first$iv, second$iv);
            contextReceiverAnnotations = (List)var9_16.component1();
            otherAnnotations = (List)var9_16.component2();
            isExtension = ((Collection)extensionAnnotations).isEmpty() == false;
            v4 = Flags.SUSPEND_TYPE.get(type.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
            isSuspend = v4;
            if (isSuspend) {
                wrapper = this.nullableTypeParent(parent, type);
                this.createTypeAnnotationStubs(wrapper, type, otherAnnotations);
                v5 = wrapper;
            } else {
                this.createTypeAnnotationStubs(parent, type, otherAnnotations);
                v5 = nullableWrapper = this.nullableTypeParent(parent, type);
            }
            if (contextReceiverAnnotations.isEmpty()) {
                v6 = 0;
            } else {
                block18: {
                    v7 = type.getExtension(JvmProtoBuf.typeAnnotation);
                    Intrinsics.checkNotNullExpressionValue(v7, (String)"getExtension(...)");
                    var18_32 = v7;
                    for (T var20_34 : var18_32) {
                        it = (ProtoBuf.Annotation)var20_34;
                        $i$a$-find-TypeClsStubBuilder$createClassReferenceTypeStub$numContextReceivers$argument$1 = false;
                        if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getClassId(this.c.getNameResolver(), it.getId()).asSingleFqName(), (Object)StandardNames.FqNames.contextFunctionTypeParams)) continue;
                        v8 = var20_34;
                        break block18;
                    }
                    v8 = null;
                }
                Intrinsics.checkNotNull(v8);
                argument = ((ProtoBuf.Annotation)v8).getArgument(0);
                v6 = (int)argument.getValue().getIntValue();
            }
            numContextReceivers = v6;
            this.createFunctionTypeStub((StubElement<? extends PsiElement>)nullableWrapper, type, isExtension, isSuspend, numContextReceivers);
            return;
        }
        this.createTypeAnnotationStubs(parent, type, annotations);
        outerTypeChain = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)type, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createClassReferenceTypeStub$lambda$11(org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder org.jetbrains.kotlin.metadata.ProtoBuf$Type ), (Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;)Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;)((TypeClsStubBuilder)this)));
        ClsStubBuildingKt.createStubForTypeName(classId, (StubElement<? extends PsiElement>)this.nullableTypeParent(parent, type), (Function1<? super Integer, ? extends KotlinTypeBean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createClassReferenceTypeStub$lambda$12(org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder org.jetbrains.kotlin.metadata.ProtoBuf$Type java.util.List int ), (Ljava/lang/Integer;)Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;)((TypeClsStubBuilder)this, (ProtoBuf.Type)type, (List)outerTypeChain), (Function2<? super KotlinUserTypeStub, ? super Integer, Unit>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createClassReferenceTypeStub$lambda$14(java.util.List org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub int ), (Lorg/jetbrains/kotlin/psi/stubs/KotlinUserTypeStub;Ljava/lang/Integer;)Lkotlin/Unit;)((List)outerTypeChain, (TypeClsStubBuilder)this));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KotlinTypeBean createKotlinTypeBean(@Nullable ProtoBuf.Type type2) {
        KotlinTypeMarker kotlinTypeMarker;
        if (type2 == null) {
            return null;
        }
        Boolean bl = Flags.DEFINITELY_NOT_NULL_TYPE.get(type2.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        boolean definitelyNotNull = bl;
        if (type2.hasTypeParameter()) {
            String string2 = this.c.getTypeParameters().get(type2.getTypeParameter()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            KotlinTypeParameterTypeBean lowerBound = new KotlinTypeParameterTypeBean(string2, type2.getNullable(), definitelyNotNull);
            kotlinTypeMarker = lowerBound;
        } else if (type2.hasTypeParameterName()) {
            kotlinTypeMarker = new KotlinTypeParameterTypeBean(this.c.getNameResolver().getString(type2.getTypeParameterName()), type2.getNullable(), definitelyNotNull);
        } else {
            void $this$mapTo$iv$iv;
            ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), type2.hasClassName() ? type2.getClassName() : type2.getTypeAliasName());
            List<ProtoBuf.Type.Argument> list = type2.getArgumentList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KotlinTypeBean kotlinTypeBean;
                void argument;
                ProtoBuf.Type.Argument argument2 = (ProtoBuf.Type.Argument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                ProtoBuf.Type.Argument.Projection projection = argument.getProjection();
                Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"getProjection(...)");
                KtProjectionKind kind = this.toProjectionKind(projection);
                if (kind == KtProjectionKind.STAR) {
                    kotlinTypeBean = null;
                } else {
                    Intrinsics.checkNotNull((Object)argument);
                    kotlinTypeBean = this.createKotlinTypeBean(ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)argument, this.c.getTypeTable()));
                }
                collection.add(new KotlinTypeArgumentBean(kind, kotlinTypeBean));
            }
            List arguments2 = (List)destination$iv$iv;
            kotlinTypeMarker = new KotlinClassTypeBean(classId, arguments2, type2.getNullable());
        }
        KotlinTypeMarker lowerBound = kotlinTypeMarker;
        KotlinTypeBean upperBoundBean = this.createKotlinTypeBean(ProtoTypeTableUtilKt.flexibleUpperBound(type2, this.c.getTypeTable()));
        return upperBoundBean != null ? (KotlinTypeBean)new KotlinFlexibleTypeBean((KotlinTypeBean)lowerBound, upperBoundBean) : (KotlinTypeBean)lowerBound;
    }

    private final void createTypeAnnotationStubs(KotlinStubBaseImpl<?> parent2, ProtoBuf.Type type2, List<AnnotationWithTarget> annotations2) {
        Set<KtModifierKeywordToken> typeModifiers = this.getTypeModifiersAsWritten(type2);
        if (annotations2.isEmpty() && typeModifiers.isEmpty()) {
            return;
        }
        long typeModifiersMask = ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, Boolean>)((Function1)arg_0 -> TypeClsStubBuilder.createTypeAnnotationStubs$lambda$16(typeModifiers, arg_0)));
        KotlinModifierListStubImpl modifiersList = new KotlinModifierListStubImpl(parent2, typeModifiersMask, KtStubElementTypes.MODIFIER_LIST);
        ClsStubBuildingKt.createTargetedAnnotationStubs(annotations2, modifiersList);
    }

    private final Set<KtModifierKeywordToken> getTypeModifiersAsWritten(ProtoBuf.Type type2) {
        if (!type2.hasClassName() && !type2.hasTypeAliasName()) {
            return SetsKt.emptySet();
        }
        HashSet<KtModifierKeywordToken> result2 = new HashSet<KtModifierKeywordToken>();
        if (Flags.SUSPEND_TYPE.get(type2.getFlags()).booleanValue()) {
            result2.add(KtTokens.SUSPEND_KEYWORD);
        }
        return result2;
    }

    private final void createTypeArgumentListStub(KotlinUserTypeStub typeStub, List<ProtoBuf.Type.Argument> typeArgumentProtoList) {
        if (typeArgumentProtoList.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl typeArgumentsListStub = new KotlinPlaceHolderStubImpl((StubElement)typeStub, KtStubElementTypes.TYPE_ARGUMENT_LIST);
        Iterable $this$forEach$iv = typeArgumentProtoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtoBuf.Type.Argument typeArgumentProto = (ProtoBuf.Type.Argument)element$iv;
            boolean bl = false;
            ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
            Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"getProjection(...)");
            KtProjectionKind projectionKind = this.toProjectionKind(projection);
            KotlinTypeProjectionStubImpl typeProjection = new KotlinTypeProjectionStubImpl((StubElement)typeArgumentsListStub, projectionKind.ordinal());
            if (projectionKind == KtProjectionKind.STAR) continue;
            KtSingleValueToken ktSingleValueToken = projectionKind.getToken();
            KtModifierKeywordToken modifierKeywordToken = ktSingleValueToken instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)ktSingleValueToken : null;
            ClsStubBuildingKt.createModifierListStub(typeProjection, CollectionsKt.listOfNotNull((Object)modifierKeywordToken));
            StubElement stubElement = typeProjection;
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type2);
            TypeClsStubBuilder.createTypeReferenceStub$default(this, stubElement, type2, null, null, 12, null);
        }
    }

    private final KtProjectionKind toProjectionKind(ProtoBuf.Type.Argument.Projection $this$toProjectionKind) {
        KtProjectionKind ktProjectionKind;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toProjectionKind.ordinal()]) {
            case 1: {
                ktProjectionKind = KtProjectionKind.IN;
                break;
            }
            case 2: {
                ktProjectionKind = KtProjectionKind.OUT;
                break;
            }
            case 3: {
                ktProjectionKind = KtProjectionKind.NONE;
                break;
            }
            case 4: {
                ktProjectionKind = KtProjectionKind.STAR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktProjectionKind;
    }

    /*
     * WARNING - void declaration
     */
    private final void createFunctionTypeStub(StubElement<? extends PsiElement> parent2, ProtoBuf.Type type2, boolean isExtensionFunctionType, boolean isSuspend, int numContextReceivers) {
        Object destination$iv$iv;
        List<ProtoBuf.Type.Argument> typeArgumentList = type2.getArgumentList();
        KotlinPlaceHolderStubImpl functionType = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.FUNCTION_TYPE);
        int processedTypes = 0;
        if (numContextReceivers != 0) {
            Object object;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = typeArgumentList.subList(processedTypes, processedTypes + numContextReceivers);
            StubElement stubElement = functionType;
            ContextReceiversListStubBuilder contextReceiversListStubBuilder = new ContextReceiversListStubBuilder(this.c);
            boolean $i$f$map = false;
            void var11_15 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                ProtoBuf.Type type3 = ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)it, this.c.getTypeTable());
                Intrinsics.checkNotNull((Object)type3);
                object.add(type3);
            }
            object = (List)destination$iv$iv;
            contextReceiversListStubBuilder.createContextReceiverStubs(stubElement, (List<ProtoBuf.Type>)object);
            processedTypes += numContextReceivers;
        }
        if (isExtensionFunctionType) {
            KotlinPlaceHolderStubImpl functionTypeReceiverStub = new KotlinPlaceHolderStubImpl((StubElement)functionType, KtStubElementTypes.FUNCTION_TYPE_RECEIVER);
            ProtoBuf.Type.Argument argument = typeArgumentList.get(processedTypes);
            Intrinsics.checkNotNullExpressionValue((Object)argument, (String)"get(...)");
            ProtoBuf.Type type4 = ProtoTypeTableUtilKt.type(argument, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type4);
            ProtoBuf.Type receiverTypeProto = type4;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionTypeReceiverStub, receiverTypeProto, null, null, 12, null);
            ++processedTypes;
        }
        KotlinPlaceHolderStubImpl parameterList2 = new KotlinPlaceHolderStubImpl((StubElement)functionType, KtStubElementTypes.VALUE_PARAMETER_LIST);
        List<ProtoBuf.Type.Argument> typeArgumentsWithoutReceiverAndReturnType = typeArgumentList.subList(processedTypes, typeArgumentList.size() - 1);
        ProtoBuf.Type suspendParameterType = null;
        destination$iv$iv = ((Iterable)typeArgumentsWithoutReceiverAndReturnType).iterator();
        int n = 0;
        while (destination$iv$iv.hasNext()) {
            ProtoBuf.Type parameterType;
            int index = n++;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)destination$iv$iv.next();
            Intrinsics.checkNotNull((Object)argument);
            Intrinsics.checkNotNull((Object)ProtoTypeTableUtilKt.type(argument, this.c.getTypeTable()));
            if (isSuspend && index == typeArgumentsWithoutReceiverAndReturnType.size() - 1 && parameterType.hasClassName() && parameterType.getArgumentCount() == 1) {
                boolean bl;
                ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), parameterType.getClassName());
                FqName fqName = classId.asSingleFqName();
                boolean bl2 = bl = Intrinsics.areEqual((Object)fqName, (Object)new FqName("kotlin.coroutines.Continuation")) || Intrinsics.areEqual((Object)fqName, (Object)new FqName("kotlin.coroutines.experimental.Continuation"));
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Last parameter type of suspend function must be Continuation, but it is " + fqName;
                    throw new AssertionError((Object)string2);
                }
                suspendParameterType = parameterType;
                continue;
            }
            List<AnnotationWithArgs> annotations2 = this.c.getComponents().getAnnotationLoader().loadTypeAnnotations(parameterType, this.c.getNameResolver());
            KotlinParameterStubImpl parameter2 = new KotlinParameterStubImpl(parameterList2, null, null, false, false, false, TypeClsStubBuilder.createFunctionTypeStub$getFunctionTypeParameterName(annotations2));
            TypeClsStubBuilder.createTypeReferenceStub$default(this, parameter2, parameterType, null, arg_0 -> TypeClsStubBuilder.createFunctionTypeStub$lambda$20(annotations2, arg_0), 4, null);
        }
        if (suspendParameterType == null) {
            Intrinsics.checkNotNull(typeArgumentList);
            Object object = CollectionsKt.last(typeArgumentList);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            ProtoBuf.Type type5 = ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)object, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type5);
            ProtoBuf.Type returnType2 = type5;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionType, returnType2, null, null, 12, null);
        } else {
            ProtoBuf.Type.Argument argument = suspendParameterType.getArgument(0);
            Intrinsics.checkNotNullExpressionValue((Object)argument, (String)"getArgument(...)");
            ProtoBuf.Type type6 = ProtoTypeTableUtilKt.type(argument, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type6);
            ProtoBuf.Type continuationArgumentType = type6;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionType, continuationArgumentType, null, null, 12, null);
        }
    }

    public final void createValueParameterListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull MessageLite callableProto, @NotNull List<ProtoBuf.ValueParameter> parameters2, @NotNull ProtoContainer container, @NotNull AnnotatedCallableKind callableKind) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)((Object)callableKind), (String)"callableKind");
        KotlinPlaceHolderStubImpl parameterListStub = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.VALUE_PARAMETER_LIST);
        Iterator iterator2 = ((Iterable)parameters2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            List<AnnotationWithArgs> parameterAnnotations;
            int index = n++;
            ProtoBuf.ValueParameter valueParameterProto = (ProtoBuf.ValueParameter)iterator2.next();
            Name parameterName = ClsStubBuildingKt.computeParameterName(NameResolverUtilKt.getName(this.c.getNameResolver(), valueParameterProto.getName()));
            Boolean bl = Flags.DECLARES_DEFAULT_VALUE.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            boolean hasDefaultValue = bl;
            StringRef stringRef = ClsStubBuildingKt.ref(parameterName);
            KotlinParameterStubImpl parameterStub = new KotlinParameterStubImpl(parameterListStub, null, stringRef, false, false, hasDefaultValue, null, 64, null);
            ProtoBuf.Type varargElementType = ProtoTypeTableUtilKt.varargElementType(valueParameterProto, this.c.getTypeTable());
            ProtoBuf.Type type2 = varargElementType;
            if (type2 == null) {
                type2 = ProtoTypeTableUtilKt.type(valueParameterProto, this.c.getTypeTable());
            }
            ProtoBuf.Type typeProto = type2;
            ArrayList<KtModifierKeywordToken> modifiers2 = new ArrayList<KtModifierKeywordToken>();
            if (varargElementType != null) {
                modifiers2.add(KtTokens.VARARG_KEYWORD);
            }
            if (Flags.IS_CROSSINLINE.get(valueParameterProto.getFlags()).booleanValue()) {
                modifiers2.add(KtTokens.CROSSINLINE_KEYWORD);
            }
            if (Flags.IS_NOINLINE.get(valueParameterProto.getFlags()).booleanValue()) {
                modifiers2.add(KtTokens.NOINLINE_KEYWORD);
            }
            KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStub(parameterStub, (Collection<KtModifierKeywordToken>)modifiers2);
            if (Flags.HAS_ANNOTATIONS.get(valueParameterProto.getFlags()).booleanValue() && !((Collection)(parameterAnnotations = this.c.getComponents().getAnnotationLoader().loadValueParameterAnnotations(container, callableProto, callableKind, index, valueParameterProto))).isEmpty()) {
                KotlinModifierListStubImpl kotlinModifierListStubImpl = modifierList2;
                if (kotlinModifierListStubImpl == null) {
                    kotlinModifierListStubImpl = ClsStubBuildingKt.createEmptyModifierListStub(parameterStub);
                }
                ClsStubBuildingKt.createAnnotationStubs(parameterAnnotations, kotlinModifierListStubImpl);
            }
            TypeClsStubBuilder.createTypeReferenceStub$default(this, parameterStub, typeProto, null, null, 12, null);
            if (!hasDefaultValue) continue;
            new KotlinNameReferenceExpressionStubImpl((StubElement)parameterStub, StringRef.fromString("COMPILED_CODE"));
        }
    }

    public static /* synthetic */ void createValueParameterListStub$default(TypeClsStubBuilder typeClsStubBuilder, StubElement stubElement, MessageLite messageLite, List list, ProtoContainer protoContainer, AnnotatedCallableKind annotatedCallableKind, int n, Object object) {
        if ((n & 0x10) != 0) {
            annotatedCallableKind = ClsStubBuildingKt.getAnnotatedCallableKind(messageLite);
        }
        typeClsStubBuilder.createValueParameterListStub(stubElement, messageLite, list, protoContainer, annotatedCallableKind);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Name, ProtoBuf.Type>> createTypeParameterListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtoList) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(typeParameterProtoList, (String)"typeParameterProtoList");
        if (typeParameterProtoList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KotlinPlaceHolderStubImpl typeParameterListStub = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.TYPE_PARAMETER_LIST);
        ArrayList protosForTypeConstraintList = new ArrayList();
        for (ProtoBuf.TypeParameter proto : typeParameterProtoList) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Name name2 = NameResolverUtilKt.getName(this.c.getNameResolver(), proto.getName());
            KotlinTypeParameterStubImpl typeParameterStub = new KotlinTypeParameterStubImpl(typeParameterListStub, ClsStubBuildingKt.ref(name2), proto.getVariance() == ProtoBuf.TypeParameter.Variance.IN, proto.getVariance() == ProtoBuf.TypeParameter.Variance.OUT);
            this.createTypeParameterModifierListStub(typeParameterStub, proto);
            List<ProtoBuf.Type> upperBoundProtos = ProtoTypeTableUtilKt.upperBounds(proto, this.c.getTypeTable());
            if (!(!((Collection)upperBoundProtos).isEmpty())) continue;
            ProtoBuf.Type upperBound = (ProtoBuf.Type)CollectionsKt.first(upperBoundProtos);
            if (!this.isDefaultUpperBound(upperBound)) {
                TypeClsStubBuilder.createTypeReferenceStub$default(this, typeParameterStub, upperBound, null, null, 12, null);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)upperBoundProtos, (int)1);
            ArrayList arrayList = protosForTypeConstraintList;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)name2, (Object)it));
            }
            arrayList.addAll((List)destination$iv$iv);
        }
        return protosForTypeConstraintList;
    }

    public final void createTypeConstraintListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull List<Pair<Name, ProtoBuf.Type>> protosForTypeConstraintList) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(protosForTypeConstraintList, (String)"protosForTypeConstraintList");
        if (protosForTypeConstraintList.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl typeConstraintListStub = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.TYPE_CONSTRAINT_LIST);
        for (Pair<Name, ProtoBuf.Type> pair : protosForTypeConstraintList) {
            Name name2 = (Name)pair.component1();
            ProtoBuf.Type type2 = (ProtoBuf.Type)pair.component2();
            KotlinPlaceHolderStubImpl typeConstraintStub = new KotlinPlaceHolderStubImpl((StubElement)typeConstraintListStub, KtStubElementTypes.TYPE_CONSTRAINT);
            new KotlinNameReferenceExpressionStubImpl((StubElement)typeConstraintStub, ClsStubBuildingKt.ref(name2));
            TypeClsStubBuilder.createTypeReferenceStub$default(this, typeConstraintStub, type2, null, null, 12, null);
        }
    }

    private final void createTypeParameterModifierListStub(KotlinTypeParameterStubImpl typeParameterStub, ProtoBuf.TypeParameter typeParameterProto) {
        ArrayList<KtModifierKeywordToken> modifiers2 = new ArrayList<KtModifierKeywordToken>();
        ProtoBuf.TypeParameter.Variance variance2 = typeParameterProto.getVariance();
        switch (variance2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[variance2.ordinal()]) {
            case 1: {
                modifiers2.add(KtTokens.IN_KEYWORD);
                break;
            }
            case 2: {
                modifiers2.add(KtTokens.OUT_KEYWORD);
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (typeParameterProto.getReified()) {
            modifiers2.add(KtTokens.REIFIED_KEYWORD);
        }
        KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStub(typeParameterStub, (Collection<KtModifierKeywordToken>)modifiers2);
        List<AnnotationWithArgs> annotations2 = this.c.getComponents().getAnnotationLoader().loadTypeParameterAnnotations(typeParameterProto, this.c.getNameResolver());
        if (!((Collection)annotations2).isEmpty()) {
            KotlinModifierListStubImpl kotlinModifierListStubImpl = modifierList2;
            if (kotlinModifierListStubImpl == null) {
                kotlinModifierListStubImpl = ClsStubBuildingKt.createEmptyModifierListStub(typeParameterStub);
            }
            ClsStubBuildingKt.createAnnotationStubs(annotations2, kotlinModifierListStubImpl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefaultUpperBound(ProtoBuf.Type $this$isDefaultUpperBound) {
        if (!$this$isDefaultUpperBound.hasClassName()) return false;
        ClassId it = NameResolverUtilKt.getClassId(this.c.getNameResolver(), $this$isDefaultUpperBound.getClassName());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)StandardNames.FqNames.any, (Object)it.asSingleFqName().toUnsafe())) return false;
        if (!$this$isDefaultUpperBound.getNullable()) return false;
        return true;
    }

    private static final List createTypeReferenceStub$lambda$0() {
        return CollectionsKt.emptyList();
    }

    private static final List createTypeReferenceStub$lambda$1(TypeClsStubBuilder this$0, ProtoBuf.Type it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.c.getComponents().getAnnotationLoader().loadTypeAnnotations(it, this$0.c.getNameResolver());
    }

    private static final KotlinTypeBean createTypeParameterStub$lambda$4(KotlinTypeBean $upperBoundType, int it) {
        return $upperBoundType;
    }

    private static final KotlinTypeBean createDefinitelyNotNullTypeStub$lambda$5(KotlinTypeBean $upperBoundType, int it) {
        return $upperBoundType;
    }

    private static final ProtoBuf.Type createClassReferenceTypeStub$lambda$11(TypeClsStubBuilder this$0, ProtoBuf.Type it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProtoTypeTableUtilKt.outerType(it, this$0.c.getTypeTable());
    }

    private static final KotlinTypeBean createClassReferenceTypeStub$lambda$12(TypeClsStubBuilder this$0, ProtoBuf.Type $type, List $outerTypeChain, int level) {
        KotlinTypeBean kotlinTypeBean;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$outerTypeChain, (String)"$outerTypeChain");
        if (level == 0) {
            kotlinTypeBean = this$0.createKotlinTypeBean(ProtoTypeTableUtilKt.flexibleUpperBound($type, this$0.c.getTypeTable()));
        } else {
            ProtoBuf.Type type2 = (ProtoBuf.Type)CollectionsKt.getOrNull((List)$outerTypeChain, (int)level);
            kotlinTypeBean = this$0.createKotlinTypeBean(type2 != null ? ProtoTypeTableUtilKt.flexibleUpperBound(type2, this$0.c.getTypeTable()) : null);
        }
        return kotlinTypeBean;
    }

    private static final Unit createClassReferenceTypeStub$lambda$14(List $outerTypeChain, TypeClsStubBuilder this$0, KotlinUserTypeStub userTypeStub, int index) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$outerTypeChain, (String)"$outerTypeChain");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)userTypeStub, (String)"userTypeStub");
            ProtoBuf.Type type2 = (ProtoBuf.Type)CollectionsKt.getOrNull((List)$outerTypeChain, (int)index);
            if (type2 == null) break block0;
            ProtoBuf.Type it = type2;
            boolean bl = false;
            List<ProtoBuf.Type.Argument> list = it.getArgumentList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
            this$0.createTypeArgumentListStub(userTypeStub, list);
        }
        return Unit.INSTANCE;
    }

    private static final boolean createTypeAnnotationStubs$lambda$16(Set $typeModifiers, KtModifierKeywordToken it) {
        Intrinsics.checkNotNullParameter((Object)$typeModifiers, (String)"$typeModifiers");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $typeModifiers.contains(it);
    }

    private static final String createFunctionTypeStub$getFunctionTypeParameterName(List<AnnotationWithArgs> annotations2) {
        for (AnnotationWithArgs annotationWithArgs : annotations2) {
            if (!Intrinsics.areEqual((Object)annotationWithArgs.getClassId().asSingleFqName(), (Object)StandardNames.FqNames.parameterName)) continue;
            Object object = CollectionsKt.firstOrNull((Iterable)annotationWithArgs.getArgs().values());
            StringValue stringValue = object instanceof StringValue ? (StringValue)object : null;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }
        return null;
    }

    private static final List createFunctionTypeStub$lambda$20(List $annotations, ProtoBuf.Type it) {
        Intrinsics.checkNotNullParameter((Object)$annotations, (String)"$annotations");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $annotations;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProtoBuf.Type.Argument.Projection.values().length];
            try {
                nArray[ProtoBuf.Type.Argument.Projection.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.TypeParameter.Variance.values().length];
            try {
                nArray[ProtoBuf.TypeParameter.Variance.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

