/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;

final class CombinationSpliterator
implements Spliterator<int[]> {
    private long pos;
    private int[] value;
    private final long fence;
    private final int n;

    public CombinationSpliterator(int n, long pos, long fence, int[] value2) {
        this.n = n;
        this.pos = pos;
        this.fence = fence;
        this.value = value2;
    }

    @Override
    public void forEachRemaining(Consumer<? super int[]> action) {
        long rest = this.pos - this.fence;
        this.pos = this.fence;
        while (rest > 0L) {
            action.accept((int[])this.value.clone());
            if (--rest <= 0L) continue;
            CombinationSpliterator.step(this.value, this.n);
        }
    }

    @Override
    public Spliterator<int[]> trySplit() {
        if (this.pos - this.fence < 2L) {
            return null;
        }
        long newPos = this.fence + this.pos >>> 1;
        CombinationSpliterator result2 = new CombinationSpliterator(this.n, this.pos, newPos, this.value);
        this.value = CombinationSpliterator.jump(newPos - 1L, this.value.length, this.n);
        this.pos = newPos;
        return result2;
    }

    @Override
    public long estimateSize() {
        return this.pos - this.fence;
    }

    @Override
    public int characteristics() {
        return 17745;
    }

    static void step(int[] value2, int n) {
        int k;
        int i = k = value2.length;
        while (--i >= 0) {
            int n2 = i;
            value2[n2] = value2[n2] + 1;
            if (value2[n2] < n) break;
            --n;
        }
        while (++i < k) {
            value2[i] = value2[i - 1] + 1;
        }
    }

    static int[] jump(long newPos, int k, int n) {
        int[] newValue = new int[k];
        int curK = k - 1;
        long bound = 0L;
        for (int i = 0; i < k; ++i) {
            long cnk = 1L;
            int curN = curK;
            while (newPos >= bound + cnk) {
                bound += cnk;
                cnk = cnk * (long)(++curN) / (long)(curN - curK);
            }
            --curK;
            newValue[i] = n - curN - 1;
        }
        return newValue;
    }

    static long gcd(long a, long b) {
        while (b != 0L) {
            long t = a % b;
            a = b;
            b = t;
        }
        return a;
    }

    static long cnk(int n, int k) {
        long size = 1L;
        int rest = n;
        long div = 1L;
        while (div <= (long)k) {
            long t;
            long gcd;
            if ((size /= (gcd = CombinationSpliterator.gcd(size, div))) > Long.MAX_VALUE / (t = (long)rest / (div / gcd))) {
                throw new UnsupportedOperationException("Number of combinations exceed Long.MAX_VALUE: unsupported");
            }
            size *= t;
            ++div;
            --rest;
        }
        return size;
    }

    @Override
    public boolean tryAdvance(Consumer<? super int[]> action) {
        if (this.pos <= this.fence) {
            return false;
        }
        action.accept((int[])this.value.clone());
        if (--this.pos > this.fence) {
            CombinationSpliterator.step(this.value, this.n);
        }
        return true;
    }
}

