/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;
import org.jetbrains.kotlin.resolve.jvm.KotlinSafeClassFinder;
import org.jetbrains.kotlin.resolve.jvm.NotFoundPackagesCachingStrategy;
import org.jetbrains.kotlin.resolve.jvm.TopPackageNamesProvider;

public class KotlinJavaPsiFacade
implements Disposable {
    private volatile KotlinPsiElementFinderWrapper[] elementFinders;
    private static final PsiPackage NULL_PACKAGE = new PsiPackageImpl(null, "NULL_PACKAGE");
    private volatile PackageCache packageCache;
    private volatile NotFoundPackagesCachingStrategy notFoundPackagesCachingStrategy;
    private final Project project;
    private final LightModifierList emptyModifierList;

    @Nullable
    private static PsiPackage unwrap(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(0);
        }
        return psiPackage == NULL_PACKAGE ? null : psiPackage;
    }

    public static KotlinJavaPsiFacade getInstance(Project project) {
        return project.getService(KotlinJavaPsiFacade.class);
    }

    public KotlinJavaPsiFacade(@NotNull Project project) {
        if (project == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(1);
        }
        this.notFoundPackagesCachingStrategy = NotFoundPackagesCachingStrategy.Default.INSTANCE;
        this.project = project;
        this.emptyModifierList = new LightModifierList(PsiManager.getInstance(project), KotlinLanguage.INSTANCE, new String[0]);
        LowMemoryWatcher.register(this::clearPackageCaches, this);
        MessageBusConnection connection = project.getMessageBus().connect(this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean relevant = false;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    relevant = vFileEvent instanceof VFileCreateEvent && ((VFileCreateEvent)vFileEvent).isDirectory() || file2 != null && file2.isDirectory() && (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileCopyEvent);
                    if (!relevant) continue;
                    break;
                }
                if (relevant) {
                    KotlinJavaPsiFacade.this.clearPackageCaches(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$1", "after"));
            }
        });
        final PsiModificationTracker modificationTracker = PsiManager.getInstance(project).getModificationTracker();
        connection.subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
            private long lastTimeSeen = -1L;

            @Override
            public void modificationCountChanged() {
                long now = modificationTracker.getModificationCount();
                if (this.lastTimeSeen != now) {
                    this.lastTimeSeen = now;
                    KotlinJavaPsiFacade.this.clearPackageCaches(false);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.clearPackageCaches();
    }

    public void clearPackageCaches() {
        this.clearPackageCaches(true);
    }

    private void clearPackageCaches(boolean force) {
        this.elementFinders = null;
        if (force) {
            this.packageCache = null;
        } else {
            this.obtainPackageCache().clear();
        }
    }

    public void setNotFoundPackagesCachingStrategy(NotFoundPackagesCachingStrategy notFoundPackagesCachingStrategy) {
        this.notFoundPackagesCachingStrategy = notFoundPackagesCachingStrategy;
    }

    public LightModifierList getEmptyModifierList() {
        return this.emptyModifierList;
    }

    public JavaClass findClass(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope scope) {
        if (request == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(3);
        }
        if (scope == GlobalSearchScope.EMPTY_SCOPE) {
            return null;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ClassId classId = request.getClassId();
        String qualifiedName2 = classId.asSingleFqName().asString();
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName2, scope);
            if (classes2.length != 0) {
                return this.createJavaClass(classId, classes2[0]);
            }
            return null;
        }
        for (KotlinPsiElementFinderWrapper finder : this.finders()) {
            Object aClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (finder instanceof CliFinder) {
                aClass = ((CliFinder)finder).findClass(request, scope);
                if (aClass == null) continue;
                return aClass;
            }
            aClass = finder.findClass(qualifiedName2, scope);
            if (aClass == null) continue;
            return this.createJavaClass(classId, (PsiClass)aClass);
        }
        return null;
    }

    @NotNull
    public List<JavaClass> findClasses(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope scope) {
        if (request == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(5);
        }
        if (scope == GlobalSearchScope.EMPTY_SCOPE) {
            List<JavaClass> list2 = Collections.emptyList();
            if (list2 == null) {
                KotlinJavaPsiFacade.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        assert (!this.shouldUseSlowResolve()) : "`findClasses` should not be called from dumb mode, as results may be incomplete.";
        ClassId classId = request.getClassId();
        String qualifiedName2 = classId.asSingleFqName().asString();
        SmartList<JavaClass> javaClasses = new SmartList<JavaClass>();
        for (KotlinPsiElementFinderWrapper finder : this.finders()) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            for (PsiClass psiClass : finder.findClasses(qualifiedName2, scope)) {
                javaClasses.add(this.createJavaClass(classId, psiClass));
            }
        }
        SmartList<JavaClass> smartList = javaClasses;
        if (smartList == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @NotNull
    private JavaClass createJavaClass(@NotNull ClassId classId, @NotNull PsiClass psiClass) {
        if (classId == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(9);
        }
        JavaClassImpl javaClass = new JavaClassImpl(JavaElementSourceFactory.getInstance(this.project).createPsiSource(psiClass));
        FqName fqName2 = classId.asSingleFqName();
        if (!fqName2.equals(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName2 + ", got " + javaClass.getFqName());
        }
        if (psiClass instanceof KtLightClassMarker) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName2);
        }
        JavaClassImpl javaClassImpl = javaClass;
        if (javaClassImpl == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(10);
        }
        return javaClassImpl;
    }

    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope) {
        if (packageFqName == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(12);
        }
        if (scope == GlobalSearchScope.EMPTY_SCOPE) {
            return Collections.emptySet();
        }
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (this.canComputeKnownClassNamesInPackage().booleanValue()) {
            return ((CliFinder)finders[0]).knownClassNamesInPackage(packageFqName);
        }
        return null;
    }

    public Boolean canComputeKnownClassNamesInPackage() {
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        return finders.length == 1 && finders[0] instanceof CliFinder;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        if (qualifiedName2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(14);
        }
        String packageName2 = StringUtil.getPackageName(qualifiedName2);
        PsiPackage pkg = this.findPackage(packageName2, scope);
        String className2 = StringUtil.getShortName(qualifiedName2);
        if (pkg == null && packageName2.length() < qualifiedName2.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName2, scope);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className2, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    KotlinJavaPsiFacade.$$$reportNull$$$0(15);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                KotlinJavaPsiFacade.$$$reportNull$$$0(16);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className2)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                KotlinJavaPsiFacade.$$$reportNull$$$0(17);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className2, scope);
        if (psiClassArray == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(18);
        }
        return psiClassArray;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] finders() {
        KotlinPsiElementFinderWrapper[] answer = this.elementFinders;
        if (answer == null) {
            answer = this.calcFinders();
            this.elementFinders = answer;
        }
        if (answer == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(19);
        }
        return answer;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] calcFinders() {
        ArrayList<KotlinPsiElementFinderWrapper> elementFinders = new ArrayList<KotlinPsiElementFinderWrapper>();
        JavaFileManager javaFileManager2 = KotlinJavaPsiFacade.findJavaFileManager(this.project);
        elementFinders.add(javaFileManager2 instanceof KotlinCliJavaFileManager ? new CliFinder((KotlinCliJavaFileManager)javaFileManager2) : new NonCliFinder(this.project, javaFileManager2));
        ArrayList<PsiElementFinder> nonKotlinFinders = new ArrayList<PsiElementFinder>();
        for (PsiElementFinder finder : PsiElementFinder.EP.getExtensions(this.getProject())) {
            if (!(finder instanceof KotlinSafeClassFinder) && (finder instanceof NonClasspathClassFinder || finder instanceof KotlinFinderMarker || finder instanceof PsiElementFinderImpl)) continue;
            nonKotlinFinders.add(finder);
        }
        elementFinders.addAll(CollectionsKt.map(nonKotlinFinders, KotlinJavaPsiFacade::wrap));
        KotlinPsiElementFinderWrapper[] kotlinPsiElementFinderWrapperArray = elementFinders.toArray(new KotlinPsiElementFinderWrapper[0]);
        if (kotlinPsiElementFinderWrapperArray == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(20);
        }
        return kotlinPsiElementFinderWrapperArray;
    }

    @NotNull
    private static JavaFileManager findJavaFileManager(@NotNull Project project) {
        JavaFileManager javaFileManager2;
        if (project == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(21);
        }
        if ((javaFileManager2 = project.getService(JavaFileManager.class)) == null) {
            throw new IllegalStateException("JavaFileManager component is not found in project");
        }
        JavaFileManager javaFileManager3 = javaFileManager2;
        if (javaFileManager3 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(22);
        }
        return javaFileManager3;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName2, GlobalSearchScope searchScope) {
        ConcurrentMap<GlobalSearchScope, ConcurrentMap<String, PsiPackage>> notFoundPackageInScopeCache;
        PsiPackage pkg;
        if (qualifiedName2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(23);
        }
        if (searchScope == GlobalSearchScope.EMPTY_SCOPE) {
            return null;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (KotlinJavaPsiFacade.certainlyDoesNotExist(qualifiedName2, searchScope)) {
            return null;
        }
        PackageCache cache2 = this.obtainPackageCache();
        Boolean packageFoundInAllScope = (Boolean)cache2.hasPackageInAllScopeCache.get(qualifiedName2);
        if (packageFoundInAllScope != null && !packageFoundInAllScope.booleanValue()) {
            return null;
        }
        ConcurrentMap packageInLibScope = (ConcurrentMap)cache2.packageInLibScopeCache.get(searchScope);
        PsiPackage psiPackage = pkg = packageInLibScope != null ? (PsiPackage)packageInLibScope.get(qualifiedName2) : null;
        if (pkg != null) {
            return KotlinJavaPsiFacade.unwrap(pkg);
        }
        ConcurrentMap packageInScope = (ConcurrentMap)cache2.packageInScopeCache.get(searchScope);
        PsiPackage psiPackage2 = pkg = packageInScope != null ? (PsiPackage)packageInScope.get(qualifiedName2) : null;
        if (pkg != null) {
            return KotlinJavaPsiFacade.unwrap(pkg);
        }
        boolean isALibrarySearchScope = KotlinJavaPsiFacade.isALibrarySearchScope(searchScope);
        NotFoundPackagesCachingStrategy.CacheType notFoundCacheType = this.notFoundPackagesCachingStrategy.chooseStrategy(isALibrarySearchScope, qualifiedName2);
        ConcurrentMap<GlobalSearchScope, ConcurrentMap<String, PsiPackage>> existedPackageInScopeCache = isALibrarySearchScope ? cache2.packageInLibScopeCache : cache2.packageInScopeCache;
        KotlinPsiElementFinderWrapper[] finders = this.filteredFinders();
        if (packageFoundInAllScope != null) {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                PsiPackage aPackage;
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName2, searchScope)) == null) continue;
                ConcurrentMap concurrentMap = ConcurrencyUtil.cacheOrGet(existedPackageInScopeCache, searchScope, new ConcurrentHashMap());
                return KotlinJavaPsiFacade.unwrap(ConcurrencyUtil.cacheOrGet(concurrentMap, qualifiedName2, aPackage));
            }
        } else {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                PsiPackage aPackage = finder.findPackage(qualifiedName2, searchScope);
                if (aPackage == null) continue;
                ConcurrentMap concurrentMap = ConcurrencyUtil.cacheOrGet(existedPackageInScopeCache, searchScope, new ConcurrentHashMap());
                return KotlinJavaPsiFacade.unwrap(ConcurrencyUtil.cacheOrGet(concurrentMap, qualifiedName2, aPackage));
            }
            boolean found = false;
            for (KotlinPsiElementFinderWrapper finder : finders) {
                PsiPackage aPackage;
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName2, GlobalSearchScope.allScope(this.project))) == null) continue;
                found = true;
                break;
            }
            if (found || notFoundCacheType != NotFoundPackagesCachingStrategy.CacheType.NO_CACHING) {
                cache2.hasPackageInAllScopeCache.put(qualifiedName2, found);
            }
        }
        switch (notFoundCacheType) {
            case LIB_SCOPE: {
                notFoundPackageInScopeCache = cache2.packageInLibScopeCache;
                break;
            }
            case SCOPE: {
                notFoundPackageInScopeCache = cache2.packageInScopeCache;
                break;
            }
            case NO_CACHING: {
                return null;
            }
            default: {
                throw new IllegalStateException("Impossible enum value: " + notFoundCacheType.toString());
            }
        }
        ConcurrentMap concurrentMap = ConcurrencyUtil.cacheOrGet(notFoundPackageInScopeCache, searchScope, new ConcurrentHashMap());
        return KotlinJavaPsiFacade.unwrap(ConcurrencyUtil.cacheOrGet(concurrentMap, qualifiedName2, NULL_PACKAGE));
    }

    private PackageCache obtainPackageCache() {
        PackageCache cache2 = this.packageCache;
        if (cache2 == null) {
            this.packageCache = cache2 = new PackageCache();
        }
        return cache2;
    }

    private static boolean isALibrarySearchScope(GlobalSearchScope searchScope) {
        return searchScope.isSearchInLibraries();
    }

    private static boolean certainlyDoesNotExist(@NotNull String qualifiedName2, GlobalSearchScope searchScope) {
        TopPackageNamesProvider topPackageAwareSearchScope;
        Set<String> topPackageNames;
        if (qualifiedName2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(24);
        }
        if (searchScope instanceof TopPackageNamesProvider && (topPackageNames = (topPackageAwareSearchScope = (TopPackageNamesProvider)((Object)searchScope)).getTopPackageNames()) != null) {
            String topPackageName = qualifiedName2;
            int index2 = topPackageName.indexOf(46);
            if (index2 > 0) {
                topPackageName = topPackageName.substring(0, index2);
            }
            if (!topPackageNames.contains(topPackageName)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (dumbService.isDumb()) {
            List<KotlinPsiElementFinderWrapper> list2 = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list2.toArray(new KotlinPsiElementFinderWrapper[0]);
        }
        if (finders == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(25);
        }
        return finders;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(26);
        }
        return project;
    }

    public static KotlinPsiElementFinderWrapper wrap(PsiElementFinder finder) {
        return finder instanceof DumbAware ? new KotlinPsiElementFinderWrapperImplDumbAware(finder) : new KotlinPsiElementFinderWrapperImpl(finder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 13: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaClass";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "finders";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFinders";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaFileManager";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createJavaClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "knownClassNamesInPackage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findJavaFileManager";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "certainlyDoesNotExist";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonCliFinder
    implements KotlinPsiElementFinderWrapper,
    DumbAware {
        private final JavaFileManager javaFileManager;
        private final PsiManager psiManager;
        private final PackageIndex packageIndex;

        public NonCliFinder(@NotNull Project project, @NotNull JavaFileManager javaFileManager2) {
            if (project == null) {
                NonCliFinder.$$$reportNull$$$0(0);
            }
            if (javaFileManager2 == null) {
                NonCliFinder.$$$reportNull$$$0(1);
            }
            this.javaFileManager = javaFileManager2;
            this.packageIndex = PackageIndex.getInstance(project);
            this.psiManager = PsiManager.getInstance(project);
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                NonCliFinder.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                NonCliFinder.$$$reportNull$$$0(3);
            }
            return this.javaFileManager.findClass(qualifiedName2, scope);
        }

        @Override
        public PsiClass[] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                NonCliFinder.$$$reportNull$$$0(4);
            }
            if (scope == null) {
                NonCliFinder.$$$reportNull$$$0(5);
            }
            return this.javaFileManager.findClasses(qualifiedName2, scope);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            Query<VirtualFile> dirs;
            if (qualifiedName2 == null) {
                NonCliFinder.$$$reportNull$$$0(6);
            }
            if (scope == null) {
                NonCliFinder.$$$reportNull$$$0(7);
            }
            return NonCliFinder.hasDirectoriesInScope(dirs = this.packageIndex.getDirsByPackageName(qualifiedName2, true), scope) ? new PsiPackageImpl(this.psiManager, qualifiedName2) : null;
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static boolean hasDirectoriesInScope(Query<VirtualFile> dirs, final GlobalSearchScope scope) {
            CommonProcessors.FindProcessor<VirtualFile> findProcessor = new CommonProcessors.FindProcessor<VirtualFile>(){

                @Override
                protected boolean accept(VirtualFile file2) {
                    return scope.accept(file2);
                }
            };
            dirs.forEach((Processor<VirtualFile>)findProcessor);
            return findProcessor.isFound();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaFileManager";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$NonCliFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClasses";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CliFinder
    implements KotlinPsiElementFinderWrapper,
    DumbAware {
        private final KotlinCliJavaFileManager javaFileManager;

        public CliFinder(@NotNull KotlinCliJavaFileManager javaFileManager2) {
            if (javaFileManager2 == null) {
                CliFinder.$$$reportNull$$$0(0);
            }
            this.javaFileManager = javaFileManager2;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                CliFinder.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                CliFinder.$$$reportNull$$$0(2);
            }
            return this.javaFileManager.findClass(qualifiedName2, scope);
        }

        public JavaClass findClass(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope scope) {
            if (request == null) {
                CliFinder.$$$reportNull$$$0(3);
            }
            if (scope == null) {
                CliFinder.$$$reportNull$$$0(4);
            }
            return this.javaFileManager.findClass(request, scope);
        }

        @Override
        public PsiClass[] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                CliFinder.$$$reportNull$$$0(5);
            }
            if (scope == null) {
                CliFinder.$$$reportNull$$$0(6);
            }
            return this.javaFileManager.findClasses(qualifiedName2, scope);
        }

        @Nullable
        public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
            if (packageFqName == null) {
                CliFinder.$$$reportNull$$$0(7);
            }
            return this.javaFileManager.knownClassNamesInPackage(packageFqName);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                CliFinder.$$$reportNull$$$0(8);
            }
            if (scope == null) {
                CliFinder.$$$reportNull$$$0(9);
            }
            return this.javaFileManager.findPackage(qualifiedName2);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaFileManager";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageFqName";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$CliFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClasses";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "knownClassNamesInPackage";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KotlinPsiElementFinderWrapperImplDumbAware
    extends KotlinPsiElementFinderWrapperImpl
    implements DumbAware {
        private KotlinPsiElementFinderWrapperImplDumbAware(PsiElementFinder finder) {
            super(finder);
        }
    }

    private static class KotlinPsiElementFinderWrapperImpl
    implements KotlinPsiElementFinderWrapper {
        private final PsiElementFinder finder;

        private KotlinPsiElementFinderWrapperImpl(@NotNull PsiElementFinder finder) {
            if (finder == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(0);
            }
            this.finder = finder;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(2);
            }
            return this.finder.findClass(qualifiedName2, scope);
        }

        @Override
        public PsiClass[] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(3);
            }
            if (scope == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(4);
            }
            return this.finder.findClasses(qualifiedName2, scope);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
            if (qualifiedName2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(5);
            }
            if (scope == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(6);
            }
            return this.finder.findPackage(qualifiedName2);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return true;
        }

        public String toString() {
            return this.finder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finder";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClasses";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface KotlinPsiElementFinderWrapper {
        public PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public PsiClass[] findClasses(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public PsiPackage findPackage(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public boolean isSameResultForAnyScope();
    }

    private static class PackageCache {
        final ConcurrentMap<GlobalSearchScope, ConcurrentMap<String, PsiPackage>> packageInLibScopeCache = new ConcurrentHashMap<GlobalSearchScope, ConcurrentMap<String, PsiPackage>>();
        final ConcurrentMap<GlobalSearchScope, ConcurrentMap<String, PsiPackage>> packageInScopeCache = new ConcurrentHashMap<GlobalSearchScope, ConcurrentMap<String, PsiPackage>>();
        final ConcurrentMap<String, Boolean> hasPackageInAllScopeCache = new ConcurrentHashMap<String, Boolean>();

        private PackageCache() {
        }

        void clear() {
            this.packageInScopeCache.clear();
            this.hasPackageInAllScopeCache.clear();
        }
    }
}

