/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ICClassesAttributes;
import org.jetbrains.kotlin.incremental.storage.ICClassesAttributesExternalizer;
import org.jetbrains.kotlin.incremental.storage.PersistentStorage;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0019\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ClassAttributesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ICClassesAttributes;", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpValue", "", "value", "get", "key", "Lorg/jetbrains/kotlin/name/FqName;", "remove", "", "set", "kotlin-build-common"})
public class ClassAttributesMap
extends BasicStringMap<ICClassesAttributes> {
    public ClassAttributesMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        super(storageFile, ICClassesAttributesExternalizer.INSTANCE, icContext);
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull ICClassesAttributes value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return value2.toString();
    }

    @Override
    public final void set(@NotNull FqName key, @NotNull ICClassesAttributes value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        PersistentStorage<String, ICClassesAttributes> persistentStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        persistentStorage.set(string2, value2);
    }

    @Override
    @Nullable
    public final ICClassesAttributes get(@NotNull FqName key) {
        Intrinsics.checkNotNullParameter(key, "key");
        PersistentStorage persistentStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return (ICClassesAttributes)persistentStorage.get(string2);
    }

    @Override
    public final void remove(@NotNull FqName key) {
        Intrinsics.checkNotNullParameter(key, "key");
        PersistentStorage persistentStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        persistentStorage.remove(string2);
    }
}

