/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.AppendableBasicStringMap;
import org.jetbrains.kotlin.incremental.storage.NameTransformer;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u0002B#\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0004H\u0016J\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0086\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\u000e\u001a\u00020\bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap;", "Name", "Lorg/jetbrains/kotlin/incremental/storage/AppendableBasicStringMap;", "", "", "nameTransformer", "Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "add", "", "sourceFile", "className", "(Ljava/io/File;Ljava/lang/Object;)V", "clearOutputsForSource", "contains", "", "dumpValue", "value", "get", "getFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nSourceToOutputMaps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceToOutputMaps.kt\norg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1547#2:67\n1618#2,3:68\n1547#2:71\n1618#2,3:72\n*S KotlinDebug\n*F\n+ 1 SourceToOutputMaps.kt\norg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap\n*L\n58#1:67\n58#1:68,3\n61#1:71\n61#1:72,3\n*E\n"})
public abstract class AbstractSourceToOutputMap<Name>
extends AppendableBasicStringMap<String, Collection<? extends String>> {
    @NotNull
    private final NameTransformer<Name> nameTransformer;

    public AbstractSourceToOutputMap(@NotNull NameTransformer<Name> nameTransformer, @NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(nameTransformer, "nameTransformer");
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        KeyDescriptor keyDescriptor = PathStringDescriptor.INSTANCE;
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(enumeratorStringDescriptor, "INSTANCE");
        super(storageFile, keyDescriptor, (DataExternalizer)enumeratorStringDescriptor, icContext);
        this.nameTransformer = nameTransformer;
    }

    public final void clearOutputsForSource(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        this.remove(this.getPathConverter().toPath(sourceFile));
    }

    public final void add(@NotNull File sourceFile, Name className2) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        this.getStorage().append(this.getPathConverter().toPath(sourceFile), this.nameTransformer.asString(className2));
    }

    @Override
    public final boolean contains(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        return this.getStorage().contains(this.getPathConverter().toPath(sourceFile));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Collection<Name> get(@NotNull File sourceFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Collection collection = (Collection)this.getStorage().get(this.getPathConverter().toPath(sourceFile));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable iterable = CollectionsKt.toSet(collection);
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(nameTransformer.asName((String)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FqName> getFqNames(@NotNull File sourceFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Collection collection = (Collection)this.getStorage().get(this.getPathConverter().toPath(sourceFile));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable iterable = CollectionsKt.toSet(collection);
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(nameTransformer.asFqName((String)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull Collection<String> value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return IncrementalJvmCacheKt.dumpCollection(value2);
    }
}

