/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeIdentifierChecker;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativePackageDirectiveChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativePackageDirectiveChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativePackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativePackageDirectiveChecker\n+ 2 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 3 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n42#2,7:31\n64#2:38\n96#2,6:39\n66#2:45\n102#2:46\n49#2:47\n50#2:52\n105#2,5:53\n67#2:58\n110#2,2:61\n113#2:64\n69#2:65\n51#2:66\n80#2:67\n96#2,6:68\n82#2:74\n102#2:75\n52#2:76\n53#2:83\n105#2,5:84\n83#2:89\n110#2,4:90\n85#2:94\n54#2:95\n582#3,4:48\n588#3,6:77\n229#4:59\n1853#5:60\n1854#5:63\n*S KotlinDebug\n*F\n+ 1 FirNativePackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativePackageDirectiveChecker\n*L\n20#1:31,7\n20#1:38\n20#1:39,6\n20#1:45\n20#1:46\n20#1:47\n20#1:52\n20#1:53,5\n20#1:58\n20#1:61,2\n20#1:64\n20#1:65\n20#1:66\n20#1:67\n20#1:68,6\n20#1:74\n20#1:75\n20#1:76\n20#1:83\n20#1:84,5\n20#1:89\n20#1:90,4\n20#1:94\n20#1:95\n20#1:48,4\n20#1:77,6\n20#1:59\n20#1:60\n20#1:63\n*E\n"})
public final class FirNativePackageDirectiveChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirNativePackageDirectiveChecker INSTANCE = new FirNativePackageDirectiveChecker();

    private FirNativePackageDirectiveChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtSourceElement ktSourceElement = declaration2.getPackageDirective().getSource();
        if (ktSourceElement != null) {
            void $this$forEachChildOfType_u24default$iv;
            KtSourceElement ktSourceElement2 = ktSourceElement;
            Set<IElementType> types$iv = SetsKt.setOf(KtNodeTypes.REFERENCE_EXPRESSION);
            int depth$iv = -1;
            boolean reverse$iv = false;
            boolean $i$f$forEachChildOfType = false;
            void var9_9 = $this$forEachChildOfType_u24default$iv;
            if (var9_9 instanceof KtPsiSourceElement) {
                PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
                boolean $i$f$forEachChildOfType2 = false;
                boolean $i$f$forEachChildOfType3 = false;
                Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    PsiElement it$iv$iv;
                    object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = ((Pair)object).component1();
                    int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                        Set<IElementType> set = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getNode().getElementType();
                        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
                        if (set.contains(iElementType)) {
                            KtPsiSourceElement ktPsiSourceElement;
                            PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                            boolean bl2 = false;
                            PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                            KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                            boolean $i$f$toKtPsiSourceElement = false;
                            KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                                ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            KtSourceElement it = ktPsiSourceElement;
                            boolean bl3 = false;
                            Name name2 = Name.identifier(String.valueOf(KtSourceElementKt.getText(it)));
                            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
                            FirNativeIdentifierChecker.INSTANCE.checkNameAndReport$checkers_native(name2, it, context2, reporter);
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (PsiElement)element$iv$iv$iv;
                    boolean bl = false;
                    List list2 = SequencesKt.toList(PsiUtilsKt.getAllChildren(it$iv$iv));
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf22 = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl4 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                    while ($i$f$butIf22.hasNext()) {
                        Object element$iv$iv$iv$iv;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                        boolean bl5 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                    }
                }
            } else if (var9_9 instanceof KtLightSourceElement) {
                LighterASTNode $this$forEachChildOfType$iv$iv = $this$forEachChildOfType_u24default$iv.getLighterASTNode();
                FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = $this$forEachChildOfType_u24default$iv.getTreeStructure();
                boolean $i$f$forEachChildOfType4 = false;
                boolean $i$f$forEachChildOfType5 = false;
                Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    LighterASTNode it$iv$iv;
                    object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = ((Pair)object).component1();
                    int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        LighterASTNode lighterASTNode2 = (LighterASTNode)element$iv$iv$iv;
                        Set<IElementType> set = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getTokenType();
                        Intrinsics.checkNotNullExpressionValue(iElementType, "getTokenType(...)");
                        if (set.contains(iElementType)) {
                            void $this$toKtLightSourceElement_u24default$iv$iv;
                            LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                            boolean bl6 = false;
                            LighterASTNode kind$iv$iv = it$iv;
                            FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = $this$forEachChildOfType_u24default$iv.getTreeStructure();
                            KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                            int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                            int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                            boolean $i$f$toKtLightSourceElement = false;
                            KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                            boolean bl7 = false;
                            Name name3 = Name.identifier(String.valueOf(KtSourceElementKt.getText(it)));
                            Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
                            FirNativeIdentifierChecker.INSTANCE.checkNameAndReport$checkers_native(name3, it, context2, reporter);
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                    boolean bl = false;
                    List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl8 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv$iv$iv2;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                        boolean bl9 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

