/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureClashTracker;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR0\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "clashTracker", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureClashTracker;", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureClashTracker;)V", "publicIdSignatureComputer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "getPublicIdSignatureComputer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "table", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/HashMap;", "getTable", "()Ljava/util/HashMap;", "computeSignatureByDeclaration", "declaration", "compatibleMode", "", "isExportedDeclaration", "loadKnownBuiltins", "", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,104:1\n1853#2:105\n1854#2:107\n1#3:106\n372#4,7:108\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n*L\n40#1:105\n40#1:107\n47#1:108,7\n*E\n"})
public abstract class GlobalDeclarationTable {
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final IdSignatureClashTracker clashTracker;
    @NotNull
    private final PublicIdSignatureComputer publicIdSignatureComputer;
    @NotNull
    private final HashMap<IrDeclaration, IdSignature> table;

    public GlobalDeclarationTable(@NotNull KotlinMangler.IrMangler mangler, @NotNull IdSignatureClashTracker clashTracker) {
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        Intrinsics.checkNotNullParameter(clashTracker, "clashTracker");
        this.mangler = mangler;
        this.clashTracker = clashTracker;
        this.publicIdSignatureComputer = new PublicIdSignatureComputer(this.mangler);
        this.table = new HashMap();
    }

    @NotNull
    public final PublicIdSignatureComputer getPublicIdSignatureComputer() {
        return this.publicIdSignatureComputer;
    }

    @NotNull
    protected final HashMap<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    public GlobalDeclarationTable(@NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        this(mangler, IdSignatureClashTracker.Companion.getDEFAULT_TRACKER());
    }

    protected final void loadKnownBuiltins(@NotNull IrBuiltIns builtIns2) {
        Intrinsics.checkNotNullParameter(builtIns2, "builtIns");
        Iterable $this$forEach$iv = DeclarationTableKt.getKnownBuiltins(builtIns2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdSignature idSignature;
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            IrSymbol symbol2 = ((IrSymbolOwner)it).getSymbol();
            Map map = this.table;
            IdSignature idSignature2 = symbol2.getSignature();
            Intrinsics.checkNotNull(idSignature2);
            IdSignature id = idSignature = idSignature2;
            boolean bl2 = false;
            this.clashTracker.commit(it, id);
            map.put(it, idSignature);
        }
    }

    @NotNull
    public IdSignature computeSignatureByDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        Object object;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            IdSignature idSignature;
            boolean bl = false;
            IdSignature it = idSignature = this.publicIdSignatureComputer.composePublicIdSignature(declaration2, compatibleMode);
            boolean bl2 = false;
            this.clashTracker.commit(declaration2, it);
            IdSignature answer$iv = idSignature;
            $this$getOrPut$iv.put(declaration2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        KotlinMangler.IrMangler $this$isExportedDeclaration_u24lambda_u244 = this.mangler;
        boolean bl = false;
        return $this$isExportedDeclaration_u24lambda_u244.isExported(declaration2, compatibleMode);
    }
}

