/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J1\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0019\u0010\u001a\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u00190\u001b\u00a2\u0006\u0002\b\u001cH\u0082\b\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\tJ\u0016\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0011J\u0016\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0015R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage;", "", "()V", "cacheStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "enterCallable", "", "getDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getLocalFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "leaveCallable", "putDelegatedProperty", "firProperty", "irProperty", "putLocalFunction", "firFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "putParameter", "firParameter", "irParameter", "putVariable", "firVariable", "irVariable", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrLocalCallableStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n43#1,2:66\n46#1:69\n43#1,2:70\n46#1:73\n43#1,2:74\n46#1:77\n1#2:68\n1#2:72\n1#2:76\n1#2:78\n*S KotlinDebug\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n*L\n34#1:66,2\n34#1:69\n37#1:70,2\n37#1:73\n40#1:74,2\n40#1:77\n34#1:68\n37#1:72\n40#1:76\n*E\n"})
public final class Fir2IrLocalCallableStorage {
    @NotNull
    private final List<Fir2IrScopeCache> cacheStack = new ArrayList();

    public final void enterCallable() {
        ((Collection)this.cacheStack).add(new Fir2IrScopeCache());
    }

    public final void leaveCallable() {
        CollectionsKt.last(this.cacheStack).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameter getParameter(@NotNull FirValueParameter parameter2) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameter local = cache2.getParameter(parameter2);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariable getVariable(@NotNull FirVariable variable2) {
        IrVariable irVariable;
        block1: {
            Intrinsics.checkNotNullParameter(variable2, "variable");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getVariable_u24lambda_u240 = cache$iv = iterator2.next();
                boolean bl = false;
                IrVariable irVariable2 = $this$getVariable_u24lambda_u240.getVariable(variable2);
                if (irVariable2 == null) continue;
                IrVariable it$iv = irVariable2;
                boolean bl2 = false;
                irVariable = it$iv;
                break block1;
            }
            irVariable = null;
        }
        return irVariable;
    }

    @Nullable
    public final IrSimpleFunctionSymbol getLocalFunctionSymbol(@NotNull FirFunction localFunction) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(localFunction, "localFunction");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getLocalFunctionSymbol_u24lambda_u241 = cache$iv = iterator2.next();
                boolean bl = false;
                IrSimpleFunction irSimpleFunction = $this$getLocalFunctionSymbol_u24lambda_u241.getLocalFunction(localFunction);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunction != null ? irSimpleFunction.getSymbol() : null;
                if (irSimpleFunctionSymbol2 == null) continue;
                IrSimpleFunctionSymbol it$iv = irSimpleFunctionSymbol2;
                boolean bl2 = false;
                irSimpleFunctionSymbol = it$iv;
                break block1;
            }
            irSimpleFunctionSymbol = null;
        }
        return irSimpleFunctionSymbol;
    }

    @Nullable
    public final IrLocalDelegatedProperty getDelegatedProperty(@NotNull FirProperty property) {
        IrLocalDelegatedProperty irLocalDelegatedProperty;
        block1: {
            Intrinsics.checkNotNullParameter(property, "property");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getDelegatedProperty_u24lambda_u242 = cache$iv = iterator2.next();
                boolean bl = false;
                IrLocalDelegatedProperty irLocalDelegatedProperty2 = $this$getDelegatedProperty_u24lambda_u242.getDelegatedProperty(property);
                if (irLocalDelegatedProperty2 == null) continue;
                IrLocalDelegatedProperty it$iv = irLocalDelegatedProperty2;
                boolean bl2 = false;
                irLocalDelegatedProperty = it$iv;
                break block1;
            }
            irLocalDelegatedProperty = null;
        }
        return irLocalDelegatedProperty;
    }

    private final <T> T last(Function1<? super Fir2IrScopeCache, ? extends T> getter2) {
        boolean $i$f$last = false;
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            T t = getter2.invoke(cache2);
            if (t == null) continue;
            T it = t;
            boolean bl = false;
            return it;
        }
        return null;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameter irParameter) {
        Intrinsics.checkNotNullParameter(firParameter, "firParameter");
        Intrinsics.checkNotNullParameter(irParameter, "irParameter");
        CollectionsKt.last(this.cacheStack).putParameter(firParameter, irParameter);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariable irVariable) {
        Intrinsics.checkNotNullParameter(firVariable, "firVariable");
        Intrinsics.checkNotNullParameter(irVariable, "irVariable");
        CollectionsKt.last(this.cacheStack).putVariable(firVariable, irVariable);
    }

    public final void putLocalFunction(@NotNull FirFunction firFunction, @NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(firFunction, "firFunction");
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        CollectionsKt.last(this.cacheStack).putLocalFunction(firFunction, irFunction);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedProperty irProperty) {
        Intrinsics.checkNotNullParameter(firProperty, "firProperty");
        Intrinsics.checkNotNullParameter(irProperty, "irProperty");
        CollectionsKt.last(this.cacheStack).putDelegatedProperty(firProperty, irProperty);
    }
}

