/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.name.WasmStandardClassIds;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"isJsExportedDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmJsExportHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmJsExportHelpers.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/FirWasmJsExportHelpersKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,29:1\n21#2:30\n*S KotlinDebug\n*F\n+ 1 FirWasmJsExportHelpers.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/FirWasmJsExportHelpersKt\n*L\n21#1:30\n*E\n"})
public final class FirWasmJsExportHelpersKt {
    public static final boolean isJsExportedDeclaration(@NotNull FirDeclaration declaration2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!(declaration2 instanceof FirSimpleFunction)) {
            return false;
        }
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Public.INSTANCE)) {
            return false;
        }
        if (FirAnnotationUtilsKt.hasAnnotation(declaration2, WasmStandardClassIds.Annotations.JsExport, session2)) {
            return true;
        }
        FirFile containerFile = FirProviderKt.getFirProvider(session2).getFirCallableContainerFile(((FirSimpleFunction)declaration2).getSymbol());
        return containerFile != null && FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)containerFile, WasmStandardClassIds.Annotations.JsExport, session2);
    }
}

