/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ToArrayLoweringKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "backend.jvm.lower"})
public final class SyntheticAccessorLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public SyntheticAccessorLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        Set pendingAccessorsToAdd = new LinkedHashSet();
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new SyntheticAccessorTransformer(this.context, irFile, pendingAccessorsToAdd));
        for (IrFunction accessor : pendingAccessorsToAdd) {
            IrDeclarationParent irDeclarationParent = accessor.getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(accessor);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorLowering$Companion;", "", "()V", "isAccessible", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "currentScope", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "withSuper", "thisObjReference", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "fromOtherClassLoader", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAccessible(@NotNull IrSymbol $this$isAccessible, @NotNull JvmBackendContext context2, @Nullable ScopeWithIr currentScope, @NotNull IrInlineScopeResolver inlineScopeResolver, boolean withSuper, @Nullable IrClassSymbol thisObjReference, boolean fromOtherClassLoader) {
            IrDeclarationWithVisibility irDeclarationWithVisibility;
            Integer jvmVisibility;
            Intrinsics.checkNotNullParameter($this$isAccessible, "<this>");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(inlineScopeResolver, "inlineScopeResolver");
            IrSymbolOwner irSymbolOwner = $this$isAccessible.getOwner();
            Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility");
            IrDeclarationWithVisibility declarationRaw = (IrDeclarationWithVisibility)irSymbolOwner;
            if (declarationRaw instanceof IrConstructor && IrUtilsKt.isEnumEntry(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)declarationRaw))) {
                return true;
            }
            Integer n = jvmVisibility = AsmUtil.getVisibilityAccessFlag(declarationRaw.getVisibility().getDelegate());
            int n2 = 1;
            if (n != null && n == n2 && !withSuper) {
                return true;
            }
            if (declarationRaw instanceof IrSimpleFunction && (ToArrayLoweringKt.isNonGenericToArray((IrSimpleFunction)declarationRaw) || ToArrayLoweringKt.isGenericToArray((IrSimpleFunction)declarationRaw, context2)) && ToArrayLoweringKt.isCollectionSubClass(IrUtilsKt.getParentAsClass(declarationRaw))) {
                return true;
            }
            if (declarationRaw instanceof IrField && JvmIrUtilsKt.isAssertionsDisabledField((IrField)declarationRaw, context2)) {
                return true;
            }
            if (declarationRaw instanceof IrFunction) {
                if (((IrFunction)declarationRaw).isInline()) return true;
                if (context2.getGetIntrinsic().invoke(((IrFunction)declarationRaw).getSymbol()) != null) {
                    return true;
                }
            }
            IrDeclarationWithVisibility declaration2 = (irDeclarationWithVisibility = declarationRaw) instanceof IrSimpleFunction ? (IrDeclarationWithVisibility)IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstractOrFail((IrOverridableDeclaration)declarationRaw) : (irDeclarationWithVisibility instanceof IrField ? (IrDeclarationWithVisibility)SyntheticAccessorLoweringKt.access$resolveFieldFakeOverride((IrField)declarationRaw) : declarationRaw);
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            if (!(irDeclarationParent instanceof IrClass)) return true;
            IrClass irClass = (IrClass)irDeclarationParent;
            if (irClass == null) {
                return true;
            }
            IrClass ownerClass = irClass;
            ScopeWithIr scopeWithIr = currentScope;
            Intrinsics.checkNotNull(scopeWithIr);
            IrDeclarationContainer irDeclarationContainer = inlineScopeResolver.findContainer(scopeWithIr.getIrElement());
            if (irDeclarationContainer == null) {
                return false;
            }
            IrDeclarationContainer scopeClassOrPackage = irDeclarationContainer;
            IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment(scopeClassOrPackage);
            boolean samePackage = Intrinsics.areEqual(IrUtilsKt.getPackageFragment(ownerClass).getPackageFqName(), irPackageFragment != null ? irPackageFragment.getPackageFqName() : null);
            Integer n3 = jvmVisibility;
            int n4 = 2;
            if (n3 == null || n3 != n4) {
                if (!withSuper && samePackage) {
                    Integer n5 = jvmVisibility;
                    if (n5 != null && n5 == 0) {
                        return true;
                    }
                }
                if (!withSuper && samePackage && !fromOtherClassLoader) {
                    return true;
                }
                if (!(scopeClassOrPackage instanceof IrClass)) return false;
                if (!IrUtilsKt.isSubclassOf((IrClass)scopeClassOrPackage, ownerClass)) return false;
                if (thisObjReference == null) return true;
                if (!IrUtilsKt.isSubclassOf((IrClass)thisObjReference.getOwner(), (IrClass)scopeClassOrPackage)) return false;
                return true;
            }
            boolean bl = Intrinsics.areEqual(ownerClass, scopeClassOrPackage);
            return bl;
        }

        public static /* synthetic */ boolean isAccessible$default(Companion companion, IrSymbol irSymbol2, JvmBackendContext jvmBackendContext, ScopeWithIr scopeWithIr, IrInlineScopeResolver irInlineScopeResolver, boolean bl, IrClassSymbol irClassSymbol, boolean bl2, int n, Object object) {
            if ((n & 0x20) != 0) {
                bl2 = false;
            }
            return companion.isAccessible(irSymbol2, jvmBackendContext, scopeWithIr, irInlineScopeResolver, bl, irClassSymbol, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

