/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class CompositePsiElement
extends CompositeElement
implements NavigatablePsiElement {
    private static final Logger LOG = Logger.getInstance(CompositePsiElement.class);
    protected static int ourHC;

    protected CompositePsiElement(IElementType type2) {
        super(type2);
        this.setPsi(this);
    }

    @Override
    @NotNull
    public CompositePsiElement clone() {
        CompositePsiElement clone = (CompositePsiElement)super.clone();
        clone.setPsi(clone);
        CompositePsiElement compositePsiElement = clone;
        if (compositePsiElement == null) {
            CompositePsiElement.$$$reportNull$$$0(0);
        }
        return compositePsiElement;
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            CompositePsiElement.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        TreeElement node = this.getFirstChildNode();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement getLastChild() {
        TreeElement node = this.getLastChildNode();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            CompositePsiElement.$$$reportNull$$$0(2);
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor2);
        }
    }

    @Override
    public PsiElement getParent() {
        CompositeElement parentNode = this.getTreeParent();
        return parentNode != null ? parentNode.getPsi() : null;
    }

    @Override
    public PsiElement getNextSibling() {
        TreeElement node = this.getTreeNext();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement getPrevSibling() {
        TreeElement node = this.getTreePrev();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file2 = SharedImplUtil.getContainingFile(this);
        if (file2 == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return file2;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        LeafElement leaf = this.findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(leaf);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    @Override
    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    @Override
    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            CompositePsiElement.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            CompositePsiElement.$$$reportNull$$$0(4);
        }
        return this.addInnerBefore(element2, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        if (element2 == null) {
            CompositePsiElement.$$$reportNull$$$0(5);
        }
        return this.addInnerBefore(element2, anchor2);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        if (element2 == null) {
            CompositePsiElement.$$$reportNull$$$0(6);
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element2);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
        return ChangeUtil.decodeInformation(treeElement).getPsi();
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            CompositePsiElement.$$$reportNull$$$0(7);
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public final PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            CompositePsiElement.$$$reportNull$$$0(8);
        }
        if (last == null) {
            CompositePsiElement.$$$reportNull$$$0(9);
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null, "Parent not found for " + this);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = first.getNode();
        ASTNode lastElement = last.getNode();
        LOG.assertTrue(firstElement.getTreeParent() == this);
        LOG.assertTrue(lastElement.getTreeParent() == this);
        CodeEditUtil.removeChildren(this, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            CompositePsiElement.$$$reportNull$$$0(10);
        }
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            CompositePsiElement.$$$reportNull$$$0(11);
        }
        visitor2.visitElement(this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            CompositePsiElement.$$$reportNull$$$0(12);
        }
        if (state == null) {
            CompositePsiElement.$$$reportNull$$$0(13);
        }
        if (place == null) {
            CompositePsiElement.$$$reportNull$$$0(14);
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType() + ")";
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        CompositePsiElement compositePsiElement = this;
        if (compositePsiElement == null) {
            CompositePsiElement.$$$reportNull$$$0(15);
        }
        return compositePsiElement;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file2 = this.getContainingFile();
        return file2 != null && file2.isPhysical();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            CompositePsiElement.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            CompositePsiElement.$$$reportNull$$$0(17);
        }
        return globalSearchScope;
    }

    @Override
    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable descriptor2 = PsiNavigationSupport.getInstance().getDescriptor(this);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                CompositePsiElement.$$$reportNull$$$0(18);
            }
            return project2;
        }
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project3 = manager.getProject();
        if (project3 == null) {
            CompositePsiElement.$$$reportNull$$$0(19);
        }
        return project3;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            CompositePsiElement.$$$reportNull$$$0(20);
        }
        return language;
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        CompositePsiElement compositePsiElement = this;
        if (compositePsiElement == null) {
            CompositePsiElement.$$$reportNull$$$0(21);
        }
        return compositePsiElement;
    }

    private PsiElement addInnerBefore(PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element2);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
        if (treeElement != null) {
            return ChangeUtil.decodeInformation(treeElement).getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/CompositePsiElement";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/CompositePsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

